package software.amazon.awscdk.cloudassembly.schema;

/**
 * In what scenarios should the CLI ask for approval.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * App app = new App();
 * Stack stackUnderTest = new Stack(app, "StackUnderTest");
 * Stack stack = new Stack(app, "stack");
 * IntegTest testCase = IntegTest.Builder.create(app, "CustomizedDeploymentWorkflow")
 *         .testCases(List.of(stackUnderTest))
 *         .diffAssets(true)
 *         .stackUpdateWorkflow(true)
 *         .cdkCommandOptions(CdkCommands.builder()
 *                 .deploy(DeployCommand.builder()
 *                         .args(DeployOptions.builder()
 *                                 .requireApproval(RequireApproval.NEVER)
 *                                 .json(true)
 *                                 .build())
 *                         .build())
 *                 .destroy(DestroyCommand.builder()
 *                         .args(DestroyOptions.builder()
 *                                 .force(true)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:32.217Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.RequireApproval")
public enum RequireApproval {
    /**
     * Never ask for approval.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NEVER,
    /**
     * Prompt for approval for any type  of change to the stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ANYCHANGE,
    /**
     * Only prompt for approval if there are security related changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BROADENING,
}
