package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a <code>CfnUsagePlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnUsagePlanProps cfnUsagePlanProps = CfnUsagePlanProps.builder()
 *         .apiStages(List.of(ApiStageProperty.builder()
 *                 .apiId("apiId")
 *                 .stage("stage")
 *                 .throttle(Map.of(
 *                         "throttleKey", ThrottleSettingsProperty.builder()
 *                                 .burstLimit(123)
 *                                 .rateLimit(123)
 *                                 .build()))
 *                 .build()))
 *         .description("description")
 *         .quota(QuotaSettingsProperty.builder()
 *                 .limit(123)
 *                 .offset(123)
 *                 .period("period")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .throttle(ThrottleSettingsProperty.builder()
 *                 .burstLimit(123)
 *                 .rateLimit(123)
 *                 .build())
 *         .usagePlanName("usagePlanName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:18.833Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CfnUsagePlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnUsagePlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnUsagePlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The associated API stages of a usage plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-apistages</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getApiStages() {
        return null;
    }

    /**
     * The description of a usage plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The target maximum number of permitted requests per a given unit time interval.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-quota</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getQuota() {
        return null;
    }

    /**
     * The collection of tags.
     * <p>
     * Each tag element is associated with a given resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A map containing method level throttling information for API stage in a usage plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-throttle</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getThrottle() {
        return null;
    }

    /**
     * The name of a usage plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html#cfn-apigateway-usageplan-usageplanname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getUsagePlanName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnUsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnUsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnUsagePlanProps> {
        java.lang.Object apiStages;
        java.lang.String description;
        java.lang.Object quota;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object throttle;
        java.lang.String usagePlanName;

        /**
         * Sets the value of {@link CfnUsagePlanProps#getApiStages}
         * @param apiStages The associated API stages of a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(software.amazon.awscdk.IResolvable apiStages) {
            this.apiStages = apiStages;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getApiStages}
         * @param apiStages The associated API stages of a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(java.util.List<? extends java.lang.Object> apiStages) {
            this.apiStages = apiStages;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getDescription}
         * @param description The description of a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getQuota}
         * @param quota The target maximum number of permitted requests per a given unit time interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.IResolvable quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getQuota}
         * @param quota The target maximum number of permitted requests per a given unit time interval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigateway.CfnUsagePlan.QuotaSettingsProperty quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getTags}
         * @param tags The collection of tags.
         *             Each tag element is associated with a given resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getThrottle}
         * @param throttle A map containing method level throttling information for API stage in a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.IResolvable throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getThrottle}
         * @param throttle A map containing method level throttling information for API stage in a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.CfnUsagePlan.ThrottleSettingsProperty throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Sets the value of {@link CfnUsagePlanProps#getUsagePlanName}
         * @param usagePlanName The name of a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usagePlanName(java.lang.String usagePlanName) {
            this.usagePlanName = usagePlanName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnUsagePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnUsagePlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnUsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnUsagePlanProps {
        private final java.lang.Object apiStages;
        private final java.lang.String description;
        private final java.lang.Object quota;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object throttle;
        private final java.lang.String usagePlanName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiStages = software.amazon.jsii.Kernel.get(this, "apiStages", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.quota = software.amazon.jsii.Kernel.get(this, "quota", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.throttle = software.amazon.jsii.Kernel.get(this, "throttle", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.usagePlanName = software.amazon.jsii.Kernel.get(this, "usagePlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiStages = builder.apiStages;
            this.description = builder.description;
            this.quota = builder.quota;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.throttle = builder.throttle;
            this.usagePlanName = builder.usagePlanName;
        }

        @Override
        public final java.lang.Object getApiStages() {
            return this.apiStages;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getQuota() {
            return this.quota;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getThrottle() {
            return this.throttle;
        }

        @Override
        public final java.lang.String getUsagePlanName() {
            return this.usagePlanName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiStages() != null) {
                data.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getQuota() != null) {
                data.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThrottle() != null) {
                data.set("throttle", om.valueToTree(this.getThrottle()));
            }
            if (this.getUsagePlanName() != null) {
                data.set("usagePlanName", om.valueToTree(this.getUsagePlanName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigateway.CfnUsagePlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnUsagePlanProps.Jsii$Proxy that = (CfnUsagePlanProps.Jsii$Proxy) o;

            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.throttle != null ? !this.throttle.equals(that.throttle) : that.throttle != null) return false;
            return this.usagePlanName != null ? this.usagePlanName.equals(that.usagePlanName) : that.usagePlanName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiStages != null ? this.apiStages.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            result = 31 * result + (this.usagePlanName != null ? this.usagePlanName.hashCode() : 0);
            return result;
        }
    }
}
