package software.amazon.awscdk.services.apigateway;

/**
 * Cognito user pools based custom authorizer.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Resource books;
 * UserPool userPool = new UserPool(this, "UserPool");
 * CognitoUserPoolsAuthorizer auth = CognitoUserPoolsAuthorizer.Builder.create(this, "booksAuthorizer")
 *         .cognitoUserPools(List.of(userPool))
 *         .build();
 * books.addMethod("GET", new HttpIntegration("http://amazon.com"), MethodOptions.builder()
 *         .authorizer(auth)
 *         .authorizationType(AuthorizationType.COGNITO)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:18.835Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.CognitoUserPoolsAuthorizer")
public class CognitoUserPoolsAuthorizer extends software.amazon.awscdk.services.apigateway.Authorizer implements software.amazon.awscdk.services.apigateway.IAuthorizer {

    protected CognitoUserPoolsAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CognitoUserPoolsAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CognitoUserPoolsAuthorizer(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * The ARN of the authorizer to be used in permission policies, such as IAM and resource-based grants.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerArn() {
        return software.amazon.jsii.Kernel.get(this, "authorizerArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The id of the authorizer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The authorization type of this authorizer.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.AuthorizationType getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.AuthorizationType.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizerProps.Builder();
        }

        /**
         * The user pools to associate with this authorizer.
         * <p>
         * @return {@code this}
         * @param cognitoUserPools The user pools to associate with this authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoUserPools(final java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPool> cognitoUserPools) {
            this.props.cognitoUserPools(cognitoUserPools);
            return this;
        }

        /**
         * An optional human friendly name for the authorizer.
         * <p>
         * Note that, this is not the primary identifier of the authorizer.
         * <p>
         * Default: - the unique construct ID
         * <p>
         * @return {@code this}
         * @param authorizerName An optional human friendly name for the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        /**
         * The request header mapping expression for the bearer token.
         * <p>
         * This is typically passed as part of the header, in which case
         * this should be <code>method.request.header.Authorizer</code> where <code>Authorizer</code> is the header containing the bearer token.
         * <p>
         * Default: `IdentitySource.header('Authorization')`
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/api/API_CreateAuthorizer.html#apigw-CreateAuthorizer-request-identitySource">https://docs.aws.amazon.com/apigateway/latest/api/API_CreateAuthorizer.html#apigw-CreateAuthorizer-request-identitySource</a>
         * @param identitySource The request header mapping expression for the bearer token. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.lang.String identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * How long APIGateway should cache the results.
         * <p>
         * Max 1 hour.
         * Disable caching by setting this to 0.
         * <p>
         * Default: Duration.minutes(5)
         * <p>
         * @return {@code this}
         * @param resultsCacheTtl How long APIGateway should cache the results. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(final software.amazon.awscdk.Duration resultsCacheTtl) {
            this.props.resultsCacheTtl(resultsCacheTtl);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer build() {
            return new software.amazon.awscdk.services.apigateway.CognitoUserPoolsAuthorizer(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
