package software.amazon.awscdk.services.apigateway;

/**
 * Time period for which quota settings apply.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * RateLimitedApiKey key = RateLimitedApiKey.Builder.create(this, "rate-limited-api-key")
 *         .customerId("hello-customer")
 *         .stages(List.of(api.getDeploymentStage()))
 *         .quota(QuotaSettings.builder()
 *                 .limit(10000)
 *                 .period(Period.MONTH)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:18.903Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.Period")
public enum Period {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DAY,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    WEEK,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MONTH,
}
