package software.amazon.awscdk.services.apigatewayv2;

/**
 * custom domain name attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * DomainNameAttributes domainNameAttributes = DomainNameAttributes.builder()
 *         .name("name")
 *         .regionalDomainName("regionalDomainName")
 *         .regionalHostedZoneId("regionalHostedZoneId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.032Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.DomainNameAttributes")
@software.amazon.jsii.Jsii.Proxy(DomainNameAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * domain name string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The domain name associated with the regional endpoint for this custom domain name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegionalDomainName();

    /**
     * The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRegionalHostedZoneId();

    /**
     * @return a {@link Builder} of {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DomainNameAttributes> {
        java.lang.String name;
        java.lang.String regionalDomainName;
        java.lang.String regionalHostedZoneId;

        /**
         * Sets the value of {@link DomainNameAttributes#getName}
         * @param name domain name string. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameAttributes#getRegionalDomainName}
         * @param regionalDomainName The domain name associated with the regional endpoint for this custom domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalDomainName(java.lang.String regionalDomainName) {
            this.regionalDomainName = regionalDomainName;
            return this;
        }

        /**
         * Sets the value of {@link DomainNameAttributes#getRegionalHostedZoneId}
         * @param regionalHostedZoneId The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder regionalHostedZoneId(java.lang.String regionalHostedZoneId) {
            this.regionalHostedZoneId = regionalHostedZoneId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DomainNameAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DomainNameAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameAttributes {
        private final java.lang.String name;
        private final java.lang.String regionalDomainName;
        private final java.lang.String regionalHostedZoneId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionalDomainName = software.amazon.jsii.Kernel.get(this, "regionalDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.regionalHostedZoneId = software.amazon.jsii.Kernel.get(this, "regionalHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.regionalDomainName = java.util.Objects.requireNonNull(builder.regionalDomainName, "regionalDomainName is required");
            this.regionalHostedZoneId = java.util.Objects.requireNonNull(builder.regionalHostedZoneId, "regionalHostedZoneId is required");
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getRegionalDomainName() {
            return this.regionalDomainName;
        }

        @Override
        public final java.lang.String getRegionalHostedZoneId() {
            return this.regionalHostedZoneId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("regionalDomainName", om.valueToTree(this.getRegionalDomainName()));
            data.set("regionalHostedZoneId", om.valueToTree(this.getRegionalHostedZoneId()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.DomainNameAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DomainNameAttributes.Jsii$Proxy that = (DomainNameAttributes.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!regionalDomainName.equals(that.regionalDomainName)) return false;
            return this.regionalHostedZoneId.equals(that.regionalHostedZoneId);
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.regionalDomainName.hashCode());
            result = 31 * result + (this.regionalHostedZoneId.hashCode());
            return result;
        }
    }
}
