package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options used to add route to the API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.WebSocketLambdaIntegration;
 * Function messageHandler;
 * WebSocketApi webSocketApi = new WebSocketApi(this, "mywsapi");
 * WebSocketStage.Builder.create(this, "mystage")
 *         .webSocketApi(webSocketApi)
 *         .stageName("dev")
 *         .autoDeploy(true)
 *         .build();
 * webSocketApi.addRoute("sendMessage", WebSocketRouteOptions.builder()
 *         .integration(new WebSocketLambdaIntegration("SendMessageIntegration", messageHandler))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.102Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketRouteOptions")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketRouteOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The integration to be configured on this route.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration getIntegration();

    /**
     * The authorize to this route.
     * <p>
     * You can only set authorizer to a $connect route.
     * <p>
     * Default: - No Authorizer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer getAuthorizer() {
        return null;
    }

    /**
     * Should the route send a response to the client.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getReturnResponse() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteOptions> {
        software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;
        java.lang.Boolean returnResponse;

        /**
         * Sets the value of {@link WebSocketRouteOptions#getIntegration}
         * @param integration The integration to be configured on this route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integration(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration) {
            this.integration = integration;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteOptions#getAuthorizer}
         * @param authorizer The authorize to this route.
         *                   You can only set authorizer to a $connect route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizer(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer) {
            this.authorizer = authorizer;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteOptions#getReturnResponse}
         * @param returnResponse Should the route send a response to the client.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder returnResponse(java.lang.Boolean returnResponse) {
            this.returnResponse = returnResponse;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketRouteOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteOptions {
        private final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration integration;
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer authorizer;
        private final java.lang.Boolean returnResponse;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.integration = software.amazon.jsii.Kernel.get(this, "integration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration.class));
            this.authorizer = software.amazon.jsii.Kernel.get(this, "authorizer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer.class));
            this.returnResponse = software.amazon.jsii.Kernel.get(this, "returnResponse", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.integration = java.util.Objects.requireNonNull(builder.integration, "integration is required");
            this.authorizer = builder.authorizer;
            this.returnResponse = builder.returnResponse;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.WebSocketRouteIntegration getIntegration() {
            return this.integration;
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketRouteAuthorizer getAuthorizer() {
            return this.authorizer;
        }

        @Override
        public final java.lang.Boolean getReturnResponse() {
            return this.returnResponse;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("integration", om.valueToTree(this.getIntegration()));
            if (this.getAuthorizer() != null) {
                data.set("authorizer", om.valueToTree(this.getAuthorizer()));
            }
            if (this.getReturnResponse() != null) {
                data.set("returnResponse", om.valueToTree(this.getReturnResponse()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketRouteOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteOptions.Jsii$Proxy that = (WebSocketRouteOptions.Jsii$Proxy) o;

            if (!integration.equals(that.integration)) return false;
            if (this.authorizer != null ? !this.authorizer.equals(that.authorizer) : that.authorizer != null) return false;
            return this.returnResponse != null ? this.returnResponse.equals(that.returnResponse) : that.returnResponse == null;
        }

        @Override
        public final int hashCode() {
            int result = this.integration.hashCode();
            result = 31 * result + (this.authorizer != null ? this.authorizer.hashCode() : 0);
            result = 31 * result + (this.returnResponse != null ? this.returnResponse.hashCode() : 0);
            return result;
        }
    }
}
