package software.amazon.awscdk.services.appconfig;

/**
 * Defines Extension action points.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn;
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new LambdaDestination(fn))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions-about.html#working-with-appconfig-extensions-how-it-works-step-2">https://docs.aws.amazon.com/appconfig/latest/userguide/working-with-appconfig-extensions-about.html#working-with-appconfig-extensions-how-it-works-step-2</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.146Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ActionPoint")
public enum ActionPoint {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRE_CREATE_HOSTED_CONFIGURATION_VERSION,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PRE_START_DEPLOYMENT,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEPLOYMENT_START,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEPLOYMENT_STEP,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEPLOYMENT_BAKING,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEPLOYMENT_COMPLETE,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ON_DEPLOYMENT_ROLLED_BACK,
}
