package software.amazon.awscdk.services.appconfig;

/**
 * Defines the integrated configuration sources.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application application;
 * Bucket bucket;
 * SourcedConfiguration.Builder.create(this, "MySourcedConfiguration")
 *         .application(application)
 *         .location(ConfigurationSource.fromBucket(bucket, "path/to/file.json"))
 *         .type(ConfigurationType.FEATURE_FLAGS)
 *         .name("MyConfig")
 *         .description("This is my sourced configuration from CDK.")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.184Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.ConfigurationSource")
public abstract class ConfigurationSource extends software.amazon.jsii.JsiiObject {

    protected ConfigurationSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ConfigurationSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected ConfigurationSource() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Defines configuration content from an Amazon S3 bucket.
     * <p>
     * @param bucket The S3 bucket where the configuration is stored. This parameter is required.
     * @param objectKey The path to the configuration. This parameter is required.
     * @param key The KMS Key that the bucket is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String objectKey, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(objectKey, "objectKey is required"), key });
    }

    /**
     * Defines configuration content from an Amazon S3 bucket.
     * <p>
     * @param bucket The S3 bucket where the configuration is stored. This parameter is required.
     * @param objectKey The path to the configuration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromBucket(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket bucket, final @org.jetbrains.annotations.NotNull java.lang.String objectKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(bucket, "bucket is required"), java.util.Objects.requireNonNull(objectKey, "objectKey is required") });
    }

    /**
     * Defines configuration content from a Systems Manager (SSM) document.
     * <p>
     * @param document The SSM document where the configuration is stored. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromCfnDocument(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.CfnDocument document) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromCfnDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(document, "document is required") });
    }

    /**
     * Defines configuration content from a Systems Manager (SSM) Parameter Store parameter.
     * <p>
     * @param parameter The parameter where the configuration is stored. This parameter is required.
     * @param key The KMS Key that the secure string is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey key) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required"), key });
    }

    /**
     * Defines configuration content from a Systems Manager (SSM) Parameter Store parameter.
     * <p>
     * @param parameter The parameter where the configuration is stored. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromParameter(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ssm.IParameter parameter) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromParameter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(parameter, "parameter is required") });
    }

    /**
     * Defines configuration content from AWS CodePipeline.
     * <p>
     * @param pipeline The pipeline where the configuration is stored. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromPipeline(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IPipeline pipeline) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromPipeline", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(pipeline, "pipeline is required") });
    }

    /**
     * Defines configuration content from an AWS Secrets Manager secret.
     * <p>
     * @param secret The secret where the configuration is stored. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSource fromSecret(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret secret) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appconfig.ConfigurationSource.class, "fromSecret", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSource.class), new Object[] { java.util.Objects.requireNonNull(secret, "secret is required") });
    }

    /**
     * The URI of the configuration source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull java.lang.String getLocationUri();

    /**
     * The type of the configuration source.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSourceType getType();

    /**
     * The KMS Key that encrypts the configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKey();

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appconfig.ConfigurationSource {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The URI of the configuration source.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getLocationUri() {
            return software.amazon.jsii.Kernel.get(this, "locationUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The type of the configuration source.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ConfigurationSourceType getType() {
            return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.ConfigurationSourceType.class));
        }

        /**
         * The KMS Key that encrypts the configuration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getKey() {
            return software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }
    }
}
