package software.amazon.awscdk.services.appflow;

/**
 * The <code>AWS::AppFlow::Flow</code> resource is an Amazon AppFlow resource type that specifies a new flow.
 * <p>
 * <blockquote>
 * <p>
 * If you want to use AWS CloudFormation to create a connector profile for connectors that implement OAuth (such as Salesforce, Slack, Zendesk, and Google Analytics), you must fetch the access and refresh tokens. You can do this by implementing your own UI for OAuth, or by retrieving the tokens from elsewhere. Alternatively, you can use the Amazon AppFlow console to create the connector profile, and then use that connector profile in the flow creation CloudFormation template.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appflow.*;
 * CfnFlow cfnFlow = CfnFlow.Builder.create(this, "MyCfnFlow")
 *         .destinationFlowConfigList(List.of(DestinationFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
 *                         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(Map.of(
 *                                         "customPropertiesKey", "customProperties"))
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .redshift(RedshiftDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .s3(S3DestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .targetFileSize(123)
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         .preserveSourceDataTyping(false)
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .dataTransferApi("dataTransferApi")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .sapoData(SAPODataDestinationPropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .build())
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
 *                                 .intermediateBucketName("intermediateBucketName")
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .build())
 *                         .upsolver(UpsolverDestinationPropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
 *                                         .prefixConfig(PrefixConfigProperty.builder()
 *                                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
 *                                                 .prefixFormat("prefixFormat")
 *                                                 .prefixType("prefixType")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .aggregationConfig(AggregationConfigProperty.builder()
 *                                                 .aggregationType("aggregationType")
 *                                                 .targetFileSize(123)
 *                                                 .build())
 *                                         .fileType("fileType")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .bucketPrefix("bucketPrefix")
 *                                 .build())
 *                         .zendesk(ZendeskDestinationPropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
 *                                         .bucketName("bucketName")
 *                                         .bucketPrefix("bucketPrefix")
 *                                         .failOnFirstError(false)
 *                                         .build())
 *                                 .idFieldNames(List.of("idFieldNames"))
 *                                 .writeOperationType("writeOperationType")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .build()))
 *         .flowName("flowName")
 *         .sourceFlowConfig(SourceFlowConfigProperty.builder()
 *                 .connectorType("connectorType")
 *                 .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
 *                         .amplitude(AmplitudeSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
 *                                 .entityName("entityName")
 *                                 // the properties below are optional
 *                                 .customProperties(Map.of(
 *                                         "customPropertiesKey", "customProperties"))
 *                                 .dataTransferApi(DataTransferApiProperty.builder()
 *                                         .name("name")
 *                                         .type("type")
 *                                         .build())
 *                                 .build())
 *                         .datadog(DatadogSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .dynatrace(DynatraceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .inforNexus(InforNexusSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .marketo(MarketoSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .pardot(PardotSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .s3(S3SourcePropertiesProperty.builder()
 *                                 .bucketName("bucketName")
 *                                 .bucketPrefix("bucketPrefix")
 *                                 // the properties below are optional
 *                                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
 *                                         .s3InputFileType("s3InputFileType")
 *                                         .build())
 *                                 .build())
 *                         .salesforce(SalesforceSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .dataTransferApi("dataTransferApi")
 *                                 .enableDynamicFieldUpdate(false)
 *                                 .includeDeletedRecords(false)
 *                                 .build())
 *                         .sapoData(SAPODataSourcePropertiesProperty.builder()
 *                                 .objectPath("objectPath")
 *                                 // the properties below are optional
 *                                 .paginationConfig(SAPODataPaginationConfigProperty.builder()
 *                                         .maxPageSize(123)
 *                                         .build())
 *                                 .parallelismConfig(SAPODataParallelismConfigProperty.builder()
 *                                         .maxParallelism(123)
 *                                         .build())
 *                                 .build())
 *                         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .singular(SingularSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .slack(SlackSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .veeva(VeevaSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 // the properties below are optional
 *                                 .documentType("documentType")
 *                                 .includeAllVersions(false)
 *                                 .includeRenditions(false)
 *                                 .includeSourceFiles(false)
 *                                 .build())
 *                         .zendesk(ZendeskSourcePropertiesProperty.builder()
 *                                 .object("object")
 *                                 .build())
 *                         .build())
 *                 // the properties below are optional
 *                 .apiVersion("apiVersion")
 *                 .connectorProfileName("connectorProfileName")
 *                 .incrementalPullConfig(IncrementalPullConfigProperty.builder()
 *                         .datetimeTypeFieldName("datetimeTypeFieldName")
 *                         .build())
 *                 .build())
 *         .tasks(List.of(TaskProperty.builder()
 *                 .sourceFields(List.of("sourceFields"))
 *                 .taskType("taskType")
 *                 // the properties below are optional
 *                 .connectorOperator(ConnectorOperatorProperty.builder()
 *                         .amplitude("amplitude")
 *                         .customConnector("customConnector")
 *                         .datadog("datadog")
 *                         .dynatrace("dynatrace")
 *                         .googleAnalytics("googleAnalytics")
 *                         .inforNexus("inforNexus")
 *                         .marketo("marketo")
 *                         .pardot("pardot")
 *                         .s3("s3")
 *                         .salesforce("salesforce")
 *                         .sapoData("sapoData")
 *                         .serviceNow("serviceNow")
 *                         .singular("singular")
 *                         .slack("slack")
 *                         .trendmicro("trendmicro")
 *                         .veeva("veeva")
 *                         .zendesk("zendesk")
 *                         .build())
 *                 .destinationField("destinationField")
 *                 .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         .triggerConfig(TriggerConfigProperty.builder()
 *                 .triggerType("triggerType")
 *                 // the properties below are optional
 *                 .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
 *                         .scheduleExpression("scheduleExpression")
 *                         // the properties below are optional
 *                         .dataPullMode("dataPullMode")
 *                         .firstExecutionFrom(123)
 *                         .flowErrorDeactivationThreshold(123)
 *                         .scheduleEndTime(123)
 *                         .scheduleOffset(123)
 *                         .scheduleStartTime(123)
 *                         .timeZone("timeZone")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .description("description")
 *         .flowStatus("flowStatus")
 *         .kmsArn("kmsArn")
 *         .metadataCatalogConfig(MetadataCatalogConfigProperty.builder()
 *                 .glueDataCatalog(GlueDataCatalogProperty.builder()
 *                         .databaseName("databaseName")
 *                         .roleArn("roleArn")
 *                         .tablePrefix("tablePrefix")
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.268Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow")
public class CfnFlow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnFlow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.appflow.CfnFlow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The flow's Amazon Resource Name (ARN).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFlowArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFlowArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDestinationFlowConfigList() {
        return software.amazon.jsii.Kernel.get(this, "destinationFlowConfigList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationFlowConfigList(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "destinationFlowConfigList", java.util.Objects.requireNonNull(value, "destinationFlowConfigList is required"));
    }

    /**
     * The configuration that controls how Amazon AppFlow places data in the destination connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDestinationFlowConfigList(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.appflow.CfnFlow.DestinationFlowConfigProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "destinationFlowConfigList", java.util.Objects.requireNonNull(value, "destinationFlowConfigList is required"));
    }

    /**
     * The specified name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getFlowName() {
        return software.amazon.jsii.Kernel.get(this, "flowName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The specified name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowName", java.util.Objects.requireNonNull(value, "flowName is required"));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getSourceFlowConfig() {
        return software.amazon.jsii.Kernel.get(this, "sourceFlowConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFlowConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "sourceFlowConfig", java.util.Objects.requireNonNull(value, "sourceFlowConfig is required"));
    }

    /**
     * Contains information about the configuration of the source connector used in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceFlowConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "sourceFlowConfig", java.util.Objects.requireNonNull(value, "sourceFlowConfig is required"));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTasks() {
        return software.amazon.jsii.Kernel.get(this, "tasks", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTasks(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tasks", java.util.Objects.requireNonNull(value, "tasks is required"));
    }

    /**
     * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTasks(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.appflow.CfnFlow.TaskProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.appflow.CfnFlow.TaskProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "tasks", java.util.Objects.requireNonNull(value, "tasks is required"));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getTriggerConfig() {
        return software.amazon.jsii.Kernel.get(this, "triggerConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "triggerConfig", java.util.Objects.requireNonNull(value, "triggerConfig is required"));
    }

    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTriggerConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "triggerConfig", java.util.Objects.requireNonNull(value, "triggerConfig is required"));
    }

    /**
     * A user-entered description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A user-entered description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Sets the status of the flow.
     * <p>
     * You can specify one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getFlowStatus() {
        return software.amazon.jsii.Kernel.get(this, "flowStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Sets the status of the flow.
     * <p>
     * You can specify one of the following values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFlowStatus(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "flowStatus", value);
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsArn() {
        return software.amazon.jsii.Kernel.get(this, "kmsArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsArn", value);
    }

    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getMetadataCatalogConfig() {
        return software.amazon.jsii.Kernel.get(this, "metadataCatalogConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataCatalogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "metadataCatalogConfig", value);
    }

    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMetadataCatalogConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appflow.CfnFlow.MetadataCatalogConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "metadataCatalogConfig", value);
    }

    /**
     * The tags used to organize, track, or control access for your flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The tags used to organize, track, or control access for your flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * The aggregation settings that you can use to customize the output format of your flow data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AggregationConfigProperty aggregationConfigProperty = AggregationConfigProperty.builder()
     *         .aggregationType("aggregationType")
     *         .targetFileSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.AggregationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(AggregationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AggregationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html#cfn-appflow-flow-aggregationconfig-aggregationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html#cfn-appflow-flow-aggregationconfig-aggregationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAggregationType() {
            return null;
        }

        /**
         * The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination.
         * <p>
         * For each file, Amazon AppFlow attempts to achieve the size that you specify. The actual file sizes might differ from this target based on the number and size of the records that each file contains.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html#cfn-appflow-flow-aggregationconfig-targetfilesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-aggregationconfig.html#cfn-appflow-flow-aggregationconfig-targetfilesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTargetFileSize() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AggregationConfigProperty> {
            java.lang.String aggregationType;
            java.lang.Number targetFileSize;

            /**
             * Sets the value of {@link AggregationConfigProperty#getAggregationType}
             * @param aggregationType Specifies whether Amazon AppFlow aggregates the flow records into a single file, or leave them unaggregated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationType(java.lang.String aggregationType) {
                this.aggregationType = aggregationType;
                return this;
            }

            /**
             * Sets the value of {@link AggregationConfigProperty#getTargetFileSize}
             * @param targetFileSize The desired file size, in MB, for each output file that Amazon AppFlow writes to the flow destination.
             *                       For each file, Amazon AppFlow attempts to achieve the size that you specify. The actual file sizes might differ from this target based on the number and size of the records that each file contains.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetFileSize(java.lang.Number targetFileSize) {
                this.targetFileSize = targetFileSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AggregationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AggregationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AggregationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AggregationConfigProperty {
            private final java.lang.String aggregationType;
            private final java.lang.Number targetFileSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationType = software.amazon.jsii.Kernel.get(this, "aggregationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetFileSize = software.amazon.jsii.Kernel.get(this, "targetFileSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationType = builder.aggregationType;
                this.targetFileSize = builder.targetFileSize;
            }

            @Override
            public final java.lang.String getAggregationType() {
                return this.aggregationType;
            }

            @Override
            public final java.lang.Number getTargetFileSize() {
                return this.targetFileSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregationType() != null) {
                    data.set("aggregationType", om.valueToTree(this.getAggregationType()));
                }
                if (this.getTargetFileSize() != null) {
                    data.set("targetFileSize", om.valueToTree(this.getTargetFileSize()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.AggregationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AggregationConfigProperty.Jsii$Proxy that = (AggregationConfigProperty.Jsii$Proxy) o;

                if (this.aggregationType != null ? !this.aggregationType.equals(that.aggregationType) : that.aggregationType != null) return false;
                return this.targetFileSize != null ? this.targetFileSize.equals(that.targetFileSize) : that.targetFileSize == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationType != null ? this.aggregationType.hashCode() : 0;
                result = 31 * result + (this.targetFileSize != null ? this.targetFileSize.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amplitude is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * AmplitudeSourcePropertiesProperty amplitudeSourcePropertiesProperty = AmplitudeSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.AmplitudeSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(AmplitudeSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AmplitudeSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amplitude flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html#cfn-appflow-flow-amplitudesourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-amplitudesourceproperties.html#cfn-appflow-flow-amplitudesourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AmplitudeSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link AmplitudeSourcePropertiesProperty#getObject}
             * @param object The object specified in the Amplitude flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AmplitudeSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AmplitudeSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AmplitudeSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AmplitudeSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.AmplitudeSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AmplitudeSourcePropertiesProperty.Jsii$Proxy that = (AmplitudeSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The operation to be performed on the provided source fields.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ConnectorOperatorProperty connectorOperatorProperty = ConnectorOperatorProperty.builder()
     *         .amplitude("amplitude")
     *         .customConnector("customConnector")
     *         .datadog("datadog")
     *         .dynatrace("dynatrace")
     *         .googleAnalytics("googleAnalytics")
     *         .inforNexus("inforNexus")
     *         .marketo("marketo")
     *         .pardot("pardot")
     *         .s3("s3")
     *         .salesforce("salesforce")
     *         .sapoData("sapoData")
     *         .serviceNow("serviceNow")
     *         .singular("singular")
     *         .slack("slack")
     *         .trendmicro("trendmicro")
     *         .veeva("veeva")
     *         .zendesk("zendesk")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ConnectorOperatorProperty")
    @software.amazon.jsii.Jsii.Proxy(ConnectorOperatorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConnectorOperatorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The operation to be performed on the provided Amplitude source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-amplitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-amplitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAmplitude() {
            return null;
        }

        /**
         * Operators supported by the custom connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-customconnector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-customconnector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomConnector() {
            return null;
        }

        /**
         * The operation to be performed on the provided Datadog source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-datadog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-datadog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatadog() {
            return null;
        }

        /**
         * The operation to be performed on the provided Dynatrace source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-dynatrace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-dynatrace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDynatrace() {
            return null;
        }

        /**
         * The operation to be performed on the provided Google Analytics source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-googleanalytics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-googleanalytics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGoogleAnalytics() {
            return null;
        }

        /**
         * The operation to be performed on the provided Infor Nexus source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-infornexus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-infornexus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInforNexus() {
            return null;
        }

        /**
         * The operation to be performed on the provided Marketo source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMarketo() {
            return null;
        }

        /**
         * The operation to be performed on the provided Salesforce Pardot source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-pardot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-pardot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPardot() {
            return null;
        }

        /**
         * The operation to be performed on the provided Amazon S3 source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3() {
            return null;
        }

        /**
         * The operation to be performed on the provided Salesforce source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSalesforce() {
            return null;
        }

        /**
         * The operation to be performed on the provided SAPOData source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-sapodata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-sapodata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSapoData() {
            return null;
        }

        /**
         * The operation to be performed on the provided ServiceNow source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getServiceNow() {
            return null;
        }

        /**
         * The operation to be performed on the provided Singular source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-singular">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-singular</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSingular() {
            return null;
        }

        /**
         * The operation to be performed on the provided Slack source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-slack">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-slack</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSlack() {
            return null;
        }

        /**
         * The operation to be performed on the provided Trend Micro source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-trendmicro">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-trendmicro</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrendmicro() {
            return null;
        }

        /**
         * The operation to be performed on the provided Veeva source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-veeva">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-veeva</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVeeva() {
            return null;
        }

        /**
         * The operation to be performed on the provided Zendesk source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-connectoroperator.html#cfn-appflow-flow-connectoroperator-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConnectorOperatorProperty> {
            java.lang.String amplitude;
            java.lang.String customConnector;
            java.lang.String datadog;
            java.lang.String dynatrace;
            java.lang.String googleAnalytics;
            java.lang.String inforNexus;
            java.lang.String marketo;
            java.lang.String pardot;
            java.lang.String s3;
            java.lang.String salesforce;
            java.lang.String sapoData;
            java.lang.String serviceNow;
            java.lang.String singular;
            java.lang.String slack;
            java.lang.String trendmicro;
            java.lang.String veeva;
            java.lang.String zendesk;

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getAmplitude}
             * @param amplitude The operation to be performed on the provided Amplitude source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(java.lang.String amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getCustomConnector}
             * @param customConnector Operators supported by the custom connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(java.lang.String customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getDatadog}
             * @param datadog The operation to be performed on the provided Datadog source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(java.lang.String datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getDynatrace}
             * @param dynatrace The operation to be performed on the provided Dynatrace source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(java.lang.String dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getGoogleAnalytics}
             * @param googleAnalytics The operation to be performed on the provided Google Analytics source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(java.lang.String googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getInforNexus}
             * @param inforNexus The operation to be performed on the provided Infor Nexus source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(java.lang.String inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getMarketo}
             * @param marketo The operation to be performed on the provided Marketo source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(java.lang.String marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getPardot}
             * @param pardot The operation to be performed on the provided Salesforce Pardot source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(java.lang.String pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getS3}
             * @param s3 The operation to be performed on the provided Amazon S3 source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(java.lang.String s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSalesforce}
             * @param salesforce The operation to be performed on the provided Salesforce source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(java.lang.String salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSapoData}
             * @param sapoData The operation to be performed on the provided SAPOData source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(java.lang.String sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getServiceNow}
             * @param serviceNow The operation to be performed on the provided ServiceNow source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(java.lang.String serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSingular}
             * @param singular The operation to be performed on the provided Singular source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(java.lang.String singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getSlack}
             * @param slack The operation to be performed on the provided Slack source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(java.lang.String slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getTrendmicro}
             * @param trendmicro The operation to be performed on the provided Trend Micro source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(java.lang.String trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getVeeva}
             * @param veeva The operation to be performed on the provided Veeva source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(java.lang.String veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link ConnectorOperatorProperty#getZendesk}
             * @param zendesk The operation to be performed on the provided Zendesk source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(java.lang.String zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConnectorOperatorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConnectorOperatorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConnectorOperatorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConnectorOperatorProperty {
            private final java.lang.String amplitude;
            private final java.lang.String customConnector;
            private final java.lang.String datadog;
            private final java.lang.String dynatrace;
            private final java.lang.String googleAnalytics;
            private final java.lang.String inforNexus;
            private final java.lang.String marketo;
            private final java.lang.String pardot;
            private final java.lang.String s3;
            private final java.lang.String salesforce;
            private final java.lang.String sapoData;
            private final java.lang.String serviceNow;
            private final java.lang.String singular;
            private final java.lang.String slack;
            private final java.lang.String trendmicro;
            private final java.lang.String veeva;
            private final java.lang.String zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pardot = software.amazon.jsii.Kernel.get(this, "pardot", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.pardot = builder.pardot;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.String getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.String getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.String getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.String getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.String getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.String getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.String getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.String getPardot() {
                return this.pardot;
            }

            @Override
            public final java.lang.String getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.String getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.String getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.String getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.String getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.String getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.String getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.String getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.String getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getPardot() != null) {
                    data.set("pardot", om.valueToTree(this.getPardot()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ConnectorOperatorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConnectorOperatorProperty.Jsii$Proxy that = (ConnectorOperatorProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.pardot != null ? !this.pardot.equals(that.pardot) : that.pardot != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.customConnector != null ? this.customConnector.hashCode() : 0);
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.pardot != null ? this.pardot.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when the custom connector is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * CustomConnectorDestinationPropertiesProperty customConnectorDestinationPropertiesProperty = CustomConnectorDestinationPropertiesProperty.builder()
     *         .entityName("entityName")
     *         // the properties below are optional
     *         .customProperties(Map.of(
     *                 "customPropertiesKey", "customProperties"))
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity specified in the custom connector as a destination in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-entityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-entityname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

        /**
         * The custom properties that are specific to the connector when it's used as a destination in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-customproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-customproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomProperties() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-idfieldnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-idfieldnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * Specifies the type of write operation to be performed in the custom connector when it's used as destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-writeoperationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectordestinationproperties.html#cfn-appflow-flow-customconnectordestinationproperties-writeoperationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorDestinationPropertiesProperty> {
            java.lang.String entityName;
            java.lang.Object customProperties;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getEntityName}
             * @param entityName The entity specified in the custom connector as a destination in the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityName(java.lang.String entityName) {
                this.entityName = entityName;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getCustomProperties}
             * @param customProperties The custom properties that are specific to the connector when it's used as a destination in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(software.amazon.awscdk.IResolvable customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getCustomProperties}
             * @param customProperties The custom properties that are specific to the connector when it's used as a destination in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(java.util.Map<java.lang.String, java.lang.String> customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the custom connector as destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update, delete, or upsert.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType Specifies the type of write operation to be performed in the custom connector when it's used as destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorDestinationPropertiesProperty {
            private final java.lang.String entityName;
            private final java.lang.Object customProperties;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customProperties = software.amazon.jsii.Kernel.get(this, "customProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
                this.customProperties = builder.customProperties;
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getEntityName() {
                return this.entityName;
            }

            @Override
            public final java.lang.Object getCustomProperties() {
                return this.customProperties;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityName", om.valueToTree(this.getEntityName()));
                if (this.getCustomProperties() != null) {
                    data.set("customProperties", om.valueToTree(this.getCustomProperties()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorDestinationPropertiesProperty.Jsii$Proxy that = (CustomConnectorDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!entityName.equals(that.entityName)) return false;
                if (this.customProperties != null ? !this.customProperties.equals(that.customProperties) : that.customProperties != null) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityName.hashCode();
                result = 31 * result + (this.customProperties != null ? this.customProperties.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when the custom connector is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * CustomConnectorSourcePropertiesProperty customConnectorSourcePropertiesProperty = CustomConnectorSourcePropertiesProperty.builder()
     *         .entityName("entityName")
     *         // the properties below are optional
     *         .customProperties(Map.of(
     *                 "customPropertiesKey", "customProperties"))
     *         .dataTransferApi(DataTransferApiProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomConnectorSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomConnectorSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The entity specified in the custom connector as a source in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-entityname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-entityname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityName();

        /**
         * Custom properties that are required to use the custom connector as a source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-customproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-customproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomProperties() {
            return null;
        }

        /**
         * The API of the connector application that Amazon AppFlow uses to transfer your data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-datatransferapi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-customconnectorsourceproperties.html#cfn-appflow-flow-customconnectorsourceproperties-datatransferapi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataTransferApi() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomConnectorSourcePropertiesProperty> {
            java.lang.String entityName;
            java.lang.Object customProperties;
            java.lang.Object dataTransferApi;

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getEntityName}
             * @param entityName The entity specified in the custom connector as a source in the flow. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityName(java.lang.String entityName) {
                this.entityName = entityName;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getCustomProperties}
             * @param customProperties Custom properties that are required to use the custom connector as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(software.amazon.awscdk.IResolvable customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getCustomProperties}
             * @param customProperties Custom properties that are required to use the custom connector as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customProperties(java.util.Map<java.lang.String, java.lang.String> customProperties) {
                this.customProperties = customProperties;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getDataTransferApi}
             * @param dataTransferApi The API of the connector application that Amazon AppFlow uses to transfer your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransferApi(software.amazon.awscdk.IResolvable dataTransferApi) {
                this.dataTransferApi = dataTransferApi;
                return this;
            }

            /**
             * Sets the value of {@link CustomConnectorSourcePropertiesProperty#getDataTransferApi}
             * @param dataTransferApi The API of the connector application that Amazon AppFlow uses to transfer your data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransferApi(software.amazon.awscdk.services.appflow.CfnFlow.DataTransferApiProperty dataTransferApi) {
                this.dataTransferApi = dataTransferApi;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomConnectorSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomConnectorSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomConnectorSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomConnectorSourcePropertiesProperty {
            private final java.lang.String entityName;
            private final java.lang.Object customProperties;
            private final java.lang.Object dataTransferApi;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityName = software.amazon.jsii.Kernel.get(this, "entityName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customProperties = software.amazon.jsii.Kernel.get(this, "customProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataTransferApi = software.amazon.jsii.Kernel.get(this, "dataTransferApi", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityName = java.util.Objects.requireNonNull(builder.entityName, "entityName is required");
                this.customProperties = builder.customProperties;
                this.dataTransferApi = builder.dataTransferApi;
            }

            @Override
            public final java.lang.String getEntityName() {
                return this.entityName;
            }

            @Override
            public final java.lang.Object getCustomProperties() {
                return this.customProperties;
            }

            @Override
            public final java.lang.Object getDataTransferApi() {
                return this.dataTransferApi;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityName", om.valueToTree(this.getEntityName()));
                if (this.getCustomProperties() != null) {
                    data.set("customProperties", om.valueToTree(this.getCustomProperties()));
                }
                if (this.getDataTransferApi() != null) {
                    data.set("dataTransferApi", om.valueToTree(this.getDataTransferApi()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.CustomConnectorSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomConnectorSourcePropertiesProperty.Jsii$Proxy that = (CustomConnectorSourcePropertiesProperty.Jsii$Proxy) o;

                if (!entityName.equals(that.entityName)) return false;
                if (this.customProperties != null ? !this.customProperties.equals(that.customProperties) : that.customProperties != null) return false;
                return this.dataTransferApi != null ? this.dataTransferApi.equals(that.dataTransferApi) : that.dataTransferApi == null;
            }

            @Override
            public final int hashCode() {
                int result = this.entityName.hashCode();
                result = 31 * result + (this.customProperties != null ? this.customProperties.hashCode() : 0);
                result = 31 * result + (this.dataTransferApi != null ? this.dataTransferApi.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The API of the connector application that Amazon AppFlow uses to transfer your data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DataTransferApiProperty dataTransferApiProperty = DataTransferApiProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DataTransferApiProperty")
    @software.amazon.jsii.Jsii.Proxy(DataTransferApiProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataTransferApiProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the connector application API.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html#cfn-appflow-flow-datatransferapi-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html#cfn-appflow-flow-datatransferapi-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * You can specify one of the following types:.
         * <p>
         * <ul>
         * <li><strong>AUTOMATIC</strong> - The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.</li>
         * <li><strong>SYNC</strong> - A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.</li>
         * <li><strong>ASYNC</strong> - An asynchronous API. This type of API optimizes a flow for large datasets.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html#cfn-appflow-flow-datatransferapi-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datatransferapi.html#cfn-appflow-flow-datatransferapi-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link DataTransferApiProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataTransferApiProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataTransferApiProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link DataTransferApiProperty#getName}
             * @param name The name of the connector application API. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link DataTransferApiProperty#getType}
             * @param type You can specify one of the following types:. This parameter is required.
             *             <ul>
             *             <li><strong>AUTOMATIC</strong> - The default. Optimizes a flow for datasets that fluctuate in size from small to large. For each flow run, Amazon AppFlow chooses to use the SYNC or ASYNC API type based on the amount of data that the run transfers.</li>
             *             <li><strong>SYNC</strong> - A synchronous API. This type of API optimizes a flow for small to medium-sized datasets.</li>
             *             <li><strong>ASYNC</strong> - An asynchronous API. This type of API optimizes a flow for large datasets.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataTransferApiProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataTransferApiProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataTransferApiProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataTransferApiProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DataTransferApiProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataTransferApiProperty.Jsii$Proxy that = (DataTransferApiProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Datadog is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DatadogSourcePropertiesProperty datadogSourcePropertiesProperty = DatadogSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DatadogSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DatadogSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DatadogSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Datadog flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html#cfn-appflow-flow-datadogsourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-datadogsourceproperties.html#cfn-appflow-flow-datadogsourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DatadogSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link DatadogSourcePropertiesProperty#getObject}
             * @param object The object specified in the Datadog flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DatadogSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DatadogSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DatadogSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DatadogSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DatadogSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DatadogSourcePropertiesProperty.Jsii$Proxy that = (DatadogSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * This stores the information that is required to query a particular connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DestinationConnectorPropertiesProperty destinationConnectorPropertiesProperty = DestinationConnectorPropertiesProperty.builder()
     *         .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
     *                 .entityName("entityName")
     *                 // the properties below are optional
     *                 .customProperties(Map.of(
     *                         "customPropertiesKey", "customProperties"))
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .marketo(MarketoDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .redshift(RedshiftDestinationPropertiesProperty.builder()
     *                 .intermediateBucketName("intermediateBucketName")
     *                 .object("object")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .s3(S3DestinationPropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                         .aggregationConfig(AggregationConfigProperty.builder()
     *                                 .aggregationType("aggregationType")
     *                                 .targetFileSize(123)
     *                                 .build())
     *                         .fileType("fileType")
     *                         .prefixConfig(PrefixConfigProperty.builder()
     *                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                                 .prefixFormat("prefixFormat")
     *                                 .prefixType("prefixType")
     *                                 .build())
     *                         .preserveSourceDataTyping(false)
     *                         .build())
     *                 .build())
     *         .salesforce(SalesforceDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .dataTransferApi("dataTransferApi")
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .sapoData(SAPODataDestinationPropertiesProperty.builder()
     *                 .objectPath("objectPath")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .snowflake(SnowflakeDestinationPropertiesProperty.builder()
     *                 .intermediateBucketName("intermediateBucketName")
     *                 .object("object")
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .build())
     *         .upsolver(UpsolverDestinationPropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                         .prefixConfig(PrefixConfigProperty.builder()
     *                                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                                 .prefixFormat("prefixFormat")
     *                                 .prefixType("prefixType")
     *                                 .build())
     *                         // the properties below are optional
     *                         .aggregationConfig(AggregationConfigProperty.builder()
     *                                 .aggregationType("aggregationType")
     *                                 .targetFileSize(123)
     *                                 .build())
     *                         .fileType("fileType")
     *                         .build())
     *                 // the properties below are optional
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .zendesk(ZendeskDestinationPropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         .failOnFirstError(false)
     *                         .build())
     *                 .idFieldNames(List.of("idFieldNames"))
     *                 .writeOperationType("writeOperationType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DestinationConnectorPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationConnectorPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationConnectorPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The properties that are required to query the custom Connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-customconnector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-customconnector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * The properties required to query Amazon EventBridge.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-eventbridge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-eventbridge</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridge() {
            return null;
        }

        /**
         * The properties required to query Amazon Lookout for Metrics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-lookoutmetrics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-lookoutmetrics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLookoutMetrics() {
            return null;
        }

        /**
         * The properties required to query Marketo.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * The properties required to query Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-redshift">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-redshift</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRedshift() {
            return null;
        }

        /**
         * The properties required to query Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * The properties required to query Salesforce.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The properties required to query SAPOData.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-sapodata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-sapodata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * The properties required to query Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-snowflake">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-snowflake</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSnowflake() {
            return null;
        }

        /**
         * The properties required to query Upsolver.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-upsolver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-upsolver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpsolver() {
            return null;
        }

        /**
         * The properties required to query Zendesk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationconnectorproperties.html#cfn-appflow-flow-destinationconnectorproperties-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationConnectorPropertiesProperty> {
            java.lang.Object customConnector;
            java.lang.Object eventBridge;
            java.lang.Object lookoutMetrics;
            java.lang.Object marketo;
            java.lang.Object redshift;
            java.lang.Object s3;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object snowflake;
            java.lang.Object upsolver;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector The properties that are required to query the custom Connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector The properties that are required to query the custom Connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorDestinationPropertiesProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getEventBridge}
             * @param eventBridge The properties required to query Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridge(software.amazon.awscdk.IResolvable eventBridge) {
                this.eventBridge = eventBridge;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getEventBridge}
             * @param eventBridge The properties required to query Amazon EventBridge.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventBridge(software.amazon.awscdk.services.appflow.CfnFlow.EventBridgeDestinationPropertiesProperty eventBridge) {
                this.eventBridge = eventBridge;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getLookoutMetrics}
             * @param lookoutMetrics The properties required to query Amazon Lookout for Metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookoutMetrics(software.amazon.awscdk.IResolvable lookoutMetrics) {
                this.lookoutMetrics = lookoutMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getLookoutMetrics}
             * @param lookoutMetrics The properties required to query Amazon Lookout for Metrics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lookoutMetrics(software.amazon.awscdk.services.appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty lookoutMetrics) {
                this.lookoutMetrics = lookoutMetrics;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties required to query Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getMarketo}
             * @param marketo The properties required to query Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnFlow.MarketoDestinationPropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getRedshift}
             * @param redshift The properties required to query Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.IResolvable redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getRedshift}
             * @param redshift The properties required to query Amazon Redshift.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder redshift(software.amazon.awscdk.services.appflow.CfnFlow.RedshiftDestinationPropertiesProperty redshift) {
                this.redshift = redshift;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getS3}
             * @param s3 The properties required to query Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getS3}
             * @param s3 The properties required to query Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.appflow.CfnFlow.S3DestinationPropertiesProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties required to query Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSalesforce}
             * @param salesforce The properties required to query Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnFlow.SalesforceDestinationPropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties required to query SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties required to query SAPOData.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataDestinationPropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSnowflake}
             * @param snowflake The properties required to query Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.IResolvable snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getSnowflake}
             * @param snowflake The properties required to query Snowflake.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snowflake(software.amazon.awscdk.services.appflow.CfnFlow.SnowflakeDestinationPropertiesProperty snowflake) {
                this.snowflake = snowflake;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getUpsolver}
             * @param upsolver The properties required to query Upsolver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upsolver(software.amazon.awscdk.IResolvable upsolver) {
                this.upsolver = upsolver;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getUpsolver}
             * @param upsolver The properties required to query Upsolver.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder upsolver(software.amazon.awscdk.services.appflow.CfnFlow.UpsolverDestinationPropertiesProperty upsolver) {
                this.upsolver = upsolver;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties required to query Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link DestinationConnectorPropertiesProperty#getZendesk}
             * @param zendesk The properties required to query Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnFlow.ZendeskDestinationPropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationConnectorPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationConnectorPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationConnectorPropertiesProperty {
            private final java.lang.Object customConnector;
            private final java.lang.Object eventBridge;
            private final java.lang.Object lookoutMetrics;
            private final java.lang.Object marketo;
            private final java.lang.Object redshift;
            private final java.lang.Object s3;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object snowflake;
            private final java.lang.Object upsolver;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.eventBridge = software.amazon.jsii.Kernel.get(this, "eventBridge", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lookoutMetrics = software.amazon.jsii.Kernel.get(this, "lookoutMetrics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.redshift = software.amazon.jsii.Kernel.get(this, "redshift", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.snowflake = software.amazon.jsii.Kernel.get(this, "snowflake", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.upsolver = software.amazon.jsii.Kernel.get(this, "upsolver", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customConnector = builder.customConnector;
                this.eventBridge = builder.eventBridge;
                this.lookoutMetrics = builder.lookoutMetrics;
                this.marketo = builder.marketo;
                this.redshift = builder.redshift;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.snowflake = builder.snowflake;
                this.upsolver = builder.upsolver;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getEventBridge() {
                return this.eventBridge;
            }

            @Override
            public final java.lang.Object getLookoutMetrics() {
                return this.lookoutMetrics;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getRedshift() {
                return this.redshift;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getSnowflake() {
                return this.snowflake;
            }

            @Override
            public final java.lang.Object getUpsolver() {
                return this.upsolver;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getEventBridge() != null) {
                    data.set("eventBridge", om.valueToTree(this.getEventBridge()));
                }
                if (this.getLookoutMetrics() != null) {
                    data.set("lookoutMetrics", om.valueToTree(this.getLookoutMetrics()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getRedshift() != null) {
                    data.set("redshift", om.valueToTree(this.getRedshift()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getSnowflake() != null) {
                    data.set("snowflake", om.valueToTree(this.getSnowflake()));
                }
                if (this.getUpsolver() != null) {
                    data.set("upsolver", om.valueToTree(this.getUpsolver()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DestinationConnectorPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationConnectorPropertiesProperty.Jsii$Proxy that = (DestinationConnectorPropertiesProperty.Jsii$Proxy) o;

                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.eventBridge != null ? !this.eventBridge.equals(that.eventBridge) : that.eventBridge != null) return false;
                if (this.lookoutMetrics != null ? !this.lookoutMetrics.equals(that.lookoutMetrics) : that.lookoutMetrics != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.redshift != null ? !this.redshift.equals(that.redshift) : that.redshift != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.snowflake != null ? !this.snowflake.equals(that.snowflake) : that.snowflake != null) return false;
                if (this.upsolver != null ? !this.upsolver.equals(that.upsolver) : that.upsolver != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customConnector != null ? this.customConnector.hashCode() : 0;
                result = 31 * result + (this.eventBridge != null ? this.eventBridge.hashCode() : 0);
                result = 31 * result + (this.lookoutMetrics != null ? this.lookoutMetrics.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.redshift != null ? this.redshift.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.snowflake != null ? this.snowflake.hashCode() : 0);
                result = 31 * result + (this.upsolver != null ? this.upsolver.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the configuration of destination connectors present in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DestinationFlowConfigProperty destinationFlowConfigProperty = DestinationFlowConfigProperty.builder()
     *         .connectorType("connectorType")
     *         .destinationConnectorProperties(DestinationConnectorPropertiesProperty.builder()
     *                 .customConnector(CustomConnectorDestinationPropertiesProperty.builder()
     *                         .entityName("entityName")
     *                         // the properties below are optional
     *                         .customProperties(Map.of(
     *                                 "customPropertiesKey", "customProperties"))
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .eventBridge(EventBridgeDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .lookoutMetrics(LookoutMetricsDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .marketo(MarketoDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .redshift(RedshiftDestinationPropertiesProperty.builder()
     *                         .intermediateBucketName("intermediateBucketName")
     *                         .object("object")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .s3(S3DestinationPropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                                 .aggregationConfig(AggregationConfigProperty.builder()
     *                                         .aggregationType("aggregationType")
     *                                         .targetFileSize(123)
     *                                         .build())
     *                                 .fileType("fileType")
     *                                 .prefixConfig(PrefixConfigProperty.builder()
     *                                         .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                                         .prefixFormat("prefixFormat")
     *                                         .prefixType("prefixType")
     *                                         .build())
     *                                 .preserveSourceDataTyping(false)
     *                                 .build())
     *                         .build())
     *                 .salesforce(SalesforceDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .dataTransferApi("dataTransferApi")
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .sapoData(SAPODataDestinationPropertiesProperty.builder()
     *                         .objectPath("objectPath")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .build())
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .snowflake(SnowflakeDestinationPropertiesProperty.builder()
     *                         .intermediateBucketName("intermediateBucketName")
     *                         .object("object")
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .build())
     *                 .upsolver(UpsolverDestinationPropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                                 .prefixConfig(PrefixConfigProperty.builder()
     *                                         .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                                         .prefixFormat("prefixFormat")
     *                                         .prefixType("prefixType")
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .aggregationConfig(AggregationConfigProperty.builder()
     *                                         .aggregationType("aggregationType")
     *                                         .targetFileSize(123)
     *                                         .build())
     *                                 .fileType("fileType")
     *                                 .build())
     *                         // the properties below are optional
     *                         .bucketPrefix("bucketPrefix")
     *                         .build())
     *                 .zendesk(ZendeskDestinationPropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .bucketPrefix("bucketPrefix")
     *                                 .failOnFirstError(false)
     *                                 .build())
     *                         .idFieldNames(List.of("idFieldNames"))
     *                         .writeOperationType("writeOperationType")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .apiVersion("apiVersion")
     *         .connectorProfileName("connectorProfileName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DestinationFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DestinationFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DestinationFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of destination connector, such as Sales force, Amazon S3, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

        /**
         * This stores the information that is required to query a particular connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-destinationconnectorproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-destinationconnectorproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getDestinationConnectorProperties();

        /**
         * The API version that the destination connector uses.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-apiversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-apiversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
            return null;
        }

        /**
         * The name of the connector profile.
         * <p>
         * This name must be unique for each connector profile in the AWS account .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectorprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-destinationflowconfig.html#cfn-appflow-flow-destinationflowconfig-connectorprofilename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorProfileName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DestinationFlowConfigProperty> {
            java.lang.String connectorType;
            java.lang.Object destinationConnectorProperties;
            java.lang.String apiVersion;
            java.lang.String connectorProfileName;

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getConnectorType}
             * @param connectorType The type of destination connector, such as Sales force, Amazon S3, and so on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorType(java.lang.String connectorType) {
                this.connectorType = connectorType;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getDestinationConnectorProperties}
             * @param destinationConnectorProperties This stores the information that is required to query a particular connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConnectorProperties(software.amazon.awscdk.IResolvable destinationConnectorProperties) {
                this.destinationConnectorProperties = destinationConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getDestinationConnectorProperties}
             * @param destinationConnectorProperties This stores the information that is required to query a particular connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationConnectorProperties(software.amazon.awscdk.services.appflow.CfnFlow.DestinationConnectorPropertiesProperty destinationConnectorProperties) {
                this.destinationConnectorProperties = destinationConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getApiVersion}
             * @param apiVersion The API version that the destination connector uses.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiVersion(java.lang.String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            /**
             * Sets the value of {@link DestinationFlowConfigProperty#getConnectorProfileName}
             * @param connectorProfileName The name of the connector profile.
             *                             This name must be unique for each connector profile in the AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileName(java.lang.String connectorProfileName) {
                this.connectorProfileName = connectorProfileName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DestinationFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DestinationFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DestinationFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DestinationFlowConfigProperty {
            private final java.lang.String connectorType;
            private final java.lang.Object destinationConnectorProperties;
            private final java.lang.String apiVersion;
            private final java.lang.String connectorProfileName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.destinationConnectorProperties = software.amazon.jsii.Kernel.get(this, "destinationConnectorProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
                this.destinationConnectorProperties = java.util.Objects.requireNonNull(builder.destinationConnectorProperties, "destinationConnectorProperties is required");
                this.apiVersion = builder.apiVersion;
                this.connectorProfileName = builder.connectorProfileName;
            }

            @Override
            public final java.lang.String getConnectorType() {
                return this.connectorType;
            }

            @Override
            public final java.lang.Object getDestinationConnectorProperties() {
                return this.destinationConnectorProperties;
            }

            @Override
            public final java.lang.String getApiVersion() {
                return this.apiVersion;
            }

            @Override
            public final java.lang.String getConnectorProfileName() {
                return this.connectorProfileName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorType", om.valueToTree(this.getConnectorType()));
                data.set("destinationConnectorProperties", om.valueToTree(this.getDestinationConnectorProperties()));
                if (this.getApiVersion() != null) {
                    data.set("apiVersion", om.valueToTree(this.getApiVersion()));
                }
                if (this.getConnectorProfileName() != null) {
                    data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DestinationFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DestinationFlowConfigProperty.Jsii$Proxy that = (DestinationFlowConfigProperty.Jsii$Proxy) o;

                if (!connectorType.equals(that.connectorType)) return false;
                if (!destinationConnectorProperties.equals(that.destinationConnectorProperties)) return false;
                if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
                return this.connectorProfileName != null ? this.connectorProfileName.equals(that.connectorProfileName) : that.connectorProfileName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorType.hashCode();
                result = 31 * result + (this.destinationConnectorProperties.hashCode());
                result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
                result = 31 * result + (this.connectorProfileName != null ? this.connectorProfileName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Dynatrace is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * DynatraceSourcePropertiesProperty dynatraceSourcePropertiesProperty = DynatraceSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.DynatraceSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(DynatraceSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DynatraceSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Dynatrace flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html#cfn-appflow-flow-dynatracesourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-dynatracesourceproperties.html#cfn-appflow-flow-dynatracesourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DynatraceSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link DynatraceSourcePropertiesProperty#getObject}
             * @param object The object specified in the Dynatrace flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DynatraceSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DynatraceSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DynatraceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DynatraceSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.DynatraceSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DynatraceSourcePropertiesProperty.Jsii$Proxy that = (DynatraceSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
     * <p>
     * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ErrorHandlingConfigProperty errorHandlingConfigProperty = ErrorHandlingConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         .failOnFirstError(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ErrorHandlingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ErrorHandlingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ErrorHandlingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the name of the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * Specifies the Amazon S3 bucket prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-failonfirsterror">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-errorhandlingconfig.html#cfn-appflow-flow-errorhandlingconfig-failonfirsterror</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getFailOnFirstError() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ErrorHandlingConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object failOnFirstError;

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getBucketName}
             * @param bucketName Specifies the name of the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getBucketPrefix}
             * @param bucketPrefix Specifies the Amazon S3 bucket prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getFailOnFirstError}
             * @param failOnFirstError Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failOnFirstError(java.lang.Boolean failOnFirstError) {
                this.failOnFirstError = failOnFirstError;
                return this;
            }

            /**
             * Sets the value of {@link ErrorHandlingConfigProperty#getFailOnFirstError}
             * @param failOnFirstError Specifies if the flow should fail after the first instance of a failure when attempting to place data in the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failOnFirstError(software.amazon.awscdk.IResolvable failOnFirstError) {
                this.failOnFirstError = failOnFirstError;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ErrorHandlingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ErrorHandlingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ErrorHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorHandlingConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object failOnFirstError;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failOnFirstError = software.amazon.jsii.Kernel.get(this, "failOnFirstError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = builder.bucketName;
                this.bucketPrefix = builder.bucketPrefix;
                this.failOnFirstError = builder.failOnFirstError;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getFailOnFirstError() {
                return this.failOnFirstError;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getFailOnFirstError() != null) {
                    data.set("failOnFirstError", om.valueToTree(this.getFailOnFirstError()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ErrorHandlingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ErrorHandlingConfigProperty.Jsii$Proxy that = (ErrorHandlingConfigProperty.Jsii$Proxy) o;

                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.failOnFirstError != null ? this.failOnFirstError.equals(that.failOnFirstError) : that.failOnFirstError == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.failOnFirstError != null ? this.failOnFirstError.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon EventBridge is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * EventBridgeDestinationPropertiesProperty eventBridgeDestinationPropertiesProperty = EventBridgeDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.EventBridgeDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(EventBridgeDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventBridgeDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amazon EventBridge flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object specified in the Amplitude flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-eventbridgedestinationproperties.html#cfn-appflow-flow-eventbridgedestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventBridgeDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon EventBridge flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The object specified in the Amplitude flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link EventBridgeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The object specified in the Amplitude flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventBridgeDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventBridgeDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventBridgeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventBridgeDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.EventBridgeDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventBridgeDestinationPropertiesProperty.Jsii$Proxy that = (EventBridgeDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Trigger settings of the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * GlueDataCatalogProperty glueDataCatalogProperty = GlueDataCatalogProperty.builder()
     *         .databaseName("databaseName")
     *         .roleArn("roleArn")
     *         .tablePrefix("tablePrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.GlueDataCatalogProperty")
    @software.amazon.jsii.Jsii.Proxy(GlueDataCatalogProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GlueDataCatalogProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A string containing the value for the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-databasename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-databasename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDatabaseName();

        /**
         * A string containing the value for the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * A string containing the value for the tag.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-tableprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-gluedatacatalog.html#cfn-appflow-flow-gluedatacatalog-tableprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTablePrefix();

        /**
         * @return a {@link Builder} of {@link GlueDataCatalogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GlueDataCatalogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GlueDataCatalogProperty> {
            java.lang.String databaseName;
            java.lang.String roleArn;
            java.lang.String tablePrefix;

            /**
             * Sets the value of {@link GlueDataCatalogProperty#getDatabaseName}
             * @param databaseName A string containing the value for the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder databaseName(java.lang.String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            /**
             * Sets the value of {@link GlueDataCatalogProperty#getRoleArn}
             * @param roleArn A string containing the value for the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link GlueDataCatalogProperty#getTablePrefix}
             * @param tablePrefix A string containing the value for the tag. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tablePrefix(java.lang.String tablePrefix) {
                this.tablePrefix = tablePrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GlueDataCatalogProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GlueDataCatalogProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GlueDataCatalogProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GlueDataCatalogProperty {
            private final java.lang.String databaseName;
            private final java.lang.String roleArn;
            private final java.lang.String tablePrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.databaseName = software.amazon.jsii.Kernel.get(this, "databaseName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tablePrefix = software.amazon.jsii.Kernel.get(this, "tablePrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.databaseName = java.util.Objects.requireNonNull(builder.databaseName, "databaseName is required");
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.tablePrefix = java.util.Objects.requireNonNull(builder.tablePrefix, "tablePrefix is required");
            }

            @Override
            public final java.lang.String getDatabaseName() {
                return this.databaseName;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getTablePrefix() {
                return this.tablePrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("databaseName", om.valueToTree(this.getDatabaseName()));
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("tablePrefix", om.valueToTree(this.getTablePrefix()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.GlueDataCatalogProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GlueDataCatalogProperty.Jsii$Proxy that = (GlueDataCatalogProperty.Jsii$Proxy) o;

                if (!databaseName.equals(that.databaseName)) return false;
                if (!roleArn.equals(that.roleArn)) return false;
                return this.tablePrefix.equals(that.tablePrefix);
            }

            @Override
            public final int hashCode() {
                int result = this.databaseName.hashCode();
                result = 31 * result + (this.roleArn.hashCode());
                result = 31 * result + (this.tablePrefix.hashCode());
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Google Analytics is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * GoogleAnalyticsSourcePropertiesProperty googleAnalyticsSourcePropertiesProperty = GoogleAnalyticsSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GoogleAnalyticsSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Google Analytics flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html#cfn-appflow-flow-googleanalyticssourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-googleanalyticssourceproperties.html#cfn-appflow-flow-googleanalyticssourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GoogleAnalyticsSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link GoogleAnalyticsSourcePropertiesProperty#getObject}
             * @param object The object specified in the Google Analytics flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GoogleAnalyticsSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GoogleAnalyticsSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GoogleAnalyticsSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GoogleAnalyticsSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy that = (GoogleAnalyticsSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration used when importing incremental records from the source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * IncrementalPullConfigProperty incrementalPullConfigProperty = IncrementalPullConfigProperty.builder()
     *         .datetimeTypeFieldName("datetimeTypeFieldName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-incrementalpullconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-incrementalpullconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.IncrementalPullConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IncrementalPullConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IncrementalPullConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-incrementalpullconfig.html#cfn-appflow-flow-incrementalpullconfig-datetimetypefieldname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-incrementalpullconfig.html#cfn-appflow-flow-incrementalpullconfig-datetimetypefieldname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDatetimeTypeFieldName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IncrementalPullConfigProperty> {
            java.lang.String datetimeTypeFieldName;

            /**
             * Sets the value of {@link IncrementalPullConfigProperty#getDatetimeTypeFieldName}
             * @param datetimeTypeFieldName A field that specifies the date time or timestamp field as the criteria to use when importing incremental records from the source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datetimeTypeFieldName(java.lang.String datetimeTypeFieldName) {
                this.datetimeTypeFieldName = datetimeTypeFieldName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IncrementalPullConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IncrementalPullConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IncrementalPullConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IncrementalPullConfigProperty {
            private final java.lang.String datetimeTypeFieldName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.datetimeTypeFieldName = software.amazon.jsii.Kernel.get(this, "datetimeTypeFieldName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.datetimeTypeFieldName = builder.datetimeTypeFieldName;
            }

            @Override
            public final java.lang.String getDatetimeTypeFieldName() {
                return this.datetimeTypeFieldName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDatetimeTypeFieldName() != null) {
                    data.set("datetimeTypeFieldName", om.valueToTree(this.getDatetimeTypeFieldName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.IncrementalPullConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IncrementalPullConfigProperty.Jsii$Proxy that = (IncrementalPullConfigProperty.Jsii$Proxy) o;

                return this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.equals(that.datetimeTypeFieldName) : that.datetimeTypeFieldName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.datetimeTypeFieldName != null ? this.datetimeTypeFieldName.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Infor Nexus is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * InforNexusSourcePropertiesProperty inforNexusSourcePropertiesProperty = InforNexusSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.InforNexusSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(InforNexusSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InforNexusSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Infor Nexus flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html#cfn-appflow-flow-infornexussourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-infornexussourceproperties.html#cfn-appflow-flow-infornexussourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InforNexusSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link InforNexusSourcePropertiesProperty#getObject}
             * @param object The object specified in the Infor Nexus flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InforNexusSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InforNexusSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InforNexusSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InforNexusSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.InforNexusSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InforNexusSourcePropertiesProperty.Jsii$Proxy that = (InforNexusSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon Lookout for Metrics is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * LookoutMetricsDestinationPropertiesProperty lookoutMetricsDestinationPropertiesProperty = LookoutMetricsDestinationPropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-lookoutmetricsdestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-lookoutmetricsdestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LookoutMetricsDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Amazon Lookout for Metrics flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-lookoutmetricsdestinationproperties.html#cfn-appflow-flow-lookoutmetricsdestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-lookoutmetricsdestinationproperties.html#cfn-appflow-flow-lookoutmetricsdestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getObject() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LookoutMetricsDestinationPropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link LookoutMetricsDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon Lookout for Metrics flow destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LookoutMetricsDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LookoutMetricsDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LookoutMetricsDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LookoutMetricsDestinationPropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = builder.object;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getObject() != null) {
                    data.set("object", om.valueToTree(this.getObject()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.LookoutMetricsDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy that = (LookoutMetricsDestinationPropertiesProperty.Jsii$Proxy) o;

                return this.object != null ? this.object.equals(that.object) : that.object == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object != null ? this.object.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that Amazon AppFlow applies when you use Marketo as a flow destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoDestinationPropertiesProperty marketoDestinationPropertiesProperty = MarketoDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.MarketoDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Marketo flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html#cfn-appflow-flow-marketodestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html#cfn-appflow-flow-marketodestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html#cfn-appflow-flow-marketodestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketodestinationproperties.html#cfn-appflow-flow-marketodestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Marketo flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link MarketoDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.MarketoDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoDestinationPropertiesProperty.Jsii$Proxy that = (MarketoDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Marketo is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MarketoSourcePropertiesProperty marketoSourcePropertiesProperty = MarketoSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.MarketoSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MarketoSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MarketoSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Marketo flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html#cfn-appflow-flow-marketosourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-marketosourceproperties.html#cfn-appflow-flow-marketosourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MarketoSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link MarketoSourcePropertiesProperty#getObject}
             * @param object The object specified in the Marketo flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MarketoSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MarketoSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MarketoSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MarketoSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.MarketoSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MarketoSourcePropertiesProperty.Jsii$Proxy that = (MarketoSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
     * <p>
     * When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * MetadataCatalogConfigProperty metadataCatalogConfigProperty = MetadataCatalogConfigProperty.builder()
     *         .glueDataCatalog(GlueDataCatalogProperty.builder()
     *                 .databaseName("databaseName")
     *                 .roleArn("roleArn")
     *                 .tablePrefix("tablePrefix")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-metadatacatalogconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-metadatacatalogconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.MetadataCatalogConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MetadataCatalogConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MetadataCatalogConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the AWS Glue Data Catalog .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-metadatacatalogconfig.html#cfn-appflow-flow-metadatacatalogconfig-gluedatacatalog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-metadatacatalogconfig.html#cfn-appflow-flow-metadatacatalogconfig-gluedatacatalog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGlueDataCatalog() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MetadataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MetadataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MetadataCatalogConfigProperty> {
            java.lang.Object glueDataCatalog;

            /**
             * Sets the value of {@link MetadataCatalogConfigProperty#getGlueDataCatalog}
             * @param glueDataCatalog Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueDataCatalog(software.amazon.awscdk.IResolvable glueDataCatalog) {
                this.glueDataCatalog = glueDataCatalog;
                return this;
            }

            /**
             * Sets the value of {@link MetadataCatalogConfigProperty#getGlueDataCatalog}
             * @param glueDataCatalog Specifies the configuration that Amazon AppFlow uses when it catalogs your data with the AWS Glue Data Catalog .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder glueDataCatalog(software.amazon.awscdk.services.appflow.CfnFlow.GlueDataCatalogProperty glueDataCatalog) {
                this.glueDataCatalog = glueDataCatalog;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MetadataCatalogConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MetadataCatalogConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MetadataCatalogConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MetadataCatalogConfigProperty {
            private final java.lang.Object glueDataCatalog;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.glueDataCatalog = software.amazon.jsii.Kernel.get(this, "glueDataCatalog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.glueDataCatalog = builder.glueDataCatalog;
            }

            @Override
            public final java.lang.Object getGlueDataCatalog() {
                return this.glueDataCatalog;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGlueDataCatalog() != null) {
                    data.set("glueDataCatalog", om.valueToTree(this.getGlueDataCatalog()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.MetadataCatalogConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MetadataCatalogConfigProperty.Jsii$Proxy that = (MetadataCatalogConfigProperty.Jsii$Proxy) o;

                return this.glueDataCatalog != null ? this.glueDataCatalog.equals(that.glueDataCatalog) : that.glueDataCatalog == null;
            }

            @Override
            public final int hashCode() {
                int result = this.glueDataCatalog != null ? this.glueDataCatalog.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce Pardot is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * PardotSourcePropertiesProperty pardotSourcePropertiesProperty = PardotSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-pardotsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-pardotsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.PardotSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(PardotSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PardotSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce Pardot flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-pardotsourceproperties.html#cfn-appflow-flow-pardotsourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-pardotsourceproperties.html#cfn-appflow-flow-pardotsourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link PardotSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PardotSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PardotSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link PardotSourcePropertiesProperty#getObject}
             * @param object The object specified in the Salesforce Pardot flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PardotSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PardotSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PardotSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PardotSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.PardotSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PardotSourcePropertiesProperty.Jsii$Proxy that = (PardotSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * PrefixConfigProperty prefixConfigProperty = PrefixConfigProperty.builder()
     *         .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *         .prefixFormat("prefixFormat")
     *         .prefixType("prefixType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.PrefixConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(PrefixConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PrefixConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the destination file path includes either or both of the following elements:.
         * <p>
         * <ul>
         * <li><strong>EXECUTION_ID</strong> - The ID that Amazon AppFlow assigns to the flow run.</li>
         * <li><strong>SCHEMA_VERSION</strong> - The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:</li>
         * <li>Source-to-destination field mappings</li>
         * <li>Field data types</li>
         * <li>Partition keys</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-pathprefixhierarchy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-pathprefixhierarchy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPathPrefixHierarchy() {
            return null;
        }

        /**
         * Determines the level of granularity for the date and time that's included in the prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixFormat() {
            return null;
        }

        /**
         * Determines the format of the prefix, and whether it applies to the file name, file path, or both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-prefixconfig.html#cfn-appflow-flow-prefixconfig-prefixtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefixType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PrefixConfigProperty> {
            java.util.List<java.lang.String> pathPrefixHierarchy;
            java.lang.String prefixFormat;
            java.lang.String prefixType;

            /**
             * Sets the value of {@link PrefixConfigProperty#getPathPrefixHierarchy}
             * @param pathPrefixHierarchy Specifies whether the destination file path includes either or both of the following elements:.
             *                            <ul>
             *                            <li><strong>EXECUTION_ID</strong> - The ID that Amazon AppFlow assigns to the flow run.</li>
             *                            <li><strong>SCHEMA_VERSION</strong> - The version number of your data schema. Amazon AppFlow assigns this version number. The version number increases by one when you change any of the following settings in your flow configuration:</li>
             *                            <li>Source-to-destination field mappings</li>
             *                            <li>Field data types</li>
             *                            <li>Partition keys</li>
             *                            </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPrefixHierarchy(java.util.List<java.lang.String> pathPrefixHierarchy) {
                this.pathPrefixHierarchy = pathPrefixHierarchy;
                return this;
            }

            /**
             * Sets the value of {@link PrefixConfigProperty#getPrefixFormat}
             * @param prefixFormat Determines the level of granularity for the date and time that's included in the prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixFormat(java.lang.String prefixFormat) {
                this.prefixFormat = prefixFormat;
                return this;
            }

            /**
             * Sets the value of {@link PrefixConfigProperty#getPrefixType}
             * @param prefixType Determines the format of the prefix, and whether it applies to the file name, file path, or both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixType(java.lang.String prefixType) {
                this.prefixType = prefixType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PrefixConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PrefixConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PrefixConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PrefixConfigProperty {
            private final java.util.List<java.lang.String> pathPrefixHierarchy;
            private final java.lang.String prefixFormat;
            private final java.lang.String prefixType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pathPrefixHierarchy = software.amazon.jsii.Kernel.get(this, "pathPrefixHierarchy", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.prefixFormat = software.amazon.jsii.Kernel.get(this, "prefixFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefixType = software.amazon.jsii.Kernel.get(this, "prefixType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pathPrefixHierarchy = builder.pathPrefixHierarchy;
                this.prefixFormat = builder.prefixFormat;
                this.prefixType = builder.prefixType;
            }

            @Override
            public final java.util.List<java.lang.String> getPathPrefixHierarchy() {
                return this.pathPrefixHierarchy;
            }

            @Override
            public final java.lang.String getPrefixFormat() {
                return this.prefixFormat;
            }

            @Override
            public final java.lang.String getPrefixType() {
                return this.prefixType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPathPrefixHierarchy() != null) {
                    data.set("pathPrefixHierarchy", om.valueToTree(this.getPathPrefixHierarchy()));
                }
                if (this.getPrefixFormat() != null) {
                    data.set("prefixFormat", om.valueToTree(this.getPrefixFormat()));
                }
                if (this.getPrefixType() != null) {
                    data.set("prefixType", om.valueToTree(this.getPrefixType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.PrefixConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PrefixConfigProperty.Jsii$Proxy that = (PrefixConfigProperty.Jsii$Proxy) o;

                if (this.pathPrefixHierarchy != null ? !this.pathPrefixHierarchy.equals(that.pathPrefixHierarchy) : that.pathPrefixHierarchy != null) return false;
                if (this.prefixFormat != null ? !this.prefixFormat.equals(that.prefixFormat) : that.prefixFormat != null) return false;
                return this.prefixType != null ? this.prefixType.equals(that.prefixType) : that.prefixType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.pathPrefixHierarchy != null ? this.pathPrefixHierarchy.hashCode() : 0;
                result = 31 * result + (this.prefixFormat != null ? this.prefixFormat.hashCode() : 0);
                result = 31 * result + (this.prefixType != null ? this.prefixType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon Redshift is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * RedshiftDestinationPropertiesProperty redshiftDestinationPropertiesProperty = RedshiftDestinationPropertiesProperty.builder()
     *         .intermediateBucketName("intermediateBucketName")
     *         .object("object")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.RedshiftDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(RedshiftDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RedshiftDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-intermediatebucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-intermediatebucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateBucketName();

        /**
         * The object specified in the Amazon Redshift flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object key for the bucket in which Amazon AppFlow places the destination files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-redshiftdestinationproperties.html#cfn-appflow-flow-redshiftdestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RedshiftDestinationPropertiesProperty> {
            java.lang.String intermediateBucketName;
            java.lang.String object;
            java.lang.String bucketPrefix;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getIntermediateBucketName}
             * @param intermediateBucketName The intermediate bucket that Amazon AppFlow uses when moving data into Amazon Redshift. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateBucketName(java.lang.String intermediateBucketName) {
                this.intermediateBucketName = intermediateBucketName;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Amazon Redshift flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the bucket in which Amazon AppFlow places the destination files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link RedshiftDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Amazon Redshift destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RedshiftDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RedshiftDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RedshiftDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RedshiftDestinationPropertiesProperty {
            private final java.lang.String intermediateBucketName;
            private final java.lang.String object;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateBucketName = software.amazon.jsii.Kernel.get(this, "intermediateBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateBucketName = java.util.Objects.requireNonNull(builder.intermediateBucketName, "intermediateBucketName is required");
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getIntermediateBucketName() {
                return this.intermediateBucketName;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateBucketName", om.valueToTree(this.getIntermediateBucketName()));
                data.set("object", om.valueToTree(this.getObject()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.RedshiftDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RedshiftDestinationPropertiesProperty.Jsii$Proxy that = (RedshiftDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!intermediateBucketName.equals(that.intermediateBucketName)) return false;
                if (!object.equals(that.object)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateBucketName.hashCode();
                result = 31 * result + (this.object.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon S3 is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3DestinationPropertiesProperty s3DestinationPropertiesProperty = S3DestinationPropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .s3OutputFormatConfig(S3OutputFormatConfigProperty.builder()
     *                 .aggregationConfig(AggregationConfigProperty.builder()
     *                         .aggregationType("aggregationType")
     *                         .targetFileSize(123)
     *                         .build())
     *                 .fileType("fileType")
     *                 .prefixConfig(PrefixConfigProperty.builder()
     *                         .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                         .prefixFormat("prefixFormat")
     *                         .prefixType("prefixType")
     *                         .build())
     *                 .preserveSourceDataTyping(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3DestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(S3DestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3DestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-s3outputformatconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3destinationproperties.html#cfn-appflow-flow-s3destinationproperties-s3outputformatconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3OutputFormatConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3DestinationPropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object s3OutputFormatConfig;

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name in which Amazon AppFlow places the transferred data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.IResolvable s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3DestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.S3OutputFormatConfigProperty s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3DestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3DestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3DestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3DestinationPropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object s3OutputFormatConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3OutputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.s3OutputFormatConfig = builder.s3OutputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getS3OutputFormatConfig() {
                return this.s3OutputFormatConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getS3OutputFormatConfig() != null) {
                    data.set("s3OutputFormatConfig", om.valueToTree(this.getS3OutputFormatConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3DestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3DestinationPropertiesProperty.Jsii$Proxy that = (S3DestinationPropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.s3OutputFormatConfig != null ? this.s3OutputFormatConfig.equals(that.s3OutputFormatConfig) : that.s3OutputFormatConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.s3OutputFormatConfig != null ? this.s3OutputFormatConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3InputFormatConfigProperty s3InputFormatConfigProperty = S3InputFormatConfigProperty.builder()
     *         .s3InputFileType("s3InputFileType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3inputformatconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3inputformatconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3InputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3InputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3InputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The file type that Amazon AppFlow gets from your Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3inputformatconfig.html#cfn-appflow-flow-s3inputformatconfig-s3inputfiletype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3inputformatconfig.html#cfn-appflow-flow-s3inputformatconfig-s3inputfiletype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getS3InputFileType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3InputFormatConfigProperty> {
            java.lang.String s3InputFileType;

            /**
             * Sets the value of {@link S3InputFormatConfigProperty#getS3InputFileType}
             * @param s3InputFileType The file type that Amazon AppFlow gets from your Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFileType(java.lang.String s3InputFileType) {
                this.s3InputFileType = s3InputFileType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3InputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3InputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3InputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3InputFormatConfigProperty {
            private final java.lang.String s3InputFileType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3InputFileType = software.amazon.jsii.Kernel.get(this, "s3InputFileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3InputFileType = builder.s3InputFileType;
            }

            @Override
            public final java.lang.String getS3InputFileType() {
                return this.s3InputFileType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3InputFileType() != null) {
                    data.set("s3InputFileType", om.valueToTree(this.getS3InputFileType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3InputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3InputFormatConfigProperty.Jsii$Proxy that = (S3InputFormatConfigProperty.Jsii$Proxy) o;

                return this.s3InputFileType != null ? this.s3InputFileType.equals(that.s3InputFileType) : that.s3InputFileType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3InputFileType != null ? this.s3InputFileType.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The configuration that determines how Amazon AppFlow should format the flow output data when Amazon S3 is used as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3OutputFormatConfigProperty s3OutputFormatConfigProperty = S3OutputFormatConfigProperty.builder()
     *         .aggregationConfig(AggregationConfigProperty.builder()
     *                 .aggregationType("aggregationType")
     *                 .targetFileSize(123)
     *                 .build())
     *         .fileType("fileType")
     *         .prefixConfig(PrefixConfigProperty.builder()
     *                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                 .prefixFormat("prefixFormat")
     *                 .prefixType("prefixType")
     *                 .build())
     *         .preserveSourceDataTyping(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3OutputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OutputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OutputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The aggregation settings that you can use to customize the output format of your flow data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-aggregationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-aggregationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationConfig() {
            return null;
        }

        /**
         * Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-filetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-filetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileType() {
            return null;
        }

        /**
         * Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
         * <p>
         * You can name folders according to the flow frequency and date.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-prefixconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-prefixconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrefixConfig() {
            return null;
        }

        /**
         * If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
         * <p>
         * <ul>
         * <li><code>true</code> : Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or <code>1</code> in your source data is still an integer in your output.</li>
         * <li><code>false</code> : Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in the output.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-preservesourcedatatyping">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3outputformatconfig.html#cfn-appflow-flow-s3outputformatconfig-preservesourcedatatyping</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPreserveSourceDataTyping() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OutputFormatConfigProperty> {
            java.lang.Object aggregationConfig;
            java.lang.String fileType;
            java.lang.Object prefixConfig;
            java.lang.Object preserveSourceDataTyping;

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.IResolvable aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.services.appflow.CfnFlow.AggregationConfigProperty aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getFileType}
             * @param fileType Indicates the file type that Amazon AppFlow places in the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileType(java.lang.String fileType) {
                this.fileType = fileType;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
             *                     You can name folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.IResolvable prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Determines the prefix that Amazon AppFlow applies to the folder name in the Amazon S3 bucket.
             *                     You can name folders according to the flow frequency and date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.services.appflow.CfnFlow.PrefixConfigProperty prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPreserveSourceDataTyping}
             * @param preserveSourceDataTyping If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
             *                                 <ul>
             *                                 <li><code>true</code> : Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or <code>1</code> in your source data is still an integer in your output.</li>
             *                                 <li><code>false</code> : Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in the output.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveSourceDataTyping(java.lang.Boolean preserveSourceDataTyping) {
                this.preserveSourceDataTyping = preserveSourceDataTyping;
                return this;
            }

            /**
             * Sets the value of {@link S3OutputFormatConfigProperty#getPreserveSourceDataTyping}
             * @param preserveSourceDataTyping If your file output format is Parquet, use this parameter to set whether Amazon AppFlow preserves the data types in your source data when it writes the output to Amazon S3.
             *                                 <ul>
             *                                 <li><code>true</code> : Amazon AppFlow preserves the data types when it writes to Amazon S3. For example, an integer or <code>1</code> in your source data is still an integer in your output.</li>
             *                                 <li><code>false</code> : Amazon AppFlow converts all of the source data into strings when it writes to Amazon S3. For example, an integer of <code>1</code> in your source data becomes the string <code>"1"</code> in the output.</li>
             *                                 </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveSourceDataTyping(software.amazon.awscdk.IResolvable preserveSourceDataTyping) {
                this.preserveSourceDataTyping = preserveSourceDataTyping;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OutputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OutputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OutputFormatConfigProperty {
            private final java.lang.Object aggregationConfig;
            private final java.lang.String fileType;
            private final java.lang.Object prefixConfig;
            private final java.lang.Object preserveSourceDataTyping;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.aggregationConfig = software.amazon.jsii.Kernel.get(this, "aggregationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileType = software.amazon.jsii.Kernel.get(this, "fileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.prefixConfig = software.amazon.jsii.Kernel.get(this, "prefixConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preserveSourceDataTyping = software.amazon.jsii.Kernel.get(this, "preserveSourceDataTyping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.aggregationConfig = builder.aggregationConfig;
                this.fileType = builder.fileType;
                this.prefixConfig = builder.prefixConfig;
                this.preserveSourceDataTyping = builder.preserveSourceDataTyping;
            }

            @Override
            public final java.lang.Object getAggregationConfig() {
                return this.aggregationConfig;
            }

            @Override
            public final java.lang.String getFileType() {
                return this.fileType;
            }

            @Override
            public final java.lang.Object getPrefixConfig() {
                return this.prefixConfig;
            }

            @Override
            public final java.lang.Object getPreserveSourceDataTyping() {
                return this.preserveSourceDataTyping;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAggregationConfig() != null) {
                    data.set("aggregationConfig", om.valueToTree(this.getAggregationConfig()));
                }
                if (this.getFileType() != null) {
                    data.set("fileType", om.valueToTree(this.getFileType()));
                }
                if (this.getPrefixConfig() != null) {
                    data.set("prefixConfig", om.valueToTree(this.getPrefixConfig()));
                }
                if (this.getPreserveSourceDataTyping() != null) {
                    data.set("preserveSourceDataTyping", om.valueToTree(this.getPreserveSourceDataTyping()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3OutputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OutputFormatConfigProperty.Jsii$Proxy that = (S3OutputFormatConfigProperty.Jsii$Proxy) o;

                if (this.aggregationConfig != null ? !this.aggregationConfig.equals(that.aggregationConfig) : that.aggregationConfig != null) return false;
                if (this.fileType != null ? !this.fileType.equals(that.fileType) : that.fileType != null) return false;
                if (this.prefixConfig != null ? !this.prefixConfig.equals(that.prefixConfig) : that.prefixConfig != null) return false;
                return this.preserveSourceDataTyping != null ? this.preserveSourceDataTyping.equals(that.preserveSourceDataTyping) : that.preserveSourceDataTyping == null;
            }

            @Override
            public final int hashCode() {
                int result = this.aggregationConfig != null ? this.aggregationConfig.hashCode() : 0;
                result = 31 * result + (this.fileType != null ? this.fileType.hashCode() : 0);
                result = 31 * result + (this.prefixConfig != null ? this.prefixConfig.hashCode() : 0);
                result = 31 * result + (this.preserveSourceDataTyping != null ? this.preserveSourceDataTyping.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Amazon S3 is being used as the flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * S3SourcePropertiesProperty s3SourcePropertiesProperty = S3SourcePropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         // the properties below are optional
     *         .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                 .s3InputFileType("s3InputFileType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.S3SourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(S3SourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3SourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon S3 bucket name where the source files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The object key for the Amazon S3 bucket in which the source files are stored.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketPrefix();

        /**
         * When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-s3inputformatconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-s3sourceproperties.html#cfn-appflow-flow-s3sourceproperties-s3inputformatconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3InputFormatConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3SourcePropertiesProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;
            java.lang.Object s3InputFormatConfig;

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketName}
             * @param bucketName The Amazon S3 bucket name where the source files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the Amazon S3 bucket in which the source files are stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getS3InputFormatConfig}
             * @param s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFormatConfig(software.amazon.awscdk.IResolvable s3InputFormatConfig) {
                this.s3InputFormatConfig = s3InputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link S3SourcePropertiesProperty#getS3InputFormatConfig}
             * @param s3InputFormatConfig When you use Amazon S3 as the source, the configuration format that you provide the flow input data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3InputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.S3InputFormatConfigProperty s3InputFormatConfig) {
                this.s3InputFormatConfig = s3InputFormatConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3SourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3SourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3SourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3SourcePropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object s3InputFormatConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3InputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3InputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.bucketPrefix = java.util.Objects.requireNonNull(builder.bucketPrefix, "bucketPrefix is required");
                this.s3InputFormatConfig = builder.s3InputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getS3InputFormatConfig() {
                return this.s3InputFormatConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                if (this.getS3InputFormatConfig() != null) {
                    data.set("s3InputFormatConfig", om.valueToTree(this.getS3InputFormatConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.S3SourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3SourcePropertiesProperty.Jsii$Proxy that = (S3SourcePropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!bucketPrefix.equals(that.bucketPrefix)) return false;
                return this.s3InputFormatConfig != null ? this.s3InputFormatConfig.equals(that.s3InputFormatConfig) : that.s3InputFormatConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.bucketPrefix.hashCode());
                result = 31 * result + (this.s3InputFormatConfig != null ? this.s3InputFormatConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using SAPOData as a flow destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataDestinationPropertiesProperty sAPODataDestinationPropertiesProperty = SAPODataDestinationPropertiesProperty.builder()
     *         .objectPath("objectPath")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .successResponseHandlingConfig(SuccessResponseHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .build())
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object path specified in the SAPOData flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-objectpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-objectpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectPath();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-idfieldnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-idfieldnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
         * <p>
         * For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-successresponsehandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-successresponsehandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSuccessResponseHandlingConfig() {
            return null;
        }

        /**
         * The possible write operations in the destination connector.
         * <p>
         * When this value is not provided, this defaults to the <code>INSERT</code> operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-writeoperationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatadestinationproperties.html#cfn-appflow-flow-sapodatadestinationproperties-writeoperationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataDestinationPropertiesProperty> {
            java.lang.String objectPath;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.Object successResponseHandlingConfig;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getObjectPath}
             * @param objectPath The object path specified in the SAPOData flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectPath(java.lang.String objectPath) {
                this.objectPath = objectPath;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames A list of field names that can be used as an ID field when performing a write operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getSuccessResponseHandlingConfig}
             * @param successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
             *                                      For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponseHandlingConfig(software.amazon.awscdk.IResolvable successResponseHandlingConfig) {
                this.successResponseHandlingConfig = successResponseHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getSuccessResponseHandlingConfig}
             * @param successResponseHandlingConfig Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
             *                                      For example, this setting would determine where to write the response from a destination connector upon a successful insert operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder successResponseHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.SuccessResponseHandlingConfigProperty successResponseHandlingConfig) {
                this.successResponseHandlingConfig = successResponseHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType The possible write operations in the destination connector.
             *                           When this value is not provided, this defaults to the <code>INSERT</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataDestinationPropertiesProperty {
            private final java.lang.String objectPath;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.Object successResponseHandlingConfig;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectPath = software.amazon.jsii.Kernel.get(this, "objectPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.successResponseHandlingConfig = software.amazon.jsii.Kernel.get(this, "successResponseHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectPath = java.util.Objects.requireNonNull(builder.objectPath, "objectPath is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.successResponseHandlingConfig = builder.successResponseHandlingConfig;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObjectPath() {
                return this.objectPath;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.Object getSuccessResponseHandlingConfig() {
                return this.successResponseHandlingConfig;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectPath", om.valueToTree(this.getObjectPath()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getSuccessResponseHandlingConfig() != null) {
                    data.set("successResponseHandlingConfig", om.valueToTree(this.getSuccessResponseHandlingConfig()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataDestinationPropertiesProperty.Jsii$Proxy that = (SAPODataDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!objectPath.equals(that.objectPath)) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                if (this.successResponseHandlingConfig != null ? !this.successResponseHandlingConfig.equals(that.successResponseHandlingConfig) : that.successResponseHandlingConfig != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectPath.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.successResponseHandlingConfig != null ? this.successResponseHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * SAP Source connector page size.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataPaginationConfigProperty sAPODataPaginationConfigProperty = SAPODataPaginationConfigProperty.builder()
     *         .maxPageSize(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatapaginationconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatapaginationconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataPaginationConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataPaginationConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataPaginationConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatapaginationconfig.html#cfn-appflow-flow-sapodatapaginationconfig-maxpagesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatapaginationconfig.html#cfn-appflow-flow-sapodatapaginationconfig-maxpagesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxPageSize();

        /**
         * @return a {@link Builder} of {@link SAPODataPaginationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataPaginationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataPaginationConfigProperty> {
            java.lang.Number maxPageSize;

            /**
             * Sets the value of {@link SAPODataPaginationConfigProperty#getMaxPageSize}
             * @param maxPageSize the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxPageSize(java.lang.Number maxPageSize) {
                this.maxPageSize = maxPageSize;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataPaginationConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataPaginationConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataPaginationConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataPaginationConfigProperty {
            private final java.lang.Number maxPageSize;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxPageSize = software.amazon.jsii.Kernel.get(this, "maxPageSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxPageSize = java.util.Objects.requireNonNull(builder.maxPageSize, "maxPageSize is required");
            }

            @Override
            public final java.lang.Number getMaxPageSize() {
                return this.maxPageSize;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxPageSize", om.valueToTree(this.getMaxPageSize()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataPaginationConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataPaginationConfigProperty.Jsii$Proxy that = (SAPODataPaginationConfigProperty.Jsii$Proxy) o;

                return this.maxPageSize.equals(that.maxPageSize);
            }

            @Override
            public final int hashCode() {
                int result = this.maxPageSize.hashCode();
                return result;
            }
        }
    }
    /**
     * SAP Source connector parallelism factor.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataParallelismConfigProperty sAPODataParallelismConfigProperty = SAPODataParallelismConfigProperty.builder()
     *         .maxParallelism(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodataparallelismconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodataparallelismconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataParallelismConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataParallelismConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataParallelismConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodataparallelismconfig.html#cfn-appflow-flow-sapodataparallelismconfig-maxparallelism">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodataparallelismconfig.html#cfn-appflow-flow-sapodataparallelismconfig-maxparallelism</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMaxParallelism();

        /**
         * @return a {@link Builder} of {@link SAPODataParallelismConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataParallelismConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataParallelismConfigProperty> {
            java.lang.Number maxParallelism;

            /**
             * Sets the value of {@link SAPODataParallelismConfigProperty#getMaxParallelism}
             * @param maxParallelism the value to be set. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxParallelism(java.lang.Number maxParallelism) {
                this.maxParallelism = maxParallelism;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataParallelismConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataParallelismConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataParallelismConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataParallelismConfigProperty {
            private final java.lang.Number maxParallelism;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxParallelism = software.amazon.jsii.Kernel.get(this, "maxParallelism", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxParallelism = java.util.Objects.requireNonNull(builder.maxParallelism, "maxParallelism is required");
            }

            @Override
            public final java.lang.Number getMaxParallelism() {
                return this.maxParallelism;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("maxParallelism", om.valueToTree(this.getMaxParallelism()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataParallelismConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataParallelismConfigProperty.Jsii$Proxy that = (SAPODataParallelismConfigProperty.Jsii$Proxy) o;

                return this.maxParallelism.equals(that.maxParallelism);
            }

            @Override
            public final int hashCode() {
                int result = this.maxParallelism.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using SAPOData as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SAPODataSourcePropertiesProperty sAPODataSourcePropertiesProperty = SAPODataSourcePropertiesProperty.builder()
     *         .objectPath("objectPath")
     *         // the properties below are optional
     *         .paginationConfig(SAPODataPaginationConfigProperty.builder()
     *                 .maxPageSize(123)
     *                 .build())
     *         .parallelismConfig(SAPODataParallelismConfigProperty.builder()
     *                 .maxParallelism(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SAPODataSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SAPODataSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAPODataSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object path specified in the SAPOData flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-objectpath">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-objectpath</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObjectPath();

        /**
         * SAP Source connector page size.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-paginationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-paginationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPaginationConfig() {
            return null;
        }

        /**
         * SAP Source connector parallelism factor.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-parallelismconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sapodatasourceproperties.html#cfn-appflow-flow-sapodatasourceproperties-parallelismconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getParallelismConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAPODataSourcePropertiesProperty> {
            java.lang.String objectPath;
            java.lang.Object paginationConfig;
            java.lang.Object parallelismConfig;

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getObjectPath}
             * @param objectPath The object path specified in the SAPOData flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder objectPath(java.lang.String objectPath) {
                this.objectPath = objectPath;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getPaginationConfig}
             * @param paginationConfig SAP Source connector page size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paginationConfig(software.amazon.awscdk.IResolvable paginationConfig) {
                this.paginationConfig = paginationConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getPaginationConfig}
             * @param paginationConfig SAP Source connector page size.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paginationConfig(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataPaginationConfigProperty paginationConfig) {
                this.paginationConfig = paginationConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getParallelismConfig}
             * @param parallelismConfig SAP Source connector parallelism factor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelismConfig(software.amazon.awscdk.IResolvable parallelismConfig) {
                this.parallelismConfig = parallelismConfig;
                return this;
            }

            /**
             * Sets the value of {@link SAPODataSourcePropertiesProperty#getParallelismConfig}
             * @param parallelismConfig SAP Source connector parallelism factor.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parallelismConfig(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataParallelismConfigProperty parallelismConfig) {
                this.parallelismConfig = parallelismConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAPODataSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAPODataSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAPODataSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAPODataSourcePropertiesProperty {
            private final java.lang.String objectPath;
            private final java.lang.Object paginationConfig;
            private final java.lang.Object parallelismConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.objectPath = software.amazon.jsii.Kernel.get(this, "objectPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.paginationConfig = software.amazon.jsii.Kernel.get(this, "paginationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.parallelismConfig = software.amazon.jsii.Kernel.get(this, "parallelismConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.objectPath = java.util.Objects.requireNonNull(builder.objectPath, "objectPath is required");
                this.paginationConfig = builder.paginationConfig;
                this.parallelismConfig = builder.parallelismConfig;
            }

            @Override
            public final java.lang.String getObjectPath() {
                return this.objectPath;
            }

            @Override
            public final java.lang.Object getPaginationConfig() {
                return this.paginationConfig;
            }

            @Override
            public final java.lang.Object getParallelismConfig() {
                return this.parallelismConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("objectPath", om.valueToTree(this.getObjectPath()));
                if (this.getPaginationConfig() != null) {
                    data.set("paginationConfig", om.valueToTree(this.getPaginationConfig()));
                }
                if (this.getParallelismConfig() != null) {
                    data.set("parallelismConfig", om.valueToTree(this.getParallelismConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SAPODataSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAPODataSourcePropertiesProperty.Jsii$Proxy that = (SAPODataSourcePropertiesProperty.Jsii$Proxy) o;

                if (!objectPath.equals(that.objectPath)) return false;
                if (this.paginationConfig != null ? !this.paginationConfig.equals(that.paginationConfig) : that.paginationConfig != null) return false;
                return this.parallelismConfig != null ? this.parallelismConfig.equals(that.parallelismConfig) : that.parallelismConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.objectPath.hashCode();
                result = 31 * result + (this.paginationConfig != null ? this.paginationConfig.hashCode() : 0);
                result = 31 * result + (this.parallelismConfig != null ? this.parallelismConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceDestinationPropertiesProperty salesforceDestinationPropertiesProperty = SalesforceDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .dataTransferApi("dataTransferApi")
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SalesforceDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
         * <p>
         * <ul>
         * <li><strong>AUTOMATIC</strong> - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.</li>
         * </ul>
         * <p>
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         * <p>
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
         * <p>
         * <ul>
         * <li><strong>BULKV2</strong> - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.</li>
         * </ul>
         * <p>
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         * <p>
         * <ul>
         * <li><strong>REST_SYNC</strong> - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-datatransferapi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-datatransferapi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataTransferApi() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-idfieldnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-idfieldnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * This specifies the type of write operation to be performed in Salesforce.
         * <p>
         * When the value is <code>UPSERT</code> , then <code>idFieldNames</code> is required.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-writeoperationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcedestinationproperties.html#cfn-appflow-flow-salesforcedestinationproperties-writeoperationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.String dataTransferApi;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Salesforce flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getDataTransferApi}
             * @param dataTransferApi Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data to Salesforce.
             *                        <ul>
             *                        <li><strong>AUTOMATIC</strong> - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers to Salesforce. If your flow transfers fewer than 1,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.</li>
             *                        </ul>
             *                        <p>
             *                        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900 records, and it might use Bulk API 2.0 on the next day to transfer 1,100 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
             *                        <p>
             *                        By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
             *                        <p>
             *                        <ul>
             *                        <li><strong>BULKV2</strong> - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.</li>
             *                        </ul>
             *                        <p>
             *                        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
             *                        <p>
             *                        <ul>
             *                        <li><strong>REST_SYNC</strong> - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail with a timed out error.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransferApi(java.lang.String dataTransferApi) {
                this.dataTransferApi = dataTransferApi;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Salesforce destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames The name of the field that Amazon AppFlow uses as an ID when performing a write operation such as update or delete.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType This specifies the type of write operation to be performed in Salesforce.
             *                           When the value is <code>UPSERT</code> , then <code>idFieldNames</code> is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.String dataTransferApi;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTransferApi = software.amazon.jsii.Kernel.get(this, "dataTransferApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.dataTransferApi = builder.dataTransferApi;
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getDataTransferApi() {
                return this.dataTransferApi;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getDataTransferApi() != null) {
                    data.set("dataTransferApi", om.valueToTree(this.getDataTransferApi()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SalesforceDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceDestinationPropertiesProperty.Jsii$Proxy that = (SalesforceDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.dataTransferApi != null ? !this.dataTransferApi.equals(that.dataTransferApi) : that.dataTransferApi != null) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.dataTransferApi != null ? this.dataTransferApi.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Salesforce is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SalesforceSourcePropertiesProperty salesforceSourcePropertiesProperty = SalesforceSourcePropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .dataTransferApi("dataTransferApi")
     *         .enableDynamicFieldUpdate(false)
     *         .includeDeletedRecords(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SalesforceSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SalesforceSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SalesforceSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Salesforce flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
         * <p>
         * <ul>
         * <li><strong>AUTOMATIC</strong> - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.</li>
         * </ul>
         * <p>
         * Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
         * <p>
         * By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
         * <p>
         * <ul>
         * <li><strong>BULKV2</strong> - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.</li>
         * </ul>
         * <p>
         * Note that Bulk API 2.0 does not transfer Salesforce compound fields.
         * <p>
         * <ul>
         * <li><strong>REST_SYNC</strong> - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-datatransferapi">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-datatransferapi</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataTransferApi() {
            return null;
        }

        /**
         * The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-enabledynamicfieldupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-enabledynamicfieldupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableDynamicFieldUpdate() {
            return null;
        }

        /**
         * Indicates whether Amazon AppFlow includes deleted files in the flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-includedeletedrecords">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-salesforcesourceproperties.html#cfn-appflow-flow-salesforcesourceproperties-includedeletedrecords</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeDeletedRecords() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SalesforceSourcePropertiesProperty> {
            java.lang.String object;
            java.lang.String dataTransferApi;
            java.lang.Object enableDynamicFieldUpdate;
            java.lang.Object includeDeletedRecords;

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getObject}
             * @param object The object specified in the Salesforce flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getDataTransferApi}
             * @param dataTransferApi Specifies which Salesforce API is used by Amazon AppFlow when your flow transfers data from Salesforce.
             *                        <ul>
             *                        <li><strong>AUTOMATIC</strong> - The default. Amazon AppFlow selects which API to use based on the number of records that your flow transfers from Salesforce. If your flow transfers fewer than 1,000,000 records, Amazon AppFlow uses Salesforce REST API. If your flow transfers 1,000,000 records or more, Amazon AppFlow uses Salesforce Bulk API 2.0.</li>
             *                        </ul>
             *                        <p>
             *                        Each of these Salesforce APIs structures data differently. If Amazon AppFlow selects the API automatically, be aware that, for recurring flows, the data output might vary from one flow run to the next. For example, if a flow runs daily, it might use REST API on one day to transfer 900,000 records, and it might use Bulk API 2.0 on the next day to transfer 1,100,000 records. For each of these flow runs, the respective Salesforce API formats the data differently. Some of the differences include how dates are formatted and null values are represented. Also, Bulk API 2.0 doesn't transfer Salesforce compound fields.
             *                        <p>
             *                        By choosing this option, you optimize flow performance for both small and large data transfers, but the tradeoff is inconsistent formatting in the output.
             *                        <p>
             *                        <ul>
             *                        <li><strong>BULKV2</strong> - Amazon AppFlow uses only Salesforce Bulk API 2.0. This API runs asynchronous data transfers, and it's optimal for large sets of data. By choosing this option, you ensure that your flow writes consistent output, but you optimize performance only for large data transfers.</li>
             *                        </ul>
             *                        <p>
             *                        Note that Bulk API 2.0 does not transfer Salesforce compound fields.
             *                        <p>
             *                        <ul>
             *                        <li><strong>REST_SYNC</strong> - Amazon AppFlow uses only Salesforce REST API. By choosing this option, you ensure that your flow writes consistent output, but you decrease performance for large data transfers that are better suited for Bulk API 2.0. In some cases, if your flow attempts to transfer a vary large set of data, it might fail wituh a timed out error.</li>
             *                        </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataTransferApi(java.lang.String dataTransferApi) {
                this.dataTransferApi = dataTransferApi;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(java.lang.Boolean enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getEnableDynamicFieldUpdate}
             * @param enableDynamicFieldUpdate The flag that enables dynamic fetching of new (recently added) fields in the Salesforce objects while running a flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableDynamicFieldUpdate(software.amazon.awscdk.IResolvable enableDynamicFieldUpdate) {
                this.enableDynamicFieldUpdate = enableDynamicFieldUpdate;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(java.lang.Boolean includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Sets the value of {@link SalesforceSourcePropertiesProperty#getIncludeDeletedRecords}
             * @param includeDeletedRecords Indicates whether Amazon AppFlow includes deleted files in the flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeDeletedRecords(software.amazon.awscdk.IResolvable includeDeletedRecords) {
                this.includeDeletedRecords = includeDeletedRecords;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SalesforceSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SalesforceSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SalesforceSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SalesforceSourcePropertiesProperty {
            private final java.lang.String object;
            private final java.lang.String dataTransferApi;
            private final java.lang.Object enableDynamicFieldUpdate;
            private final java.lang.Object includeDeletedRecords;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataTransferApi = software.amazon.jsii.Kernel.get(this, "dataTransferApi", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enableDynamicFieldUpdate = software.amazon.jsii.Kernel.get(this, "enableDynamicFieldUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeDeletedRecords = software.amazon.jsii.Kernel.get(this, "includeDeletedRecords", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.dataTransferApi = builder.dataTransferApi;
                this.enableDynamicFieldUpdate = builder.enableDynamicFieldUpdate;
                this.includeDeletedRecords = builder.includeDeletedRecords;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getDataTransferApi() {
                return this.dataTransferApi;
            }

            @Override
            public final java.lang.Object getEnableDynamicFieldUpdate() {
                return this.enableDynamicFieldUpdate;
            }

            @Override
            public final java.lang.Object getIncludeDeletedRecords() {
                return this.includeDeletedRecords;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getDataTransferApi() != null) {
                    data.set("dataTransferApi", om.valueToTree(this.getDataTransferApi()));
                }
                if (this.getEnableDynamicFieldUpdate() != null) {
                    data.set("enableDynamicFieldUpdate", om.valueToTree(this.getEnableDynamicFieldUpdate()));
                }
                if (this.getIncludeDeletedRecords() != null) {
                    data.set("includeDeletedRecords", om.valueToTree(this.getIncludeDeletedRecords()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SalesforceSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SalesforceSourcePropertiesProperty.Jsii$Proxy that = (SalesforceSourcePropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.dataTransferApi != null ? !this.dataTransferApi.equals(that.dataTransferApi) : that.dataTransferApi != null) return false;
                if (this.enableDynamicFieldUpdate != null ? !this.enableDynamicFieldUpdate.equals(that.enableDynamicFieldUpdate) : that.enableDynamicFieldUpdate != null) return false;
                return this.includeDeletedRecords != null ? this.includeDeletedRecords.equals(that.includeDeletedRecords) : that.includeDeletedRecords == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.dataTransferApi != null ? this.dataTransferApi.hashCode() : 0);
                result = 31 * result + (this.enableDynamicFieldUpdate != null ? this.enableDynamicFieldUpdate.hashCode() : 0);
                result = 31 * result + (this.includeDeletedRecords != null ? this.includeDeletedRecords.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the configuration details of a schedule-triggered flow as defined by the user.
     * <p>
     * Currently, these settings only apply to the <code>Scheduled</code> trigger type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ScheduledTriggerPropertiesProperty scheduledTriggerPropertiesProperty = ScheduledTriggerPropertiesProperty.builder()
     *         .scheduleExpression("scheduleExpression")
     *         // the properties below are optional
     *         .dataPullMode("dataPullMode")
     *         .firstExecutionFrom(123)
     *         .flowErrorDeactivationThreshold(123)
     *         .scheduleEndTime(123)
     *         .scheduleOffset(123)
     *         .scheduleStartTime(123)
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ScheduledTriggerPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduledTriggerPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduledTriggerPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleexpression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleexpression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getScheduleExpression();

        /**
         * Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-datapullmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-datapullmode</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDataPullMode() {
            return null;
        }

        /**
         * Specifies the date range for the records to import from the connector in the first flow run.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-firstexecutionfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-firstexecutionfrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFirstExecutionFrom() {
            return null;
        }

        /**
         * Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-flowerrordeactivationthreshold">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-flowerrordeactivationthreshold</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getFlowErrorDeactivationThreshold() {
            return null;
        }

        /**
         * The time at which the scheduled flow ends.
         * <p>
         * The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-27T13:00:00-07:00</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleendtime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleendtime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleEndTime() {
            return null;
        }

        /**
         * Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleoffset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-scheduleoffset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleOffset() {
            return null;
        }

        /**
         * The time at which the scheduled flow starts.
         * <p>
         * The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-26T13:00:00-07:00</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-schedulestarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-schedulestarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getScheduleStartTime() {
            return null;
        }

        /**
         * Specifies the time zone used when referring to the dates and times of a scheduled flow, such as <code>America/New_York</code> .
         * <p>
         * This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
         * <p>
         * If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are <code>-04:00</code> EDT and <code>-05:00 EST</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-scheduledtriggerproperties.html#cfn-appflow-flow-scheduledtriggerproperties-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTimeZone() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduledTriggerPropertiesProperty> {
            java.lang.String scheduleExpression;
            java.lang.String dataPullMode;
            java.lang.Number firstExecutionFrom;
            java.lang.Number flowErrorDeactivationThreshold;
            java.lang.Number scheduleEndTime;
            java.lang.Number scheduleOffset;
            java.lang.Number scheduleStartTime;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleExpression}
             * @param scheduleExpression The scheduling expression that determines the rate at which the schedule will run, for example <code>rate(5minutes)</code> . This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleExpression(java.lang.String scheduleExpression) {
                this.scheduleExpression = scheduleExpression;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getDataPullMode}
             * @param dataPullMode Specifies whether a scheduled flow has an incremental data transfer or a complete data transfer for each flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataPullMode(java.lang.String dataPullMode) {
                this.dataPullMode = dataPullMode;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getFirstExecutionFrom}
             * @param firstExecutionFrom Specifies the date range for the records to import from the connector in the first flow run.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder firstExecutionFrom(java.lang.Number firstExecutionFrom) {
                this.firstExecutionFrom = firstExecutionFrom;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getFlowErrorDeactivationThreshold}
             * @param flowErrorDeactivationThreshold Defines how many times a scheduled flow fails consecutively before Amazon AppFlow deactivates it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder flowErrorDeactivationThreshold(java.lang.Number flowErrorDeactivationThreshold) {
                this.flowErrorDeactivationThreshold = flowErrorDeactivationThreshold;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleEndTime}
             * @param scheduleEndTime The time at which the scheduled flow ends.
             *                        The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-27T13:00:00-07:00</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleEndTime(java.lang.Number scheduleEndTime) {
                this.scheduleEndTime = scheduleEndTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleOffset}
             * @param scheduleOffset Specifies the optional offset that is added to the time interval for a schedule-triggered flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleOffset(java.lang.Number scheduleOffset) {
                this.scheduleOffset = scheduleOffset;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getScheduleStartTime}
             * @param scheduleStartTime The time at which the scheduled flow starts.
             *                          The time is formatted as a timestamp that follows the ISO 8601 standard, such as <code>2022-04-26T13:00:00-07:00</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scheduleStartTime(java.lang.Number scheduleStartTime) {
                this.scheduleStartTime = scheduleStartTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduledTriggerPropertiesProperty#getTimeZone}
             * @param timeZone Specifies the time zone used when referring to the dates and times of a scheduled flow, such as <code>America/New_York</code> .
             *                 This time zone is only a descriptive label. It doesn't affect how Amazon AppFlow interprets the timestamps that you specify to schedule the flow.
             *                 <p>
             *                 If you want to schedule a flow by using times in a particular time zone, indicate the time zone as a UTC offset in your timestamps. For example, the UTC offsets for the <code>America/New_York</code> timezone are <code>-04:00</code> EDT and <code>-05:00 EST</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduledTriggerPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduledTriggerPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduledTriggerPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduledTriggerPropertiesProperty {
            private final java.lang.String scheduleExpression;
            private final java.lang.String dataPullMode;
            private final java.lang.Number firstExecutionFrom;
            private final java.lang.Number flowErrorDeactivationThreshold;
            private final java.lang.Number scheduleEndTime;
            private final java.lang.Number scheduleOffset;
            private final java.lang.Number scheduleStartTime;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.scheduleExpression = software.amazon.jsii.Kernel.get(this, "scheduleExpression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dataPullMode = software.amazon.jsii.Kernel.get(this, "dataPullMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.firstExecutionFrom = software.amazon.jsii.Kernel.get(this, "firstExecutionFrom", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.flowErrorDeactivationThreshold = software.amazon.jsii.Kernel.get(this, "flowErrorDeactivationThreshold", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleEndTime = software.amazon.jsii.Kernel.get(this, "scheduleEndTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleOffset = software.amazon.jsii.Kernel.get(this, "scheduleOffset", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.scheduleStartTime = software.amazon.jsii.Kernel.get(this, "scheduleStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.scheduleExpression = java.util.Objects.requireNonNull(builder.scheduleExpression, "scheduleExpression is required");
                this.dataPullMode = builder.dataPullMode;
                this.firstExecutionFrom = builder.firstExecutionFrom;
                this.flowErrorDeactivationThreshold = builder.flowErrorDeactivationThreshold;
                this.scheduleEndTime = builder.scheduleEndTime;
                this.scheduleOffset = builder.scheduleOffset;
                this.scheduleStartTime = builder.scheduleStartTime;
                this.timeZone = builder.timeZone;
            }

            @Override
            public final java.lang.String getScheduleExpression() {
                return this.scheduleExpression;
            }

            @Override
            public final java.lang.String getDataPullMode() {
                return this.dataPullMode;
            }

            @Override
            public final java.lang.Number getFirstExecutionFrom() {
                return this.firstExecutionFrom;
            }

            @Override
            public final java.lang.Number getFlowErrorDeactivationThreshold() {
                return this.flowErrorDeactivationThreshold;
            }

            @Override
            public final java.lang.Number getScheduleEndTime() {
                return this.scheduleEndTime;
            }

            @Override
            public final java.lang.Number getScheduleOffset() {
                return this.scheduleOffset;
            }

            @Override
            public final java.lang.Number getScheduleStartTime() {
                return this.scheduleStartTime;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("scheduleExpression", om.valueToTree(this.getScheduleExpression()));
                if (this.getDataPullMode() != null) {
                    data.set("dataPullMode", om.valueToTree(this.getDataPullMode()));
                }
                if (this.getFirstExecutionFrom() != null) {
                    data.set("firstExecutionFrom", om.valueToTree(this.getFirstExecutionFrom()));
                }
                if (this.getFlowErrorDeactivationThreshold() != null) {
                    data.set("flowErrorDeactivationThreshold", om.valueToTree(this.getFlowErrorDeactivationThreshold()));
                }
                if (this.getScheduleEndTime() != null) {
                    data.set("scheduleEndTime", om.valueToTree(this.getScheduleEndTime()));
                }
                if (this.getScheduleOffset() != null) {
                    data.set("scheduleOffset", om.valueToTree(this.getScheduleOffset()));
                }
                if (this.getScheduleStartTime() != null) {
                    data.set("scheduleStartTime", om.valueToTree(this.getScheduleStartTime()));
                }
                if (this.getTimeZone() != null) {
                    data.set("timeZone", om.valueToTree(this.getTimeZone()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ScheduledTriggerPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduledTriggerPropertiesProperty.Jsii$Proxy that = (ScheduledTriggerPropertiesProperty.Jsii$Proxy) o;

                if (!scheduleExpression.equals(that.scheduleExpression)) return false;
                if (this.dataPullMode != null ? !this.dataPullMode.equals(that.dataPullMode) : that.dataPullMode != null) return false;
                if (this.firstExecutionFrom != null ? !this.firstExecutionFrom.equals(that.firstExecutionFrom) : that.firstExecutionFrom != null) return false;
                if (this.flowErrorDeactivationThreshold != null ? !this.flowErrorDeactivationThreshold.equals(that.flowErrorDeactivationThreshold) : that.flowErrorDeactivationThreshold != null) return false;
                if (this.scheduleEndTime != null ? !this.scheduleEndTime.equals(that.scheduleEndTime) : that.scheduleEndTime != null) return false;
                if (this.scheduleOffset != null ? !this.scheduleOffset.equals(that.scheduleOffset) : that.scheduleOffset != null) return false;
                if (this.scheduleStartTime != null ? !this.scheduleStartTime.equals(that.scheduleStartTime) : that.scheduleStartTime != null) return false;
                return this.timeZone != null ? this.timeZone.equals(that.timeZone) : that.timeZone == null;
            }

            @Override
            public final int hashCode() {
                int result = this.scheduleExpression.hashCode();
                result = 31 * result + (this.dataPullMode != null ? this.dataPullMode.hashCode() : 0);
                result = 31 * result + (this.firstExecutionFrom != null ? this.firstExecutionFrom.hashCode() : 0);
                result = 31 * result + (this.flowErrorDeactivationThreshold != null ? this.flowErrorDeactivationThreshold.hashCode() : 0);
                result = 31 * result + (this.scheduleEndTime != null ? this.scheduleEndTime.hashCode() : 0);
                result = 31 * result + (this.scheduleOffset != null ? this.scheduleOffset.hashCode() : 0);
                result = 31 * result + (this.scheduleStartTime != null ? this.scheduleStartTime.hashCode() : 0);
                result = 31 * result + (this.timeZone != null ? this.timeZone.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when ServiceNow is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ServiceNowSourcePropertiesProperty serviceNowSourcePropertiesProperty = ServiceNowSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ServiceNowSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceNowSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceNowSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the ServiceNow flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html#cfn-appflow-flow-servicenowsourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-servicenowsourceproperties.html#cfn-appflow-flow-servicenowsourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceNowSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ServiceNowSourcePropertiesProperty#getObject}
             * @param object The object specified in the ServiceNow flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceNowSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceNowSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceNowSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceNowSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ServiceNowSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceNowSourcePropertiesProperty.Jsii$Proxy that = (ServiceNowSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Singular is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SingularSourcePropertiesProperty singularSourcePropertiesProperty = SingularSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SingularSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SingularSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SingularSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Singular flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html#cfn-appflow-flow-singularsourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-singularsourceproperties.html#cfn-appflow-flow-singularsourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SingularSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link SingularSourcePropertiesProperty#getObject}
             * @param object The object specified in the Singular flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SingularSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SingularSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SingularSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingularSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SingularSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SingularSourcePropertiesProperty.Jsii$Proxy that = (SingularSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Slack is being used as a source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SlackSourcePropertiesProperty slackSourcePropertiesProperty = SlackSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SlackSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SlackSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SlackSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Slack flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html#cfn-appflow-flow-slacksourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-slacksourceproperties.html#cfn-appflow-flow-slacksourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SlackSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link SlackSourcePropertiesProperty#getObject}
             * @param object The object specified in the Slack flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SlackSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SlackSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SlackSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SlackSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SlackSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SlackSourcePropertiesProperty.Jsii$Proxy that = (SlackSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Snowflake is being used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SnowflakeDestinationPropertiesProperty snowflakeDestinationPropertiesProperty = SnowflakeDestinationPropertiesProperty.builder()
     *         .intermediateBucketName("intermediateBucketName")
     *         .object("object")
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SnowflakeDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SnowflakeDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnowflakeDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-intermediatebucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-intermediatebucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getIntermediateBucketName();

        /**
         * The object specified in the Snowflake flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The object key for the destination bucket in which Amazon AppFlow places the files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-snowflakedestinationproperties.html#cfn-appflow-flow-snowflakedestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnowflakeDestinationPropertiesProperty> {
            java.lang.String intermediateBucketName;
            java.lang.String object;
            java.lang.String bucketPrefix;
            java.lang.Object errorHandlingConfig;

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getIntermediateBucketName}
             * @param intermediateBucketName The intermediate bucket that Amazon AppFlow uses when moving data into Snowflake. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder intermediateBucketName(java.lang.String intermediateBucketName) {
                this.intermediateBucketName = intermediateBucketName;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Snowflake flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link SnowflakeDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the Snowflake destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnowflakeDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnowflakeDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnowflakeDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnowflakeDestinationPropertiesProperty {
            private final java.lang.String intermediateBucketName;
            private final java.lang.String object;
            private final java.lang.String bucketPrefix;
            private final java.lang.Object errorHandlingConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.intermediateBucketName = software.amazon.jsii.Kernel.get(this, "intermediateBucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.intermediateBucketName = java.util.Objects.requireNonNull(builder.intermediateBucketName, "intermediateBucketName is required");
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.bucketPrefix = builder.bucketPrefix;
                this.errorHandlingConfig = builder.errorHandlingConfig;
            }

            @Override
            public final java.lang.String getIntermediateBucketName() {
                return this.intermediateBucketName;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("intermediateBucketName", om.valueToTree(this.getIntermediateBucketName()));
                data.set("object", om.valueToTree(this.getObject()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SnowflakeDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnowflakeDestinationPropertiesProperty.Jsii$Proxy that = (SnowflakeDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!intermediateBucketName.equals(that.intermediateBucketName)) return false;
                if (!object.equals(that.object)) return false;
                if (this.bucketPrefix != null ? !this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix != null) return false;
                return this.errorHandlingConfig != null ? this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.intermediateBucketName.hashCode();
                result = 31 * result + (this.object.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies the information that is required to query a particular connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SourceConnectorPropertiesProperty sourceConnectorPropertiesProperty = SourceConnectorPropertiesProperty.builder()
     *         .amplitude(AmplitudeSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .customConnector(CustomConnectorSourcePropertiesProperty.builder()
     *                 .entityName("entityName")
     *                 // the properties below are optional
     *                 .customProperties(Map.of(
     *                         "customPropertiesKey", "customProperties"))
     *                 .dataTransferApi(DataTransferApiProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build())
     *                 .build())
     *         .datadog(DatadogSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .dynatrace(DynatraceSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .inforNexus(InforNexusSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .marketo(MarketoSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .pardot(PardotSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .s3(S3SourcePropertiesProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 // the properties below are optional
     *                 .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                         .s3InputFileType("s3InputFileType")
     *                         .build())
     *                 .build())
     *         .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .dataTransferApi("dataTransferApi")
     *                 .enableDynamicFieldUpdate(false)
     *                 .includeDeletedRecords(false)
     *                 .build())
     *         .sapoData(SAPODataSourcePropertiesProperty.builder()
     *                 .objectPath("objectPath")
     *                 // the properties below are optional
     *                 .paginationConfig(SAPODataPaginationConfigProperty.builder()
     *                         .maxPageSize(123)
     *                         .build())
     *                 .parallelismConfig(SAPODataParallelismConfigProperty.builder()
     *                         .maxParallelism(123)
     *                         .build())
     *                 .build())
     *         .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .singular(SingularSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .slack(SlackSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .trendmicro(TrendmicroSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .veeva(VeevaSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 // the properties below are optional
     *                 .documentType("documentType")
     *                 .includeAllVersions(false)
     *                 .includeRenditions(false)
     *                 .includeSourceFiles(false)
     *                 .build())
     *         .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                 .object("object")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SourceConnectorPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceConnectorPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceConnectorPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the information that is required for querying Amplitude.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-amplitude">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-amplitude</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAmplitude() {
            return null;
        }

        /**
         * The properties that are applied when the custom connector is being used as a source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-customconnector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-customconnector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomConnector() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Datadog.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-datadog">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-datadog</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDatadog() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Dynatrace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-dynatrace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-dynatrace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDynatrace() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Google Analytics.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-googleanalytics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-googleanalytics</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGoogleAnalytics() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Infor Nexus.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-infornexus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-infornexus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInforNexus() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Marketo.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-marketo">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-marketo</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMarketo() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Salesforce Pardot.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-pardot">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-pardot</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPardot() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Amazon S3.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Salesforce.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-salesforce">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-salesforce</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSalesforce() {
            return null;
        }

        /**
         * The properties that are applied when using SAPOData as a flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-sapodata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-sapodata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSapoData() {
            return null;
        }

        /**
         * Specifies the information that is required for querying ServiceNow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-servicenow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-servicenow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServiceNow() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Singular.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-singular">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-singular</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSingular() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Slack.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-slack">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-slack</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSlack() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Trend Micro.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-trendmicro">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-trendmicro</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTrendmicro() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Veeva.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-veeva">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-veeva</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVeeva() {
            return null;
        }

        /**
         * Specifies the information that is required for querying Zendesk.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-zendesk">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceconnectorproperties.html#cfn-appflow-flow-sourceconnectorproperties-zendesk</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZendesk() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceConnectorPropertiesProperty> {
            java.lang.Object amplitude;
            java.lang.Object customConnector;
            java.lang.Object datadog;
            java.lang.Object dynatrace;
            java.lang.Object googleAnalytics;
            java.lang.Object inforNexus;
            java.lang.Object marketo;
            java.lang.Object pardot;
            java.lang.Object s3;
            java.lang.Object salesforce;
            java.lang.Object sapoData;
            java.lang.Object serviceNow;
            java.lang.Object singular;
            java.lang.Object slack;
            java.lang.Object trendmicro;
            java.lang.Object veeva;
            java.lang.Object zendesk;

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getAmplitude}
             * @param amplitude Specifies the information that is required for querying Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.IResolvable amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getAmplitude}
             * @param amplitude Specifies the information that is required for querying Amplitude.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder amplitude(software.amazon.awscdk.services.appflow.CfnFlow.AmplitudeSourcePropertiesProperty amplitude) {
                this.amplitude = amplitude;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector The properties that are applied when the custom connector is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.IResolvable customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getCustomConnector}
             * @param customConnector The properties that are applied when the custom connector is being used as a source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customConnector(software.amazon.awscdk.services.appflow.CfnFlow.CustomConnectorSourcePropertiesProperty customConnector) {
                this.customConnector = customConnector;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDatadog}
             * @param datadog Specifies the information that is required for querying Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.IResolvable datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDatadog}
             * @param datadog Specifies the information that is required for querying Datadog.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder datadog(software.amazon.awscdk.services.appflow.CfnFlow.DatadogSourcePropertiesProperty datadog) {
                this.datadog = datadog;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDynatrace}
             * @param dynatrace Specifies the information that is required for querying Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.IResolvable dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getDynatrace}
             * @param dynatrace Specifies the information that is required for querying Dynatrace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dynatrace(software.amazon.awscdk.services.appflow.CfnFlow.DynatraceSourcePropertiesProperty dynatrace) {
                this.dynatrace = dynatrace;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getGoogleAnalytics}
             * @param googleAnalytics Specifies the information that is required for querying Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.IResolvable googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getGoogleAnalytics}
             * @param googleAnalytics Specifies the information that is required for querying Google Analytics.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder googleAnalytics(software.amazon.awscdk.services.appflow.CfnFlow.GoogleAnalyticsSourcePropertiesProperty googleAnalytics) {
                this.googleAnalytics = googleAnalytics;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getInforNexus}
             * @param inforNexus Specifies the information that is required for querying Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.IResolvable inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getInforNexus}
             * @param inforNexus Specifies the information that is required for querying Infor Nexus.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inforNexus(software.amazon.awscdk.services.appflow.CfnFlow.InforNexusSourcePropertiesProperty inforNexus) {
                this.inforNexus = inforNexus;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo Specifies the information that is required for querying Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.IResolvable marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getMarketo}
             * @param marketo Specifies the information that is required for querying Marketo.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder marketo(software.amazon.awscdk.services.appflow.CfnFlow.MarketoSourcePropertiesProperty marketo) {
                this.marketo = marketo;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getPardot}
             * @param pardot Specifies the information that is required for querying Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.IResolvable pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getPardot}
             * @param pardot Specifies the information that is required for querying Salesforce Pardot.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pardot(software.amazon.awscdk.services.appflow.CfnFlow.PardotSourcePropertiesProperty pardot) {
                this.pardot = pardot;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 Specifies the information that is required for querying Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getS3}
             * @param s3 Specifies the information that is required for querying Amazon S3.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.appflow.CfnFlow.S3SourcePropertiesProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce Specifies the information that is required for querying Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.IResolvable salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSalesforce}
             * @param salesforce Specifies the information that is required for querying Salesforce.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder salesforce(software.amazon.awscdk.services.appflow.CfnFlow.SalesforceSourcePropertiesProperty salesforce) {
                this.salesforce = salesforce;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties that are applied when using SAPOData as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.IResolvable sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSapoData}
             * @param sapoData The properties that are applied when using SAPOData as a flow source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sapoData(software.amazon.awscdk.services.appflow.CfnFlow.SAPODataSourcePropertiesProperty sapoData) {
                this.sapoData = sapoData;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow Specifies the information that is required for querying ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.IResolvable serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getServiceNow}
             * @param serviceNow Specifies the information that is required for querying ServiceNow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceNow(software.amazon.awscdk.services.appflow.CfnFlow.ServiceNowSourcePropertiesProperty serviceNow) {
                this.serviceNow = serviceNow;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSingular}
             * @param singular Specifies the information that is required for querying Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.IResolvable singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSingular}
             * @param singular Specifies the information that is required for querying Singular.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder singular(software.amazon.awscdk.services.appflow.CfnFlow.SingularSourcePropertiesProperty singular) {
                this.singular = singular;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSlack}
             * @param slack Specifies the information that is required for querying Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.IResolvable slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getSlack}
             * @param slack Specifies the information that is required for querying Slack.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder slack(software.amazon.awscdk.services.appflow.CfnFlow.SlackSourcePropertiesProperty slack) {
                this.slack = slack;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getTrendmicro}
             * @param trendmicro Specifies the information that is required for querying Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.IResolvable trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getTrendmicro}
             * @param trendmicro Specifies the information that is required for querying Trend Micro.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trendmicro(software.amazon.awscdk.services.appflow.CfnFlow.TrendmicroSourcePropertiesProperty trendmicro) {
                this.trendmicro = trendmicro;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getVeeva}
             * @param veeva Specifies the information that is required for querying Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.IResolvable veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getVeeva}
             * @param veeva Specifies the information that is required for querying Veeva.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder veeva(software.amazon.awscdk.services.appflow.CfnFlow.VeevaSourcePropertiesProperty veeva) {
                this.veeva = veeva;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk Specifies the information that is required for querying Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.IResolvable zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Sets the value of {@link SourceConnectorPropertiesProperty#getZendesk}
             * @param zendesk Specifies the information that is required for querying Zendesk.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zendesk(software.amazon.awscdk.services.appflow.CfnFlow.ZendeskSourcePropertiesProperty zendesk) {
                this.zendesk = zendesk;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceConnectorPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceConnectorPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceConnectorPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceConnectorPropertiesProperty {
            private final java.lang.Object amplitude;
            private final java.lang.Object customConnector;
            private final java.lang.Object datadog;
            private final java.lang.Object dynatrace;
            private final java.lang.Object googleAnalytics;
            private final java.lang.Object inforNexus;
            private final java.lang.Object marketo;
            private final java.lang.Object pardot;
            private final java.lang.Object s3;
            private final java.lang.Object salesforce;
            private final java.lang.Object sapoData;
            private final java.lang.Object serviceNow;
            private final java.lang.Object singular;
            private final java.lang.Object slack;
            private final java.lang.Object trendmicro;
            private final java.lang.Object veeva;
            private final java.lang.Object zendesk;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.amplitude = software.amazon.jsii.Kernel.get(this, "amplitude", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.customConnector = software.amazon.jsii.Kernel.get(this, "customConnector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.datadog = software.amazon.jsii.Kernel.get(this, "datadog", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dynatrace = software.amazon.jsii.Kernel.get(this, "dynatrace", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.googleAnalytics = software.amazon.jsii.Kernel.get(this, "googleAnalytics", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inforNexus = software.amazon.jsii.Kernel.get(this, "inforNexus", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.marketo = software.amazon.jsii.Kernel.get(this, "marketo", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.pardot = software.amazon.jsii.Kernel.get(this, "pardot", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.salesforce = software.amazon.jsii.Kernel.get(this, "salesforce", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sapoData = software.amazon.jsii.Kernel.get(this, "sapoData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.serviceNow = software.amazon.jsii.Kernel.get(this, "serviceNow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.singular = software.amazon.jsii.Kernel.get(this, "singular", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.slack = software.amazon.jsii.Kernel.get(this, "slack", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.trendmicro = software.amazon.jsii.Kernel.get(this, "trendmicro", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.veeva = software.amazon.jsii.Kernel.get(this, "veeva", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zendesk = software.amazon.jsii.Kernel.get(this, "zendesk", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.amplitude = builder.amplitude;
                this.customConnector = builder.customConnector;
                this.datadog = builder.datadog;
                this.dynatrace = builder.dynatrace;
                this.googleAnalytics = builder.googleAnalytics;
                this.inforNexus = builder.inforNexus;
                this.marketo = builder.marketo;
                this.pardot = builder.pardot;
                this.s3 = builder.s3;
                this.salesforce = builder.salesforce;
                this.sapoData = builder.sapoData;
                this.serviceNow = builder.serviceNow;
                this.singular = builder.singular;
                this.slack = builder.slack;
                this.trendmicro = builder.trendmicro;
                this.veeva = builder.veeva;
                this.zendesk = builder.zendesk;
            }

            @Override
            public final java.lang.Object getAmplitude() {
                return this.amplitude;
            }

            @Override
            public final java.lang.Object getCustomConnector() {
                return this.customConnector;
            }

            @Override
            public final java.lang.Object getDatadog() {
                return this.datadog;
            }

            @Override
            public final java.lang.Object getDynatrace() {
                return this.dynatrace;
            }

            @Override
            public final java.lang.Object getGoogleAnalytics() {
                return this.googleAnalytics;
            }

            @Override
            public final java.lang.Object getInforNexus() {
                return this.inforNexus;
            }

            @Override
            public final java.lang.Object getMarketo() {
                return this.marketo;
            }

            @Override
            public final java.lang.Object getPardot() {
                return this.pardot;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            public final java.lang.Object getSalesforce() {
                return this.salesforce;
            }

            @Override
            public final java.lang.Object getSapoData() {
                return this.sapoData;
            }

            @Override
            public final java.lang.Object getServiceNow() {
                return this.serviceNow;
            }

            @Override
            public final java.lang.Object getSingular() {
                return this.singular;
            }

            @Override
            public final java.lang.Object getSlack() {
                return this.slack;
            }

            @Override
            public final java.lang.Object getTrendmicro() {
                return this.trendmicro;
            }

            @Override
            public final java.lang.Object getVeeva() {
                return this.veeva;
            }

            @Override
            public final java.lang.Object getZendesk() {
                return this.zendesk;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAmplitude() != null) {
                    data.set("amplitude", om.valueToTree(this.getAmplitude()));
                }
                if (this.getCustomConnector() != null) {
                    data.set("customConnector", om.valueToTree(this.getCustomConnector()));
                }
                if (this.getDatadog() != null) {
                    data.set("datadog", om.valueToTree(this.getDatadog()));
                }
                if (this.getDynatrace() != null) {
                    data.set("dynatrace", om.valueToTree(this.getDynatrace()));
                }
                if (this.getGoogleAnalytics() != null) {
                    data.set("googleAnalytics", om.valueToTree(this.getGoogleAnalytics()));
                }
                if (this.getInforNexus() != null) {
                    data.set("inforNexus", om.valueToTree(this.getInforNexus()));
                }
                if (this.getMarketo() != null) {
                    data.set("marketo", om.valueToTree(this.getMarketo()));
                }
                if (this.getPardot() != null) {
                    data.set("pardot", om.valueToTree(this.getPardot()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }
                if (this.getSalesforce() != null) {
                    data.set("salesforce", om.valueToTree(this.getSalesforce()));
                }
                if (this.getSapoData() != null) {
                    data.set("sapoData", om.valueToTree(this.getSapoData()));
                }
                if (this.getServiceNow() != null) {
                    data.set("serviceNow", om.valueToTree(this.getServiceNow()));
                }
                if (this.getSingular() != null) {
                    data.set("singular", om.valueToTree(this.getSingular()));
                }
                if (this.getSlack() != null) {
                    data.set("slack", om.valueToTree(this.getSlack()));
                }
                if (this.getTrendmicro() != null) {
                    data.set("trendmicro", om.valueToTree(this.getTrendmicro()));
                }
                if (this.getVeeva() != null) {
                    data.set("veeva", om.valueToTree(this.getVeeva()));
                }
                if (this.getZendesk() != null) {
                    data.set("zendesk", om.valueToTree(this.getZendesk()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SourceConnectorPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceConnectorPropertiesProperty.Jsii$Proxy that = (SourceConnectorPropertiesProperty.Jsii$Proxy) o;

                if (this.amplitude != null ? !this.amplitude.equals(that.amplitude) : that.amplitude != null) return false;
                if (this.customConnector != null ? !this.customConnector.equals(that.customConnector) : that.customConnector != null) return false;
                if (this.datadog != null ? !this.datadog.equals(that.datadog) : that.datadog != null) return false;
                if (this.dynatrace != null ? !this.dynatrace.equals(that.dynatrace) : that.dynatrace != null) return false;
                if (this.googleAnalytics != null ? !this.googleAnalytics.equals(that.googleAnalytics) : that.googleAnalytics != null) return false;
                if (this.inforNexus != null ? !this.inforNexus.equals(that.inforNexus) : that.inforNexus != null) return false;
                if (this.marketo != null ? !this.marketo.equals(that.marketo) : that.marketo != null) return false;
                if (this.pardot != null ? !this.pardot.equals(that.pardot) : that.pardot != null) return false;
                if (this.s3 != null ? !this.s3.equals(that.s3) : that.s3 != null) return false;
                if (this.salesforce != null ? !this.salesforce.equals(that.salesforce) : that.salesforce != null) return false;
                if (this.sapoData != null ? !this.sapoData.equals(that.sapoData) : that.sapoData != null) return false;
                if (this.serviceNow != null ? !this.serviceNow.equals(that.serviceNow) : that.serviceNow != null) return false;
                if (this.singular != null ? !this.singular.equals(that.singular) : that.singular != null) return false;
                if (this.slack != null ? !this.slack.equals(that.slack) : that.slack != null) return false;
                if (this.trendmicro != null ? !this.trendmicro.equals(that.trendmicro) : that.trendmicro != null) return false;
                if (this.veeva != null ? !this.veeva.equals(that.veeva) : that.veeva != null) return false;
                return this.zendesk != null ? this.zendesk.equals(that.zendesk) : that.zendesk == null;
            }

            @Override
            public final int hashCode() {
                int result = this.amplitude != null ? this.amplitude.hashCode() : 0;
                result = 31 * result + (this.customConnector != null ? this.customConnector.hashCode() : 0);
                result = 31 * result + (this.datadog != null ? this.datadog.hashCode() : 0);
                result = 31 * result + (this.dynatrace != null ? this.dynatrace.hashCode() : 0);
                result = 31 * result + (this.googleAnalytics != null ? this.googleAnalytics.hashCode() : 0);
                result = 31 * result + (this.inforNexus != null ? this.inforNexus.hashCode() : 0);
                result = 31 * result + (this.marketo != null ? this.marketo.hashCode() : 0);
                result = 31 * result + (this.pardot != null ? this.pardot.hashCode() : 0);
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                result = 31 * result + (this.salesforce != null ? this.salesforce.hashCode() : 0);
                result = 31 * result + (this.sapoData != null ? this.sapoData.hashCode() : 0);
                result = 31 * result + (this.serviceNow != null ? this.serviceNow.hashCode() : 0);
                result = 31 * result + (this.singular != null ? this.singular.hashCode() : 0);
                result = 31 * result + (this.slack != null ? this.slack.hashCode() : 0);
                result = 31 * result + (this.trendmicro != null ? this.trendmicro.hashCode() : 0);
                result = 31 * result + (this.veeva != null ? this.veeva.hashCode() : 0);
                result = 31 * result + (this.zendesk != null ? this.zendesk.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about the configuration of the source connector used in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SourceFlowConfigProperty sourceFlowConfigProperty = SourceFlowConfigProperty.builder()
     *         .connectorType("connectorType")
     *         .sourceConnectorProperties(SourceConnectorPropertiesProperty.builder()
     *                 .amplitude(AmplitudeSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .customConnector(CustomConnectorSourcePropertiesProperty.builder()
     *                         .entityName("entityName")
     *                         // the properties below are optional
     *                         .customProperties(Map.of(
     *                                 "customPropertiesKey", "customProperties"))
     *                         .dataTransferApi(DataTransferApiProperty.builder()
     *                                 .name("name")
     *                                 .type("type")
     *                                 .build())
     *                         .build())
     *                 .datadog(DatadogSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .dynatrace(DynatraceSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .googleAnalytics(GoogleAnalyticsSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .inforNexus(InforNexusSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .marketo(MarketoSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .pardot(PardotSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .s3(S3SourcePropertiesProperty.builder()
     *                         .bucketName("bucketName")
     *                         .bucketPrefix("bucketPrefix")
     *                         // the properties below are optional
     *                         .s3InputFormatConfig(S3InputFormatConfigProperty.builder()
     *                                 .s3InputFileType("s3InputFileType")
     *                                 .build())
     *                         .build())
     *                 .salesforce(SalesforceSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .dataTransferApi("dataTransferApi")
     *                         .enableDynamicFieldUpdate(false)
     *                         .includeDeletedRecords(false)
     *                         .build())
     *                 .sapoData(SAPODataSourcePropertiesProperty.builder()
     *                         .objectPath("objectPath")
     *                         // the properties below are optional
     *                         .paginationConfig(SAPODataPaginationConfigProperty.builder()
     *                                 .maxPageSize(123)
     *                                 .build())
     *                         .parallelismConfig(SAPODataParallelismConfigProperty.builder()
     *                                 .maxParallelism(123)
     *                                 .build())
     *                         .build())
     *                 .serviceNow(ServiceNowSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .singular(SingularSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .slack(SlackSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .trendmicro(TrendmicroSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .veeva(VeevaSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         // the properties below are optional
     *                         .documentType("documentType")
     *                         .includeAllVersions(false)
     *                         .includeRenditions(false)
     *                         .includeSourceFiles(false)
     *                         .build())
     *                 .zendesk(ZendeskSourcePropertiesProperty.builder()
     *                         .object("object")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .apiVersion("apiVersion")
     *         .connectorProfileName("connectorProfileName")
     *         .incrementalPullConfig(IncrementalPullConfigProperty.builder()
     *                 .datetimeTypeFieldName("datetimeTypeFieldName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SourceFlowConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SourceFlowConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SourceFlowConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of connector, such as Salesforce, Amplitude, and so on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectortype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectortype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getConnectorType();

        /**
         * Specifies the information that is required to query a particular source connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-sourceconnectorproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-sourceconnectorproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConnectorProperties();

        /**
         * The API version of the connector when it's used as a source in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-apiversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-apiversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApiVersion() {
            return null;
        }

        /**
         * The name of the connector profile.
         * <p>
         * This name must be unique for each connector profile in the AWS account .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectorprofilename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-connectorprofilename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getConnectorProfileName() {
            return null;
        }

        /**
         * Defines the configuration for a scheduled incremental data pull.
         * <p>
         * If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-incrementalpullconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-sourceflowconfig.html#cfn-appflow-flow-sourceflowconfig-incrementalpullconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncrementalPullConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SourceFlowConfigProperty> {
            java.lang.String connectorType;
            java.lang.Object sourceConnectorProperties;
            java.lang.String apiVersion;
            java.lang.String connectorProfileName;
            java.lang.Object incrementalPullConfig;

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorType}
             * @param connectorType The type of connector, such as Salesforce, Amplitude, and so on. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorType(java.lang.String connectorType) {
                this.connectorType = connectorType;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.IResolvable sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getSourceConnectorProperties}
             * @param sourceConnectorProperties Specifies the information that is required to query a particular source connector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConnectorProperties(software.amazon.awscdk.services.appflow.CfnFlow.SourceConnectorPropertiesProperty sourceConnectorProperties) {
                this.sourceConnectorProperties = sourceConnectorProperties;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getApiVersion}
             * @param apiVersion The API version of the connector when it's used as a source in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiVersion(java.lang.String apiVersion) {
                this.apiVersion = apiVersion;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getConnectorProfileName}
             * @param connectorProfileName The name of the connector profile.
             *                             This name must be unique for each connector profile in the AWS account .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorProfileName(java.lang.String connectorProfileName) {
                this.connectorProfileName = connectorProfileName;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.IResolvable incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Sets the value of {@link SourceFlowConfigProperty#getIncrementalPullConfig}
             * @param incrementalPullConfig Defines the configuration for a scheduled incremental data pull.
             *                              If a valid configuration is provided, the fields specified in the configuration are used when querying for the incremental data pull.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementalPullConfig(software.amazon.awscdk.services.appflow.CfnFlow.IncrementalPullConfigProperty incrementalPullConfig) {
                this.incrementalPullConfig = incrementalPullConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SourceFlowConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SourceFlowConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SourceFlowConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SourceFlowConfigProperty {
            private final java.lang.String connectorType;
            private final java.lang.Object sourceConnectorProperties;
            private final java.lang.String apiVersion;
            private final java.lang.String connectorProfileName;
            private final java.lang.Object incrementalPullConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connectorType = software.amazon.jsii.Kernel.get(this, "connectorType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sourceConnectorProperties = software.amazon.jsii.Kernel.get(this, "sourceConnectorProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apiVersion = software.amazon.jsii.Kernel.get(this, "apiVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorProfileName = software.amazon.jsii.Kernel.get(this, "connectorProfileName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.incrementalPullConfig = software.amazon.jsii.Kernel.get(this, "incrementalPullConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connectorType = java.util.Objects.requireNonNull(builder.connectorType, "connectorType is required");
                this.sourceConnectorProperties = java.util.Objects.requireNonNull(builder.sourceConnectorProperties, "sourceConnectorProperties is required");
                this.apiVersion = builder.apiVersion;
                this.connectorProfileName = builder.connectorProfileName;
                this.incrementalPullConfig = builder.incrementalPullConfig;
            }

            @Override
            public final java.lang.String getConnectorType() {
                return this.connectorType;
            }

            @Override
            public final java.lang.Object getSourceConnectorProperties() {
                return this.sourceConnectorProperties;
            }

            @Override
            public final java.lang.String getApiVersion() {
                return this.apiVersion;
            }

            @Override
            public final java.lang.String getConnectorProfileName() {
                return this.connectorProfileName;
            }

            @Override
            public final java.lang.Object getIncrementalPullConfig() {
                return this.incrementalPullConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("connectorType", om.valueToTree(this.getConnectorType()));
                data.set("sourceConnectorProperties", om.valueToTree(this.getSourceConnectorProperties()));
                if (this.getApiVersion() != null) {
                    data.set("apiVersion", om.valueToTree(this.getApiVersion()));
                }
                if (this.getConnectorProfileName() != null) {
                    data.set("connectorProfileName", om.valueToTree(this.getConnectorProfileName()));
                }
                if (this.getIncrementalPullConfig() != null) {
                    data.set("incrementalPullConfig", om.valueToTree(this.getIncrementalPullConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SourceFlowConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SourceFlowConfigProperty.Jsii$Proxy that = (SourceFlowConfigProperty.Jsii$Proxy) o;

                if (!connectorType.equals(that.connectorType)) return false;
                if (!sourceConnectorProperties.equals(that.sourceConnectorProperties)) return false;
                if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) return false;
                if (this.connectorProfileName != null ? !this.connectorProfileName.equals(that.connectorProfileName) : that.connectorProfileName != null) return false;
                return this.incrementalPullConfig != null ? this.incrementalPullConfig.equals(that.incrementalPullConfig) : that.incrementalPullConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connectorType.hashCode();
                result = 31 * result + (this.sourceConnectorProperties.hashCode());
                result = 31 * result + (this.apiVersion != null ? this.apiVersion.hashCode() : 0);
                result = 31 * result + (this.connectorProfileName != null ? this.connectorProfileName.hashCode() : 0);
                result = 31 * result + (this.incrementalPullConfig != null ? this.incrementalPullConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Determines how Amazon AppFlow handles the success response that it gets from the connector after placing data.
     * <p>
     * For example, this setting would determine where to write the response from the destination connector upon a successful insert operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * SuccessResponseHandlingConfigProperty successResponseHandlingConfigProperty = SuccessResponseHandlingConfigProperty.builder()
     *         .bucketName("bucketName")
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.SuccessResponseHandlingConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(SuccessResponseHandlingConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SuccessResponseHandlingConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html#cfn-appflow-flow-successresponsehandlingconfig-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html#cfn-appflow-flow-successresponsehandlingconfig-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketName() {
            return null;
        }

        /**
         * The Amazon S3 bucket prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html#cfn-appflow-flow-successresponsehandlingconfig-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-successresponsehandlingconfig.html#cfn-appflow-flow-successresponsehandlingconfig-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SuccessResponseHandlingConfigProperty> {
            java.lang.String bucketName;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link SuccessResponseHandlingConfigProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link SuccessResponseHandlingConfigProperty#getBucketPrefix}
             * @param bucketPrefix The Amazon S3 bucket prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SuccessResponseHandlingConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SuccessResponseHandlingConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SuccessResponseHandlingConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SuccessResponseHandlingConfigProperty {
            private final java.lang.String bucketName;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = builder.bucketName;
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBucketName() != null) {
                    data.set("bucketName", om.valueToTree(this.getBucketName()));
                }
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.SuccessResponseHandlingConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SuccessResponseHandlingConfigProperty.Jsii$Proxy that = (SuccessResponseHandlingConfigProperty.Jsii$Proxy) o;

                if (this.bucketName != null ? !this.bucketName.equals(that.bucketName) : that.bucketName != null) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName != null ? this.bucketName.hashCode() : 0;
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A map used to store task-related information.
     * <p>
     * The execution service looks for particular information based on the <code>TaskType</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TaskPropertiesObjectProperty taskPropertiesObjectProperty = TaskPropertiesObjectProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TaskPropertiesObjectProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskPropertiesObjectProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskPropertiesObjectProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The task property key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The task property value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-taskpropertiesobject.html#cfn-appflow-flow-taskpropertiesobject-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskPropertiesObjectProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TaskPropertiesObjectProperty#getKey}
             * @param key The task property key. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TaskPropertiesObjectProperty#getValue}
             * @param value The task property value. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskPropertiesObjectProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskPropertiesObjectProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskPropertiesObjectProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskPropertiesObjectProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TaskPropertiesObjectProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskPropertiesObjectProperty.Jsii$Proxy that = (TaskPropertiesObjectProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * A class for modeling different type of tasks.
     * <p>
     * Task implementation varies based on the <code>TaskType</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TaskProperty taskProperty = TaskProperty.builder()
     *         .sourceFields(List.of("sourceFields"))
     *         .taskType("taskType")
     *         // the properties below are optional
     *         .connectorOperator(ConnectorOperatorProperty.builder()
     *                 .amplitude("amplitude")
     *                 .customConnector("customConnector")
     *                 .datadog("datadog")
     *                 .dynatrace("dynatrace")
     *                 .googleAnalytics("googleAnalytics")
     *                 .inforNexus("inforNexus")
     *                 .marketo("marketo")
     *                 .pardot("pardot")
     *                 .s3("s3")
     *                 .salesforce("salesforce")
     *                 .sapoData("sapoData")
     *                 .serviceNow("serviceNow")
     *                 .singular("singular")
     *                 .slack("slack")
     *                 .trendmicro("trendmicro")
     *                 .veeva("veeva")
     *                 .zendesk("zendesk")
     *                 .build())
     *         .destinationField("destinationField")
     *         .taskProperties(List.of(TaskPropertiesObjectProperty.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TaskProperty")
    @software.amazon.jsii.Jsii.Proxy(TaskProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TaskProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The source fields to which a particular task is applied.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-sourcefields">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-sourcefields</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSourceFields();

        /**
         * Specifies the particular task implementation that Amazon AppFlow performs.
         * <p>
         * <em>Allowed values</em> : <code>Arithmetic</code> | <code>Filter</code> | <code>Map</code> | <code>Map_all</code> | <code>Mask</code> | <code>Merge</code> | <code>Truncate</code> | <code>Validate</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-tasktype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-tasktype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTaskType();

        /**
         * The operation to be performed on the provided source fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-connectoroperator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-connectoroperator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnectorOperator() {
            return null;
        }

        /**
         * A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-destinationfield">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-destinationfield</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDestinationField() {
            return null;
        }

        /**
         * A map used to store task-related information.
         * <p>
         * The execution service looks for particular information based on the <code>TaskType</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-taskproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-task.html#cfn-appflow-flow-task-taskproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TaskProperty> {
            java.util.List<java.lang.String> sourceFields;
            java.lang.String taskType;
            java.lang.Object connectorOperator;
            java.lang.String destinationField;
            java.lang.Object taskProperties;

            /**
             * Sets the value of {@link TaskProperty#getSourceFields}
             * @param sourceFields The source fields to which a particular task is applied. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceFields(java.util.List<java.lang.String> sourceFields) {
                this.sourceFields = sourceFields;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskType}
             * @param taskType Specifies the particular task implementation that Amazon AppFlow performs. This parameter is required.
             *                 <em>Allowed values</em> : <code>Arithmetic</code> | <code>Filter</code> | <code>Map</code> | <code>Map_all</code> | <code>Mask</code> | <code>Merge</code> | <code>Truncate</code> | <code>Validate</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskType(java.lang.String taskType) {
                this.taskType = taskType;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.IResolvable connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getConnectorOperator}
             * @param connectorOperator The operation to be performed on the provided source fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectorOperator(software.amazon.awscdk.services.appflow.CfnFlow.ConnectorOperatorProperty connectorOperator) {
                this.connectorOperator = connectorOperator;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getDestinationField}
             * @param destinationField A field in a destination connector, or a field value against which Amazon AppFlow validates a source field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinationField(java.lang.String destinationField) {
                this.destinationField = destinationField;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The execution service looks for particular information based on the <code>TaskType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(software.amazon.awscdk.IResolvable taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Sets the value of {@link TaskProperty#getTaskProperties}
             * @param taskProperties A map used to store task-related information.
             *                       The execution service looks for particular information based on the <code>TaskType</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskProperties(java.util.List<? extends java.lang.Object> taskProperties) {
                this.taskProperties = taskProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TaskProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TaskProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TaskProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TaskProperty {
            private final java.util.List<java.lang.String> sourceFields;
            private final java.lang.String taskType;
            private final java.lang.Object connectorOperator;
            private final java.lang.String destinationField;
            private final java.lang.Object taskProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceFields = software.amazon.jsii.Kernel.get(this, "sourceFields", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.taskType = software.amazon.jsii.Kernel.get(this, "taskType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.connectorOperator = software.amazon.jsii.Kernel.get(this, "connectorOperator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.destinationField = software.amazon.jsii.Kernel.get(this, "destinationField", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.taskProperties = software.amazon.jsii.Kernel.get(this, "taskProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceFields = java.util.Objects.requireNonNull(builder.sourceFields, "sourceFields is required");
                this.taskType = java.util.Objects.requireNonNull(builder.taskType, "taskType is required");
                this.connectorOperator = builder.connectorOperator;
                this.destinationField = builder.destinationField;
                this.taskProperties = builder.taskProperties;
            }

            @Override
            public final java.util.List<java.lang.String> getSourceFields() {
                return this.sourceFields;
            }

            @Override
            public final java.lang.String getTaskType() {
                return this.taskType;
            }

            @Override
            public final java.lang.Object getConnectorOperator() {
                return this.connectorOperator;
            }

            @Override
            public final java.lang.String getDestinationField() {
                return this.destinationField;
            }

            @Override
            public final java.lang.Object getTaskProperties() {
                return this.taskProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceFields", om.valueToTree(this.getSourceFields()));
                data.set("taskType", om.valueToTree(this.getTaskType()));
                if (this.getConnectorOperator() != null) {
                    data.set("connectorOperator", om.valueToTree(this.getConnectorOperator()));
                }
                if (this.getDestinationField() != null) {
                    data.set("destinationField", om.valueToTree(this.getDestinationField()));
                }
                if (this.getTaskProperties() != null) {
                    data.set("taskProperties", om.valueToTree(this.getTaskProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TaskProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TaskProperty.Jsii$Proxy that = (TaskProperty.Jsii$Proxy) o;

                if (!sourceFields.equals(that.sourceFields)) return false;
                if (!taskType.equals(that.taskType)) return false;
                if (this.connectorOperator != null ? !this.connectorOperator.equals(that.connectorOperator) : that.connectorOperator != null) return false;
                if (this.destinationField != null ? !this.destinationField.equals(that.destinationField) : that.destinationField != null) return false;
                return this.taskProperties != null ? this.taskProperties.equals(that.taskProperties) : that.taskProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceFields.hashCode();
                result = 31 * result + (this.taskType.hashCode());
                result = 31 * result + (this.connectorOperator != null ? this.connectorOperator.hashCode() : 0);
                result = 31 * result + (this.destinationField != null ? this.destinationField.hashCode() : 0);
                result = 31 * result + (this.taskProperties != null ? this.taskProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Trend Micro as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TrendmicroSourcePropertiesProperty trendmicroSourcePropertiesProperty = TrendmicroSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TrendmicroSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(TrendmicroSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TrendmicroSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Trend Micro flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html#cfn-appflow-flow-trendmicrosourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-trendmicrosourceproperties.html#cfn-appflow-flow-trendmicrosourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TrendmicroSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link TrendmicroSourcePropertiesProperty#getObject}
             * @param object The object specified in the Trend Micro flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TrendmicroSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TrendmicroSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TrendmicroSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TrendmicroSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TrendmicroSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TrendmicroSourcePropertiesProperty.Jsii$Proxy that = (TrendmicroSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }
    /**
     * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * TriggerConfigProperty triggerConfigProperty = TriggerConfigProperty.builder()
     *         .triggerType("triggerType")
     *         // the properties below are optional
     *         .triggerProperties(ScheduledTriggerPropertiesProperty.builder()
     *                 .scheduleExpression("scheduleExpression")
     *                 // the properties below are optional
     *                 .dataPullMode("dataPullMode")
     *                 .firstExecutionFrom(123)
     *                 .flowErrorDeactivationThreshold(123)
     *                 .scheduleEndTime(123)
     *                 .scheduleOffset(123)
     *                 .scheduleStartTime(123)
     *                 .timeZone("timeZone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.TriggerConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(TriggerConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TriggerConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the type of flow trigger.
         * <p>
         * This can be <code>OnDemand</code> , <code>Scheduled</code> , or <code>Event</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTriggerType();

        /**
         * Specifies the configuration details of a schedule-triggered flow as defined by the user.
         * <p>
         * Currently, these settings only apply to the <code>Scheduled</code> trigger type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggerproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-triggerconfig.html#cfn-appflow-flow-triggerconfig-triggerproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTriggerProperties() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TriggerConfigProperty> {
            java.lang.String triggerType;
            java.lang.Object triggerProperties;

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerType}
             * @param triggerType Specifies the type of flow trigger. This parameter is required.
             *                    This can be <code>OnDemand</code> , <code>Scheduled</code> , or <code>Event</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerType(java.lang.String triggerType) {
                this.triggerType = triggerType;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow as defined by the user.
             *                          Currently, these settings only apply to the <code>Scheduled</code> trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.IResolvable triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Sets the value of {@link TriggerConfigProperty#getTriggerProperties}
             * @param triggerProperties Specifies the configuration details of a schedule-triggered flow as defined by the user.
             *                          Currently, these settings only apply to the <code>Scheduled</code> trigger type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder triggerProperties(software.amazon.awscdk.services.appflow.CfnFlow.ScheduledTriggerPropertiesProperty triggerProperties) {
                this.triggerProperties = triggerProperties;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TriggerConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TriggerConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TriggerConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TriggerConfigProperty {
            private final java.lang.String triggerType;
            private final java.lang.Object triggerProperties;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.triggerType = software.amazon.jsii.Kernel.get(this, "triggerType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.triggerProperties = software.amazon.jsii.Kernel.get(this, "triggerProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.triggerType = java.util.Objects.requireNonNull(builder.triggerType, "triggerType is required");
                this.triggerProperties = builder.triggerProperties;
            }

            @Override
            public final java.lang.String getTriggerType() {
                return this.triggerType;
            }

            @Override
            public final java.lang.Object getTriggerProperties() {
                return this.triggerProperties;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("triggerType", om.valueToTree(this.getTriggerType()));
                if (this.getTriggerProperties() != null) {
                    data.set("triggerProperties", om.valueToTree(this.getTriggerProperties()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.TriggerConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TriggerConfigProperty.Jsii$Proxy that = (TriggerConfigProperty.Jsii$Proxy) o;

                if (!triggerType.equals(that.triggerType)) return false;
                return this.triggerProperties != null ? this.triggerProperties.equals(that.triggerProperties) : that.triggerProperties == null;
            }

            @Override
            public final int hashCode() {
                int result = this.triggerType.hashCode();
                result = 31 * result + (this.triggerProperties != null ? this.triggerProperties.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Upsolver is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * UpsolverDestinationPropertiesProperty upsolverDestinationPropertiesProperty = UpsolverDestinationPropertiesProperty.builder()
     *         .bucketName("bucketName")
     *         .s3OutputFormatConfig(UpsolverS3OutputFormatConfigProperty.builder()
     *                 .prefixConfig(PrefixConfigProperty.builder()
     *                         .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                         .prefixFormat("prefixFormat")
     *                         .prefixType("prefixType")
     *                         .build())
     *                 // the properties below are optional
     *                 .aggregationConfig(AggregationConfigProperty.builder()
     *                         .aggregationType("aggregationType")
     *                         .targetFileSize(123)
     *                         .build())
     *                 .fileType("fileType")
     *                 .build())
     *         // the properties below are optional
     *         .bucketPrefix("bucketPrefix")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.UpsolverDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(UpsolverDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpsolverDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * The configuration that determines how data is formatted when Upsolver is used as the flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-s3outputformatconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-s3outputformatconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getS3OutputFormatConfig();

        /**
         * The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-bucketprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolverdestinationproperties.html#cfn-appflow-flow-upsolverdestinationproperties-bucketprefix</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucketPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpsolverDestinationPropertiesProperty> {
            java.lang.String bucketName;
            java.lang.Object s3OutputFormatConfig;
            java.lang.String bucketPrefix;

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getBucketName}
             * @param bucketName The Upsolver Amazon S3 bucket name in which Amazon AppFlow places the transferred data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how data is formatted when Upsolver is used as the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.IResolvable s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getS3OutputFormatConfig}
             * @param s3OutputFormatConfig The configuration that determines how data is formatted when Upsolver is used as the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OutputFormatConfig(software.amazon.awscdk.services.appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty s3OutputFormatConfig) {
                this.s3OutputFormatConfig = s3OutputFormatConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverDestinationPropertiesProperty#getBucketPrefix}
             * @param bucketPrefix The object key for the destination Upsolver Amazon S3 bucket in which Amazon AppFlow places the files.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketPrefix(java.lang.String bucketPrefix) {
                this.bucketPrefix = bucketPrefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpsolverDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpsolverDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpsolverDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpsolverDestinationPropertiesProperty {
            private final java.lang.String bucketName;
            private final java.lang.Object s3OutputFormatConfig;
            private final java.lang.String bucketPrefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3OutputFormatConfig = software.amazon.jsii.Kernel.get(this, "s3OutputFormatConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.bucketPrefix = software.amazon.jsii.Kernel.get(this, "bucketPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
                this.s3OutputFormatConfig = java.util.Objects.requireNonNull(builder.s3OutputFormatConfig, "s3OutputFormatConfig is required");
                this.bucketPrefix = builder.bucketPrefix;
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            public final java.lang.Object getS3OutputFormatConfig() {
                return this.s3OutputFormatConfig;
            }

            @Override
            public final java.lang.String getBucketPrefix() {
                return this.bucketPrefix;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));
                data.set("s3OutputFormatConfig", om.valueToTree(this.getS3OutputFormatConfig()));
                if (this.getBucketPrefix() != null) {
                    data.set("bucketPrefix", om.valueToTree(this.getBucketPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.UpsolverDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpsolverDestinationPropertiesProperty.Jsii$Proxy that = (UpsolverDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!bucketName.equals(that.bucketName)) return false;
                if (!s3OutputFormatConfig.equals(that.s3OutputFormatConfig)) return false;
                return this.bucketPrefix != null ? this.bucketPrefix.equals(that.bucketPrefix) : that.bucketPrefix == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                result = 31 * result + (this.s3OutputFormatConfig.hashCode());
                result = 31 * result + (this.bucketPrefix != null ? this.bucketPrefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration that determines how Amazon AppFlow formats the flow output data when Upsolver is used as the destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * UpsolverS3OutputFormatConfigProperty upsolverS3OutputFormatConfigProperty = UpsolverS3OutputFormatConfigProperty.builder()
     *         .prefixConfig(PrefixConfigProperty.builder()
     *                 .pathPrefixHierarchy(List.of("pathPrefixHierarchy"))
     *                 .prefixFormat("prefixFormat")
     *                 .prefixType("prefixType")
     *                 .build())
     *         // the properties below are optional
     *         .aggregationConfig(AggregationConfigProperty.builder()
     *                 .aggregationType("aggregationType")
     *                 .targetFileSize(123)
     *                 .build())
     *         .fileType("fileType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(UpsolverS3OutputFormatConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface UpsolverS3OutputFormatConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-prefixconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-prefixconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPrefixConfig();

        /**
         * The aggregation settings that you can use to customize the output format of your flow data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-aggregationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-aggregationconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAggregationConfig() {
            return null;
        }

        /**
         * Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-filetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-upsolvers3outputformatconfig.html#cfn-appflow-flow-upsolvers3outputformatconfig-filetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFileType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<UpsolverS3OutputFormatConfigProperty> {
            java.lang.Object prefixConfig;
            java.lang.Object aggregationConfig;
            java.lang.String fileType;

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.IResolvable prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getPrefixConfig}
             * @param prefixConfig Specifies elements that Amazon AppFlow includes in the file and folder names in the flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixConfig(software.amazon.awscdk.services.appflow.CfnFlow.PrefixConfigProperty prefixConfig) {
                this.prefixConfig = prefixConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.IResolvable aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getAggregationConfig}
             * @param aggregationConfig The aggregation settings that you can use to customize the output format of your flow data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aggregationConfig(software.amazon.awscdk.services.appflow.CfnFlow.AggregationConfigProperty aggregationConfig) {
                this.aggregationConfig = aggregationConfig;
                return this;
            }

            /**
             * Sets the value of {@link UpsolverS3OutputFormatConfigProperty#getFileType}
             * @param fileType Indicates the file type that Amazon AppFlow places in the Upsolver Amazon S3 bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fileType(java.lang.String fileType) {
                this.fileType = fileType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link UpsolverS3OutputFormatConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public UpsolverS3OutputFormatConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link UpsolverS3OutputFormatConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UpsolverS3OutputFormatConfigProperty {
            private final java.lang.Object prefixConfig;
            private final java.lang.Object aggregationConfig;
            private final java.lang.String fileType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefixConfig = software.amazon.jsii.Kernel.get(this, "prefixConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.aggregationConfig = software.amazon.jsii.Kernel.get(this, "aggregationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.fileType = software.amazon.jsii.Kernel.get(this, "fileType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefixConfig = java.util.Objects.requireNonNull(builder.prefixConfig, "prefixConfig is required");
                this.aggregationConfig = builder.aggregationConfig;
                this.fileType = builder.fileType;
            }

            @Override
            public final java.lang.Object getPrefixConfig() {
                return this.prefixConfig;
            }

            @Override
            public final java.lang.Object getAggregationConfig() {
                return this.aggregationConfig;
            }

            @Override
            public final java.lang.String getFileType() {
                return this.fileType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("prefixConfig", om.valueToTree(this.getPrefixConfig()));
                if (this.getAggregationConfig() != null) {
                    data.set("aggregationConfig", om.valueToTree(this.getAggregationConfig()));
                }
                if (this.getFileType() != null) {
                    data.set("fileType", om.valueToTree(this.getFileType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.UpsolverS3OutputFormatConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                UpsolverS3OutputFormatConfigProperty.Jsii$Proxy that = (UpsolverS3OutputFormatConfigProperty.Jsii$Proxy) o;

                if (!prefixConfig.equals(that.prefixConfig)) return false;
                if (this.aggregationConfig != null ? !this.aggregationConfig.equals(that.aggregationConfig) : that.aggregationConfig != null) return false;
                return this.fileType != null ? this.fileType.equals(that.fileType) : that.fileType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefixConfig.hashCode();
                result = 31 * result + (this.aggregationConfig != null ? this.aggregationConfig.hashCode() : 0);
                result = 31 * result + (this.fileType != null ? this.fileType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Veeva as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * VeevaSourcePropertiesProperty veevaSourcePropertiesProperty = VeevaSourcePropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .documentType("documentType")
     *         .includeAllVersions(false)
     *         .includeRenditions(false)
     *         .includeSourceFiles(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.VeevaSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(VeevaSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VeevaSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Veeva flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The document type specified in the Veeva document extract flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-documenttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-documenttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDocumentType() {
            return null;
        }

        /**
         * Boolean value to include All Versions of files in Veeva document extract flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includeallversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includeallversions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeAllVersions() {
            return null;
        }

        /**
         * Boolean value to include file renditions in Veeva document extract flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includerenditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includerenditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeRenditions() {
            return null;
        }

        /**
         * Boolean value to include source files in Veeva document extract flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includesourcefiles">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-veevasourceproperties.html#cfn-appflow-flow-veevasourceproperties-includesourcefiles</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeSourceFiles() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VeevaSourcePropertiesProperty> {
            java.lang.String object;
            java.lang.String documentType;
            java.lang.Object includeAllVersions;
            java.lang.Object includeRenditions;
            java.lang.Object includeSourceFiles;

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getObject}
             * @param object The object specified in the Veeva flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getDocumentType}
             * @param documentType The document type specified in the Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder documentType(java.lang.String documentType) {
                this.documentType = documentType;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeAllVersions}
             * @param includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAllVersions(java.lang.Boolean includeAllVersions) {
                this.includeAllVersions = includeAllVersions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeAllVersions}
             * @param includeAllVersions Boolean value to include All Versions of files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeAllVersions(software.amazon.awscdk.IResolvable includeAllVersions) {
                this.includeAllVersions = includeAllVersions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeRenditions}
             * @param includeRenditions Boolean value to include file renditions in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRenditions(java.lang.Boolean includeRenditions) {
                this.includeRenditions = includeRenditions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeRenditions}
             * @param includeRenditions Boolean value to include file renditions in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeRenditions(software.amazon.awscdk.IResolvable includeRenditions) {
                this.includeRenditions = includeRenditions;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeSourceFiles}
             * @param includeSourceFiles Boolean value to include source files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSourceFiles(java.lang.Boolean includeSourceFiles) {
                this.includeSourceFiles = includeSourceFiles;
                return this;
            }

            /**
             * Sets the value of {@link VeevaSourcePropertiesProperty#getIncludeSourceFiles}
             * @param includeSourceFiles Boolean value to include source files in Veeva document extract flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeSourceFiles(software.amazon.awscdk.IResolvable includeSourceFiles) {
                this.includeSourceFiles = includeSourceFiles;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VeevaSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VeevaSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VeevaSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VeevaSourcePropertiesProperty {
            private final java.lang.String object;
            private final java.lang.String documentType;
            private final java.lang.Object includeAllVersions;
            private final java.lang.Object includeRenditions;
            private final java.lang.Object includeSourceFiles;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.documentType = software.amazon.jsii.Kernel.get(this, "documentType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.includeAllVersions = software.amazon.jsii.Kernel.get(this, "includeAllVersions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeRenditions = software.amazon.jsii.Kernel.get(this, "includeRenditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeSourceFiles = software.amazon.jsii.Kernel.get(this, "includeSourceFiles", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.documentType = builder.documentType;
                this.includeAllVersions = builder.includeAllVersions;
                this.includeRenditions = builder.includeRenditions;
                this.includeSourceFiles = builder.includeSourceFiles;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.String getDocumentType() {
                return this.documentType;
            }

            @Override
            public final java.lang.Object getIncludeAllVersions() {
                return this.includeAllVersions;
            }

            @Override
            public final java.lang.Object getIncludeRenditions() {
                return this.includeRenditions;
            }

            @Override
            public final java.lang.Object getIncludeSourceFiles() {
                return this.includeSourceFiles;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getDocumentType() != null) {
                    data.set("documentType", om.valueToTree(this.getDocumentType()));
                }
                if (this.getIncludeAllVersions() != null) {
                    data.set("includeAllVersions", om.valueToTree(this.getIncludeAllVersions()));
                }
                if (this.getIncludeRenditions() != null) {
                    data.set("includeRenditions", om.valueToTree(this.getIncludeRenditions()));
                }
                if (this.getIncludeSourceFiles() != null) {
                    data.set("includeSourceFiles", om.valueToTree(this.getIncludeSourceFiles()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.VeevaSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VeevaSourcePropertiesProperty.Jsii$Proxy that = (VeevaSourcePropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.documentType != null ? !this.documentType.equals(that.documentType) : that.documentType != null) return false;
                if (this.includeAllVersions != null ? !this.includeAllVersions.equals(that.includeAllVersions) : that.includeAllVersions != null) return false;
                if (this.includeRenditions != null ? !this.includeRenditions.equals(that.includeRenditions) : that.includeRenditions != null) return false;
                return this.includeSourceFiles != null ? this.includeSourceFiles.equals(that.includeSourceFiles) : that.includeSourceFiles == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.documentType != null ? this.documentType.hashCode() : 0);
                result = 31 * result + (this.includeAllVersions != null ? this.includeAllVersions.hashCode() : 0);
                result = 31 * result + (this.includeRenditions != null ? this.includeRenditions.hashCode() : 0);
                result = 31 * result + (this.includeSourceFiles != null ? this.includeSourceFiles.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when Zendesk is used as a destination.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskDestinationPropertiesProperty zendeskDestinationPropertiesProperty = ZendeskDestinationPropertiesProperty.builder()
     *         .object("object")
     *         // the properties below are optional
     *         .errorHandlingConfig(ErrorHandlingConfigProperty.builder()
     *                 .bucketName("bucketName")
     *                 .bucketPrefix("bucketPrefix")
     *                 .failOnFirstError(false)
     *                 .build())
     *         .idFieldNames(List.of("idFieldNames"))
     *         .writeOperationType("writeOperationType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ZendeskDestinationPropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskDestinationPropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskDestinationPropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Zendesk flow destination.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
         * <p>
         * For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-errorhandlingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-errorhandlingconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getErrorHandlingConfig() {
            return null;
        }

        /**
         * A list of field names that can be used as an ID field when performing a write operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-idfieldnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-idfieldnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getIdFieldNames() {
            return null;
        }

        /**
         * The possible write operations in the destination connector.
         * <p>
         * When this value is not provided, this defaults to the <code>INSERT</code> operation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-writeoperationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendeskdestinationproperties.html#cfn-appflow-flow-zendeskdestinationproperties-writeoperationtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWriteOperationType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskDestinationPropertiesProperty> {
            java.lang.String object;
            java.lang.Object errorHandlingConfig;
            java.util.List<java.lang.String> idFieldNames;
            java.lang.String writeOperationType;

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getObject}
             * @param object The object specified in the Zendesk flow destination. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.IResolvable errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getErrorHandlingConfig}
             * @param errorHandlingConfig The settings that determine how Amazon AppFlow handles an error when placing data in the destination.
             *                            For example, this setting would determine if the flow should fail after one insertion error, or continue and attempt to insert every record regardless of the initial failure. <code>ErrorHandlingConfig</code> is a part of the destination connector details.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorHandlingConfig(software.amazon.awscdk.services.appflow.CfnFlow.ErrorHandlingConfigProperty errorHandlingConfig) {
                this.errorHandlingConfig = errorHandlingConfig;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getIdFieldNames}
             * @param idFieldNames A list of field names that can be used as an ID field when performing a write operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idFieldNames(java.util.List<java.lang.String> idFieldNames) {
                this.idFieldNames = idFieldNames;
                return this;
            }

            /**
             * Sets the value of {@link ZendeskDestinationPropertiesProperty#getWriteOperationType}
             * @param writeOperationType The possible write operations in the destination connector.
             *                           When this value is not provided, this defaults to the <code>INSERT</code> operation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder writeOperationType(java.lang.String writeOperationType) {
                this.writeOperationType = writeOperationType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskDestinationPropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskDestinationPropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskDestinationPropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskDestinationPropertiesProperty {
            private final java.lang.String object;
            private final java.lang.Object errorHandlingConfig;
            private final java.util.List<java.lang.String> idFieldNames;
            private final java.lang.String writeOperationType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.errorHandlingConfig = software.amazon.jsii.Kernel.get(this, "errorHandlingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idFieldNames = software.amazon.jsii.Kernel.get(this, "idFieldNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.writeOperationType = software.amazon.jsii.Kernel.get(this, "writeOperationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
                this.errorHandlingConfig = builder.errorHandlingConfig;
                this.idFieldNames = builder.idFieldNames;
                this.writeOperationType = builder.writeOperationType;
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            public final java.lang.Object getErrorHandlingConfig() {
                return this.errorHandlingConfig;
            }

            @Override
            public final java.util.List<java.lang.String> getIdFieldNames() {
                return this.idFieldNames;
            }

            @Override
            public final java.lang.String getWriteOperationType() {
                return this.writeOperationType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));
                if (this.getErrorHandlingConfig() != null) {
                    data.set("errorHandlingConfig", om.valueToTree(this.getErrorHandlingConfig()));
                }
                if (this.getIdFieldNames() != null) {
                    data.set("idFieldNames", om.valueToTree(this.getIdFieldNames()));
                }
                if (this.getWriteOperationType() != null) {
                    data.set("writeOperationType", om.valueToTree(this.getWriteOperationType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ZendeskDestinationPropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskDestinationPropertiesProperty.Jsii$Proxy that = (ZendeskDestinationPropertiesProperty.Jsii$Proxy) o;

                if (!object.equals(that.object)) return false;
                if (this.errorHandlingConfig != null ? !this.errorHandlingConfig.equals(that.errorHandlingConfig) : that.errorHandlingConfig != null) return false;
                if (this.idFieldNames != null ? !this.idFieldNames.equals(that.idFieldNames) : that.idFieldNames != null) return false;
                return this.writeOperationType != null ? this.writeOperationType.equals(that.writeOperationType) : that.writeOperationType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                result = 31 * result + (this.errorHandlingConfig != null ? this.errorHandlingConfig.hashCode() : 0);
                result = 31 * result + (this.idFieldNames != null ? this.idFieldNames.hashCode() : 0);
                result = 31 * result + (this.writeOperationType != null ? this.writeOperationType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The properties that are applied when using Zendesk as a flow source.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.appflow.*;
     * ZendeskSourcePropertiesProperty zendeskSourcePropertiesProperty = ZendeskSourcePropertiesProperty.builder()
     *         .object("object")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appflow.CfnFlow.ZendeskSourcePropertiesProperty")
    @software.amazon.jsii.Jsii.Proxy(ZendeskSourcePropertiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZendeskSourcePropertiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The object specified in the Zendesk flow source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html#cfn-appflow-flow-zendesksourceproperties-object">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appflow-flow-zendesksourceproperties.html#cfn-appflow-flow-zendesksourceproperties-object</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getObject();

        /**
         * @return a {@link Builder} of {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZendeskSourcePropertiesProperty> {
            java.lang.String object;

            /**
             * Sets the value of {@link ZendeskSourcePropertiesProperty#getObject}
             * @param object The object specified in the Zendesk flow source. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder object(java.lang.String object) {
                this.object = object;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZendeskSourcePropertiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZendeskSourcePropertiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZendeskSourcePropertiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZendeskSourcePropertiesProperty {
            private final java.lang.String object;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.object = software.amazon.jsii.Kernel.get(this, "object", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.object = java.util.Objects.requireNonNull(builder.object, "object is required");
            }

            @Override
            public final java.lang.String getObject() {
                return this.object;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("object", om.valueToTree(this.getObject()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appflow.CfnFlow.ZendeskSourcePropertiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZendeskSourcePropertiesProperty.Jsii$Proxy that = (ZendeskSourcePropertiesProperty.Jsii$Proxy) o;

                return this.object.equals(that.object);
            }

            @Override
            public final int hashCode() {
                int result = this.object.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appflow.CfnFlow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appflow.CfnFlow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appflow.CfnFlowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appflow.CfnFlowProps.Builder();
        }

        /**
         * The configuration that controls how Amazon AppFlow places data in the destination connector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist</a>
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(final software.amazon.awscdk.IResolvable destinationFlowConfigList) {
            this.props.destinationFlowConfigList(destinationFlowConfigList);
            return this;
        }
        /**
         * The configuration that controls how Amazon AppFlow places data in the destination connector.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-destinationflowconfiglist</a>
         * @param destinationFlowConfigList The configuration that controls how Amazon AppFlow places data in the destination connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationFlowConfigList(final java.util.List<? extends java.lang.Object> destinationFlowConfigList) {
            this.props.destinationFlowConfigList(destinationFlowConfigList);
            return this;
        }

        /**
         * The specified name of the flow.
         * <p>
         * Spaces are not allowed. Use underscores (_) or hyphens (-) only.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowname</a>
         * @param flowName The specified name of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowName(final java.lang.String flowName) {
            this.props.flowName(flowName);
            return this;
        }

        /**
         * Contains information about the configuration of the source connector used in the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig</a>
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(final software.amazon.awscdk.IResolvable sourceFlowConfig) {
            this.props.sourceFlowConfig(sourceFlowConfig);
            return this;
        }
        /**
         * Contains information about the configuration of the source connector used in the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-sourceflowconfig</a>
         * @param sourceFlowConfig Contains information about the configuration of the source connector used in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceFlowConfig(final software.amazon.awscdk.services.appflow.CfnFlow.SourceFlowConfigProperty sourceFlowConfig) {
            this.props.sourceFlowConfig(sourceFlowConfig);
            return this;
        }

        /**
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks</a>
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(final software.amazon.awscdk.IResolvable tasks) {
            this.props.tasks(tasks);
            return this;
        }
        /**
         * A list of tasks that Amazon AppFlow performs while transferring the data in the flow run.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tasks</a>
         * @param tasks A list of tasks that Amazon AppFlow performs while transferring the data in the flow run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tasks(final java.util.List<? extends java.lang.Object> tasks) {
            this.props.tasks(tasks);
            return this;
        }

        /**
         * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig</a>
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(final software.amazon.awscdk.IResolvable triggerConfig) {
            this.props.triggerConfig(triggerConfig);
            return this;
        }
        /**
         * The trigger settings that determine how and when Amazon AppFlow runs the specified flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-triggerconfig</a>
         * @param triggerConfig The trigger settings that determine how and when Amazon AppFlow runs the specified flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder triggerConfig(final software.amazon.awscdk.services.appflow.CfnFlow.TriggerConfigProperty triggerConfig) {
            this.props.triggerConfig(triggerConfig);
            return this;
        }

        /**
         * A user-entered description of the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-description</a>
         * @param description A user-entered description of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Sets the status of the flow. You can specify one of the following values:.
         * <p>
         * <ul>
         * <li><strong>Active</strong> - The flow runs based on the trigger settings that you defined. Active scheduled flows run as scheduled, and active event-triggered flows run when the specified change event occurs. However, active on-demand flows run only when you manually start them by using Amazon AppFlow.</li>
         * <li><strong>Suspended</strong> - You can use this option to deactivate an active flow. Scheduled and event-triggered flows will cease to run until you reactive them. This value only affects scheduled and event-triggered flows. It has no effect for on-demand flows.</li>
         * </ul>
         * <p>
         * If you omit the FlowStatus parameter, Amazon AppFlow creates the flow with a default status. The default status for on-demand flows is Active. The default status for scheduled and event-triggered flows is Draft, which means they’re not yet active.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-flowstatus</a>
         * @param flowStatus Sets the status of the flow. You can specify one of the following values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flowStatus(final java.lang.String flowStatus) {
            this.props.flowStatus(flowStatus);
            return this;
        }

        /**
         * The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption.
         * <p>
         * This is required if you do not want to use the Amazon AppFlow-managed KMS key. If you don't provide anything here, Amazon AppFlow uses the Amazon AppFlow-managed KMS key.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-kmsarn</a>
         * @param kmsArn The ARN (Amazon Resource Name) of the Key Management Service (KMS) key you provide for encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsArn(final java.lang.String kmsArn) {
            this.props.kmsArn(kmsArn);
            return this;
        }

        /**
         * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
         * <p>
         * When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig</a>
         * @param metadataCatalogConfig Specifies the configuration that Amazon AppFlow uses when it catalogs your data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataCatalogConfig(final software.amazon.awscdk.IResolvable metadataCatalogConfig) {
            this.props.metadataCatalogConfig(metadataCatalogConfig);
            return this;
        }
        /**
         * Specifies the configuration that Amazon AppFlow uses when it catalogs your data.
         * <p>
         * When Amazon AppFlow catalogs your data, it stores metadata in a data catalog.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-metadatacatalogconfig</a>
         * @param metadataCatalogConfig Specifies the configuration that Amazon AppFlow uses when it catalogs your data. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metadataCatalogConfig(final software.amazon.awscdk.services.appflow.CfnFlow.MetadataCatalogConfigProperty metadataCatalogConfig) {
            this.props.metadataCatalogConfig(metadataCatalogConfig);
            return this;
        }

        /**
         * The tags used to organize, track, or control access for your flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appflow-flow.html#cfn-appflow-flow-tags</a>
         * @param tags The tags used to organize, track, or control access for your flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appflow.CfnFlow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appflow.CfnFlow build() {
            return new software.amazon.awscdk.services.appflow.CfnFlow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
