package software.amazon.awscdk.services.appmesh;

/**
 * Properties for defining a <code>CfnGatewayRoute</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * CfnGatewayRouteProps cfnGatewayRouteProps = CfnGatewayRouteProps.builder()
 *         .meshName("meshName")
 *         .spec(GatewayRouteSpecProperty.builder()
 *                 .grpcRoute(GrpcGatewayRouteProperty.builder()
 *                         .action(GrpcGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(GrpcGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(GrpcGatewayRouteMatchProperty.builder()
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .metadata(List.of(GrpcGatewayRouteMetadataProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(GatewayRouteMetadataMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .port(123)
 *                                 .serviceName("serviceName")
 *                                 .build())
 *                         .build())
 *                 .http2Route(HttpGatewayRouteProperty.builder()
 *                         .action(HttpGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                                 .defaultPrefix("defaultPrefix")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(HttpGatewayRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .httpRoute(HttpGatewayRouteProperty.builder()
 *                         .action(HttpGatewayRouteActionProperty.builder()
 *                                 .target(GatewayRouteTargetProperty.builder()
 *                                         .virtualService(GatewayRouteVirtualServiceProperty.builder()
 *                                                 .virtualServiceName("virtualServiceName")
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .port(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .rewrite(HttpGatewayRouteRewriteProperty.builder()
 *                                         .hostname(GatewayRouteHostnameRewriteProperty.builder()
 *                                                 .defaultTargetHostname("defaultTargetHostname")
 *                                                 .build())
 *                                         .path(HttpGatewayRoutePathRewriteProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .prefix(HttpGatewayRoutePrefixRewriteProperty.builder()
 *                                                 .defaultPrefix("defaultPrefix")
 *                                                 .value("value")
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .match(HttpGatewayRouteMatchProperty.builder()
 *                                 .headers(List.of(HttpGatewayRouteHeaderProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .invert(false)
 *                                         .match(HttpGatewayRouteHeaderMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .prefix("prefix")
 *                                                 .range(GatewayRouteRangeMatchProperty.builder()
 *                                                         .end(123)
 *                                                         .start(123)
 *                                                         .build())
 *                                                 .regex("regex")
 *                                                 .suffix("suffix")
 *                                                 .build())
 *                                         .build()))
 *                                 .hostname(GatewayRouteHostnameMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .suffix("suffix")
 *                                         .build())
 *                                 .method("method")
 *                                 .path(HttpPathMatchProperty.builder()
 *                                         .exact("exact")
 *                                         .regex("regex")
 *                                         .build())
 *                                 .port(123)
 *                                 .prefix("prefix")
 *                                 .queryParameters(List.of(QueryParameterProperty.builder()
 *                                         .name("name")
 *                                         // the properties below are optional
 *                                         .match(HttpQueryParameterMatchProperty.builder()
 *                                                 .exact("exact")
 *                                                 .build())
 *                                         .build()))
 *                                 .build())
 *                         .build())
 *                 .priority(123)
 *                 .build())
 *         .virtualGatewayName("virtualGatewayName")
 *         // the properties below are optional
 *         .gatewayRouteName("gatewayRouteName")
 *         .meshOwner("meshOwner")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.425Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.CfnGatewayRouteProps")
@software.amazon.jsii.Jsii.Proxy(CfnGatewayRouteProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGatewayRouteProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the service mesh that the resource resides in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMeshName();

    /**
     * The specifications of the gateway route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-spec</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpec();

    /**
     * The virtual gateway that the gateway route is associated with.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-virtualgatewayname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualGatewayName();

    /**
     * The name of the gateway route.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-gatewayroutename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGatewayRouteName() {
        return null;
    }

    /**
     * The AWS IAM account ID of the service mesh owner.
     * <p>
     * If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-meshowner</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMeshOwner() {
        return null;
    }

    /**
     * Optional metadata that you can apply to the gateway route to assist with categorization and organization.
     * <p>
     * Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appmesh-gatewayroute.html#cfn-appmesh-gatewayroute-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGatewayRouteProps> {
        java.lang.String meshName;
        java.lang.Object spec;
        java.lang.String virtualGatewayName;
        java.lang.String gatewayRouteName;
        java.lang.String meshOwner;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getMeshName}
         * @param meshName The name of the service mesh that the resource resides in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshName(java.lang.String meshName) {
            this.meshName = meshName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getSpec}
         * @param spec The specifications of the gateway route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.IResolvable spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getSpec}
         * @param spec The specifications of the gateway route. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spec(software.amazon.awscdk.services.appmesh.CfnGatewayRoute.GatewayRouteSpecProperty spec) {
            this.spec = spec;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getVirtualGatewayName}
         * @param virtualGatewayName The virtual gateway that the gateway route is associated with. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualGatewayName(java.lang.String virtualGatewayName) {
            this.virtualGatewayName = virtualGatewayName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getGatewayRouteName}
         * @param gatewayRouteName The name of the gateway route.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder gatewayRouteName(java.lang.String gatewayRouteName) {
            this.gatewayRouteName = gatewayRouteName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getMeshOwner}
         * @param meshOwner The AWS IAM account ID of the service mesh owner.
         *                  If the account ID is not your own, then it's the ID of the account that shared the mesh with your account. For more information about mesh sharing, see <a href="https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html">Working with shared meshes</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder meshOwner(java.lang.String meshOwner) {
            this.meshOwner = meshOwner;
            return this;
        }

        /**
         * Sets the value of {@link CfnGatewayRouteProps#getTags}
         * @param tags Optional metadata that you can apply to the gateway route to assist with categorization and organization.
         *             Each tag consists of a key and an optional value, both of which you define. Tag keys can have a maximum character length of 128 characters, and tag values can have a maximum length of 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayRouteProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGatewayRouteProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGatewayRouteProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayRouteProps {
        private final java.lang.String meshName;
        private final java.lang.Object spec;
        private final java.lang.String virtualGatewayName;
        private final java.lang.String gatewayRouteName;
        private final java.lang.String meshOwner;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.meshName = software.amazon.jsii.Kernel.get(this, "meshName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.spec = software.amazon.jsii.Kernel.get(this, "spec", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.virtualGatewayName = software.amazon.jsii.Kernel.get(this, "virtualGatewayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.gatewayRouteName = software.amazon.jsii.Kernel.get(this, "gatewayRouteName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.meshOwner = software.amazon.jsii.Kernel.get(this, "meshOwner", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.meshName = java.util.Objects.requireNonNull(builder.meshName, "meshName is required");
            this.spec = java.util.Objects.requireNonNull(builder.spec, "spec is required");
            this.virtualGatewayName = java.util.Objects.requireNonNull(builder.virtualGatewayName, "virtualGatewayName is required");
            this.gatewayRouteName = builder.gatewayRouteName;
            this.meshOwner = builder.meshOwner;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getMeshName() {
            return this.meshName;
        }

        @Override
        public final java.lang.Object getSpec() {
            return this.spec;
        }

        @Override
        public final java.lang.String getVirtualGatewayName() {
            return this.virtualGatewayName;
        }

        @Override
        public final java.lang.String getGatewayRouteName() {
            return this.gatewayRouteName;
        }

        @Override
        public final java.lang.String getMeshOwner() {
            return this.meshOwner;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("meshName", om.valueToTree(this.getMeshName()));
            data.set("spec", om.valueToTree(this.getSpec()));
            data.set("virtualGatewayName", om.valueToTree(this.getVirtualGatewayName()));
            if (this.getGatewayRouteName() != null) {
                data.set("gatewayRouteName", om.valueToTree(this.getGatewayRouteName()));
            }
            if (this.getMeshOwner() != null) {
                data.set("meshOwner", om.valueToTree(this.getMeshOwner()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.CfnGatewayRouteProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayRouteProps.Jsii$Proxy that = (CfnGatewayRouteProps.Jsii$Proxy) o;

            if (!meshName.equals(that.meshName)) return false;
            if (!spec.equals(that.spec)) return false;
            if (!virtualGatewayName.equals(that.virtualGatewayName)) return false;
            if (this.gatewayRouteName != null ? !this.gatewayRouteName.equals(that.gatewayRouteName) : that.gatewayRouteName != null) return false;
            if (this.meshOwner != null ? !this.meshOwner.equals(that.meshOwner) : that.meshOwner != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.meshName.hashCode();
            result = 31 * result + (this.spec.hashCode());
            result = 31 * result + (this.virtualGatewayName.hashCode());
            result = 31 * result + (this.gatewayRouteName != null ? this.gatewayRouteName.hashCode() : 0);
            result = 31 * result + (this.meshOwner != null ? this.meshOwner.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
