package software.amazon.awscdk.services.appmesh;

/**
 * Defines HTTP gateway route matching based on the URL path of the request.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * VirtualGateway gateway;
 * VirtualService virtualService;
 * gateway.addGatewayRoute("gateway-route-http-2", GatewayRouteBaseProps.builder()
 *         .routeSpec(GatewayRouteSpec.http(HttpGatewayRouteSpecOptions.builder()
 *                 .routeTarget(virtualService)
 *                 .match(HttpGatewayRouteMatch.builder()
 *                         // This rewrites the path from '/test' to '/rewrittenPath'.
 *                         .path(HttpGatewayRoutePathMatch.exactly("/test", "/rewrittenPath"))
 *                         .build())
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.555Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.HttpGatewayRoutePathMatch")
public abstract class HttpGatewayRoutePathMatch extends software.amazon.jsii.JsiiObject {

    protected HttpGatewayRoutePathMatch(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpGatewayRoutePathMatch(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected HttpGatewayRoutePathMatch() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * The value of the path must match the specified value exactly.
     * <p>
     * The provided <code>path</code> must start with the '/' character.
     * <p>
     * @param path the exact path to match on. This parameter is required.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch exactly(final @org.jetbrains.annotations.NotNull java.lang.String path, final @org.jetbrains.annotations.Nullable java.lang.String rewriteTo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "exactly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required"), rewriteTo });
    }

    /**
     * The value of the path must match the specified value exactly.
     * <p>
     * The provided <code>path</code> must start with the '/' character.
     * <p>
     * @param path the exact path to match on. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch exactly(final @org.jetbrains.annotations.NotNull java.lang.String path) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "exactly", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(path, "path is required") });
    }

    /**
     * The value of the path must match the specified regex.
     * <p>
     * @param regex the regex used to match the path. This parameter is required.
     * @param rewriteTo the value to substitute for the matched part of the path of the gateway request URL As a default, retains original request's URL path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch regex(final @org.jetbrains.annotations.NotNull java.lang.String regex, final @org.jetbrains.annotations.Nullable java.lang.String rewriteTo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "regex", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(regex, "regex is required"), rewriteTo });
    }

    /**
     * The value of the path must match the specified regex.
     * <p>
     * @param regex the regex used to match the path. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch regex(final @org.jetbrains.annotations.NotNull java.lang.String regex) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "regex", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(regex, "regex is required") });
    }

    /**
     * The value of the path must match the specified prefix.
     * <p>
     * @param prefix the value to use to match the beginning of the path part of the URL of the request. This parameter is required.
     * @param rewriteTo Specify either disabling automatic rewrite or rewriting to specified prefix path.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch startsWith(final @org.jetbrains.annotations.NotNull java.lang.String prefix, final @org.jetbrains.annotations.Nullable java.lang.String rewriteTo) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "startsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required"), rewriteTo });
    }

    /**
     * The value of the path must match the specified prefix.
     * <p>
     * @param prefix the value to use to match the beginning of the path part of the URL of the request. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch startsWith(final @org.jetbrains.annotations.NotNull java.lang.String prefix) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class, "startsWith", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch.class), new Object[] { java.util.Objects.requireNonNull(prefix, "prefix is required") });
    }

    /**
     * Returns the gateway route path match configuration.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public abstract @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatch {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * Returns the gateway route path match configuration.
         * <p>
         * @param scope This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
            return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.HttpGatewayRoutePathMatchConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
        }
    }
}
