package software.amazon.awscdk.services.appsync;

/**
 * An AppSync datasource backed by a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GraphqlApi api = GraphqlApi.Builder.create(this, "Api")
 *         .name("demo")
 *         .definition(Definition.fromFile(join(__dirname, "schema.graphql")))
 *         .authorizationConfig(AuthorizationConfig.builder()
 *                 .defaultAuthorization(AuthorizationMode.builder()
 *                         .authorizationType(AuthorizationType.IAM)
 *                         .build())
 *                 .build())
 *         .xrayEnabled(true)
 *         .build();
 * Table demoTable = Table.Builder.create(this, "DemoTable")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .build();
 * DynamoDbDataSource demoDS = api.addDynamoDbDataSource("demoDataSource", demoTable);
 * // Resolver for the Query "getDemos" that scans the DynamoDb table and returns the entire list.
 * // Resolver Mapping Template Reference:
 * // https://docs.aws.amazon.com/appsync/latest/devguide/resolver-mapping-template-reference-dynamodb.html
 * demoDS.createResolver("QueryGetDemosResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemos")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable())
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * // Resolver for the Mutation "addDemo" that puts the item into the DynamoDb table.
 * demoDS.createResolver("MutationAddDemoResolver", BaseResolverProps.builder()
 *         .typeName("Mutation")
 *         .fieldName("addDemo")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbPutItem(PrimaryKey.partition("id").auto(), Values.projecting("input")))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultItem())
 *         .build());
 * //To enable DynamoDB read consistency with the `MappingTemplate`:
 * demoDS.createResolver("QueryGetDemosConsistentResolver", BaseResolverProps.builder()
 *         .typeName("Query")
 *         .fieldName("getDemosConsistent")
 *         .requestMappingTemplate(MappingTemplate.dynamoDbScanTable(true))
 *         .responseMappingTemplate(MappingTemplate.dynamoDbResultList())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:19.776Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.DynamoDbDataSource")
public class DynamoDbDataSource extends software.amazon.awscdk.services.appsync.BackedDataSource {

    protected DynamoDbDataSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DynamoDbDataSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DynamoDbDataSource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appsync.DynamoDbDataSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.appsync.DynamoDbDataSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.appsync.DynamoDbDataSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.appsync.DynamoDbDataSourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.appsync.DynamoDbDataSourceProps.Builder();
        }

        /**
         * The API to attach this data source to.
         * <p>
         * @return {@code this}
         * @param api The API to attach this data source to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder api(final software.amazon.awscdk.services.appsync.IGraphqlApi api) {
            this.props.api(api);
            return this;
        }

        /**
         * the description of the data source.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param description the description of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the data source.
         * <p>
         * Default: - id of data source
         * <p>
         * @return {@code this}
         * @param name The name of the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The IAM service role to be assumed by AppSync to interact with the data source.
         * <p>
         * Default: -  Create a new role
         * <p>
         * @return {@code this}
         * @param serviceRole The IAM service role to be assumed by AppSync to interact with the data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(final software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.props.serviceRole(serviceRole);
            return this;
        }

        /**
         * The DynamoDB table backing this data source.
         * <p>
         * @return {@code this}
         * @param table The DynamoDB table backing this data source. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder table(final software.amazon.awscdk.services.dynamodb.ITable table) {
            this.props.table(table);
            return this;
        }

        /**
         * Specify whether this DS is read only or has read and write permissions to the DynamoDB table.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readOnlyAccess Specify whether this DS is read only or has read and write permissions to the DynamoDB table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readOnlyAccess(final java.lang.Boolean readOnlyAccess) {
            this.props.readOnlyAccess(readOnlyAccess);
            return this;
        }

        /**
         * use credentials of caller to access DynamoDB.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param useCallerCredentials use credentials of caller to access DynamoDB. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useCallerCredentials(final java.lang.Boolean useCallerCredentials) {
            this.props.useCallerCredentials(useCallerCredentials);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.appsync.DynamoDbDataSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.appsync.DynamoDbDataSource build() {
            return new software.amazon.awscdk.services.appsync.DynamoDbDataSource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
