package software.amazon.awscdk.services.autoscaling;

/**
 * Properties for a warm pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.autoscaling.*;
 * AutoScalingGroup autoScalingGroup;
 * WarmPoolProps warmPoolProps = WarmPoolProps.builder()
 *         .autoScalingGroup(autoScalingGroup)
 *         // the properties below are optional
 *         .maxGroupPreparedCapacity(123)
 *         .minSize(123)
 *         .poolState(PoolState.HIBERNATED)
 *         .reuseOnScaleIn(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.024Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_autoscaling.WarmPoolProps")
@software.amazon.jsii.Jsii.Proxy(WarmPoolProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WarmPoolProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.autoscaling.WarmPoolOptions {

    /**
     * The Auto Scaling group to add the warm pool to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup();

    /**
     * @return a {@link Builder} of {@link WarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WarmPoolProps> {
        software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        java.lang.Number maxGroupPreparedCapacity;
        java.lang.Number minSize;
        software.amazon.awscdk.services.autoscaling.PoolState poolState;
        java.lang.Boolean reuseOnScaleIn;

        /**
         * Sets the value of {@link WarmPoolProps#getAutoScalingGroup}
         * @param autoScalingGroup The Auto Scaling group to add the warm pool to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoScalingGroup(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup) {
            this.autoScalingGroup = autoScalingGroup;
            return this;
        }

        /**
         * Sets the value of {@link WarmPoolProps#getMaxGroupPreparedCapacity}
         * @param maxGroupPreparedCapacity The maximum number of instances that are allowed to be in the warm pool or in any state except Terminated for the Auto Scaling group.
         *                                 If the value is not specified, Amazon EC2 Auto Scaling launches and maintains
         *                                 the difference between the group's maximum capacity and its desired capacity.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxGroupPreparedCapacity(java.lang.Number maxGroupPreparedCapacity) {
            this.maxGroupPreparedCapacity = maxGroupPreparedCapacity;
            return this;
        }

        /**
         * Sets the value of {@link WarmPoolProps#getMinSize}
         * @param minSize The minimum number of instances to maintain in the warm pool.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minSize(java.lang.Number minSize) {
            this.minSize = minSize;
            return this;
        }

        /**
         * Sets the value of {@link WarmPoolProps#getPoolState}
         * @param poolState The instance state to transition to after the lifecycle actions are complete.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder poolState(software.amazon.awscdk.services.autoscaling.PoolState poolState) {
            this.poolState = poolState;
            return this;
        }

        /**
         * Sets the value of {@link WarmPoolProps#getReuseOnScaleIn}
         * @param reuseOnScaleIn Indicates whether instances in the Auto Scaling group can be returned to the warm pool on scale in.
         *                       If the value is not specified, instances in the Auto Scaling group will be terminated
         *                       when the group scales in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseOnScaleIn(java.lang.Boolean reuseOnScaleIn) {
            this.reuseOnScaleIn = reuseOnScaleIn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WarmPoolProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WarmPoolProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WarmPoolProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WarmPoolProps {
        private final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup autoScalingGroup;
        private final java.lang.Number maxGroupPreparedCapacity;
        private final java.lang.Number minSize;
        private final software.amazon.awscdk.services.autoscaling.PoolState poolState;
        private final java.lang.Boolean reuseOnScaleIn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.autoScalingGroup = software.amazon.jsii.Kernel.get(this, "autoScalingGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.IAutoScalingGroup.class));
            this.maxGroupPreparedCapacity = software.amazon.jsii.Kernel.get(this, "maxGroupPreparedCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.minSize = software.amazon.jsii.Kernel.get(this, "minSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.poolState = software.amazon.jsii.Kernel.get(this, "poolState", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.autoscaling.PoolState.class));
            this.reuseOnScaleIn = software.amazon.jsii.Kernel.get(this, "reuseOnScaleIn", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.autoScalingGroup = java.util.Objects.requireNonNull(builder.autoScalingGroup, "autoScalingGroup is required");
            this.maxGroupPreparedCapacity = builder.maxGroupPreparedCapacity;
            this.minSize = builder.minSize;
            this.poolState = builder.poolState;
            this.reuseOnScaleIn = builder.reuseOnScaleIn;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.IAutoScalingGroup getAutoScalingGroup() {
            return this.autoScalingGroup;
        }

        @Override
        public final java.lang.Number getMaxGroupPreparedCapacity() {
            return this.maxGroupPreparedCapacity;
        }

        @Override
        public final java.lang.Number getMinSize() {
            return this.minSize;
        }

        @Override
        public final software.amazon.awscdk.services.autoscaling.PoolState getPoolState() {
            return this.poolState;
        }

        @Override
        public final java.lang.Boolean getReuseOnScaleIn() {
            return this.reuseOnScaleIn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("autoScalingGroup", om.valueToTree(this.getAutoScalingGroup()));
            if (this.getMaxGroupPreparedCapacity() != null) {
                data.set("maxGroupPreparedCapacity", om.valueToTree(this.getMaxGroupPreparedCapacity()));
            }
            if (this.getMinSize() != null) {
                data.set("minSize", om.valueToTree(this.getMinSize()));
            }
            if (this.getPoolState() != null) {
                data.set("poolState", om.valueToTree(this.getPoolState()));
            }
            if (this.getReuseOnScaleIn() != null) {
                data.set("reuseOnScaleIn", om.valueToTree(this.getReuseOnScaleIn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_autoscaling.WarmPoolProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WarmPoolProps.Jsii$Proxy that = (WarmPoolProps.Jsii$Proxy) o;

            if (!autoScalingGroup.equals(that.autoScalingGroup)) return false;
            if (this.maxGroupPreparedCapacity != null ? !this.maxGroupPreparedCapacity.equals(that.maxGroupPreparedCapacity) : that.maxGroupPreparedCapacity != null) return false;
            if (this.minSize != null ? !this.minSize.equals(that.minSize) : that.minSize != null) return false;
            if (this.poolState != null ? !this.poolState.equals(that.poolState) : that.poolState != null) return false;
            return this.reuseOnScaleIn != null ? this.reuseOnScaleIn.equals(that.reuseOnScaleIn) : that.reuseOnScaleIn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.autoScalingGroup.hashCode();
            result = 31 * result + (this.maxGroupPreparedCapacity != null ? this.maxGroupPreparedCapacity.hashCode() : 0);
            result = 31 * result + (this.minSize != null ? this.minSize.hashCode() : 0);
            result = 31 * result + (this.poolState != null ? this.poolState.hashCode() : 0);
            result = 31 * result + (this.reuseOnScaleIn != null ? this.reuseOnScaleIn.hashCode() : 0);
            return result;
        }
    }
}
