package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnReportPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object reportDeliveryChannel;
 * Object reportSetting;
 * CfnReportPlanProps cfnReportPlanProps = CfnReportPlanProps.builder()
 *         .reportDeliveryChannel(reportDeliveryChannel)
 *         .reportSetting(reportSetting)
 *         // the properties below are optional
 *         .reportPlanDescription("reportPlanDescription")
 *         .reportPlanName("reportPlanName")
 *         .reportPlanTags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.105Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnReportPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnReportPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReportPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportdeliverychannel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportdeliverychannel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getReportDeliveryChannel();

    /**
     * Identifies the report template for the report. Reports are built using a report template. The report templates are:.
     * <p>
     * <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
     * <p>
     * If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code> , this API resource also describes the report coverage by AWS Regions and frameworks.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportsetting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportsetting</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getReportSetting();

    /**
     * An optional description of the report plan with a maximum 1,024 characters.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplandescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplandescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReportPlanDescription() {
        return null;
    }

    /**
     * The unique name of the report plan.
     * <p>
     * This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplanname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getReportPlanName() {
        return null;
    }

    /**
     * A list of tags to tag your report plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplantags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-reportplan.html#cfn-backup-reportplan-reportplantags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getReportPlanTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReportPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReportPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReportPlanProps> {
        java.lang.Object reportDeliveryChannel;
        java.lang.Object reportSetting;
        java.lang.String reportPlanDescription;
        java.lang.String reportPlanName;
        java.util.List<software.amazon.awscdk.CfnTag> reportPlanTags;

        /**
         * Sets the value of {@link CfnReportPlanProps#getReportDeliveryChannel}
         * @param reportDeliveryChannel Contains information about where and how to deliver your reports, specifically your Amazon S3 bucket name, S3 key prefix, and the formats of your reports. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportDeliveryChannel(java.lang.Object reportDeliveryChannel) {
            this.reportDeliveryChannel = reportDeliveryChannel;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportPlanProps#getReportSetting}
         * @param reportSetting Identifies the report template for the report. Reports are built using a report template. The report templates are:. This parameter is required.
         *                      <code>RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT</code>
         *                      <p>
         *                      If the report template is <code>RESOURCE_COMPLIANCE_REPORT</code> or <code>CONTROL_COMPLIANCE_REPORT</code> , this API resource also describes the report coverage by AWS Regions and frameworks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportSetting(java.lang.Object reportSetting) {
            this.reportSetting = reportSetting;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportPlanProps#getReportPlanDescription}
         * @param reportPlanDescription An optional description of the report plan with a maximum 1,024 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportPlanDescription(java.lang.String reportPlanDescription) {
            this.reportPlanDescription = reportPlanDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportPlanProps#getReportPlanName}
         * @param reportPlanName The unique name of the report plan.
         *                       This name is between 1 and 256 characters starting with a letter, and consisting of letters (a-z, A-Z), numbers (0-9), and underscores (_).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportPlanName(java.lang.String reportPlanName) {
            this.reportPlanName = reportPlanName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportPlanProps#getReportPlanTags}
         * @param reportPlanTags A list of tags to tag your report plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder reportPlanTags(java.util.List<? extends software.amazon.awscdk.CfnTag> reportPlanTags) {
            this.reportPlanTags = (java.util.List<software.amazon.awscdk.CfnTag>)reportPlanTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReportPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReportPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReportPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReportPlanProps {
        private final java.lang.Object reportDeliveryChannel;
        private final java.lang.Object reportSetting;
        private final java.lang.String reportPlanDescription;
        private final java.lang.String reportPlanName;
        private final java.util.List<software.amazon.awscdk.CfnTag> reportPlanTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.reportDeliveryChannel = software.amazon.jsii.Kernel.get(this, "reportDeliveryChannel", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.reportSetting = software.amazon.jsii.Kernel.get(this, "reportSetting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.reportPlanDescription = software.amazon.jsii.Kernel.get(this, "reportPlanDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reportPlanName = software.amazon.jsii.Kernel.get(this, "reportPlanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reportPlanTags = software.amazon.jsii.Kernel.get(this, "reportPlanTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.reportDeliveryChannel = java.util.Objects.requireNonNull(builder.reportDeliveryChannel, "reportDeliveryChannel is required");
            this.reportSetting = java.util.Objects.requireNonNull(builder.reportSetting, "reportSetting is required");
            this.reportPlanDescription = builder.reportPlanDescription;
            this.reportPlanName = builder.reportPlanName;
            this.reportPlanTags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.reportPlanTags;
        }

        @Override
        public final java.lang.Object getReportDeliveryChannel() {
            return this.reportDeliveryChannel;
        }

        @Override
        public final java.lang.Object getReportSetting() {
            return this.reportSetting;
        }

        @Override
        public final java.lang.String getReportPlanDescription() {
            return this.reportPlanDescription;
        }

        @Override
        public final java.lang.String getReportPlanName() {
            return this.reportPlanName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getReportPlanTags() {
            return this.reportPlanTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("reportDeliveryChannel", om.valueToTree(this.getReportDeliveryChannel()));
            data.set("reportSetting", om.valueToTree(this.getReportSetting()));
            if (this.getReportPlanDescription() != null) {
                data.set("reportPlanDescription", om.valueToTree(this.getReportPlanDescription()));
            }
            if (this.getReportPlanName() != null) {
                data.set("reportPlanName", om.valueToTree(this.getReportPlanName()));
            }
            if (this.getReportPlanTags() != null) {
                data.set("reportPlanTags", om.valueToTree(this.getReportPlanTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnReportPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReportPlanProps.Jsii$Proxy that = (CfnReportPlanProps.Jsii$Proxy) o;

            if (!reportDeliveryChannel.equals(that.reportDeliveryChannel)) return false;
            if (!reportSetting.equals(that.reportSetting)) return false;
            if (this.reportPlanDescription != null ? !this.reportPlanDescription.equals(that.reportPlanDescription) : that.reportPlanDescription != null) return false;
            if (this.reportPlanName != null ? !this.reportPlanName.equals(that.reportPlanName) : that.reportPlanName != null) return false;
            return this.reportPlanTags != null ? this.reportPlanTags.equals(that.reportPlanTags) : that.reportPlanTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.reportDeliveryChannel.hashCode();
            result = 31 * result + (this.reportSetting.hashCode());
            result = 31 * result + (this.reportPlanDescription != null ? this.reportPlanDescription.hashCode() : 0);
            result = 31 * result + (this.reportPlanName != null ? this.reportPlanName.hashCode() : 0);
            result = 31 * result + (this.reportPlanTags != null ? this.reportPlanTags.hashCode() : 0);
            return result;
        }
    }
}
