package software.amazon.awscdk.services.batch;

/**
 * Properties for defining a <code>CfnComputeEnvironment</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * CfnComputeEnvironmentProps cfnComputeEnvironmentProps = CfnComputeEnvironmentProps.builder()
 *         .type("type")
 *         // the properties below are optional
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .computeResources(ComputeResourcesProperty.builder()
 *                 .maxvCpus(123)
 *                 .subnets(List.of("subnets"))
 *                 .type("type")
 *                 // the properties below are optional
 *                 .allocationStrategy("allocationStrategy")
 *                 .bidPercentage(123)
 *                 .desiredvCpus(123)
 *                 .ec2Configuration(List.of(Ec2ConfigurationObjectProperty.builder()
 *                         .imageType("imageType")
 *                         // the properties below are optional
 *                         .imageIdOverride("imageIdOverride")
 *                         .imageKubernetesVersion("imageKubernetesVersion")
 *                         .build()))
 *                 .ec2KeyPair("ec2KeyPair")
 *                 .imageId("imageId")
 *                 .instanceRole("instanceRole")
 *                 .instanceTypes(List.of("instanceTypes"))
 *                 .launchTemplate(LaunchTemplateSpecificationProperty.builder()
 *                         .launchTemplateId("launchTemplateId")
 *                         .launchTemplateName("launchTemplateName")
 *                         .version("version")
 *                         .build())
 *                 .minvCpus(123)
 *                 .placementGroup("placementGroup")
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .spotIamFleetRole("spotIamFleetRole")
 *                 .tags(Map.of(
 *                         "tagsKey", "tags"))
 *                 .updateToLatestImageVersion(false)
 *                 .build())
 *         .eksConfiguration(EksConfigurationProperty.builder()
 *                 .eksClusterArn("eksClusterArn")
 *                 .kubernetesNamespace("kubernetesNamespace")
 *                 .build())
 *         .replaceComputeEnvironment(false)
 *         .serviceRole("serviceRole")
 *         .state("state")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .unmanagedvCpus(123)
 *         .updatePolicy(UpdatePolicyProperty.builder()
 *                 .jobExecutionTimeoutMinutes(123)
 *                 .terminateJobsOnUpdate(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.146Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.CfnComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(CfnComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of the compute environment: <code>MANAGED</code> or <code>UNMANAGED</code> .
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * The name for your compute environment.
     * <p>
     * It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeenvironmentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getComputeEnvironmentName() {
        return null;
    }

    /**
     * The ComputeResources property type specifies details of the compute resources managed by the compute environment.
     * <p>
     * This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-computeresources</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getComputeResources() {
        return null;
    }

    /**
     * The details for the Amazon EKS cluster that supports the compute environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-eksconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-eksconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEksConfiguration() {
        return null;
    }

    /**
     * Specifies whether the compute environment is replaced if an update is made that requires replacing the instances in the compute environment.
     * <p>
     * The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , do not change any other properties at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
     * <p>
     * The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
     * <p>
     * Default: - true
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-replacecomputeenvironment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-replacecomputeenvironment</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getReplaceComputeEnvironment() {
        return null;
    }

    /**
     * The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">AWS Batch service IAM role</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account.
     * <p>
     * </blockquote>
     * <p>
     * If your specified role has a path other than <code>/</code> , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> , specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * Depending on how you created your AWS Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-servicerole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServiceRole() {
        return null;
    }

    /**
     * The state of the compute environment.
     * <p>
     * If the state is <code>ENABLED</code> , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
     * <p>
     * If the state is <code>ENABLED</code> , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
     * <p>
     * If the state is <code>DISABLED</code> , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don't scale out.
     * <p>
     * <blockquote>
     * <p>
     * Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent additional charges, turn off and then delete the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state">State</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * </blockquote>
     * <p>
     * When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code> . This instance doesn't scale down to a <code>c5.large</code> instance.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-state</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return null;
    }

    /**
     * The tags applied to the compute environment.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * The maximum number of vCPUs for an unmanaged compute environment.
     * <p>
     * This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code> .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-unmanagedvcpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-unmanagedvcpus</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnmanagedvCpus() {
        return null;
    }

    /**
     * Specifies the infrastructure update policy for the compute environment.
     * <p>
     * For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-updatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-batch-computeenvironment.html#cfn-batch-computeenvironment-updatepolicy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getUpdatePolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnComputeEnvironmentProps> {
        java.lang.String type;
        java.lang.String computeEnvironmentName;
        java.lang.Object computeResources;
        java.lang.Object eksConfiguration;
        java.lang.Object replaceComputeEnvironment;
        java.lang.String serviceRole;
        java.lang.String state;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Number unmanagedvCpus;
        java.lang.Object updatePolicy;

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getType}
         * @param type The type of the compute environment: <code>MANAGED</code> or <code>UNMANAGED</code> . This parameter is required.
         *             For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the <em>AWS Batch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName The name for your compute environment.
         *                               It can be up to 128 characters long. It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeResources}
         * @param computeResources The ComputeResources property type specifies details of the compute resources managed by the compute environment.
         *                         This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(software.amazon.awscdk.IResolvable computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getComputeResources}
         * @param computeResources The ComputeResources property type specifies details of the compute resources managed by the compute environment.
         *                         This parameter is required for managed compute environments. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environments.html">Compute Environments</a> in the ** .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeResources(software.amazon.awscdk.services.batch.CfnComputeEnvironment.ComputeResourcesProperty computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getEksConfiguration}
         * @param eksConfiguration The details for the Amazon EKS cluster that supports the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksConfiguration(software.amazon.awscdk.IResolvable eksConfiguration) {
            this.eksConfiguration = eksConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getEksConfiguration}
         * @param eksConfiguration The details for the Amazon EKS cluster that supports the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksConfiguration(software.amazon.awscdk.services.batch.CfnComputeEnvironment.EksConfigurationProperty eksConfiguration) {
            this.eksConfiguration = eksConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getReplaceComputeEnvironment}
         * @param replaceComputeEnvironment Specifies whether the compute environment is replaced if an update is made that requires replacing the instances in the compute environment.
         *                                  The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , do not change any other properties at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
         *                                  <p>
         *                                  The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(java.lang.Boolean replaceComputeEnvironment) {
            this.replaceComputeEnvironment = replaceComputeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getReplaceComputeEnvironment}
         * @param replaceComputeEnvironment Specifies whether the compute environment is replaced if an update is made that requires replacing the instances in the compute environment.
         *                                  The default value is <code>true</code> . To enable more properties to be updated, set this property to <code>false</code> . When changing the value of this property to <code>false</code> , do not change any other properties at the same time. If other properties are changed at the same time, and the change needs to be rolled back but it can't, it's possible for the stack to go into the <code>UPDATE_ROLLBACK_FAILED</code> state. You can't update a stack that is in the <code>UPDATE_ROLLBACK_FAILED</code> state. However, if you can continue to roll it back, you can return the stack to its original settings and then try to update it again. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-continueupdaterollback.html">Continue rolling back an update</a> in the <em>AWS CloudFormation User Guide</em> .
         *                                  <p>
         *                                  The properties that can't be changed without replacing the compute environment are in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html"><code>ComputeResources</code></a> property type: <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-allocationstrategy"><code>AllocationStrategy</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-bidpercentage"><code>BidPercentage</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2configuration"><code>Ec2Configuration</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-ec2keypair"><code>Ec2KeyPair</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-imageid"><code>ImageId</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancerole"><code>InstanceRole</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-instancetypes"><code>InstanceTypes</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-launchtemplate"><code>LaunchTemplate</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-maxvcpus"><code>MaxvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-minvcpus"><code>MinvCpus</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-placementgroup"><code>PlacementGroup</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-securitygroupids"><code>SecurityGroupIds</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-subnets"><code>Subnets</code></a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-tags">Tags</a> , <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-type"><code>Type</code></a> , and <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-batch-computeenvironment-computeresources.html#cfn-batch-computeenvironment-computeresources-updatetolatestimageversion"><code>UpdateToLatestImageVersion</code></a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(software.amazon.awscdk.IResolvable replaceComputeEnvironment) {
            this.replaceComputeEnvironment = replaceComputeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getServiceRole}
         * @param serviceRole The full Amazon Resource Name (ARN) of the IAM role that allows AWS Batch to make calls to other AWS services on your behalf.
         *                    For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/service_IAM_role.html">AWS Batch service IAM role</a> in the <em>AWS Batch User Guide</em> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    If your account already created the AWS Batch service-linked role, that role is used by default for your compute environment unless you specify a different role here. If the AWS Batch service-linked role doesn't exist in your account, and no role is specified here, the service attempts to create the AWS Batch service-linked role in your account.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    If your specified role has a path other than <code>/</code> , then you must specify either the full role ARN (recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> , specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    Depending on how you created your AWS Batch service role, its ARN might contain the <code>service-role</code> path prefix. When you only specify the name of the service role, AWS Batch assumes that your ARN doesn't use the <code>service-role</code> path prefix. Because of this, we recommend that you specify the full ARN of your service role when you create compute environments.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(java.lang.String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getState}
         * @param state The state of the compute environment.
         *              If the state is <code>ENABLED</code> , then the compute environment accepts jobs from a queue and can scale out automatically based on queues.
         *              <p>
         *              If the state is <code>ENABLED</code> , then the AWS Batch scheduler can attempt to place jobs from an associated job queue on the compute resources within the environment. If the compute environment is managed, then it can scale its instances out or in automatically, based on the job queue demand.
         *              <p>
         *              If the state is <code>DISABLED</code> , then the AWS Batch scheduler doesn't attempt to place jobs within the environment. Jobs in a <code>STARTING</code> or <code>RUNNING</code> state continue to progress normally. Managed compute environments in the <code>DISABLED</code> state don't scale out.
         *              <p>
         *              <blockquote>
         *              <p>
         *              Compute environments in a <code>DISABLED</code> state may continue to incur billing charges. To prevent additional charges, turn off and then delete the compute environment. For more information, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/compute_environment_parameters.html#compute_environment_state">State</a> in the <em>AWS Batch User Guide</em> .
         *              <p>
         *              </blockquote>
         *              <p>
         *              When an instance is idle, the instance scales down to the <code>minvCpus</code> value. However, the instance size doesn't change. For example, consider a <code>c5.8xlarge</code> instance with a <code>minvCpus</code> value of <code>4</code> and a <code>desiredvCpus</code> value of <code>36</code> . This instance doesn't scale down to a <code>c5.large</code> instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(java.lang.String state) {
            this.state = state;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getTags}
         * @param tags The tags applied to the compute environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getUnmanagedvCpus}
         * @param unmanagedvCpus The maximum number of vCPUs for an unmanaged compute environment.
         *                       This parameter is only used for fair share scheduling to reserve vCPU capacity for new share identifiers. If this parameter isn't provided for a fair share job queue, no vCPU capacity is reserved.
         *                       <p>
         *                       <blockquote>
         *                       <p>
         *                       This parameter is only supported when the <code>type</code> parameter is set to <code>UNMANAGED</code> .
         *                       <p>
         *                       </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unmanagedvCpus(java.lang.Number unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getUpdatePolicy}
         * @param updatePolicy Specifies the infrastructure update policy for the compute environment.
         *                     For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(software.amazon.awscdk.IResolvable updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        /**
         * Sets the value of {@link CfnComputeEnvironmentProps#getUpdatePolicy}
         * @param updatePolicy Specifies the infrastructure update policy for the compute environment.
         *                     For more information about infrastructure updates, see <a href="https://docs.aws.amazon.com/batch/latest/userguide/updating-compute-environments.html">Updating compute environments</a> in the <em>AWS Batch User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updatePolicy(software.amazon.awscdk.services.batch.CfnComputeEnvironment.UpdatePolicyProperty updatePolicy) {
            this.updatePolicy = updatePolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnComputeEnvironmentProps {
        private final java.lang.String type;
        private final java.lang.String computeEnvironmentName;
        private final java.lang.Object computeResources;
        private final java.lang.Object eksConfiguration;
        private final java.lang.Object replaceComputeEnvironment;
        private final java.lang.String serviceRole;
        private final java.lang.String state;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Number unmanagedvCpus;
        private final java.lang.Object updatePolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.computeResources = software.amazon.jsii.Kernel.get(this, "computeResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eksConfiguration = software.amazon.jsii.Kernel.get(this, "eksConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replaceComputeEnvironment = software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.unmanagedvCpus = software.amazon.jsii.Kernel.get(this, "unmanagedvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.updatePolicy = software.amazon.jsii.Kernel.get(this, "updatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.computeResources = builder.computeResources;
            this.eksConfiguration = builder.eksConfiguration;
            this.replaceComputeEnvironment = builder.replaceComputeEnvironment;
            this.serviceRole = builder.serviceRole;
            this.state = builder.state;
            this.tags = builder.tags;
            this.unmanagedvCpus = builder.unmanagedvCpus;
            this.updatePolicy = builder.updatePolicy;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final java.lang.Object getComputeResources() {
            return this.computeResources;
        }

        @Override
        public final java.lang.Object getEksConfiguration() {
            return this.eksConfiguration;
        }

        @Override
        public final java.lang.Object getReplaceComputeEnvironment() {
            return this.replaceComputeEnvironment;
        }

        @Override
        public final java.lang.String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final java.lang.String getState() {
            return this.state;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Number getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        @Override
        public final java.lang.Object getUpdatePolicy() {
            return this.updatePolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("type", om.valueToTree(this.getType()));
            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getComputeResources() != null) {
                data.set("computeResources", om.valueToTree(this.getComputeResources()));
            }
            if (this.getEksConfiguration() != null) {
                data.set("eksConfiguration", om.valueToTree(this.getEksConfiguration()));
            }
            if (this.getReplaceComputeEnvironment() != null) {
                data.set("replaceComputeEnvironment", om.valueToTree(this.getReplaceComputeEnvironment()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }
            if (this.getState() != null) {
                data.set("state", om.valueToTree(this.getState()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getUnmanagedvCpus() != null) {
                data.set("unmanagedvCpus", om.valueToTree(this.getUnmanagedvCpus()));
            }
            if (this.getUpdatePolicy() != null) {
                data.set("updatePolicy", om.valueToTree(this.getUpdatePolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.CfnComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnComputeEnvironmentProps.Jsii$Proxy that = (CfnComputeEnvironmentProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.computeResources != null ? !this.computeResources.equals(that.computeResources) : that.computeResources != null) return false;
            if (this.eksConfiguration != null ? !this.eksConfiguration.equals(that.eksConfiguration) : that.eksConfiguration != null) return false;
            if (this.replaceComputeEnvironment != null ? !this.replaceComputeEnvironment.equals(that.replaceComputeEnvironment) : that.replaceComputeEnvironment != null) return false;
            if (this.serviceRole != null ? !this.serviceRole.equals(that.serviceRole) : that.serviceRole != null) return false;
            if (this.state != null ? !this.state.equals(that.state) : that.state != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.unmanagedvCpus != null ? !this.unmanagedvCpus.equals(that.unmanagedvCpus) : that.unmanagedvCpus != null) return false;
            return this.updatePolicy != null ? this.updatePolicy.equals(that.updatePolicy) : that.updatePolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.computeResources != null ? this.computeResources.hashCode() : 0);
            result = 31 * result + (this.eksConfiguration != null ? this.eksConfiguration.hashCode() : 0);
            result = 31 * result + (this.replaceComputeEnvironment != null ? this.replaceComputeEnvironment.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.unmanagedvCpus != null ? this.unmanagedvCpus.hashCode() : 0);
            result = 31 * result + (this.updatePolicy != null ? this.updatePolicy.hashCode() : 0);
            return result;
        }
    }
}
