package software.amazon.awscdk.services.batch;

/**
 * Represents a Volume that can be mounted to a container that uses ECS.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IFileSystem myFileSystem;
 * Role myJobRole;
 * myFileSystem.grantRead(myJobRole);
 * EcsJobDefinition jobDefn = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .volumes(List.of(EcsVolume.efs(EfsVolumeOptions.builder()
 *                         .name("myVolume")
 *                         .fileSystem(myFileSystem)
 *                         .containerPath("/Volumes/myVolume")
 *                         .useJobRole(true)
 *                         .build())))
 *                 .jobRole(myJobRole)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.229Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsVolume")
public abstract class EcsVolume extends software.amazon.jsii.JsiiObject {

    protected EcsVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected EcsVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a Volume that uses an AWS Elastic File System (EFS);
     * <p>
     * this volume can grow and shrink as needed
     * <p>
     * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html">https://docs.aws.amazon.com/batch/latest/userguide/efs-volumes.html</a>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EfsVolume efs(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EfsVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EcsVolume.class, "efs", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EfsVolume.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Creates a Host volume.
     * <p>
     * This volume will persist on the host at the specified <code>hostPath</code>.
     * If the <code>hostPath</code> is not specified, Docker will choose the host path. In this case,
     * the data may not persist after the containers that use it stop running.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostVolume host(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.HostVolumeOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EcsVolume.class, "host", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.HostVolume.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The path on the container that this volume will be mounted to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getContainerPath() {
        return software.amazon.jsii.Kernel.get(this, "containerPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this volume.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Whether or not the container has readonly access to this volume.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getReadonly() {
        return software.amazon.jsii.Kernel.get(this, "readonly", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.batch.EcsVolume {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
