package software.amazon.awscdk.services.batch;

/**
 * Props for a ManagedEc2EksComputeEnvironment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.eks.*;
 * import software.amazon.awscdk.services.iam.*;
 * Cluster cluster;
 * InstanceType instanceType;
 * LaunchTemplate launchTemplate;
 * IMachineImage machineImage;
 * PlacementGroup placementGroup;
 * Role role;
 * SecurityGroup securityGroup;
 * Subnet subnet;
 * SubnetFilter subnetFilter;
 * Vpc vpc;
 * ManagedEc2EksComputeEnvironmentProps managedEc2EksComputeEnvironmentProps = ManagedEc2EksComputeEnvironmentProps.builder()
 *         .eksCluster(cluster)
 *         .kubernetesNamespace("kubernetesNamespace")
 *         .vpc(vpc)
 *         // the properties below are optional
 *         .allocationStrategy(AllocationStrategy.BEST_FIT)
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .enabled(false)
 *         .images(List.of(EksMachineImage.builder()
 *                 .image(machineImage)
 *                 .imageType(EksMachineImageType.EKS_AL2)
 *                 .build()))
 *         .instanceClasses(List.of(InstanceClass.STANDARD3))
 *         .instanceRole(role)
 *         .instanceTypes(List.of(instanceType))
 *         .launchTemplate(launchTemplate)
 *         .maxvCpus(123)
 *         .minvCpus(123)
 *         .placementGroup(placementGroup)
 *         .replaceComputeEnvironment(false)
 *         .securityGroups(List.of(securityGroup))
 *         .serviceRole(role)
 *         .spot(false)
 *         .spotBidPercentage(123)
 *         .terminateOnUpdate(false)
 *         .updateTimeout(Duration.minutes(30))
 *         .updateToLatestImageVersion(false)
 *         .useOptimalInstanceClasses(false)
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .availabilityZones(List.of("availabilityZones"))
 *                 .onePerAz(false)
 *                 .subnetFilters(List.of(subnetFilter))
 *                 .subnetGroupName("subnetGroupName")
 *                 .subnets(List.of(subnet))
 *                 .subnetType(SubnetType.PRIVATE_ISOLATED)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.297Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.ManagedEc2EksComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(ManagedEc2EksComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedEc2EksComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.ManagedComputeEnvironmentProps {

    /**
     * The cluster that backs this Compute Environment. Required for Compute Environments running Kubernetes jobs.
     * <p>
     * Please ensure that you have followed the steps at
     * <p>
     * https://docs.aws.amazon.com/batch/latest/userguide/getting-started-eks.html
     * <p>
     * before attempting to deploy a <code>ManagedEc2EksComputeEnvironment</code> that uses this cluster.
     * If you do not follow the steps in the link, the deployment fail with a message that the
     * compute environment did not stabilize.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.eks.ICluster getEksCluster();

    /**
     * The namespace of the Cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKubernetesNamespace();

    /**
     * The allocation strategy to use if not enough instances of the best fitting instance type can be allocated.
     * <p>
     * Default: - `BEST_FIT_PROGRESSIVE` if not using Spot instances,
     * `SPOT_CAPACITY_OPTIMIZED` if using Spot instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.AllocationStrategy getAllocationStrategy() {
        return null;
    }

    /**
     * Configure which AMIs this Compute Environment can launch.
     * <p>
     * Default: If `imageKubernetesVersion` is specified,
     * - EKS_AL2 for non-GPU instances, EKS_AL2_NVIDIA for GPU instances,
     * Otherwise,
     * - ECS_AL2 for non-GPU instances, ECS_AL2_NVIDIA for GPU instances,
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.batch.EksMachineImage> getImages() {
        return null;
    }

    /**
     * The instance types that this Compute Environment can launch.
     * <p>
     * Which one is chosen depends on the <code>AllocationStrategy</code> used.
     * Batch will automatically choose the instance size.
     * <p>
     * Default: - the instances Batch considers will be used (currently C4, M4, and R4)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InstanceClass> getInstanceClasses() {
        return null;
    }

    /**
     * The execution Role that instances launched by this Compute Environment will use.
     * <p>
     * Default: - a role will be created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getInstanceRole() {
        return null;
    }

    /**
     * The instance types that this Compute Environment can launch.
     * <p>
     * Which one is chosen depends on the <code>AllocationStrategy</code> used.
     * <p>
     * Default: - the instances Batch considers will be used (currently C4, M4, and R4)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
        return null;
    }

    /**
     * The Launch Template that this Compute Environment will use to provision EC2 Instances.
     * <p>
     * <em>Note</em>: if <code>securityGroups</code> is specified on both your
     * launch template and this Compute Environment, <strong>the
     * <code>securityGroup</code>s on the Compute Environment override the
     * ones on the launch template.</strong>
     * <p>
     * Default: - no launch template
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
        return null;
    }

    /**
     * The minimum vCPUs that an environment should maintain, even if the compute environment is DISABLED.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMinvCpus() {
        return null;
    }

    /**
     * The EC2 placement group to associate with your compute resources.
     * <p>
     * If you intend to submit multi-node parallel jobs to this Compute Environment,
     * you should consider creating a cluster placement group and associate it with your compute resources.
     * This keeps your multi-node parallel job on a logical grouping of instances
     * within a single Availability Zone with high network flow potential.
     * <p>
     * Default: - no placement group
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
        return null;
    }

    /**
     * The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
     * <p>
     * For example, if your maximum percentage is 20%, the Spot price must be
     * less than 20% of the current On-Demand price for that Instance.
     * You always pay the lowest market price and never more than your maximum percentage.
     * For most use cases, Batch recommends leaving this field empty.
     * <p>
     * Implies <code>spot == true</code> if set
     * <p>
     * Default: - 100%
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getSpotBidPercentage() {
        return null;
    }

    /**
     * Whether or not to use batch's optimal instance type.
     * <p>
     * The optimal instance type is equivalent to adding the
     * C4, M4, and R4 instance classes. You can specify other instance classes
     * (of the same architecture) in addition to the optimal instance classes.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUseOptimalInstanceClasses() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ManagedEc2EksComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedEc2EksComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedEc2EksComputeEnvironmentProps> {
        software.amazon.awscdk.services.eks.ICluster eksCluster;
        java.lang.String kubernetesNamespace;
        software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy;
        java.util.List<software.amazon.awscdk.services.batch.EksMachineImage> images;
        java.util.List<software.amazon.awscdk.services.ec2.InstanceClass> instanceClasses;
        software.amazon.awscdk.services.iam.IRole instanceRole;
        java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        java.lang.Number minvCpus;
        software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        java.lang.Number spotBidPercentage;
        java.lang.Boolean useOptimalInstanceClasses;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Number maxvCpus;
        java.lang.Boolean replaceComputeEnvironment;
        java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        java.lang.Boolean spot;
        java.lang.Boolean terminateOnUpdate;
        software.amazon.awscdk.Duration updateTimeout;
        java.lang.Boolean updateToLatestImageVersion;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        java.lang.String computeEnvironmentName;
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getEksCluster}
         * @param eksCluster The cluster that backs this Compute Environment. Required for Compute Environments running Kubernetes jobs. This parameter is required.
         *                   Please ensure that you have followed the steps at
         *                   <p>
         *                   https://docs.aws.amazon.com/batch/latest/userguide/getting-started-eks.html
         *                   <p>
         *                   before attempting to deploy a <code>ManagedEc2EksComputeEnvironment</code> that uses this cluster.
         *                   If you do not follow the steps in the link, the deployment fail with a message that the
         *                   compute environment did not stabilize.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eksCluster(software.amazon.awscdk.services.eks.ICluster eksCluster) {
            this.eksCluster = eksCluster;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getKubernetesNamespace}
         * @param kubernetesNamespace The namespace of the Cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kubernetesNamespace(java.lang.String kubernetesNamespace) {
            this.kubernetesNamespace = kubernetesNamespace;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getAllocationStrategy}
         * @param allocationStrategy The allocation strategy to use if not enough instances of the best fitting instance type can be allocated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allocationStrategy(software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy) {
            this.allocationStrategy = allocationStrategy;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getImages}
         * @param images Configure which AMIs this Compute Environment can launch.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder images(java.util.List<? extends software.amazon.awscdk.services.batch.EksMachineImage> images) {
            this.images = (java.util.List<software.amazon.awscdk.services.batch.EksMachineImage>)images;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getInstanceClasses}
         * @param instanceClasses The instance types that this Compute Environment can launch.
         *                        Which one is chosen depends on the <code>AllocationStrategy</code> used.
         *                        Batch will automatically choose the instance size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder instanceClasses(java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceClass> instanceClasses) {
            this.instanceClasses = (java.util.List<software.amazon.awscdk.services.ec2.InstanceClass>)instanceClasses;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getInstanceRole}
         * @param instanceRole The execution Role that instances launched by this Compute Environment will use.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceRole(software.amazon.awscdk.services.iam.IRole instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getInstanceTypes}
         * @param instanceTypes The instance types that this Compute Environment can launch.
         *                      Which one is chosen depends on the <code>AllocationStrategy</code> used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder instanceTypes(java.util.List<? extends software.amazon.awscdk.services.ec2.InstanceType> instanceTypes) {
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)instanceTypes;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getLaunchTemplate}
         * @param launchTemplate The Launch Template that this Compute Environment will use to provision EC2 Instances.
         *                       <em>Note</em>: if <code>securityGroups</code> is specified on both your
         *                       launch template and this Compute Environment, <strong>the
         *                       <code>securityGroup</code>s on the Compute Environment override the
         *                       ones on the launch template.</strong>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchTemplate(software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getMinvCpus}
         * @param minvCpus The minimum vCPUs that an environment should maintain, even if the compute environment is DISABLED.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minvCpus(java.lang.Number minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getPlacementGroup}
         * @param placementGroup The EC2 placement group to associate with your compute resources.
         *                       If you intend to submit multi-node parallel jobs to this Compute Environment,
         *                       you should consider creating a cluster placement group and associate it with your compute resources.
         *                       This keeps your multi-node parallel job on a logical grouping of instances
         *                       within a single Availability Zone with high network flow potential.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getSpotBidPercentage}
         * @param spotBidPercentage The maximum percentage that a Spot Instance price can be when compared with the On-Demand price for that instance type before instances are launched.
         *                          For example, if your maximum percentage is 20%, the Spot price must be
         *                          less than 20% of the current On-Demand price for that Instance.
         *                          You always pay the lowest market price and never more than your maximum percentage.
         *                          For most use cases, Batch recommends leaving this field empty.
         *                          <p>
         *                          Implies <code>spot == true</code> if set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spotBidPercentage(java.lang.Number spotBidPercentage) {
            this.spotBidPercentage = spotBidPercentage;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getUseOptimalInstanceClasses}
         * @param useOptimalInstanceClasses Whether or not to use batch's optimal instance type.
         *                                  The optimal instance type is equivalent to adding the
         *                                  C4, M4, and R4 instance classes. You can specify other instance classes
         *                                  (of the same architecture) in addition to the optimal instance classes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder useOptimalInstanceClasses(java.lang.Boolean useOptimalInstanceClasses) {
            this.useOptimalInstanceClasses = useOptimalInstanceClasses;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getVpc}
         * @param vpc VPC in which this Compute Environment will launch Instances. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getMaxvCpus}
         * @param maxvCpus The maximum vCpus this <code>ManagedComputeEnvironment</code> can scale up to. Each vCPU is equivalent to 1024 CPU shares.
         *                 <em>Note</em>: if this Compute Environment uses EC2 resources (not Fargate) with either <code>AllocationStrategy.BEST_FIT_PROGRESSIVE</code> or
         *                 <code>AllocationStrategy.SPOT_CAPACITY_OPTIMIZED</code>, or <code>AllocationStrategy.BEST_FIT</code> with Spot instances,
         *                 The scheduler may exceed this number by at most one of the instances specified in <code>instanceTypes</code>
         *                 or <code>instanceClasses</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxvCpus(java.lang.Number maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getReplaceComputeEnvironment}
         * @param replaceComputeEnvironment Specifies whether this Compute Environment is replaced if an update is made that requires replacing its instances.
         *                                  To enable more properties to be updated,
         *                                  set this property to <code>false</code>. When changing the value of this property to false,
         *                                  do not change any other properties at the same time.
         *                                  If other properties are changed at the same time,
         *                                  and the change needs to be rolled back but it can't,
         *                                  it's possible for the stack to go into the UPDATE_ROLLBACK_FAILED state.
         *                                  You can't update a stack that is in the UPDATE_ROLLBACK_FAILED state.
         *                                  However, if you can continue to roll it back,
         *                                  you can return the stack to its original settings and then try to update it again.
         *                                  <p>
         *                                  The properties which require a replacement of the Compute Environment are:
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replaceComputeEnvironment(java.lang.Boolean replaceComputeEnvironment) {
            this.replaceComputeEnvironment = replaceComputeEnvironment;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getSecurityGroups}
         * @param securityGroups The security groups this Compute Environment will launch instances in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder securityGroups(java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)securityGroups;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getSpot}
         * @param spot Whether or not to use spot instances.
         *             Spot instances are less expensive EC2 instances that can be
         *             reclaimed by EC2 at any time; your job will be given two minutes
         *             of notice before reclamation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder spot(java.lang.Boolean spot) {
            this.spot = spot;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getTerminateOnUpdate}
         * @param terminateOnUpdate Whether or not any running jobs will be immediately terminated when an infrastructure update occurs.
         *                          If this is enabled, any terminated jobs may be retried, depending on the job's
         *                          retry policy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder terminateOnUpdate(java.lang.Boolean terminateOnUpdate) {
            this.terminateOnUpdate = terminateOnUpdate;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getUpdateTimeout}
         * @param updateTimeout Only meaningful if <code>terminateOnUpdate</code> is <code>false</code>.
         *                      If so,
         *                      when an infrastructure update is triggered, any running jobs
         *                      will be allowed to run until <code>updateTimeout</code> has expired.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateTimeout(software.amazon.awscdk.Duration updateTimeout) {
            this.updateTimeout = updateTimeout;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getUpdateToLatestImageVersion}
         * @param updateToLatestImageVersion Whether or not the AMI is updated to the latest one supported by Batch when an infrastructure update occurs.
         *                                   If you specify a specific AMI, this property will be ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateToLatestImageVersion(java.lang.Boolean updateToLatestImageVersion) {
            this.updateToLatestImageVersion = updateToLatestImageVersion;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getVpcSubnets}
         * @param vpcSubnets The VPC Subnets this Compute Environment will launch instances in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName The name of the ComputeEnvironment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getEnabled}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue.
         *                Enabled ComputeEnvironments can accept jobs from a Queue and
         *                can scale instances up or down.
         *                Disabled ComputeEnvironments cannot accept jobs from a Queue or
         *                scale instances up or down.
         *                <p>
         *                If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         *                Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         *                be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         *                <p>
         *                To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link ManagedEc2EksComputeEnvironmentProps#getServiceRole}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedEc2EksComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedEc2EksComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedEc2EksComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedEc2EksComputeEnvironmentProps {
        private final software.amazon.awscdk.services.eks.ICluster eksCluster;
        private final java.lang.String kubernetesNamespace;
        private final software.amazon.awscdk.services.batch.AllocationStrategy allocationStrategy;
        private final java.util.List<software.amazon.awscdk.services.batch.EksMachineImage> images;
        private final java.util.List<software.amazon.awscdk.services.ec2.InstanceClass> instanceClasses;
        private final software.amazon.awscdk.services.iam.IRole instanceRole;
        private final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> instanceTypes;
        private final software.amazon.awscdk.services.ec2.ILaunchTemplate launchTemplate;
        private final java.lang.Number minvCpus;
        private final software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        private final java.lang.Number spotBidPercentage;
        private final java.lang.Boolean useOptimalInstanceClasses;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Number maxvCpus;
        private final java.lang.Boolean replaceComputeEnvironment;
        private final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups;
        private final java.lang.Boolean spot;
        private final java.lang.Boolean terminateOnUpdate;
        private final software.amazon.awscdk.Duration updateTimeout;
        private final java.lang.Boolean updateToLatestImageVersion;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;
        private final java.lang.String computeEnvironmentName;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.eksCluster = software.amazon.jsii.Kernel.get(this, "eksCluster", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.eks.ICluster.class));
            this.kubernetesNamespace = software.amazon.jsii.Kernel.get(this, "kubernetesNamespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.allocationStrategy = software.amazon.jsii.Kernel.get(this, "allocationStrategy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.AllocationStrategy.class));
            this.images = software.amazon.jsii.Kernel.get(this, "images", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.EksMachineImage.class)));
            this.instanceClasses = software.amazon.jsii.Kernel.get(this, "instanceClasses", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceClass.class)));
            this.instanceRole = software.amazon.jsii.Kernel.get(this, "instanceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.instanceTypes = software.amazon.jsii.Kernel.get(this, "instanceTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class)));
            this.launchTemplate = software.amazon.jsii.Kernel.get(this, "launchTemplate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ILaunchTemplate.class));
            this.minvCpus = software.amazon.jsii.Kernel.get(this, "minvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPlacementGroup.class));
            this.spotBidPercentage = software.amazon.jsii.Kernel.get(this, "spotBidPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.useOptimalInstanceClasses = software.amazon.jsii.Kernel.get(this, "useOptimalInstanceClasses", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.maxvCpus = software.amazon.jsii.Kernel.get(this, "maxvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.replaceComputeEnvironment = software.amazon.jsii.Kernel.get(this, "replaceComputeEnvironment", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class)));
            this.spot = software.amazon.jsii.Kernel.get(this, "spot", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.terminateOnUpdate = software.amazon.jsii.Kernel.get(this, "terminateOnUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.updateTimeout = software.amazon.jsii.Kernel.get(this, "updateTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.updateToLatestImageVersion = software.amazon.jsii.Kernel.get(this, "updateToLatestImageVersion", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.eksCluster = java.util.Objects.requireNonNull(builder.eksCluster, "eksCluster is required");
            this.kubernetesNamespace = java.util.Objects.requireNonNull(builder.kubernetesNamespace, "kubernetesNamespace is required");
            this.allocationStrategy = builder.allocationStrategy;
            this.images = (java.util.List<software.amazon.awscdk.services.batch.EksMachineImage>)builder.images;
            this.instanceClasses = (java.util.List<software.amazon.awscdk.services.ec2.InstanceClass>)builder.instanceClasses;
            this.instanceRole = builder.instanceRole;
            this.instanceTypes = (java.util.List<software.amazon.awscdk.services.ec2.InstanceType>)builder.instanceTypes;
            this.launchTemplate = builder.launchTemplate;
            this.minvCpus = builder.minvCpus;
            this.placementGroup = builder.placementGroup;
            this.spotBidPercentage = builder.spotBidPercentage;
            this.useOptimalInstanceClasses = builder.useOptimalInstanceClasses;
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.maxvCpus = builder.maxvCpus;
            this.replaceComputeEnvironment = builder.replaceComputeEnvironment;
            this.securityGroups = (java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup>)builder.securityGroups;
            this.spot = builder.spot;
            this.terminateOnUpdate = builder.terminateOnUpdate;
            this.updateTimeout = builder.updateTimeout;
            this.updateToLatestImageVersion = builder.updateToLatestImageVersion;
            this.vpcSubnets = builder.vpcSubnets;
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.enabled = builder.enabled;
            this.serviceRole = builder.serviceRole;
        }

        @Override
        public final software.amazon.awscdk.services.eks.ICluster getEksCluster() {
            return this.eksCluster;
        }

        @Override
        public final java.lang.String getKubernetesNamespace() {
            return this.kubernetesNamespace;
        }

        @Override
        public final software.amazon.awscdk.services.batch.AllocationStrategy getAllocationStrategy() {
            return this.allocationStrategy;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.batch.EksMachineImage> getImages() {
            return this.images;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InstanceClass> getInstanceClasses() {
            return this.instanceClasses;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.InstanceType> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ILaunchTemplate getLaunchTemplate() {
            return this.launchTemplate;
        }

        @Override
        public final java.lang.Number getMinvCpus() {
            return this.minvCpus;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final java.lang.Number getSpotBidPercentage() {
            return this.spotBidPercentage;
        }

        @Override
        public final java.lang.Boolean getUseOptimalInstanceClasses() {
            return this.useOptimalInstanceClasses;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Number getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final java.lang.Boolean getReplaceComputeEnvironment() {
            return this.replaceComputeEnvironment;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.ISecurityGroup> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final java.lang.Boolean getSpot() {
            return this.spot;
        }

        @Override
        public final java.lang.Boolean getTerminateOnUpdate() {
            return this.terminateOnUpdate;
        }

        @Override
        public final software.amazon.awscdk.Duration getUpdateTimeout() {
            return this.updateTimeout;
        }

        @Override
        public final java.lang.Boolean getUpdateToLatestImageVersion() {
            return this.updateToLatestImageVersion;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("eksCluster", om.valueToTree(this.getEksCluster()));
            data.set("kubernetesNamespace", om.valueToTree(this.getKubernetesNamespace()));
            if (this.getAllocationStrategy() != null) {
                data.set("allocationStrategy", om.valueToTree(this.getAllocationStrategy()));
            }
            if (this.getImages() != null) {
                data.set("images", om.valueToTree(this.getImages()));
            }
            if (this.getInstanceClasses() != null) {
                data.set("instanceClasses", om.valueToTree(this.getInstanceClasses()));
            }
            if (this.getInstanceRole() != null) {
                data.set("instanceRole", om.valueToTree(this.getInstanceRole()));
            }
            if (this.getInstanceTypes() != null) {
                data.set("instanceTypes", om.valueToTree(this.getInstanceTypes()));
            }
            if (this.getLaunchTemplate() != null) {
                data.set("launchTemplate", om.valueToTree(this.getLaunchTemplate()));
            }
            if (this.getMinvCpus() != null) {
                data.set("minvCpus", om.valueToTree(this.getMinvCpus()));
            }
            if (this.getPlacementGroup() != null) {
                data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
            }
            if (this.getSpotBidPercentage() != null) {
                data.set("spotBidPercentage", om.valueToTree(this.getSpotBidPercentage()));
            }
            if (this.getUseOptimalInstanceClasses() != null) {
                data.set("useOptimalInstanceClasses", om.valueToTree(this.getUseOptimalInstanceClasses()));
            }
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getMaxvCpus() != null) {
                data.set("maxvCpus", om.valueToTree(this.getMaxvCpus()));
            }
            if (this.getReplaceComputeEnvironment() != null) {
                data.set("replaceComputeEnvironment", om.valueToTree(this.getReplaceComputeEnvironment()));
            }
            if (this.getSecurityGroups() != null) {
                data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
            }
            if (this.getSpot() != null) {
                data.set("spot", om.valueToTree(this.getSpot()));
            }
            if (this.getTerminateOnUpdate() != null) {
                data.set("terminateOnUpdate", om.valueToTree(this.getTerminateOnUpdate()));
            }
            if (this.getUpdateTimeout() != null) {
                data.set("updateTimeout", om.valueToTree(this.getUpdateTimeout()));
            }
            if (this.getUpdateToLatestImageVersion() != null) {
                data.set("updateToLatestImageVersion", om.valueToTree(this.getUpdateToLatestImageVersion()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }
            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.ManagedEc2EksComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedEc2EksComputeEnvironmentProps.Jsii$Proxy that = (ManagedEc2EksComputeEnvironmentProps.Jsii$Proxy) o;

            if (!eksCluster.equals(that.eksCluster)) return false;
            if (!kubernetesNamespace.equals(that.kubernetesNamespace)) return false;
            if (this.allocationStrategy != null ? !this.allocationStrategy.equals(that.allocationStrategy) : that.allocationStrategy != null) return false;
            if (this.images != null ? !this.images.equals(that.images) : that.images != null) return false;
            if (this.instanceClasses != null ? !this.instanceClasses.equals(that.instanceClasses) : that.instanceClasses != null) return false;
            if (this.instanceRole != null ? !this.instanceRole.equals(that.instanceRole) : that.instanceRole != null) return false;
            if (this.instanceTypes != null ? !this.instanceTypes.equals(that.instanceTypes) : that.instanceTypes != null) return false;
            if (this.launchTemplate != null ? !this.launchTemplate.equals(that.launchTemplate) : that.launchTemplate != null) return false;
            if (this.minvCpus != null ? !this.minvCpus.equals(that.minvCpus) : that.minvCpus != null) return false;
            if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
            if (this.spotBidPercentage != null ? !this.spotBidPercentage.equals(that.spotBidPercentage) : that.spotBidPercentage != null) return false;
            if (this.useOptimalInstanceClasses != null ? !this.useOptimalInstanceClasses.equals(that.useOptimalInstanceClasses) : that.useOptimalInstanceClasses != null) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.maxvCpus != null ? !this.maxvCpus.equals(that.maxvCpus) : that.maxvCpus != null) return false;
            if (this.replaceComputeEnvironment != null ? !this.replaceComputeEnvironment.equals(that.replaceComputeEnvironment) : that.replaceComputeEnvironment != null) return false;
            if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
            if (this.spot != null ? !this.spot.equals(that.spot) : that.spot != null) return false;
            if (this.terminateOnUpdate != null ? !this.terminateOnUpdate.equals(that.terminateOnUpdate) : that.terminateOnUpdate != null) return false;
            if (this.updateTimeout != null ? !this.updateTimeout.equals(that.updateTimeout) : that.updateTimeout != null) return false;
            if (this.updateToLatestImageVersion != null ? !this.updateToLatestImageVersion.equals(that.updateToLatestImageVersion) : that.updateToLatestImageVersion != null) return false;
            if (this.vpcSubnets != null ? !this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets != null) return false;
            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.serviceRole != null ? this.serviceRole.equals(that.serviceRole) : that.serviceRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.eksCluster.hashCode();
            result = 31 * result + (this.kubernetesNamespace.hashCode());
            result = 31 * result + (this.allocationStrategy != null ? this.allocationStrategy.hashCode() : 0);
            result = 31 * result + (this.images != null ? this.images.hashCode() : 0);
            result = 31 * result + (this.instanceClasses != null ? this.instanceClasses.hashCode() : 0);
            result = 31 * result + (this.instanceRole != null ? this.instanceRole.hashCode() : 0);
            result = 31 * result + (this.instanceTypes != null ? this.instanceTypes.hashCode() : 0);
            result = 31 * result + (this.launchTemplate != null ? this.launchTemplate.hashCode() : 0);
            result = 31 * result + (this.minvCpus != null ? this.minvCpus.hashCode() : 0);
            result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
            result = 31 * result + (this.spotBidPercentage != null ? this.spotBidPercentage.hashCode() : 0);
            result = 31 * result + (this.useOptimalInstanceClasses != null ? this.useOptimalInstanceClasses.hashCode() : 0);
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.maxvCpus != null ? this.maxvCpus.hashCode() : 0);
            result = 31 * result + (this.replaceComputeEnvironment != null ? this.replaceComputeEnvironment.hashCode() : 0);
            result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
            result = 31 * result + (this.spot != null ? this.spot.hashCode() : 0);
            result = 31 * result + (this.terminateOnUpdate != null ? this.terminateOnUpdate.hashCode() : 0);
            result = 31 * result + (this.updateTimeout != null ? this.updateTimeout.hashCode() : 0);
            result = 31 * result + (this.updateToLatestImageVersion != null ? this.updateToLatestImageVersion.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            result = 31 * result + (this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            return result;
        }
    }
}
