package software.amazon.awscdk.services.batch;

/**
 * Specifies the configuration of a Kubernetes secret volume.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * SecretPathVolume secretPathVolume = SecretPathVolume.Builder.create()
 *         .name("name")
 *         .secretName("secretName")
 *         // the properties below are optional
 *         .mountPath("mountPath")
 *         .optional(false)
 *         .readonly(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://kubernetes.io/docs/concepts/storage/volumes/#secret">https://kubernetes.io/docs/concepts/storage/volumes/#secret</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.304Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.SecretPathVolume")
public class SecretPathVolume extends software.amazon.awscdk.services.batch.EksVolume {

    protected SecretPathVolume(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretPathVolume(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretPathVolume(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.SecretPathVolumeOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * returns <code>true</code> if <code>x</code> is a <code>SecretPathVolume</code> and <code>false</code> otherwise.
     * <p>
     * @param x This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.Boolean isSecretPathVolume(final @org.jetbrains.annotations.NotNull java.lang.Object x) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.SecretPathVolume.class, "isSecretPathVolume", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class), new Object[] { x });
    }

    /**
     * The name of the secret.
     * <p>
     * Must be a valid DNS subdomain name.
     * <p>
     * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretName() {
        return software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the secret or the secret's keys must be defined.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getOptional() {
        return software.amazon.jsii.Kernel.get(this, "optional", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.SecretPathVolume}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.SecretPathVolume> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.batch.SecretPathVolumeOptions.Builder options;

        private Builder() {
            this.options = new software.amazon.awscdk.services.batch.SecretPathVolumeOptions.Builder();
        }

        /**
         * The name of this volume.
         * <p>
         * The name must be a valid DNS subdomain name.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
         * @param name The name of this volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.options.name(name);
            return this;
        }

        /**
         * The path on the container where the volume is mounted.
         * <p>
         * Default: - the volume is not mounted
         * <p>
         * @return {@code this}
         * @param mountPath The path on the container where the volume is mounted. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mountPath(final java.lang.String mountPath) {
            this.options.mountPath(mountPath);
            return this;
        }

        /**
         * If specified, the container has readonly access to the volume.
         * <p>
         * Otherwise, the container has read/write access.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param readonly If specified, the container has readonly access to the volume. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readonly(final java.lang.Boolean readonly) {
            this.options.readonly(readonly);
            return this;
        }

        /**
         * The name of the secret.
         * <p>
         * Must be a valid DNS subdomain name.
         * <p>
         * @return {@code this}
         * @see <a href="https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names">https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#dns-subdomain-names</a>
         * @param secretName The name of the secret. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretName(final java.lang.String secretName) {
            this.options.secretName(secretName);
            return this;
        }

        /**
         * Specifies whether the secret or the secret's keys must be defined.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param optional Specifies whether the secret or the secret's keys must be defined. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder optional(final java.lang.Boolean optional) {
            this.options.optional(optional);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.SecretPathVolume}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.SecretPathVolume build() {
            return new software.amazon.awscdk.services.batch.SecretPathVolume(
                this.options.build()
            );
        }
    }
}
