package software.amazon.awscdk.services.batch;

/**
 * Represents an UnmanagedComputeEnvironment.
 * <p>
 * Batch will not provision instances on your behalf
 * in this ComputeEvironment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.batch.*;
 * import software.amazon.awscdk.services.iam.*;
 * Role role;
 * UnmanagedComputeEnvironmentProps unmanagedComputeEnvironmentProps = UnmanagedComputeEnvironmentProps.builder()
 *         .computeEnvironmentName("computeEnvironmentName")
 *         .enabled(false)
 *         .serviceRole(role)
 *         .unmanagedvCpus(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.318Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.UnmanagedComputeEnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(UnmanagedComputeEnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UnmanagedComputeEnvironmentProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.batch.ComputeEnvironmentProps {

    /**
     * The vCPUs this Compute Environment provides. Used only by the scheduler to schedule jobs in <code>Queue</code>s that use <code>FairshareSchedulingPolicy</code>s.
     * <p>
     * <strong>If this parameter is not provided on a fairshare queue, no capacity is reserved</strong>;
     * that is, the <code>FairshareSchedulingPolicy</code> is ignored.
     * <p>
     * Default: 0
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getUnmanagedvCpus() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link UnmanagedComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UnmanagedComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<UnmanagedComputeEnvironmentProps> {
        java.lang.Number unmanagedvCpus;
        java.lang.String computeEnvironmentName;
        java.lang.Boolean enabled;
        software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Sets the value of {@link UnmanagedComputeEnvironmentProps#getUnmanagedvCpus}
         * @param unmanagedvCpus The vCPUs this Compute Environment provides. Used only by the scheduler to schedule jobs in <code>Queue</code>s that use <code>FairshareSchedulingPolicy</code>s.
         *                       <strong>If this parameter is not provided on a fairshare queue, no capacity is reserved</strong>;
         *                       that is, the <code>FairshareSchedulingPolicy</code> is ignored.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder unmanagedvCpus(java.lang.Number unmanagedvCpus) {
            this.unmanagedvCpus = unmanagedvCpus;
            return this;
        }

        /**
         * Sets the value of {@link UnmanagedComputeEnvironmentProps#getComputeEnvironmentName}
         * @param computeEnvironmentName The name of the ComputeEnvironment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironmentName(java.lang.String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        /**
         * Sets the value of {@link UnmanagedComputeEnvironmentProps#getEnabled}
         * @param enabled Whether or not this ComputeEnvironment can accept jobs from a Queue.
         *                Enabled ComputeEnvironments can accept jobs from a Queue and
         *                can scale instances up or down.
         *                Disabled ComputeEnvironments cannot accept jobs from a Queue or
         *                scale instances up or down.
         *                <p>
         *                If you change a ComputeEnvironment from enabled to disabled while it is executing jobs,
         *                Jobs in the <code>STARTED</code> or <code>RUNNING</code> states will not
         *                be interrupted. As jobs complete, the ComputeEnvironment will scale instances down to <code>minvCpus</code>.
         *                <p>
         *                To ensure you aren't billed for unused capacity, set <code>minvCpus</code> to <code>0</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link UnmanagedComputeEnvironmentProps#getServiceRole}
         * @param serviceRole The role Batch uses to perform actions on your behalf in your account, such as provision instances to run your jobs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRole(software.amazon.awscdk.services.iam.IRole serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UnmanagedComputeEnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public UnmanagedComputeEnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link UnmanagedComputeEnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UnmanagedComputeEnvironmentProps {
        private final java.lang.Number unmanagedvCpus;
        private final java.lang.String computeEnvironmentName;
        private final java.lang.Boolean enabled;
        private final software.amazon.awscdk.services.iam.IRole serviceRole;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.unmanagedvCpus = software.amazon.jsii.Kernel.get(this, "unmanagedvCpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.computeEnvironmentName = software.amazon.jsii.Kernel.get(this, "computeEnvironmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.serviceRole = software.amazon.jsii.Kernel.get(this, "serviceRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.unmanagedvCpus = builder.unmanagedvCpus;
            this.computeEnvironmentName = builder.computeEnvironmentName;
            this.enabled = builder.enabled;
            this.serviceRole = builder.serviceRole;
        }

        @Override
        public final java.lang.Number getUnmanagedvCpus() {
            return this.unmanagedvCpus;
        }

        @Override
        public final java.lang.String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final java.lang.Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getServiceRole() {
            return this.serviceRole;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getUnmanagedvCpus() != null) {
                data.set("unmanagedvCpus", om.valueToTree(this.getUnmanagedvCpus()));
            }
            if (this.getComputeEnvironmentName() != null) {
                data.set("computeEnvironmentName", om.valueToTree(this.getComputeEnvironmentName()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getServiceRole() != null) {
                data.set("serviceRole", om.valueToTree(this.getServiceRole()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_batch.UnmanagedComputeEnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UnmanagedComputeEnvironmentProps.Jsii$Proxy that = (UnmanagedComputeEnvironmentProps.Jsii$Proxy) o;

            if (this.unmanagedvCpus != null ? !this.unmanagedvCpus.equals(that.unmanagedvCpus) : that.unmanagedvCpus != null) return false;
            if (this.computeEnvironmentName != null ? !this.computeEnvironmentName.equals(that.computeEnvironmentName) : that.computeEnvironmentName != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            return this.serviceRole != null ? this.serviceRole.equals(that.serviceRole) : that.serviceRole == null;
        }

        @Override
        public final int hashCode() {
            int result = this.unmanagedvCpus != null ? this.unmanagedvCpus.hashCode() : 0;
            result = 31 * result + (this.computeEnvironmentName != null ? this.computeEnvironmentName.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.serviceRole != null ? this.serviceRole.hashCode() : 0);
            return result;
        }
    }
}
