package software.amazon.awscdk.services.certificatemanager;

/**
 * How to validate a certificate.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * HostedZone exampleCom = HostedZone.Builder.create(this, "ExampleCom")
 *         .zoneName("example.com")
 *         .build();
 * HostedZone exampleNet = HostedZone.Builder.create(this, "ExampleNet")
 *         .zoneName("example.net")
 *         .build();
 * Certificate cert = Certificate.Builder.create(this, "Certificate")
 *         .domainName("test.example.com")
 *         .subjectAlternativeNames(List.of("cool.example.com", "test.example.net"))
 *         .validation(CertificateValidation.fromDnsMultiZone(Map.of(
 *                 "test.example.com", exampleCom,
 *                 "cool.example.com", exampleCom,
 *                 "test.example.net", exampleNet)))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.392Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_certificatemanager.CertificateValidation")
public class CertificateValidation extends software.amazon.jsii.JsiiObject {

    protected CertificateValidation(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CertificateValidation(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Validate the certificate with DNS.
     * <p>
     * IMPORTANT: If <code>hostedZone</code> is not specified, DNS records must be added
     * manually and the stack will not complete creating until the records are
     * added.
     * <p>
     * @param hostedZone the hosted zone where DNS records must be created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificateValidation fromDns(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.route53.IHostedZone hostedZone) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class, "fromDns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class), new Object[] { hostedZone });
    }

    /**
     * Validate the certificate with DNS.
     * <p>
     * IMPORTANT: If <code>hostedZone</code> is not specified, DNS records must be added
     * manually and the stack will not complete creating until the records are
     * added.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificateValidation fromDns() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class, "fromDns", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class));
    }

    /**
     * Validate the certificate with automatically created DNS records in multiple Amazon Route 53 hosted zones.
     * <p>
     * @param hostedZones a map of hosted zones where DNS records must be created for the domains in the certificate. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificateValidation fromDnsMultiZone(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.route53.IHostedZone> hostedZones) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class, "fromDnsMultiZone", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class), new Object[] { java.util.Objects.requireNonNull(hostedZones, "hostedZones is required") });
    }

    /**
     * Validate the certificate with Email.
     * <p>
     * IMPORTANT: if you are creating a certificate as part of your stack, the stack
     * will not complete creating until you read and follow the instructions in the
     * email that you will receive.
     * <p>
     * ACM will send validation emails to the following addresses:
     * <p>
     * admin&#64;domain.com
     * administrator&#64;domain.com
     * hostmaster&#64;domain.com
     * postmaster&#64;domain.com
     * webmaster&#64;domain.com
     * <p>
     * For every domain that you register.
     * <p>
     * @param validationDomains a map of validation domains to use for domains in the certificate.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificateValidation fromEmail(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> validationDomains) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class, "fromEmail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class), new Object[] { validationDomains });
    }

    /**
     * Validate the certificate with Email.
     * <p>
     * IMPORTANT: if you are creating a certificate as part of your stack, the stack
     * will not complete creating until you read and follow the instructions in the
     * email that you will receive.
     * <p>
     * ACM will send validation emails to the following addresses:
     * <p>
     * admin&#64;domain.com
     * administrator&#64;domain.com
     * hostmaster&#64;domain.com
     * postmaster&#64;domain.com
     * webmaster&#64;domain.com
     * <p>
     * For every domain that you register.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificateValidation fromEmail() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class, "fromEmail", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificateValidation.class));
    }

    /**
     * The validation method.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.ValidationMethod getMethod() {
        return software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.ValidationMethod.class));
    }

    /**
     * Certification validation properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.certificatemanager.CertificationValidationProps getProps() {
        return software.amazon.jsii.Kernel.get(this, "props", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.certificatemanager.CertificationValidationProps.class));
    }
}
