package software.amazon.awscdk.services.chatbot;

/**
 * A new Slack channel configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.chatbot.*;
 * Project project;
 * SlackChannelConfiguration target = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * INotificationRule rule = project.notifyOnBuildSucceeded("NotifyOnBuildSucceeded", target);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.409Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_chatbot.SlackChannelConfiguration")
public class SlackChannelConfiguration extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.chatbot.ISlackChannelConfiguration {

    protected SlackChannelConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SlackChannelConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SlackChannelConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.chatbot.SlackChannelConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing Slack channel configuration provided an ARN.
     * <p>
     * @return a reference to the existing Slack channel configuration
     * @param scope The parent creating construct. This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param slackChannelConfigurationArn configuration ARN (i.e. arn:aws:chatbot::1234567890:chat-configuration/slack-channel/my-slack). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.chatbot.ISlackChannelConfiguration fromSlackChannelConfigurationArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String slackChannelConfigurationArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.chatbot.SlackChannelConfiguration.class, "fromSlackChannelConfigurationArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.chatbot.ISlackChannelConfiguration.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(slackChannelConfigurationArn, "slackChannelConfigurationArn is required") });
    }

    /**
     * Return the given named metric for All SlackChannelConfigurations.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAll(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.chatbot.SlackChannelConfiguration.class, "metricAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for All SlackChannelConfigurations.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricAll(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.chatbot.SlackChannelConfiguration.class, "metricAll", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Adds a SNS topic that deliver notifications to AWS Chatbot.
     * <p>
     * @param notificationTopic This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addNotificationTopic(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sns.ITopic notificationTopic) {
        software.amazon.jsii.Kernel.call(this, "addNotificationTopic", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(notificationTopic, "notificationTopic is required") });
    }

    /**
     * Adds extra permission to iam-role of Slack channel configuration.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addToRolePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        software.amazon.jsii.Kernel.call(this, "addToRolePolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Returns a target configuration for notification rule.
     * <p>
     * @param _scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codestarnotifications.NotificationRuleTargetConfig bindAsNotificationRuleTarget(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope) {
        return software.amazon.jsii.Kernel.call(this, "bindAsNotificationRuleTarget", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codestarnotifications.NotificationRuleTargetConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required") });
    }

    /**
     * Return the given named metric for this SlackChannelConfiguration.
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for this SlackChannelConfiguration.
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.Kernel.call(this, "metric", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.Metric.class), new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * The principal to grant permissions to.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IPrincipal getGrantPrincipal() {
        return software.amazon.jsii.Kernel.get(this, "grantPrincipal", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IPrincipal.class));
    }

    /**
     * The ARN of the Slack channel configuration In the form of arn:aws:chatbot:{region}:{account}:chat-configuration/slack-channel/{slackChannelName}.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSlackChannelConfigurationArn() {
        return software.amazon.jsii.Kernel.get(this, "slackChannelConfigurationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of Slack channel configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSlackChannelConfigurationName() {
        return software.amazon.jsii.Kernel.get(this, "slackChannelConfigurationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The permission role of Slack channel configuration.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.chatbot.SlackChannelConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.chatbot.SlackChannelConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.chatbot.SlackChannelConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.chatbot.SlackChannelConfigurationProps.Builder();
        }

        /**
         * The name of Slack channel configuration.
         * <p>
         * @return {@code this}
         * @param slackChannelConfigurationName The name of Slack channel configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackChannelConfigurationName(final java.lang.String slackChannelConfigurationName) {
            this.props.slackChannelConfigurationName(slackChannelConfigurationName);
            return this;
        }

        /**
         * The ID of the Slack channel.
         * <p>
         * To get the ID, open Slack, right click on the channel name in the left pane, then choose Copy Link.
         * The channel ID is the 9-character string at the end of the URL. For example, ABCBBLZZZ.
         * <p>
         * @return {@code this}
         * @param slackChannelId The ID of the Slack channel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackChannelId(final java.lang.String slackChannelId) {
            this.props.slackChannelId(slackChannelId);
            return this;
        }

        /**
         * The ID of the Slack workspace authorized with AWS Chatbot.
         * <p>
         * To get the workspace ID, you must perform the initial authorization flow with Slack in the AWS Chatbot console.
         * Then you can copy and paste the workspace ID from the console.
         * For more details, see steps 1-4 in Setting Up AWS Chatbot with Slack in the AWS Chatbot User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro">https://docs.aws.amazon.com/chatbot/latest/adminguide/setting-up.html#Setup_intro</a>
         * @param slackWorkspaceId The ID of the Slack workspace authorized with AWS Chatbot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder slackWorkspaceId(final java.lang.String slackWorkspaceId) {
            this.props.slackWorkspaceId(slackWorkspaceId);
            return this;
        }

        /**
         * A list of IAM managed policies that are applied as channel guardrails.
         * <p>
         * Default: - The AWS managed 'AdministratorAccess' policy is applied as a default if this is not set.
         * <p>
         * @return {@code this}
         * @param guardrailPolicies A list of IAM managed policies that are applied as channel guardrails. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailPolicies(final java.util.List<? extends software.amazon.awscdk.services.iam.IManagedPolicy> guardrailPolicies) {
            this.props.guardrailPolicies(guardrailPolicies);
            return this;
        }

        /**
         * Specifies the logging level for this configuration.
         * <p>
         * This property affects the log entries pushed to Amazon CloudWatch Logs.
         * <p>
         * Default: LoggingLevel.NONE
         * <p>
         * @return {@code this}
         * @param loggingLevel Specifies the logging level for this configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(final software.amazon.awscdk.services.chatbot.LoggingLevel loggingLevel) {
            this.props.loggingLevel(loggingLevel);
            return this;
        }

        /**
         * The number of days log events are kept in CloudWatch Logs.
         * <p>
         * When updating
         * this property, unsetting it doesn't remove the log retention policy. To
         * remove the retention policy, set the value to <code>INFINITE</code>.
         * <p>
         * Default: logs.RetentionDays.INFINITE
         * <p>
         * @return {@code this}
         * @param logRetention The number of days log events are kept in CloudWatch Logs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(final software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.props.logRetention(logRetention);
            return this;
        }

        /**
         * When log retention is specified, a custom resource attempts to create the CloudWatch log group.
         * <p>
         * These options control the retry policy when interacting with CloudWatch APIs.
         * <p>
         * Default: - Default AWS SDK retry options.
         * <p>
         * @return {@code this}
         * @param logRetentionRetryOptions When log retention is specified, a custom resource attempts to create the CloudWatch log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRetryOptions(final software.amazon.awscdk.services.logs.LogRetentionRetryOptions logRetentionRetryOptions) {
            this.props.logRetentionRetryOptions(logRetentionRetryOptions);
            return this;
        }

        /**
         * The IAM role for the Lambda function associated with the custom resource that sets the retention policy.
         * <p>
         * Default: - A new role is created.
         * <p>
         * @return {@code this}
         * @param logRetentionRole The IAM role for the Lambda function associated with the custom resource that sets the retention policy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetentionRole(final software.amazon.awscdk.services.iam.IRole logRetentionRole) {
            this.props.logRetentionRole(logRetentionRole);
            return this;
        }

        /**
         * The SNS topics that deliver notifications to AWS Chatbot.
         * <p>
         * Default: None
         * <p>
         * @return {@code this}
         * @param notificationTopics The SNS topics that deliver notifications to AWS Chatbot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationTopics(final java.util.List<? extends software.amazon.awscdk.services.sns.ITopic> notificationTopics) {
            this.props.notificationTopics(notificationTopics);
            return this;
        }

        /**
         * The permission role of Slack channel configuration.
         * <p>
         * Default: - A role will be created.
         * <p>
         * @return {@code this}
         * @param role The permission role of Slack channel configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.chatbot.SlackChannelConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.chatbot.SlackChannelConfiguration build() {
            return new software.amazon.awscdk.services.chatbot.SlackChannelConfiguration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
