package software.amazon.awscdk.services.cloudfront.origins;

/**
 * An Origin for an HTTP server or S3 bucket configured for website hosting.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Validating signed URLs or signed cookies with Trusted Key Groups
 * // public key in PEM format
 * String publicKey;
 * PublicKey pubKey = PublicKey.Builder.create(this, "MyPubKey")
 *         .encodedKey(publicKey)
 *         .build();
 * KeyGroup keyGroup = KeyGroup.Builder.create(this, "MyKeyGroup")
 *         .items(List.of(pubKey))
 *         .build();
 * Distribution.Builder.create(this, "Dist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(new HttpOrigin("www.example.com"))
 *                 .trustedKeyGroups(List.of(keyGroup))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.706Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.HttpOrigin")
public class HttpOrigin extends software.amazon.awscdk.services.cloudfront.OriginBase {

    protected HttpOrigin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpOrigin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param domainName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpOrigin(final @org.jetbrains.annotations.NotNull java.lang.String domainName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required"), props });
    }

    /**
     * @param domainName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpOrigin(final @org.jetbrains.annotations.NotNull java.lang.String domainName) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(domainName, "domainName is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty renderCustomOriginConfig() {
        return software.amazon.jsii.Kernel.call(this, "renderCustomOriginConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.origins.HttpOrigin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.origins.HttpOrigin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param domainName This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String domainName) {
            return new Builder(domainName);
        }

        private final java.lang.String domainName;
        private software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder props;

        private Builder(final java.lang.String domainName) {
            this.domainName = domainName;
        }

        /**
         * The number of times that CloudFront attempts to connect to the origin;
         * <p>
         * valid values are 1, 2, or 3 attempts.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param connectionAttempts The number of times that CloudFront attempts to connect to the origin;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionAttempts(final java.lang.Number connectionAttempts) {
            this.props().connectionAttempts(connectionAttempts);
            return this;
        }

        /**
         * The number of seconds that CloudFront waits when trying to establish a connection to the origin.
         * <p>
         * Valid values are 1-10 seconds, inclusive.
         * <p>
         * Default: Duration.seconds(10)
         * <p>
         * @return {@code this}
         * @param connectionTimeout The number of seconds that CloudFront waits when trying to establish a connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionTimeout(final software.amazon.awscdk.Duration connectionTimeout) {
            this.props().connectionTimeout(connectionTimeout);
            return this;
        }

        /**
         * A list of HTTP header names and values that CloudFront adds to requests it sends to the origin.
         * <p>
         * Default: {}
         * <p>
         * @return {@code this}
         * @param customHeaders A list of HTTP header names and values that CloudFront adds to requests it sends to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customHeaders(final java.util.Map<java.lang.String, java.lang.String> customHeaders) {
            this.props().customHeaders(customHeaders);
            return this;
        }

        /**
         * A unique identifier for the origin.
         * <p>
         * This value must be unique within the distribution.
         * <p>
         * Default: - an originid will be generated for you
         * <p>
         * @return {@code this}
         * @param originId A unique identifier for the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originId(final java.lang.String originId) {
            this.props().originId(originId);
            return this;
        }

        /**
         * Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable Origin Shield again you must set this flag to false.
         * <p>
         * Default: - true
         * <p>
         * @return {@code this}
         * @param originShieldEnabled Origin Shield is enabled by setting originShieldRegion to a valid region, after this to disable Origin Shield again you must set this flag to false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldEnabled(final java.lang.Boolean originShieldEnabled) {
            this.props().originShieldEnabled(originShieldEnabled);
            return this;
        }

        /**
         * When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance.
         * <p>
         * Default: - origin shield not enabled
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html</a>
         * @param originShieldRegion When you enable Origin Shield in the AWS Region that has the lowest latency to your origin, you can get better network performance. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originShieldRegion(final java.lang.String originShieldRegion) {
            this.props().originShieldRegion(originShieldRegion);
            return this;
        }

        /**
         * An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin.
         * <p>
         * Must begin, but not end, with '/' (e.g., '/production/images').
         * <p>
         * Default: '/'
         * <p>
         * @return {@code this}
         * @param originPath An optional path that CloudFront appends to the origin domain name when CloudFront requests content from the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originPath(final java.lang.String originPath) {
            this.props().originPath(originPath);
            return this;
        }

        /**
         * The HTTP port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 80
         * <p>
         * @return {@code this}
         * @param httpPort The HTTP port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpPort(final java.lang.Number httpPort) {
            this.props().httpPort(httpPort);
            return this;
        }

        /**
         * The HTTPS port that CloudFront uses to connect to the origin.
         * <p>
         * Default: 443
         * <p>
         * @return {@code this}
         * @param httpsPort The HTTPS port that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder httpsPort(final java.lang.Number httpsPort) {
            this.props().httpsPort(httpsPort);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront persists its connection to the origin.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(5)
         * <p>
         * @return {@code this}
         * @param keepaliveTimeout Specifies how long, in seconds, CloudFront persists its connection to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keepaliveTimeout(final software.amazon.awscdk.Duration keepaliveTimeout) {
            this.props().keepaliveTimeout(keepaliveTimeout);
            return this;
        }

        /**
         * The SSL versions to use when interacting with the origin.
         * <p>
         * Default: OriginSslPolicy.TLS_V1_2
         * <p>
         * @return {@code this}
         * @param originSslProtocols The SSL versions to use when interacting with the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originSslProtocols(final java.util.List<? extends software.amazon.awscdk.services.cloudfront.OriginSslPolicy> originSslProtocols) {
            this.props().originSslProtocols(originSslProtocols);
            return this;
        }

        /**
         * Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin.
         * <p>
         * Default: OriginProtocolPolicy.HTTPS_ONLY
         * <p>
         * @return {@code this}
         * @param protocolPolicy Specifies the protocol (HTTP or HTTPS) that CloudFront uses to connect to the origin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocolPolicy(final software.amazon.awscdk.services.cloudfront.OriginProtocolPolicy protocolPolicy) {
            this.props().protocolPolicy(protocolPolicy);
            return this;
        }

        /**
         * Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout.
         * <p>
         * The valid range is from 1 to 180 seconds, inclusive.
         * <p>
         * Note that values over 60 seconds are possible only after a limit increase request for the origin response timeout quota
         * has been approved in the target account; otherwise, values over 60 seconds will produce an error at deploy time.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param readTimeout Specifies how long, in seconds, CloudFront waits for a response from the origin, also known as the origin response timeout. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readTimeout(final software.amazon.awscdk.Duration readTimeout) {
            this.props().readTimeout(readTimeout);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.origins.HttpOrigin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.origins.HttpOrigin build() {
            return new software.amazon.awscdk.services.cloudfront.origins.HttpOrigin(
                this.domainName,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.origins.HttpOriginProps.Builder();
            }
            return this.props;
        }
    }
}
