package software.amazon.awscdk.services.cloudwatch;

/**
 * A widget that contains other widgets in a vertical column.
 * <p>
 * Widgets will be laid out next to each other
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IWidget widgetA;
 * IWidget widgetB;
 * new Column(widgetA, widgetB);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.825Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.Column")
public class Column extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.cloudwatch.IWidget {

    protected Column(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Column(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param widgets This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Column(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IWidget... widgets) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.Arrays.<Object>stream(widgets).toArray(Object[]::new));
    }

    /**
     * Add the widget to this container.
     * <p>
     * @param w This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addWidget(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.IWidget w) {
        software.amazon.jsii.Kernel.call(this, "addWidget", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(w, "w is required") });
    }

    /**
     * Place the widget at a given position.
     * <p>
     * @param x This parameter is required.
     * @param y This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void position(final @org.jetbrains.annotations.NotNull java.lang.Number x, final @org.jetbrains.annotations.NotNull java.lang.Number y) {
        software.amazon.jsii.Kernel.call(this, "position", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(x, "x is required"), java.util.Objects.requireNonNull(y, "y is required") });
    }

    /**
     * Return the widget JSON for use in the dashboard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> toJson() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "toJson", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The amount of vertical grid units the widget will take up.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getHeight() {
        return software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * List of contained widgets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cloudwatch.IWidget> getWidgets() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "widgets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudwatch.IWidget.class))));
    }

    /**
     * The amount of horizontal grid units the widget will take up.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getWidth() {
        return software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }
}
