package software.amazon.awscdk.services.cloudwatch;

/**
 * The properties for a CustomWidget.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Dashboard dashboard;
 * // Import or create a lambda function
 * IFunction fn = Function.fromFunctionArn(dashboard, "Function", "arn:aws:lambda:us-east-1:123456789012:function:MyFn");
 * dashboard.addWidgets(CustomWidget.Builder.create()
 *         .functionArn(fn.getFunctionArn())
 *         .title("My lambda baked widget")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.830Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CustomWidgetProps")
@software.amazon.jsii.Jsii.Proxy(CustomWidgetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomWidgetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Arn of the AWS Lambda function that returns HTML or JSON that will be displayed in the widget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionArn();

    /**
     * The title of the widget.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTitle();

    /**
     * Height of the widget.
     * <p>
     * Default: - 6 for Alarm and Graph widgets.
     * 3 for single value widgets where most recent value of a metric is displayed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getHeight() {
        return null;
    }

    /**
     * Parameters passed to the lambda function.
     * <p>
     * Default: - no parameters are passed to the lambda function
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getParams() {
        return null;
    }

    /**
     * Update the widget on refresh.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateOnRefresh() {
        return null;
    }

    /**
     * Update the widget on resize.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateOnResize() {
        return null;
    }

    /**
     * Update the widget on time range change.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUpdateOnTimeRangeChange() {
        return null;
    }

    /**
     * Width of the widget, in a grid of 24 units wide.
     * <p>
     * Default: 6
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getWidth() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomWidgetProps> {
        java.lang.String functionArn;
        java.lang.String title;
        java.lang.Number height;
        java.lang.Object params;
        java.lang.Boolean updateOnRefresh;
        java.lang.Boolean updateOnResize;
        java.lang.Boolean updateOnTimeRangeChange;
        java.lang.Number width;

        /**
         * Sets the value of {@link CustomWidgetProps#getFunctionArn}
         * @param functionArn The Arn of the AWS Lambda function that returns HTML or JSON that will be displayed in the widget. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionArn(java.lang.String functionArn) {
            this.functionArn = functionArn;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getTitle}
         * @param title The title of the widget. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder title(java.lang.String title) {
            this.title = title;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getHeight}
         * @param height Height of the widget.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder height(java.lang.Number height) {
            this.height = height;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getParams}
         * @param params Parameters passed to the lambda function.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder params(java.lang.Object params) {
            this.params = params;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getUpdateOnRefresh}
         * @param updateOnRefresh Update the widget on refresh.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnRefresh(java.lang.Boolean updateOnRefresh) {
            this.updateOnRefresh = updateOnRefresh;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getUpdateOnResize}
         * @param updateOnResize Update the widget on resize.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnResize(java.lang.Boolean updateOnResize) {
            this.updateOnResize = updateOnResize;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getUpdateOnTimeRangeChange}
         * @param updateOnTimeRangeChange Update the widget on time range change.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder updateOnTimeRangeChange(java.lang.Boolean updateOnTimeRangeChange) {
            this.updateOnTimeRangeChange = updateOnTimeRangeChange;
            return this;
        }

        /**
         * Sets the value of {@link CustomWidgetProps#getWidth}
         * @param width Width of the widget, in a grid of 24 units wide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder width(java.lang.Number width) {
            this.width = width;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomWidgetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomWidgetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomWidgetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomWidgetProps {
        private final java.lang.String functionArn;
        private final java.lang.String title;
        private final java.lang.Number height;
        private final java.lang.Object params;
        private final java.lang.Boolean updateOnRefresh;
        private final java.lang.Boolean updateOnResize;
        private final java.lang.Boolean updateOnTimeRangeChange;
        private final java.lang.Number width;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionArn = software.amazon.jsii.Kernel.get(this, "functionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.title = software.amazon.jsii.Kernel.get(this, "title", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.height = software.amazon.jsii.Kernel.get(this, "height", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.params = software.amazon.jsii.Kernel.get(this, "params", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.updateOnRefresh = software.amazon.jsii.Kernel.get(this, "updateOnRefresh", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.updateOnResize = software.amazon.jsii.Kernel.get(this, "updateOnResize", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.updateOnTimeRangeChange = software.amazon.jsii.Kernel.get(this, "updateOnTimeRangeChange", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.width = software.amazon.jsii.Kernel.get(this, "width", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionArn = java.util.Objects.requireNonNull(builder.functionArn, "functionArn is required");
            this.title = java.util.Objects.requireNonNull(builder.title, "title is required");
            this.height = builder.height;
            this.params = builder.params;
            this.updateOnRefresh = builder.updateOnRefresh;
            this.updateOnResize = builder.updateOnResize;
            this.updateOnTimeRangeChange = builder.updateOnTimeRangeChange;
            this.width = builder.width;
        }

        @Override
        public final java.lang.String getFunctionArn() {
            return this.functionArn;
        }

        @Override
        public final java.lang.String getTitle() {
            return this.title;
        }

        @Override
        public final java.lang.Number getHeight() {
            return this.height;
        }

        @Override
        public final java.lang.Object getParams() {
            return this.params;
        }

        @Override
        public final java.lang.Boolean getUpdateOnRefresh() {
            return this.updateOnRefresh;
        }

        @Override
        public final java.lang.Boolean getUpdateOnResize() {
            return this.updateOnResize;
        }

        @Override
        public final java.lang.Boolean getUpdateOnTimeRangeChange() {
            return this.updateOnTimeRangeChange;
        }

        @Override
        public final java.lang.Number getWidth() {
            return this.width;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionArn", om.valueToTree(this.getFunctionArn()));
            data.set("title", om.valueToTree(this.getTitle()));
            if (this.getHeight() != null) {
                data.set("height", om.valueToTree(this.getHeight()));
            }
            if (this.getParams() != null) {
                data.set("params", om.valueToTree(this.getParams()));
            }
            if (this.getUpdateOnRefresh() != null) {
                data.set("updateOnRefresh", om.valueToTree(this.getUpdateOnRefresh()));
            }
            if (this.getUpdateOnResize() != null) {
                data.set("updateOnResize", om.valueToTree(this.getUpdateOnResize()));
            }
            if (this.getUpdateOnTimeRangeChange() != null) {
                data.set("updateOnTimeRangeChange", om.valueToTree(this.getUpdateOnTimeRangeChange()));
            }
            if (this.getWidth() != null) {
                data.set("width", om.valueToTree(this.getWidth()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.CustomWidgetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomWidgetProps.Jsii$Proxy that = (CustomWidgetProps.Jsii$Proxy) o;

            if (!functionArn.equals(that.functionArn)) return false;
            if (!title.equals(that.title)) return false;
            if (this.height != null ? !this.height.equals(that.height) : that.height != null) return false;
            if (this.params != null ? !this.params.equals(that.params) : that.params != null) return false;
            if (this.updateOnRefresh != null ? !this.updateOnRefresh.equals(that.updateOnRefresh) : that.updateOnRefresh != null) return false;
            if (this.updateOnResize != null ? !this.updateOnResize.equals(that.updateOnResize) : that.updateOnResize != null) return false;
            if (this.updateOnTimeRangeChange != null ? !this.updateOnTimeRangeChange.equals(that.updateOnTimeRangeChange) : that.updateOnTimeRangeChange != null) return false;
            return this.width != null ? this.width.equals(that.width) : that.width == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionArn.hashCode();
            result = 31 * result + (this.title.hashCode());
            result = 31 * result + (this.height != null ? this.height.hashCode() : 0);
            result = 31 * result + (this.params != null ? this.params.hashCode() : 0);
            result = 31 * result + (this.updateOnRefresh != null ? this.updateOnRefresh.hashCode() : 0);
            result = 31 * result + (this.updateOnResize != null ? this.updateOnResize.hashCode() : 0);
            result = 31 * result + (this.updateOnTimeRangeChange != null ? this.updateOnTimeRangeChange.hashCode() : 0);
            result = 31 * result + (this.width != null ? this.width.hashCode() : 0);
            return result;
        }
    }
}
