package software.amazon.awscdk.services.codebuild;

/**
 * The extra options passed to the <code>IProject.bindToCodePipeline</code> method.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.s3.*;
 * Bucket bucket;
 * BindToCodePipelineOptions bindToCodePipelineOptions = BindToCodePipelineOptions.builder()
 *         .artifactBucket(bucket)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.908Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.BindToCodePipelineOptions")
@software.amazon.jsii.Jsii.Proxy(BindToCodePipelineOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BindToCodePipelineOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The artifact bucket that will be used by the action that invokes this project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.s3.IBucket getArtifactBucket();

    /**
     * @return a {@link Builder} of {@link BindToCodePipelineOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BindToCodePipelineOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BindToCodePipelineOptions> {
        software.amazon.awscdk.services.s3.IBucket artifactBucket;

        /**
         * Sets the value of {@link BindToCodePipelineOptions#getArtifactBucket}
         * @param artifactBucket The artifact bucket that will be used by the action that invokes this project. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBucket(software.amazon.awscdk.services.s3.IBucket artifactBucket) {
            this.artifactBucket = artifactBucket;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BindToCodePipelineOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BindToCodePipelineOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BindToCodePipelineOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BindToCodePipelineOptions {
        private final software.amazon.awscdk.services.s3.IBucket artifactBucket;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactBucket = software.amazon.jsii.Kernel.get(this, "artifactBucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactBucket = java.util.Objects.requireNonNull(builder.artifactBucket, "artifactBucket is required");
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getArtifactBucket() {
            return this.artifactBucket;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactBucket", om.valueToTree(this.getArtifactBucket()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codebuild.BindToCodePipelineOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BindToCodePipelineOptions.Jsii$Proxy that = (BindToCodePipelineOptions.Jsii$Proxy) o;

            return this.artifactBucket.equals(that.artifactBucket);
        }

        @Override
        public final int hashCode() {
            int result = this.artifactBucket.hashCode();
            return result;
        }
    }
}
