package software.amazon.awscdk.services.codebuild;

/**
 * Build machine compute type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * SecurityGroup mySecurityGroup;
 * CodeBuildStep.Builder.create("Synth")
 *         // ...standard ShellStep props...
 *         .commands(List.of())
 *         .env(Map.of())
 *         // If you are using a CodeBuildStep explicitly, set the 'cdk.out' directory
 *         // to be the synth step's output.
 *         .primaryOutputDirectory("cdk.out")
 *         // Control the name of the project
 *         .projectName("MyProject")
 *         // Control parts of the BuildSpec other than the regular 'build' and 'install' commands
 *         .partialBuildSpec(BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         // Control the build environment
 *         .buildEnvironment(BuildEnvironment.builder()
 *                 .computeType(ComputeType.LARGE)
 *                 .privileged(true)
 *                 .build())
 *         .timeout(Duration.minutes(90))
 *         .fileSystemLocations(List.of(FileSystemLocation.efs(EfsFileSystemLocationProps.builder()
 *                 .identifier("myidentifier2")
 *                 .location("myclodation.mydnsroot.com:/loc")
 *                 .mountPoint("/media")
 *                 .mountOptions("opts")
 *                 .build())))
 *         // Control Elastic Network Interface creation
 *         .vpc(vpc)
 *         .subnetSelection(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .securityGroups(List.of(mySecurityGroup))
 *         // Control caching
 *         .cache(Cache.bucket(new Bucket(this, "Cache")))
 *         // Additional policy statements for the execution role
 *         .rolePolicyStatements(List.of(
 *             PolicyStatement.Builder.create().build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:20.967Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codebuild.ComputeType")
public enum ComputeType {
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SMALL,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEDIUM,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LARGE,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X_LARGE,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2_LARGE,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_1GB,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_2GB,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_4GB,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_8GB,
    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LAMBDA_10GB,
}
