package software.amazon.awscdk.services.codecommit;

/**
 * Fields of CloudWatch Events that change references.
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type">https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/EventTypes.html#codebuild_event_type</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:21.023Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codecommit.ReferenceEvent")
public class ReferenceEvent extends software.amazon.jsii.JsiiObject {

    protected ReferenceEvent(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReferenceEvent(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Commit id this reference now points to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getCommitId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "commitId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of reference event.
     * <p>
     * 'referenceCreated', 'referenceUpdated' or 'referenceDeleted'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getEventType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "eventType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Full reference name.
     * <p>
     * For example, 'refs/tags/myTag'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceFullName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceFullName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of reference changed (branch or tag name).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Type of reference changed.
     * <p>
     * 'branch' or 'tag'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getReferenceType() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "referenceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Id of the CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRepositoryId() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "repositoryId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Name of the CodeCommit repository.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull java.lang.String getRepositoryName() {
        return software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codecommit.ReferenceEvent.class, "repositoryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
