package software.amazon.awscdk.services.cognito;

/**
 * Represents an identity provider that integrates with Apple.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cognito.*;
 * ProviderAttribute providerAttribute;
 * UserPool userPool;
 * UserPoolIdentityProviderApple userPoolIdentityProviderApple = UserPoolIdentityProviderApple.Builder.create(this, "MyUserPoolIdentityProviderApple")
 *         .clientId("clientId")
 *         .keyId("keyId")
 *         .privateKey("privateKey")
 *         .teamId("teamId")
 *         .userPool(userPool)
 *         // the properties below are optional
 *         .attributeMapping(AttributeMapping.builder()
 *                 .address(providerAttribute)
 *                 .birthdate(providerAttribute)
 *                 .custom(Map.of(
 *                         "customKey", providerAttribute))
 *                 .email(providerAttribute)
 *                 .familyName(providerAttribute)
 *                 .fullname(providerAttribute)
 *                 .gender(providerAttribute)
 *                 .givenName(providerAttribute)
 *                 .lastUpdateTime(providerAttribute)
 *                 .locale(providerAttribute)
 *                 .middleName(providerAttribute)
 *                 .nickname(providerAttribute)
 *                 .phoneNumber(providerAttribute)
 *                 .preferredUsername(providerAttribute)
 *                 .profilePage(providerAttribute)
 *                 .profilePicture(providerAttribute)
 *                 .timezone(providerAttribute)
 *                 .website(providerAttribute)
 *                 .build())
 *         .scopes(List.of("scopes"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:21.453Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.UserPoolIdentityProviderApple")
public class UserPoolIdentityProviderApple extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cognito.IUserPoolIdentityProvider {

    protected UserPoolIdentityProviderApple(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected UserPoolIdentityProviderApple(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public UserPoolIdentityProviderApple(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAppleProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Object configureAttributeMapping() {
        return software.amazon.jsii.Kernel.call(this, "configureAttributeMapping", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The primary identifier of this identity provider.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getProviderName() {
        return software.amazon.jsii.Kernel.get(this, "providerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderApple}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cognito.UserPoolIdentityProviderApple> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAppleProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderAppleProps.Builder();
        }

        /**
         * The user pool to which this construct provides identities.
         * <p>
         * @return {@code this}
         * @param userPool The user pool to which this construct provides identities. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userPool(final software.amazon.awscdk.services.cognito.IUserPool userPool) {
            this.props.userPool(userPool);
            return this;
        }

        /**
         * Mapping attributes from the identity provider to standard and custom attributes of the user pool.
         * <p>
         * Default: - no attribute mapping
         * <p>
         * @return {@code this}
         * @param attributeMapping Mapping attributes from the identity provider to standard and custom attributes of the user pool. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeMapping(final software.amazon.awscdk.services.cognito.AttributeMapping attributeMapping) {
            this.props.attributeMapping(attributeMapping);
            return this;
        }

        /**
         * The client id recognized by Apple APIs.
         * <p>
         * @return {@code this}
         * @see <a href="https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230948-clientid">https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230948-clientid</a>
         * @param clientId The client id recognized by Apple APIs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientId(final java.lang.String clientId) {
            this.props.clientId(clientId);
            return this;
        }

        /**
         * The keyId (of the same key, which content has to be later supplied as <code>privateKey</code>) for Apple APIs to authenticate the client.
         * <p>
         * @return {@code this}
         * @param keyId The keyId (of the same key, which content has to be later supplied as <code>privateKey</code>) for Apple APIs to authenticate the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyId(final java.lang.String keyId) {
            this.props.keyId(keyId);
            return this;
        }

        /**
         * The privateKey content for Apple APIs to authenticate the client.
         * <p>
         * @return {@code this}
         * @param privateKey The privateKey content for Apple APIs to authenticate the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateKey(final java.lang.String privateKey) {
            this.props.privateKey(privateKey);
            return this;
        }

        /**
         * The teamId for Apple APIs to authenticate the client.
         * <p>
         * @return {@code this}
         * @param teamId The teamId for Apple APIs to authenticate the client. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder teamId(final java.lang.String teamId) {
            this.props.teamId(teamId);
            return this;
        }

        /**
         * The list of apple permissions to obtain for getting access to the apple profile.
         * <p>
         * Default: [ name ]
         * <p>
         * @return {@code this}
         * @see <a href="https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230955-scope">https://developer.apple.com/documentation/sign_in_with_apple/clientconfigi/3230955-scope</a>
         * @param scopes The list of apple permissions to obtain for getting access to the apple profile. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scopes(final java.util.List<java.lang.String> scopes) {
            this.props.scopes(scopes);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cognito.UserPoolIdentityProviderApple}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cognito.UserPoolIdentityProviderApple build() {
            return new software.amazon.awscdk.services.cognito.UserPoolIdentityProviderApple(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
