package software.amazon.awscdk.services.dynamodb;

/**
 * Properties for defining a <code>CfnGlobalTable</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.dynamodb.*;
 * Object policyDocument;
 * CfnGlobalTableProps cfnGlobalTableProps = CfnGlobalTableProps.builder()
 *         .attributeDefinitions(List.of(AttributeDefinitionProperty.builder()
 *                 .attributeName("attributeName")
 *                 .attributeType("attributeType")
 *                 .build()))
 *         .keySchema(List.of(KeySchemaProperty.builder()
 *                 .attributeName("attributeName")
 *                 .keyType("keyType")
 *                 .build()))
 *         .replicas(List.of(ReplicaSpecificationProperty.builder()
 *                 .region("region")
 *                 // the properties below are optional
 *                 .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .deletionProtectionEnabled(false)
 *                 .globalSecondaryIndexes(List.of(ReplicaGlobalSecondaryIndexSpecificationProperty.builder()
 *                         .indexName("indexName")
 *                         // the properties below are optional
 *                         .contributorInsightsSpecification(ContributorInsightsSpecificationProperty.builder()
 *                                 .enabled(false)
 *                                 .build())
 *                         .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
 *                                 .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                         .maxCapacity(123)
 *                                         .minCapacity(123)
 *                                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                                 .targetValue(123)
 *                                                 // the properties below are optional
 *                                                 .disableScaleIn(false)
 *                                                 .scaleInCooldown(123)
 *                                                 .scaleOutCooldown(123)
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .seedCapacity(123)
 *                                         .build())
 *                                 .readCapacityUnits(123)
 *                                 .build())
 *                         .build()))
 *                 .kinesisStreamSpecification(KinesisStreamSpecificationProperty.builder()
 *                         .streamArn("streamArn")
 *                         // the properties below are optional
 *                         .approximateCreationDateTimePrecision("approximateCreationDateTimePrecision")
 *                         .build())
 *                 .pointInTimeRecoverySpecification(PointInTimeRecoverySpecificationProperty.builder()
 *                         .pointInTimeRecoveryEnabled(false)
 *                         .build())
 *                 .readProvisionedThroughputSettings(ReadProvisionedThroughputSettingsProperty.builder()
 *                         .readCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                 .maxCapacity(123)
 *                                 .minCapacity(123)
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .seedCapacity(123)
 *                                 .build())
 *                         .readCapacityUnits(123)
 *                         .build())
 *                 .replicaStreamSpecification(ReplicaStreamSpecificationProperty.builder()
 *                         .resourcePolicy(ResourcePolicyProperty.builder()
 *                                 .policyDocument(policyDocument)
 *                                 .build())
 *                         .build())
 *                 .resourcePolicy(ResourcePolicyProperty.builder()
 *                         .policyDocument(policyDocument)
 *                         .build())
 *                 .sseSpecification(ReplicaSSESpecificationProperty.builder()
 *                         .kmsMasterKeyId("kmsMasterKeyId")
 *                         .build())
 *                 .tableClass("tableClass")
 *                 .tags(List.of(CfnTag.builder()
 *                         .key("key")
 *                         .value("value")
 *                         .build()))
 *                 .build()))
 *         // the properties below are optional
 *         .billingMode("billingMode")
 *         .globalSecondaryIndexes(List.of(GlobalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 // the properties below are optional
 *                 .writeProvisionedThroughputSettings(WriteProvisionedThroughputSettingsProperty.builder()
 *                         .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                                 .maxCapacity(123)
 *                                 .minCapacity(123)
 *                                 .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                         .targetValue(123)
 *                                         // the properties below are optional
 *                                         .disableScaleIn(false)
 *                                         .scaleInCooldown(123)
 *                                         .scaleOutCooldown(123)
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .seedCapacity(123)
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .localSecondaryIndexes(List.of(LocalSecondaryIndexProperty.builder()
 *                 .indexName("indexName")
 *                 .keySchema(List.of(KeySchemaProperty.builder()
 *                         .attributeName("attributeName")
 *                         .keyType("keyType")
 *                         .build()))
 *                 .projection(ProjectionProperty.builder()
 *                         .nonKeyAttributes(List.of("nonKeyAttributes"))
 *                         .projectionType("projectionType")
 *                         .build())
 *                 .build()))
 *         .sseSpecification(SSESpecificationProperty.builder()
 *                 .sseEnabled(false)
 *                 // the properties below are optional
 *                 .sseType("sseType")
 *                 .build())
 *         .streamSpecification(StreamSpecificationProperty.builder()
 *                 .streamViewType("streamViewType")
 *                 .build())
 *         .tableName("tableName")
 *         .timeToLiveSpecification(TimeToLiveSpecificationProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .attributeName("attributeName")
 *                 .build())
 *         .writeProvisionedThroughputSettings(WriteProvisionedThroughputSettingsProperty.builder()
 *                 .writeCapacityAutoScalingSettings(CapacityAutoScalingSettingsProperty.builder()
 *                         .maxCapacity(123)
 *                         .minCapacity(123)
 *                         .targetTrackingScalingPolicyConfiguration(TargetTrackingScalingPolicyConfigurationProperty.builder()
 *                                 .targetValue(123)
 *                                 // the properties below are optional
 *                                 .disableScaleIn(false)
 *                                 .scaleInCooldown(123)
 *                                 .scaleOutCooldown(123)
 *                                 .build())
 *                         // the properties below are optional
 *                         .seedCapacity(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:22.159Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.CfnGlobalTableProps")
@software.amazon.jsii.Jsii.Proxy(CfnGlobalTableProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGlobalTableProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of attributes that describe the key schema for the global table and indexes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-attributedefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getAttributeDefinitions();

    /**
     * Specifies the attributes that make up the primary key for the table.
     * <p>
     * The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-keyschema</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKeySchema();

    /**
     * Specifies the list of replicas for your global table.
     * <p>
     * The list must contain at least one element, the region where the stack defining the global table is deployed. For example, if you define your table in a stack deployed to us-east-1, you must have an entry in <code>Replicas</code> with the region us-east-1. You cannot remove the replica in the stack region.
     * <p>
     * <blockquote>
     * <p>
     * Adding a replica might take a few minutes for an empty table, or up to several hours for large tables. If you want to add or remove a replica, we recommend submitting an <code>UpdateStack</code> operation containing only that change.
     * <p>
     * If you add or delete a replica during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new replica, you might need to manually delete the replica.
     * <p>
     * </blockquote>
     * <p>
     * You can create a new global table with as many replicas as needed. You can add or remove replicas after table creation, but you can only add or remove a single replica in each update.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getReplicas();

    /**
     * Specifies how you are charged for read and write throughput and how you manage capacity. Valid values are:.
     * <p>
     * <ul>
     * <li><code>PAY_PER_REQUEST</code></li>
     * <li><code>PROVISIONED</code></li>
     * </ul>
     * <p>
     * All replicas in your global table will have the same billing mode. If you use <code>PROVISIONED</code> billing mode, you must provide an auto scaling configuration via the <code>WriteProvisionedThroughputSettings</code> property. The default value of this property is <code>PROVISIONED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-billingmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingMode() {
        return null;
    }

    /**
     * Global secondary indexes to be created on the global table.
     * <p>
     * You can create up to 20 global secondary indexes. Each replica in your global table will have the same global secondary index settings. You can only create or delete one global secondary index in a single stack operation.
     * <p>
     * Since the backfilling of an index could take a long time, CloudFormation does not wait for the index to become active. If a stack operation rolls back, CloudFormation might not delete an index that has been added. In that case, you will need to delete the index manually.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-globalsecondaryindexes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGlobalSecondaryIndexes() {
        return null;
    }

    /**
     * Local secondary indexes to be created on the table.
     * <p>
     * You can create up to five local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes. Each replica in your global table will have the same local secondary index settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-localsecondaryindexes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLocalSecondaryIndexes() {
        return null;
    }

    /**
     * Specifies the settings to enable server-side encryption.
     * <p>
     * These settings will be applied to all replicas. If you plan to use customer-managed KMS keys, you must provide a key for each replica using the <code>ReplicaSpecification.ReplicaSSESpecification</code> property.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-ssespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSseSpecification() {
        return null;
    }

    /**
     * Specifies the streams settings on your global table.
     * <p>
     * You must provide a value for this property if your global table contains more than one replica. You can only change the streams settings if your global table has only one replica.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-streamspecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getStreamSpecification() {
        return null;
    }

    /**
     * A name for the global table.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID as the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-tablename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTableName() {
        return null;
    }

    /**
     * Specifies the time to live (TTL) settings for the table.
     * <p>
     * This setting will be applied to all replicas.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-timetolivespecification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTimeToLiveSpecification() {
        return null;
    }

    /**
     * Specifies an auto scaling policy for write capacity.
     * <p>
     * This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-writeprovisionedthroughputsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWriteProvisionedThroughputSettings() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGlobalTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGlobalTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGlobalTableProps> {
        java.lang.Object attributeDefinitions;
        java.lang.Object keySchema;
        java.lang.Object replicas;
        java.lang.String billingMode;
        java.lang.Object globalSecondaryIndexes;
        java.lang.Object localSecondaryIndexes;
        java.lang.Object sseSpecification;
        java.lang.Object streamSpecification;
        java.lang.String tableName;
        java.lang.Object timeToLiveSpecification;
        java.lang.Object writeProvisionedThroughputSettings;

        /**
         * Sets the value of {@link CfnGlobalTableProps#getAttributeDefinitions}
         * @param attributeDefinitions A list of attributes that describe the key schema for the global table and indexes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(software.amazon.awscdk.IResolvable attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getAttributeDefinitions}
         * @param attributeDefinitions A list of attributes that describe the key schema for the global table and indexes. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attributeDefinitions(java.util.List<? extends java.lang.Object> attributeDefinitions) {
            this.attributeDefinitions = attributeDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getKeySchema}
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         *                  The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(software.amazon.awscdk.IResolvable keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getKeySchema}
         * @param keySchema Specifies the attributes that make up the primary key for the table. This parameter is required.
         *                  The attributes in the <code>KeySchema</code> property must also be defined in the <code>AttributeDefinitions</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keySchema(java.util.List<? extends java.lang.Object> keySchema) {
            this.keySchema = keySchema;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getReplicas}
         * @param replicas Specifies the list of replicas for your global table. This parameter is required.
         *                 The list must contain at least one element, the region where the stack defining the global table is deployed. For example, if you define your table in a stack deployed to us-east-1, you must have an entry in <code>Replicas</code> with the region us-east-1. You cannot remove the replica in the stack region.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Adding a replica might take a few minutes for an empty table, or up to several hours for large tables. If you want to add or remove a replica, we recommend submitting an <code>UpdateStack</code> operation containing only that change.
         *                 <p>
         *                 If you add or delete a replica during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new replica, you might need to manually delete the replica.
         *                 <p>
         *                 </blockquote>
         *                 <p>
         *                 You can create a new global table with as many replicas as needed. You can add or remove replicas after table creation, but you can only add or remove a single replica in each update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(software.amazon.awscdk.IResolvable replicas) {
            this.replicas = replicas;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getReplicas}
         * @param replicas Specifies the list of replicas for your global table. This parameter is required.
         *                 The list must contain at least one element, the region where the stack defining the global table is deployed. For example, if you define your table in a stack deployed to us-east-1, you must have an entry in <code>Replicas</code> with the region us-east-1. You cannot remove the replica in the stack region.
         *                 <p>
         *                 <blockquote>
         *                 <p>
         *                 Adding a replica might take a few minutes for an empty table, or up to several hours for large tables. If you want to add or remove a replica, we recommend submitting an <code>UpdateStack</code> operation containing only that change.
         *                 <p>
         *                 If you add or delete a replica during an update, we recommend that you don't update any other resources. If your stack fails to update and is rolled back while adding a new replica, you might need to manually delete the replica.
         *                 <p>
         *                 </blockquote>
         *                 <p>
         *                 You can create a new global table with as many replicas as needed. You can add or remove replicas after table creation, but you can only add or remove a single replica in each update.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicas(java.util.List<? extends java.lang.Object> replicas) {
            this.replicas = replicas;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getBillingMode}
         * @param billingMode Specifies how you are charged for read and write throughput and how you manage capacity. Valid values are:.
         *                    <ul>
         *                    <li><code>PAY_PER_REQUEST</code></li>
         *                    <li><code>PROVISIONED</code></li>
         *                    </ul>
         *                    <p>
         *                    All replicas in your global table will have the same billing mode. If you use <code>PROVISIONED</code> billing mode, you must provide an auto scaling configuration via the <code>WriteProvisionedThroughputSettings</code> property. The default value of this property is <code>PROVISIONED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(java.lang.String billingMode) {
            this.billingMode = billingMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes Global secondary indexes to be created on the global table.
         *                               You can create up to 20 global secondary indexes. Each replica in your global table will have the same global secondary index settings. You can only create or delete one global secondary index in a single stack operation.
         *                               <p>
         *                               Since the backfilling of an index could take a long time, CloudFormation does not wait for the index to become active. If a stack operation rolls back, CloudFormation might not delete an index that has been added. In that case, you will need to delete the index manually.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(software.amazon.awscdk.IResolvable globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getGlobalSecondaryIndexes}
         * @param globalSecondaryIndexes Global secondary indexes to be created on the global table.
         *                               You can create up to 20 global secondary indexes. Each replica in your global table will have the same global secondary index settings. You can only create or delete one global secondary index in a single stack operation.
         *                               <p>
         *                               Since the backfilling of an index could take a long time, CloudFormation does not wait for the index to become active. If a stack operation rolls back, CloudFormation might not delete an index that has been added. In that case, you will need to delete the index manually.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder globalSecondaryIndexes(java.util.List<? extends java.lang.Object> globalSecondaryIndexes) {
            this.globalSecondaryIndexes = globalSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes Local secondary indexes to be created on the table.
         *                              You can create up to five local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes. Each replica in your global table will have the same local secondary index settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(software.amazon.awscdk.IResolvable localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getLocalSecondaryIndexes}
         * @param localSecondaryIndexes Local secondary indexes to be created on the table.
         *                              You can create up to five local secondary indexes. Each index is scoped to a given hash key value. The size of each hash key can be up to 10 gigabytes. Each replica in your global table will have the same local secondary index settings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localSecondaryIndexes(java.util.List<? extends java.lang.Object> localSecondaryIndexes) {
            this.localSecondaryIndexes = localSecondaryIndexes;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getSseSpecification}
         * @param sseSpecification Specifies the settings to enable server-side encryption.
         *                         These settings will be applied to all replicas. If you plan to use customer-managed KMS keys, you must provide a key for each replica using the <code>ReplicaSpecification.ReplicaSSESpecification</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.IResolvable sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getSseSpecification}
         * @param sseSpecification Specifies the settings to enable server-side encryption.
         *                         These settings will be applied to all replicas. If you plan to use customer-managed KMS keys, you must provide a key for each replica using the <code>ReplicaSpecification.ReplicaSSESpecification</code> property.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sseSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.SSESpecificationProperty sseSpecification) {
            this.sseSpecification = sseSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getStreamSpecification}
         * @param streamSpecification Specifies the streams settings on your global table.
         *                            You must provide a value for this property if your global table contains more than one replica. You can only change the streams settings if your global table has only one replica.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(software.amazon.awscdk.IResolvable streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getStreamSpecification}
         * @param streamSpecification Specifies the streams settings on your global table.
         *                            You must provide a value for this property if your global table contains more than one replica. You can only change the streams settings if your global table has only one replica.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.StreamSpecificationProperty streamSpecification) {
            this.streamSpecification = streamSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getTableName}
         * @param tableName A name for the global table.
         *                  If you don't specify a name, AWS CloudFormation generates a unique ID and uses that ID as the table name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name type</a> .
         *                  <p>
         *                  <blockquote>
         *                  <p>
         *                  If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         *                  <p>
         *                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(java.lang.String tableName) {
            this.tableName = tableName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification Specifies the time to live (TTL) settings for the table.
         *                                This setting will be applied to all replicas.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(software.amazon.awscdk.IResolvable timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getTimeToLiveSpecification}
         * @param timeToLiveSpecification Specifies the time to live (TTL) settings for the table.
         *                                This setting will be applied to all replicas.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveSpecification(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.TimeToLiveSpecificationProperty timeToLiveSpecification) {
            this.timeToLiveSpecification = timeToLiveSpecification;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getWriteProvisionedThroughputSettings}
         * @param writeProvisionedThroughputSettings Specifies an auto scaling policy for write capacity.
         *                                           This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeProvisionedThroughputSettings(software.amazon.awscdk.IResolvable writeProvisionedThroughputSettings) {
            this.writeProvisionedThroughputSettings = writeProvisionedThroughputSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnGlobalTableProps#getWriteProvisionedThroughputSettings}
         * @param writeProvisionedThroughputSettings Specifies an auto scaling policy for write capacity.
         *                                           This policy will be applied to all replicas. This setting must be specified if <code>BillingMode</code> is set to <code>PROVISIONED</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeProvisionedThroughputSettings(software.amazon.awscdk.services.dynamodb.CfnGlobalTable.WriteProvisionedThroughputSettingsProperty writeProvisionedThroughputSettings) {
            this.writeProvisionedThroughputSettings = writeProvisionedThroughputSettings;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGlobalTableProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGlobalTableProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGlobalTableProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGlobalTableProps {
        private final java.lang.Object attributeDefinitions;
        private final java.lang.Object keySchema;
        private final java.lang.Object replicas;
        private final java.lang.String billingMode;
        private final java.lang.Object globalSecondaryIndexes;
        private final java.lang.Object localSecondaryIndexes;
        private final java.lang.Object sseSpecification;
        private final java.lang.Object streamSpecification;
        private final java.lang.String tableName;
        private final java.lang.Object timeToLiveSpecification;
        private final java.lang.Object writeProvisionedThroughputSettings;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attributeDefinitions = software.amazon.jsii.Kernel.get(this, "attributeDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.keySchema = software.amazon.jsii.Kernel.get(this, "keySchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.replicas = software.amazon.jsii.Kernel.get(this, "replicas", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.billingMode = software.amazon.jsii.Kernel.get(this, "billingMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.globalSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "globalSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.localSecondaryIndexes = software.amazon.jsii.Kernel.get(this, "localSecondaryIndexes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sseSpecification = software.amazon.jsii.Kernel.get(this, "sseSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.streamSpecification = software.amazon.jsii.Kernel.get(this, "streamSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tableName = software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeToLiveSpecification = software.amazon.jsii.Kernel.get(this, "timeToLiveSpecification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.writeProvisionedThroughputSettings = software.amazon.jsii.Kernel.get(this, "writeProvisionedThroughputSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attributeDefinitions = java.util.Objects.requireNonNull(builder.attributeDefinitions, "attributeDefinitions is required");
            this.keySchema = java.util.Objects.requireNonNull(builder.keySchema, "keySchema is required");
            this.replicas = java.util.Objects.requireNonNull(builder.replicas, "replicas is required");
            this.billingMode = builder.billingMode;
            this.globalSecondaryIndexes = builder.globalSecondaryIndexes;
            this.localSecondaryIndexes = builder.localSecondaryIndexes;
            this.sseSpecification = builder.sseSpecification;
            this.streamSpecification = builder.streamSpecification;
            this.tableName = builder.tableName;
            this.timeToLiveSpecification = builder.timeToLiveSpecification;
            this.writeProvisionedThroughputSettings = builder.writeProvisionedThroughputSettings;
        }

        @Override
        public final java.lang.Object getAttributeDefinitions() {
            return this.attributeDefinitions;
        }

        @Override
        public final java.lang.Object getKeySchema() {
            return this.keySchema;
        }

        @Override
        public final java.lang.Object getReplicas() {
            return this.replicas;
        }

        @Override
        public final java.lang.String getBillingMode() {
            return this.billingMode;
        }

        @Override
        public final java.lang.Object getGlobalSecondaryIndexes() {
            return this.globalSecondaryIndexes;
        }

        @Override
        public final java.lang.Object getLocalSecondaryIndexes() {
            return this.localSecondaryIndexes;
        }

        @Override
        public final java.lang.Object getSseSpecification() {
            return this.sseSpecification;
        }

        @Override
        public final java.lang.Object getStreamSpecification() {
            return this.streamSpecification;
        }

        @Override
        public final java.lang.String getTableName() {
            return this.tableName;
        }

        @Override
        public final java.lang.Object getTimeToLiveSpecification() {
            return this.timeToLiveSpecification;
        }

        @Override
        public final java.lang.Object getWriteProvisionedThroughputSettings() {
            return this.writeProvisionedThroughputSettings;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attributeDefinitions", om.valueToTree(this.getAttributeDefinitions()));
            data.set("keySchema", om.valueToTree(this.getKeySchema()));
            data.set("replicas", om.valueToTree(this.getReplicas()));
            if (this.getBillingMode() != null) {
                data.set("billingMode", om.valueToTree(this.getBillingMode()));
            }
            if (this.getGlobalSecondaryIndexes() != null) {
                data.set("globalSecondaryIndexes", om.valueToTree(this.getGlobalSecondaryIndexes()));
            }
            if (this.getLocalSecondaryIndexes() != null) {
                data.set("localSecondaryIndexes", om.valueToTree(this.getLocalSecondaryIndexes()));
            }
            if (this.getSseSpecification() != null) {
                data.set("sseSpecification", om.valueToTree(this.getSseSpecification()));
            }
            if (this.getStreamSpecification() != null) {
                data.set("streamSpecification", om.valueToTree(this.getStreamSpecification()));
            }
            if (this.getTableName() != null) {
                data.set("tableName", om.valueToTree(this.getTableName()));
            }
            if (this.getTimeToLiveSpecification() != null) {
                data.set("timeToLiveSpecification", om.valueToTree(this.getTimeToLiveSpecification()));
            }
            if (this.getWriteProvisionedThroughputSettings() != null) {
                data.set("writeProvisionedThroughputSettings", om.valueToTree(this.getWriteProvisionedThroughputSettings()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_dynamodb.CfnGlobalTableProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGlobalTableProps.Jsii$Proxy that = (CfnGlobalTableProps.Jsii$Proxy) o;

            if (!attributeDefinitions.equals(that.attributeDefinitions)) return false;
            if (!keySchema.equals(that.keySchema)) return false;
            if (!replicas.equals(that.replicas)) return false;
            if (this.billingMode != null ? !this.billingMode.equals(that.billingMode) : that.billingMode != null) return false;
            if (this.globalSecondaryIndexes != null ? !this.globalSecondaryIndexes.equals(that.globalSecondaryIndexes) : that.globalSecondaryIndexes != null) return false;
            if (this.localSecondaryIndexes != null ? !this.localSecondaryIndexes.equals(that.localSecondaryIndexes) : that.localSecondaryIndexes != null) return false;
            if (this.sseSpecification != null ? !this.sseSpecification.equals(that.sseSpecification) : that.sseSpecification != null) return false;
            if (this.streamSpecification != null ? !this.streamSpecification.equals(that.streamSpecification) : that.streamSpecification != null) return false;
            if (this.tableName != null ? !this.tableName.equals(that.tableName) : that.tableName != null) return false;
            if (this.timeToLiveSpecification != null ? !this.timeToLiveSpecification.equals(that.timeToLiveSpecification) : that.timeToLiveSpecification != null) return false;
            return this.writeProvisionedThroughputSettings != null ? this.writeProvisionedThroughputSettings.equals(that.writeProvisionedThroughputSettings) : that.writeProvisionedThroughputSettings == null;
        }

        @Override
        public final int hashCode() {
            int result = this.attributeDefinitions.hashCode();
            result = 31 * result + (this.keySchema.hashCode());
            result = 31 * result + (this.replicas.hashCode());
            result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
            result = 31 * result + (this.globalSecondaryIndexes != null ? this.globalSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.localSecondaryIndexes != null ? this.localSecondaryIndexes.hashCode() : 0);
            result = 31 * result + (this.sseSpecification != null ? this.sseSpecification.hashCode() : 0);
            result = 31 * result + (this.streamSpecification != null ? this.streamSpecification.hashCode() : 0);
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.timeToLiveSpecification != null ? this.timeToLiveSpecification.hashCode() : 0);
            result = 31 * result + (this.writeProvisionedThroughputSettings != null ? this.writeProvisionedThroughputSettings.hashCode() : 0);
            return result;
        }
    }
}
