package software.amazon.awscdk.services.dynamodb;

/**
 * Provides a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.s3.*;
 * IBucket bucket;
 * App app = new App();
 * Stack stack = new Stack(app, "Stack");
 * Table.Builder.create(stack, "Table")
 *         .partitionKey(Attribute.builder()
 *                 .name("id")
 *                 .type(AttributeType.STRING)
 *                 .build())
 *         .importSource(ImportSourceSpecification.builder()
 *                 .compressionType(InputCompressionType.GZIP)
 *                 .inputFormat(InputFormat.csv(CsvOptions.builder()
 *                         .delimiter(",")
 *                         .headerList(List.of("id", "name"))
 *                         .build()))
 *                 .bucket(bucket)
 *                 .keyPrefix("prefix")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:22.200Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.Table")
public class Table extends software.amazon.awscdk.services.dynamodb.TableBase {

    protected Table(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Table(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Table(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table arn.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableArn The table's ARN. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableArn, "tableArn is required") });
    }

    /**
     * Creates a Table construct that represents an external table.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param attrs A <code>TableAttributes</code> object. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Creates a Table construct that represents an external table via table name.
     * <p>
     * @param scope The parent creating construct (usually <code>this</code>). This parameter is required.
     * @param id The construct's name. This parameter is required.
     * @param tableName The table's name. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.ITable fromTableName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String tableName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.Table.class, "fromTableName", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.ITable.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(tableName, "tableName is required") });
    }

    /**
     * Add a global secondary index of table.
     * <p>
     * @param props the property of global secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addGlobalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.GlobalSecondaryIndexProps props) {
        software.amazon.jsii.Kernel.call(this, "addGlobalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add a local secondary index of table.
     * <p>
     * @param props the property of local secondary index. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addLocalSecondaryIndex(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.LocalSecondaryIndexProps props) {
        software.amazon.jsii.Kernel.call(this, "addLocalSecondaryIndex", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexReadCapacity(final @org.jetbrains.annotations.NotNull java.lang.String indexName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleGlobalSecondaryIndexReadCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for the given GSI.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param indexName This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleGlobalSecondaryIndexWriteCapacity(final @org.jetbrains.annotations.NotNull java.lang.String indexName, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleGlobalSecondaryIndexWriteCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(indexName, "indexName is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable read capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleReadCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleReadCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Enable write capacity scaling for this table.
     * <p>
     * @return An object to configure additional AutoScaling settings for this attribute
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.IScalableTableAttribute autoScaleWriteCapacity(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.EnableScalingProps props) {
        return software.amazon.jsii.Kernel.call(this, "autoScaleWriteCapacity", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.IScalableTableAttribute.class), new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Get schema attributes of table or index.
     * <p>
     * @return Schema of table or index.
     * @param indexName
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.SchemaOptions schema(final @org.jetbrains.annotations.Nullable java.lang.String indexName) {
        return software.amazon.jsii.Kernel.call(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.SchemaOptions.class), new Object[] { indexName });
    }

    /**
     * Get schema attributes of table or index.
     * <p>
     * @return Schema of table or index.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.SchemaOptions schema() {
        return software.amazon.jsii.Kernel.call(this, "schema", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.SchemaOptions.class));
    }

    /**
     * Whether this table has indexes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getHasIndex() {
        return software.amazon.jsii.Kernel.get(this, "hasIndex", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * Arn of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableArn() {
        return software.amazon.jsii.Kernel.get(this, "tableArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Table name of the dynamodb table.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTableName() {
        return software.amazon.jsii.Kernel.get(this, "tableName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * KMS encryption key, if this table uses a customer-managed encryption key.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * ARN of the table's stream, if there is one.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTableStreamArn() {
        return software.amazon.jsii.Kernel.get(this, "tableStreamArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.dynamodb.Table}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.dynamodb.Table> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.dynamodb.TableProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.dynamodb.TableProps.Builder();
        }

        /**
         * Partition key attribute definition.
         * <p>
         * @return {@code this}
         * @param partitionKey Partition key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder partitionKey(final software.amazon.awscdk.services.dynamodb.Attribute partitionKey) {
            this.props.partitionKey(partitionKey);
            return this;
        }

        /**
         * Sort key attribute definition.
         * <p>
         * Default: no sort key
         * <p>
         * @return {@code this}
         * @param sortKey Sort key attribute definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sortKey(final software.amazon.awscdk.services.dynamodb.Attribute sortKey) {
            this.props.sortKey(sortKey);
            return this;
        }

        /**
         * Specify how you are charged for read and write throughput and how you manage capacity.
         * <p>
         * Default: PROVISIONED if `replicationRegions` is not specified, PAY_PER_REQUEST otherwise
         * <p>
         * @return {@code this}
         * @param billingMode Specify how you are charged for read and write throughput and how you manage capacity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingMode(final software.amazon.awscdk.services.dynamodb.BillingMode billingMode) {
            this.props.billingMode(billingMode);
            return this;
        }

        /**
         * Whether CloudWatch contributor insights is enabled.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param contributorInsightsEnabled Whether CloudWatch contributor insights is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contributorInsightsEnabled(final java.lang.Boolean contributorInsightsEnabled) {
            this.props.contributorInsightsEnabled(contributorInsightsEnabled);
            return this;
        }

        /**
         * Enables deletion protection for the table.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param deletionProtection Enables deletion protection for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtection(final java.lang.Boolean deletionProtection) {
            this.props.deletionProtection(deletionProtection);
            return this;
        }

        /**
         * Whether server-side encryption with an AWS managed customer master key is enabled.
         * <p>
         * This property cannot be set if <code>serverSideEncryption</code> is set.
         * <p>
         * <blockquote>
         * <p>
         * <strong>NOTE</strong>: if you set this to <code>CUSTOMER_MANAGED</code> and <code>encryptionKey</code> is not
         * specified, the key that the Tablet generates for you will be created with
         * default permissions. If you are using CDKv2, these permissions will be
         * sufficient to enable the key for use with DynamoDB tables.  If you are
         * using CDKv1, make sure the feature flag
         * <code>&#64;aws-cdk/aws-kms:defaultKeyPolicies</code> is set to <code>true</code> in your <code>cdk.json</code>.
         * <p>
         * </blockquote>
         * <p>
         * Default: - The table is encrypted with an encryption key managed by DynamoDB, and you are not charged any fee for using it.
         * <p>
         * @return {@code this}
         * @param encryption Whether server-side encryption with an AWS managed customer master key is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryption(final software.amazon.awscdk.services.dynamodb.TableEncryption encryption) {
            this.props.encryption(encryption);
            return this;
        }

        /**
         * External KMS key to use for table encryption.
         * <p>
         * This property can only be set if <code>encryption</code> is set to <code>TableEncryption.CUSTOMER_MANAGED</code>.
         * <p>
         * Default: - If `encryption` is set to `TableEncryption.CUSTOMER_MANAGED` and this
         * property is undefined, a new KMS key will be created and associated with this table.
         * If `encryption` and this property are both undefined, then the table is encrypted with
         * an encryption key managed by DynamoDB, and you are not charged any fee for using it.
         * <p>
         * @return {@code this}
         * @param encryptionKey External KMS key to use for table encryption. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKey(final software.amazon.awscdk.services.kms.IKey encryptionKey) {
            this.props.encryptionKey(encryptionKey);
            return this;
        }

        /**
         * The properties of data being imported from the S3 bucket source to the table.
         * <p>
         * Default: - no data import from the S3 bucket
         * <p>
         * @return {@code this}
         * @param importSource The properties of data being imported from the S3 bucket source to the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder importSource(final software.amazon.awscdk.services.dynamodb.ImportSourceSpecification importSource) {
            this.props.importSource(importSource);
            return this;
        }

        /**
         * Whether point-in-time recovery is enabled.
         * <p>
         * Default: - point-in-time recovery is disabled
         * <p>
         * @return {@code this}
         * @param pointInTimeRecovery Whether point-in-time recovery is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pointInTimeRecovery(final java.lang.Boolean pointInTimeRecovery) {
            this.props.pointInTimeRecovery(pointInTimeRecovery);
            return this;
        }

        /**
         * The read capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param readCapacity The read capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder readCapacity(final java.lang.Number readCapacity) {
            this.props.readCapacity(readCapacity);
            return this;
        }

        /**
         * The removal policy to apply to the DynamoDB Table.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy The removal policy to apply to the DynamoDB Table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.props.removalPolicy(removalPolicy);
            return this;
        }

        /**
         * Regions where replica tables will be created.
         * <p>
         * Default: - no replica tables are created
         * <p>
         * @return {@code this}
         * @param replicationRegions Regions where replica tables will be created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationRegions(final java.util.List<java.lang.String> replicationRegions) {
            this.props.replicationRegions(replicationRegions);
            return this;
        }

        /**
         * The timeout for a table replication operation in a single region.
         * <p>
         * Default: Duration.minutes(30)
         * <p>
         * @return {@code this}
         * @param replicationTimeout The timeout for a table replication operation in a single region. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder replicationTimeout(final software.amazon.awscdk.Duration replicationTimeout) {
            this.props.replicationTimeout(replicationTimeout);
            return this;
        }

        /**
         * When an item in the table is modified, StreamViewType determines what information is written to the stream for this table.
         * <p>
         * Default: - streams are disabled unless `replicationRegions` is specified
         * <p>
         * @return {@code this}
         * @param stream When an item in the table is modified, StreamViewType determines what information is written to the stream for this table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(final software.amazon.awscdk.services.dynamodb.StreamViewType stream) {
            this.props.stream(stream);
            return this;
        }

        /**
         * Specify the table class.
         * <p>
         * Default: STANDARD
         * <p>
         * @return {@code this}
         * @param tableClass Specify the table class. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableClass(final software.amazon.awscdk.services.dynamodb.TableClass tableClass) {
            this.props.tableClass(tableClass);
            return this;
        }

        /**
         * The name of TTL attribute.
         * <p>
         * Default: - TTL is disabled
         * <p>
         * @return {@code this}
         * @param timeToLiveAttribute The name of TTL attribute. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeToLiveAttribute(final java.lang.String timeToLiveAttribute) {
            this.props.timeToLiveAttribute(timeToLiveAttribute);
            return this;
        }

        /**
         * Indicates whether CloudFormation stack waits for replication to finish.
         * <p>
         * If set to false, the CloudFormation resource will mark the resource as
         * created and replication will be completed asynchronously. This property is
         * ignored if replicationRegions property is not set.
         * <p>
         * WARNING:
         * DO NOT UNSET this property if adding/removing multiple replicationRegions
         * in one deployment, as CloudFormation only supports one region replication
         * at a time. CDK overcomes this limitation by waiting for replication to
         * finish before starting new replicationRegion.
         * <p>
         * If the custom resource which handles replication has a physical resource
         * ID with the format <code>region</code> instead of <code>tablename-region</code> (this would happen
         * if the custom resource hasn't received an event since v1.91.0), DO NOT SET
         * this property to false without making a change to the table name.
         * This will cause the existing replicas to be deleted.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-dynamodb-globaltable.html#cfn-dynamodb-globaltable-replicas</a>
         * @param waitForReplicationToFinish Indicates whether CloudFormation stack waits for replication to finish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder waitForReplicationToFinish(final java.lang.Boolean waitForReplicationToFinish) {
            this.props.waitForReplicationToFinish(waitForReplicationToFinish);
            return this;
        }

        /**
         * The write capacity for the table.
         * <p>
         * Careful if you add Global Secondary Indexes, as
         * those will share the table's provisioned throughput.
         * <p>
         * Can only be provided if billingMode is Provisioned.
         * <p>
         * Default: 5
         * <p>
         * @return {@code this}
         * @param writeCapacity The write capacity for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder writeCapacity(final java.lang.Number writeCapacity) {
            this.props.writeCapacity(writeCapacity);
            return this;
        }

        /**
         * Kinesis Data Stream to capture item-level changes for the table.
         * <p>
         * Default: - no Kinesis Data Stream
         * <p>
         * @return {@code this}
         * @param kinesisStream Kinesis Data Stream to capture item-level changes for the table. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kinesisStream(final software.amazon.awscdk.services.kinesis.IStream kinesisStream) {
            this.props.kinesisStream(kinesisStream);
            return this;
        }

        /**
         * Enforces a particular physical table name.
         * <p>
         * Default: <generated>
         * <p>
         * @return {@code this}
         * @param tableName Enforces a particular physical table name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tableName(final java.lang.String tableName) {
            this.props.tableName(tableName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.dynamodb.Table}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.dynamodb.Table build() {
            return new software.amazon.awscdk.services.dynamodb.Table(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
