package software.amazon.awscdk.services.dynamodb;

/**
 * Represents server-side encryption for a DynamoDB table.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.services.kms.*;
 * App app = new App();
 * Stack stack = Stack.Builder.create(app, "Stack").env(Environment.builder().region("us-west-2").build()).build();
 * Key tableKey = new Key(stack, "Key");
 * Map&lt;String, String&gt; replicaKeyArns = Map.of(
 *         "us-east-1", "arn:aws:kms:us-east-1:123456789012:key/g24efbna-az9b-42ro-m3bp-cq249l94fca6",
 *         "us-east-2", "arn:aws:kms:us-east-2:123456789012:key/h90bkasj-bs1j-92wp-s2ka-bh857d60bkj8");
 * TableV2 globalTable = TableV2.Builder.create(stack, "GlobalTable")
 *         .partitionKey(Attribute.builder().name("pk").type(AttributeType.STRING).build())
 *         .encryption(TableEncryptionV2.customerManagedKey(tableKey, replicaKeyArns))
 *         .replicas(List.of(ReplicaTableProps.builder().region("us-east-1").build(), ReplicaTableProps.builder().region("us-east-2").build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:22.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_dynamodb.TableEncryptionV2")
public abstract class TableEncryptionV2 extends software.amazon.jsii.JsiiObject {

    protected TableEncryptionV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected TableEncryptionV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Configure server-side encryption using a DynamoDB owned key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableEncryptionV2 awsManagedKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class, "awsManagedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class));
    }

    /**
     * Configure server-side encryption using customer managed keys.
     * <p>
     * @param tableKey the KMS key for the primary table. This parameter is required.
     * @param replicaKeyArns an object containing the ARN of the KMS key to use for each replica table.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableEncryptionV2 customerManagedKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey tableKey, final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> replicaKeyArns) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class, "customerManagedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class), new Object[] { java.util.Objects.requireNonNull(tableKey, "tableKey is required"), replicaKeyArns });
    }

    /**
     * Configure server-side encryption using customer managed keys.
     * <p>
     * @param tableKey the KMS key for the primary table. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableEncryptionV2 customerManagedKey(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.kms.IKey tableKey) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class, "customerManagedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class), new Object[] { java.util.Objects.requireNonNull(tableKey, "tableKey is required") });
    }

    /**
     * Configure server-side encryption using a DynamoDB owned key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableEncryptionV2 dynamoOwnedKey() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class, "dynamoOwnedKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryptionV2.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.dynamodb.TableEncryption getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.dynamodb.TableEncryption.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getReplicaKeyArns() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "replicaKeyArns", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getTableKey() {
        return software.amazon.jsii.Kernel.get(this, "tableKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    private static final class Jsii$Proxy extends software.amazon.awscdk.services.dynamodb.TableEncryptionV2 {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }
    }
}
