package software.amazon.awscdk.services.ec2;

/**
 * The state of token usage for your instance metadata requests.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * LaunchTemplate.Builder.create(this, "LaunchTemplate")
 *         .httpEndpoint(true)
 *         .httpProtocolIpv6(true)
 *         .httpPutResponseHopLimit(1)
 *         .httpTokens(LaunchTemplateHttpTokens.REQUIRED)
 *         .instanceMetadataTags(true)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-launchtemplate-launchtemplatedata-metadataoptions.html#cfn-ec2-launchtemplate-launchtemplatedata-metadataoptions-httptokens</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:22.823Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.LaunchTemplateHttpTokens")
public enum LaunchTemplateHttpTokens {
    /**
     * If the state is optional, you can choose to retrieve instance metadata with or without a signed token header on your request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPTIONAL,
    /**
     * If the state is required, you must send a signed token header with any instance metadata retrieval requests.
     * <p>
     * In this state,
     * retrieving the IAM role credentials always returns the version 2.0 credentials; the version 1.0 credentials are not available.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REQUIRED,
}
