package software.amazon.awscdk.services.ec2;

/**
 * Determines how this placement group spreads instances.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:22.845Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.PlacementGroupSpreadLevel")
public enum PlacementGroupSpreadLevel {
    /**
     * Host spread level placement groups are only available with AWS Outposts.
     * <p>
     * For host spread level placement groups, there are no restrictions for running instances per Outposts.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups-outpost.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups-outpost.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HOST,
    /**
     * Each instance is launched on a separate rack.
     * <p>
     * Each has its own network and power source.
     * A rack spread placement group can span multiple Availability Zones in the same Region.
     * For rack spread level placement groups, you can have a maximum of seven running instances per Availability Zone per group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RACK,
}
