package software.amazon.awscdk.services.ecs;

/**
 * The <code>AWS::ECS::Service</code> resource creates an Amazon Elastic Container Service (Amazon ECS) service that runs and maintains the requested number of tasks and associated load balancers.
 * <p>
 * <blockquote>
 * <p>
 * The stack update fails if you change any properties that require replacement and at least one Amazon ECS Service Connect <code>ServiceConnectService</code> is configured. This is because AWS CloudFormation creates the replacement service first, but each <code>ServiceConnectService</code> must have a name that is unique in the namespace. &gt; Starting April 15, 2023, AWS ; will not onboard new customers to Amazon Elastic Inference (EI), and will help current customers migrate their workloads to options that offer better price and performance. After April 15, 2023, new customers will not be able to launch instances with Amazon EI accelerators in Amazon SageMaker, Amazon ECS , or Amazon EC2 . However, customers who have used Amazon EI at least once during the past 30-day period are considered current customers and will be able to continue using the service.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnService cfnService = CfnService.Builder.create(this, "MyCfnService")
 *         .capacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                 .base(123)
 *                 .capacityProvider("capacityProvider")
 *                 .weight(123)
 *                 .build()))
 *         .cluster("cluster")
 *         .deploymentConfiguration(DeploymentConfigurationProperty.builder()
 *                 .alarms(DeploymentAlarmsProperty.builder()
 *                         .alarmNames(List.of("alarmNames"))
 *                         .enable(false)
 *                         .rollback(false)
 *                         .build())
 *                 .deploymentCircuitBreaker(DeploymentCircuitBreakerProperty.builder()
 *                         .enable(false)
 *                         .rollback(false)
 *                         .build())
 *                 .maximumPercent(123)
 *                 .minimumHealthyPercent(123)
 *                 .build())
 *         .deploymentController(DeploymentControllerProperty.builder()
 *                 .type("type")
 *                 .build())
 *         .desiredCount(123)
 *         .enableEcsManagedTags(false)
 *         .enableExecuteCommand(false)
 *         .healthCheckGracePeriodSeconds(123)
 *         .launchType("launchType")
 *         .loadBalancers(List.of(LoadBalancerProperty.builder()
 *                 .containerName("containerName")
 *                 .containerPort(123)
 *                 .loadBalancerName("loadBalancerName")
 *                 .targetGroupArn("targetGroupArn")
 *                 .build()))
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
 *                         .assignPublicIp("assignPublicIp")
 *                         .securityGroups(List.of("securityGroups"))
 *                         .subnets(List.of("subnets"))
 *                         .build())
 *                 .build())
 *         .placementConstraints(List.of(PlacementConstraintProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .expression("expression")
 *                 .build()))
 *         .placementStrategies(List.of(PlacementStrategyProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .field("field")
 *                 .build()))
 *         .platformVersion("platformVersion")
 *         .propagateTags("propagateTags")
 *         .role("role")
 *         .schedulingStrategy("schedulingStrategy")
 *         .serviceConnectConfiguration(ServiceConnectConfigurationProperty.builder()
 *                 .enabled(false)
 *                 // the properties below are optional
 *                 .logConfiguration(LogConfigurationProperty.builder()
 *                         .logDriver("logDriver")
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .secretOptions(List.of(SecretProperty.builder()
 *                                 .name("name")
 *                                 .valueFrom("valueFrom")
 *                                 .build()))
 *                         .build())
 *                 .namespace("namespace")
 *                 .services(List.of(ServiceConnectServiceProperty.builder()
 *                         .portName("portName")
 *                         // the properties below are optional
 *                         .clientAliases(List.of(ServiceConnectClientAliasProperty.builder()
 *                                 .port(123)
 *                                 // the properties below are optional
 *                                 .dnsName("dnsName")
 *                                 .build()))
 *                         .discoveryName("discoveryName")
 *                         .ingressPortOverride(123)
 *                         .timeout(TimeoutConfigurationProperty.builder()
 *                                 .idleTimeoutSeconds(123)
 *                                 .perRequestTimeoutSeconds(123)
 *                                 .build())
 *                         .tls(ServiceConnectTlsConfigurationProperty.builder()
 *                                 .issuerCertificateAuthority(ServiceConnectTlsCertificateAuthorityProperty.builder()
 *                                         .awsPcaAuthorityArn("awsPcaAuthorityArn")
 *                                         .build())
 *                                 // the properties below are optional
 *                                 .kmsKey("kmsKey")
 *                                 .roleArn("roleArn")
 *                                 .build())
 *                         .build()))
 *                 .build())
 *         .serviceName("serviceName")
 *         .serviceRegistries(List.of(ServiceRegistryProperty.builder()
 *                 .containerName("containerName")
 *                 .containerPort(123)
 *                 .port(123)
 *                 .registryArn("registryArn")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskDefinition("taskDefinition")
 *         .volumeConfigurations(List.of(ServiceVolumeConfigurationProperty.builder()
 *                 .name("name")
 *                 // the properties below are optional
 *                 .managedEbsVolume(ServiceManagedEBSVolumeConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         // the properties below are optional
 *                         .encrypted(false)
 *                         .filesystemType("filesystemType")
 *                         .iops(123)
 *                         .kmsKeyId("kmsKeyId")
 *                         .sizeInGiB(123)
 *                         .snapshotId("snapshotId")
 *                         .tagSpecifications(List.of(EBSTagSpecificationProperty.builder()
 *                                 .resourceType("resourceType")
 *                                 // the properties below are optional
 *                                 .propagateTags("propagateTags")
 *                                 .tags(List.of(CfnTag.builder()
 *                                         .key("key")
 *                                         .value("value")
 *                                         .build()))
 *                                 .build()))
 *                         .throughput(123)
 *                         .volumeType("volumeType")
 *                         .build())
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:23.033Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService")
public class CfnService extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ecs.CfnService.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The name of the Amazon ECS service, such as <code>sample-webapp</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Not currently supported in AWS CloudFormation .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceArn() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The capacity provider strategy to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCapacityProviderStrategy() {
        return software.amazon.jsii.Kernel.get(this, "capacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The capacity provider strategy to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "capacityProviderStrategy", value);
    }

    /**
     * The capacity provider strategy to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCapacityProviderStrategy(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.CapacityProviderStrategyItemProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.CapacityProviderStrategyItemProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "capacityProviderStrategy", value);
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCluster() {
        return software.amazon.jsii.Kernel.get(this, "cluster", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCluster(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cluster", value);
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "deploymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentConfiguration", value);
    }

    /**
     * The deployment controller to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentController() {
        return software.amazon.jsii.Kernel.get(this, "deploymentController", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deployment controller to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentController(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentController", value);
    }

    /**
     * The deployment controller to use for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentController(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.DeploymentControllerProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentController", value);
    }

    /**
     * The number of instantiations of the specified task definition to place and keep running in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getDesiredCount() {
        return software.amazon.jsii.Kernel.get(this, "desiredCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of instantiations of the specified task definition to place and keep running in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDesiredCount(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "desiredCount", value);
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableEcsManagedTags() {
        return software.amazon.jsii.Kernel.get(this, "enableEcsManagedTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableEcsManagedTags(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableEcsManagedTags", value);
    }

    /**
     * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableEcsManagedTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableEcsManagedTags", value);
    }

    /**
     * Determines whether the execute command functionality is turned on for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableExecuteCommand() {
        return software.amazon.jsii.Kernel.get(this, "enableExecuteCommand", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Determines whether the execute command functionality is turned on for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableExecuteCommand(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableExecuteCommand", value);
    }

    /**
     * Determines whether the execute command functionality is turned on for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableExecuteCommand(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableExecuteCommand", value);
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getHealthCheckGracePeriodSeconds() {
        return software.amazon.jsii.Kernel.get(this, "healthCheckGracePeriodSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setHealthCheckGracePeriodSeconds(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "healthCheckGracePeriodSeconds", value);
    }

    /**
     * The launch type on which to run your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLaunchType() {
        return software.amazon.jsii.Kernel.get(this, "launchType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The launch type on which to run your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLaunchType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "launchType", value);
    }

    /**
     * A list of load balancer objects to associate with the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoadBalancers() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of load balancer objects to associate with the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loadBalancers", value);
    }

    /**
     * A list of load balancer objects to associate with the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoadBalancers(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.LoadBalancerProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "loadBalancers", value);
    }

    /**
     * The network configuration for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The network configuration for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The network configuration for the service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
        return software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * An array of placement constraint objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementConstraints(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.PlacementConstraintProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "placementConstraints", value);
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPlacementStrategies() {
        return software.amazon.jsii.Kernel.get(this, "placementStrategies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementStrategies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "placementStrategies", value);
    }

    /**
     * The placement strategy objects to use for tasks in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlacementStrategies(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.PlacementStrategyProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "placementStrategies", value);
    }

    /**
     * The platform version that your tasks in the service are running on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPlatformVersion() {
        return software.amazon.jsii.Kernel.get(this, "platformVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The platform version that your tasks in the service are running on.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPlatformVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "platformVersion", value);
    }

    /**
     * Specifies whether to propagate the tags from the task definition to the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether to propagate the tags from the task definition to the task.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropagateTags(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "propagateTags", value);
    }

    /**
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRole() {
        return software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRole(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "role", value);
    }

    /**
     * The scheduling strategy to use for the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSchedulingStrategy() {
        return software.amazon.jsii.Kernel.get(this, "schedulingStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The scheduling strategy to use for the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulingStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "schedulingStrategy", value);
    }

    /**
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceConnectConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "serviceConnectConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceConnectConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceConnectConfiguration", value);
    }

    /**
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceConnectConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.CfnService.ServiceConnectConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "serviceConnectConfiguration", value);
    }

    /**
     * The name of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServiceName() {
        return software.amazon.jsii.Kernel.get(this, "serviceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serviceName", value);
    }

    /**
     * The details of the service discovery registry to associate with this service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getServiceRegistries() {
        return software.amazon.jsii.Kernel.get(this, "serviceRegistries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The details of the service discovery registry to associate with this service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", value);
    }

    /**
     * The details of the service discovery registry to associate with this service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServiceRegistries(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.ServiceRegistryProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "serviceRegistries", value);
    }

    /**
     * The metadata that you apply to the service to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The metadata that you apply to the service to help you categorize and organize them.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The <code>family</code> and <code>revision</code> ( <code>family:revision</code> ) or full ARN of the task definition to run in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The <code>family</code> and <code>revision</code> ( <code>family:revision</code> ) or full ARN of the task definition to run in your service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTaskDefinition(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "taskDefinition", value);
    }

    /**
     * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVolumeConfigurations() {
        return software.amazon.jsii.Kernel.get(this, "volumeConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeConfigurations(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "volumeConfigurations", value);
    }

    /**
     * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVolumeConfigurations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ecs.CfnService.ServiceVolumeConfigurationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ecs.CfnService.ServiceVolumeConfigurationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "volumeConfigurations", value);
    }
    /**
     * An object representing the networking details for a task or service.
     * <p>
     * For example <code>awsvpcConfiguration={subnets=["subnet-12344321"],securityGroups=["sg-12344321"]}</code>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * AwsVpcConfigurationProperty awsVpcConfigurationProperty = AwsVpcConfigurationProperty.builder()
     *         .assignPublicIp("assignPublicIp")
     *         .securityGroups(List.of("securityGroups"))
     *         .subnets(List.of("subnets"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.AwsVpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AwsVpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AwsVpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether the task's elastic network interface receives a public IP address.
         * <p>
         * The default value is <code>DISABLED</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-assignpublicip">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-assignpublicip</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAssignPublicIp() {
            return null;
        }

        /**
         * The IDs of the security groups associated with the task or service.
         * <p>
         * If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per <code>AwsVpcConfiguration</code> .
         * <p>
         * <blockquote>
         * <p>
         * All specified security groups must be from the same VPC.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-securitygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-securitygroups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroups() {
            return null;
        }

        /**
         * The IDs of the subnets associated with the task or service.
         * <p>
         * There's a limit of 16 subnets that can be specified per <code>AwsVpcConfiguration</code> .
         * <p>
         * <blockquote>
         * <p>
         * All specified subnets must be from the same VPC.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-subnets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-awsvpcconfiguration.html#cfn-ecs-service-awsvpcconfiguration-subnets</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnets() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AwsVpcConfigurationProperty> {
            java.lang.String assignPublicIp;
            java.util.List<java.lang.String> securityGroups;
            java.util.List<java.lang.String> subnets;

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getAssignPublicIp}
             * @param assignPublicIp Whether the task's elastic network interface receives a public IP address.
             *                       The default value is <code>DISABLED</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assignPublicIp(java.lang.String assignPublicIp) {
                this.assignPublicIp = assignPublicIp;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSecurityGroups}
             * @param securityGroups The IDs of the security groups associated with the task or service.
             *                       If you don't specify a security group, the default security group for the VPC is used. There's a limit of 5 security groups that can be specified per <code>AwsVpcConfiguration</code> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       All specified security groups must be from the same VPC.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroups(java.util.List<java.lang.String> securityGroups) {
                this.securityGroups = securityGroups;
                return this;
            }

            /**
             * Sets the value of {@link AwsVpcConfigurationProperty#getSubnets}
             * @param subnets The IDs of the subnets associated with the task or service.
             *                There's a limit of 16 subnets that can be specified per <code>AwsVpcConfiguration</code> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                All specified subnets must be from the same VPC.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnets(java.util.List<java.lang.String> subnets) {
                this.subnets = subnets;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AwsVpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AwsVpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AwsVpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsVpcConfigurationProperty {
            private final java.lang.String assignPublicIp;
            private final java.util.List<java.lang.String> securityGroups;
            private final java.util.List<java.lang.String> subnets;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.assignPublicIp = software.amazon.jsii.Kernel.get(this, "assignPublicIp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.securityGroups = software.amazon.jsii.Kernel.get(this, "securityGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnets = software.amazon.jsii.Kernel.get(this, "subnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.assignPublicIp = builder.assignPublicIp;
                this.securityGroups = builder.securityGroups;
                this.subnets = builder.subnets;
            }

            @Override
            public final java.lang.String getAssignPublicIp() {
                return this.assignPublicIp;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroups() {
                return this.securityGroups;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnets() {
                return this.subnets;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAssignPublicIp() != null) {
                    data.set("assignPublicIp", om.valueToTree(this.getAssignPublicIp()));
                }
                if (this.getSecurityGroups() != null) {
                    data.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                }
                if (this.getSubnets() != null) {
                    data.set("subnets", om.valueToTree(this.getSubnets()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.AwsVpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AwsVpcConfigurationProperty.Jsii$Proxy that = (AwsVpcConfigurationProperty.Jsii$Proxy) o;

                if (this.assignPublicIp != null ? !this.assignPublicIp.equals(that.assignPublicIp) : that.assignPublicIp != null) return false;
                if (this.securityGroups != null ? !this.securityGroups.equals(that.securityGroups) : that.securityGroups != null) return false;
                return this.subnets != null ? this.subnets.equals(that.subnets) : that.subnets == null;
            }

            @Override
            public final int hashCode() {
                int result = this.assignPublicIp != null ? this.assignPublicIp.hashCode() : 0;
                result = 31 * result + (this.securityGroups != null ? this.securityGroups.hashCode() : 0);
                result = 31 * result + (this.subnets != null ? this.subnets.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details of a capacity provider strategy.
     * <p>
     * A capacity provider strategy can be set when using the <code>RunTask</code> or <code>CreateService</code> APIs or as the default capacity provider strategy for a cluster with the <code>CreateCluster</code> API.
     * <p>
     * Only capacity providers that are already associated with a cluster and have an <code>ACTIVE</code> or <code>UPDATING</code> status can be used in a capacity provider strategy. The <code>PutClusterCapacityProviders</code> API is used to associate a capacity provider with a cluster.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must already be created. New Auto Scaling group capacity providers can be created with the <code>CreateCapacityProvider</code> API operation.
     * <p>
     * To use an AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used in a capacity provider strategy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * CapacityProviderStrategyItemProperty capacityProviderStrategyItemProperty = CapacityProviderStrategyItemProperty.builder()
     *         .base(123)
     *         .capacityProvider("capacityProvider")
     *         .weight(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.CapacityProviderStrategyItemProperty")
    @software.amazon.jsii.Jsii.Proxy(CapacityProviderStrategyItemProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CapacityProviderStrategyItemProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <em>base</em> value designates how many tasks, at a minimum, to run on the specified capacity provider.
         * <p>
         * Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-base">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-base</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBase() {
            return null;
        }

        /**
         * The short name of the capacity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-capacityprovider">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-capacityprovider</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCapacityProvider() {
            return null;
        }

        /**
         * The <em>weight</em> value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
         * <p>
         * The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
         * <p>
         * If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
         * <p>
         * An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-weight">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-capacityproviderstrategyitem.html#cfn-ecs-service-capacityproviderstrategyitem-weight</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWeight() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CapacityProviderStrategyItemProperty> {
            java.lang.Number base;
            java.lang.String capacityProvider;
            java.lang.Number weight;

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getBase}
             * @param base The <em>base</em> value designates how many tasks, at a minimum, to run on the specified capacity provider.
             *             Only one capacity provider in a capacity provider strategy can have a <em>base</em> defined. If no value is specified, the default value of <code>0</code> is used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder base(java.lang.Number base) {
                this.base = base;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getCapacityProvider}
             * @param capacityProvider The short name of the capacity provider.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder capacityProvider(java.lang.String capacityProvider) {
                this.capacityProvider = capacityProvider;
                return this;
            }

            /**
             * Sets the value of {@link CapacityProviderStrategyItemProperty#getWeight}
             * @param weight The <em>weight</em> value designates the relative percentage of the total number of tasks launched that should use the specified capacity provider.
             *               The <code>weight</code> value is taken into consideration after the <code>base</code> value, if defined, is satisfied.
             *               <p>
             *               If no <code>weight</code> value is specified, the default value of <code>0</code> is used. When multiple capacity providers are specified within a capacity provider strategy, at least one of the capacity providers must have a weight value greater than zero and any capacity providers with a weight of <code>0</code> can't be used to place tasks. If you specify multiple capacity providers in a strategy that all have a weight of <code>0</code> , any <code>RunTask</code> or <code>CreateService</code> actions using the capacity provider strategy will fail.
             *               <p>
             *               An example scenario for using weights is defining a strategy that contains two capacity providers and both have a weight of <code>1</code> , then when the <code>base</code> is satisfied, the tasks will be split evenly across the two capacity providers. Using that same logic, if you specify a weight of <code>1</code> for <em>capacityProviderA</em> and a weight of <code>4</code> for <em>capacityProviderB</em> , then for every one task that's run using <em>capacityProviderA</em> , four tasks would use <em>capacityProviderB</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weight(java.lang.Number weight) {
                this.weight = weight;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CapacityProviderStrategyItemProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CapacityProviderStrategyItemProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CapacityProviderStrategyItemProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CapacityProviderStrategyItemProperty {
            private final java.lang.Number base;
            private final java.lang.String capacityProvider;
            private final java.lang.Number weight;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.base = software.amazon.jsii.Kernel.get(this, "base", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.capacityProvider = software.amazon.jsii.Kernel.get(this, "capacityProvider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.weight = software.amazon.jsii.Kernel.get(this, "weight", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.base = builder.base;
                this.capacityProvider = builder.capacityProvider;
                this.weight = builder.weight;
            }

            @Override
            public final java.lang.Number getBase() {
                return this.base;
            }

            @Override
            public final java.lang.String getCapacityProvider() {
                return this.capacityProvider;
            }

            @Override
            public final java.lang.Number getWeight() {
                return this.weight;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBase() != null) {
                    data.set("base", om.valueToTree(this.getBase()));
                }
                if (this.getCapacityProvider() != null) {
                    data.set("capacityProvider", om.valueToTree(this.getCapacityProvider()));
                }
                if (this.getWeight() != null) {
                    data.set("weight", om.valueToTree(this.getWeight()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.CapacityProviderStrategyItemProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CapacityProviderStrategyItemProperty.Jsii$Proxy that = (CapacityProviderStrategyItemProperty.Jsii$Proxy) o;

                if (this.base != null ? !this.base.equals(that.base) : that.base != null) return false;
                if (this.capacityProvider != null ? !this.capacityProvider.equals(that.capacityProvider) : that.capacityProvider != null) return false;
                return this.weight != null ? this.weight.equals(that.weight) : that.weight == null;
            }

            @Override
            public final int hashCode() {
                int result = this.base != null ? this.base.hashCode() : 0;
                result = 31 * result + (this.capacityProvider != null ? this.capacityProvider.hashCode() : 0);
                result = 31 * result + (this.weight != null ? this.weight.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * One of the methods which provide a way for you to quickly identify when a deployment has failed, and then to optionally roll back the failure to the last working deployment.
     * <p>
     * When the alarms are generated, Amazon ECS sets the service deployment to failed. Set the rollback parameter to have Amazon ECS to roll back your service to the last completed deployment after a failure.
     * <p>
     * You can only use the <code>DeploymentAlarms</code> method to detect failures when the <code>DeploymentController</code> is set to <code>ECS</code> (rolling update).
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <strong>Amazon Elastic Container Service Developer Guide</strong> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentAlarmsProperty deploymentAlarmsProperty = DeploymentAlarmsProperty.builder()
     *         .alarmNames(List.of("alarmNames"))
     *         .enable(false)
     *         .rollback(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentAlarmsProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentAlarmsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentAlarmsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more CloudWatch alarm names.
         * <p>
         * Use a "," to separate the alarms.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-alarmnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-alarmnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAlarmNames();

        /**
         * Determines whether to use the CloudWatch alarm option in the service deployment process.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-enable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-enable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnable();

        /**
         * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails.
         * <p>
         * If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-rollback">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentalarms.html#cfn-ecs-service-deploymentalarms-rollback</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRollback();

        /**
         * @return a {@link Builder} of {@link DeploymentAlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentAlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentAlarmsProperty> {
            java.util.List<java.lang.String> alarmNames;
            java.lang.Object enable;
            java.lang.Object rollback;

            /**
             * Sets the value of {@link DeploymentAlarmsProperty#getAlarmNames}
             * @param alarmNames One or more CloudWatch alarm names. This parameter is required.
             *                   Use a "," to separate the alarms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarmNames(java.util.List<java.lang.String> alarmNames) {
                this.alarmNames = alarmNames;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentAlarmsProperty#getEnable}
             * @param enable Determines whether to use the CloudWatch alarm option in the service deployment process. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentAlarmsProperty#getEnable}
             * @param enable Determines whether to use the CloudWatch alarm option in the service deployment process. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentAlarmsProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(java.lang.Boolean rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentAlarmsProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is used, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(software.amazon.awscdk.IResolvable rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentAlarmsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentAlarmsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentAlarmsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentAlarmsProperty {
            private final java.util.List<java.lang.String> alarmNames;
            private final java.lang.Object enable;
            private final java.lang.Object rollback;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarmNames = software.amazon.jsii.Kernel.get(this, "alarmNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollback = software.amazon.jsii.Kernel.get(this, "rollback", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarmNames = java.util.Objects.requireNonNull(builder.alarmNames, "alarmNames is required");
                this.enable = java.util.Objects.requireNonNull(builder.enable, "enable is required");
                this.rollback = java.util.Objects.requireNonNull(builder.rollback, "rollback is required");
            }

            @Override
            public final java.util.List<java.lang.String> getAlarmNames() {
                return this.alarmNames;
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            public final java.lang.Object getRollback() {
                return this.rollback;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("alarmNames", om.valueToTree(this.getAlarmNames()));
                data.set("enable", om.valueToTree(this.getEnable()));
                data.set("rollback", om.valueToTree(this.getRollback()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentAlarmsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentAlarmsProperty.Jsii$Proxy that = (DeploymentAlarmsProperty.Jsii$Proxy) o;

                if (!alarmNames.equals(that.alarmNames)) return false;
                if (!enable.equals(that.enable)) return false;
                return this.rollback.equals(that.rollback);
            }

            @Override
            public final int hashCode() {
                int result = this.alarmNames.hashCode();
                result = 31 * result + (this.enable.hashCode());
                result = 31 * result + (this.rollback.hashCode());
                return result;
            }
        }
    }
    /**
     * <blockquote><p>The deployment circuit breaker can only be used for services using the rolling update ( <code>ECS</code> ) deployment type.<p></blockquote>
     * <p>
     * The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If it is turned on, a service deployment will transition to a failed state and stop launching new tasks. You can also configure Amazon ECS to roll back your service to the last completed deployment after a failure. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * For more information about API failure reasons, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/api_failures_messages.html">API failure reasons</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentCircuitBreakerProperty deploymentCircuitBreakerProperty = DeploymentCircuitBreakerProperty.builder()
     *         .enable(false)
     *         .rollback(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentCircuitBreakerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentCircuitBreakerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentCircuitBreakerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Determines whether to use the deployment circuit breaker logic for the service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html#cfn-ecs-service-deploymentcircuitbreaker-enable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html#cfn-ecs-service-deploymentcircuitbreaker-enable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnable();

        /**
         * Determines whether to configure Amazon ECS to roll back the service if a service deployment fails.
         * <p>
         * If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html#cfn-ecs-service-deploymentcircuitbreaker-rollback">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcircuitbreaker.html#cfn-ecs-service-deploymentcircuitbreaker-rollback</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRollback();

        /**
         * @return a {@link Builder} of {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentCircuitBreakerProperty> {
            java.lang.Object enable;
            java.lang.Object rollback;

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getEnable}
             * @param enable Determines whether to use the deployment circuit breaker logic for the service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(java.lang.Boolean enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getEnable}
             * @param enable Determines whether to use the deployment circuit breaker logic for the service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enable(software.amazon.awscdk.IResolvable enable) {
                this.enable = enable;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(java.lang.Boolean rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentCircuitBreakerProperty#getRollback}
             * @param rollback Determines whether to configure Amazon ECS to roll back the service if a service deployment fails. This parameter is required.
             *                 If rollback is on, when a service deployment fails, the service is rolled back to the last deployment that completed successfully.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rollback(software.amazon.awscdk.IResolvable rollback) {
                this.rollback = rollback;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentCircuitBreakerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentCircuitBreakerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentCircuitBreakerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentCircuitBreakerProperty {
            private final java.lang.Object enable;
            private final java.lang.Object rollback;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enable = software.amazon.jsii.Kernel.get(this, "enable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.rollback = software.amazon.jsii.Kernel.get(this, "rollback", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enable = java.util.Objects.requireNonNull(builder.enable, "enable is required");
                this.rollback = java.util.Objects.requireNonNull(builder.rollback, "rollback is required");
            }

            @Override
            public final java.lang.Object getEnable() {
                return this.enable;
            }

            @Override
            public final java.lang.Object getRollback() {
                return this.rollback;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enable", om.valueToTree(this.getEnable()));
                data.set("rollback", om.valueToTree(this.getRollback()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentCircuitBreakerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentCircuitBreakerProperty.Jsii$Proxy that = (DeploymentCircuitBreakerProperty.Jsii$Proxy) o;

                if (!enable.equals(that.enable)) return false;
                return this.rollback.equals(that.rollback);
            }

            @Override
            public final int hashCode() {
                int result = this.enable.hashCode();
                result = 31 * result + (this.rollback.hashCode());
                return result;
            }
        }
    }
    /**
     * Optional deployment parameters that control how many tasks run during a deployment and the ordering of stopping and starting tasks.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentConfigurationProperty deploymentConfigurationProperty = DeploymentConfigurationProperty.builder()
     *         .alarms(DeploymentAlarmsProperty.builder()
     *                 .alarmNames(List.of("alarmNames"))
     *                 .enable(false)
     *                 .rollback(false)
     *                 .build())
     *         .deploymentCircuitBreaker(DeploymentCircuitBreakerProperty.builder()
     *                 .enable(false)
     *                 .rollback(false)
     *                 .build())
     *         .maximumPercent(123)
     *         .minimumHealthyPercent(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the CloudWatch alarms.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-alarms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-alarms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAlarms() {
            return null;
        }

        /**
         * <blockquote><p>The deployment circuit breaker can only be used for services using the rolling update ( <code>ECS</code> ) deployment type.<p></blockquote>
         * <p>
         * The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If you use the deployment circuit breaker, a service deployment will transition to a failed state and stop launching new tasks. If you use the rollback option, when a service deployment fails, the service is rolled back to the last deployment that completed successfully. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-deploymentcircuitbreaker">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-deploymentcircuitbreaker</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentCircuitBreaker() {
            return null;
        }

        /**
         * If a service is using the rolling update ( <code>ECS</code> ) deployment type, the <code>maximumPercent</code> parameter represents an upper limit on the number of your service's tasks that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, as a percentage of the <code>desiredCount</code> (rounded down to the nearest integer).
         * <p>
         * This parameter enables you to define the deployment batch size. For example, if your service is using the <code>REPLICA</code> service scheduler and has a <code>desiredCount</code> of four tasks and a <code>maximumPercent</code> value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default <code>maximumPercent</code> value for a service using the <code>REPLICA</code> service scheduler is 200%.
         * <p>
         * If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the <em>maximum percent</em> value is set to the default value and is used to define the upper limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If the tasks in the service use the Fargate launch type, the maximum percent value is not used, although it is returned when describing your service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-maximumpercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-maximumpercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumPercent() {
            return null;
        }

        /**
         * If a service is using the rolling update ( <code>ECS</code> ) deployment type, the <code>minimumHealthyPercent</code> represents a lower limit on the number of your service's tasks that must remain in the <code>RUNNING</code> state during a deployment, as a percentage of the <code>desiredCount</code> (rounded up to the nearest integer).
         * <p>
         * This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a <code>desiredCount</code> of four tasks and a <code>minimumHealthyPercent</code> of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks.
         * <p>
         * For services that <em>do not</em> use a load balancer, the following should be noted:
         * <p>
         * <ul>
         * <li>A service is considered healthy if all essential containers within the tasks in the service pass their health checks.</li>
         * <li>If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a <code>RUNNING</code> state before the task is counted towards the minimum healthy percent total.</li>
         * <li>If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings.</li>
         * </ul>
         * <p>
         * For services that <em>do</em> use a load balancer, the following should be noted:
         * <p>
         * <ul>
         * <li>If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
         * <li>If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
         * </ul>
         * <p>
         * If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the EC2 launch type, the <em>minimum healthy percent</em> value is set to the default value and is used to define the lower limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-minimumhealthypercent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentconfiguration.html#cfn-ecs-service-deploymentconfiguration-minimumhealthypercent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinimumHealthyPercent() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigurationProperty> {
            java.lang.Object alarms;
            java.lang.Object deploymentCircuitBreaker;
            java.lang.Number maximumPercent;
            java.lang.Number minimumHealthyPercent;

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getAlarms}
             * @param alarms Information about the CloudWatch alarms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.IResolvable alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getAlarms}
             * @param alarms Information about the CloudWatch alarms.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder alarms(software.amazon.awscdk.services.ecs.CfnService.DeploymentAlarmsProperty alarms) {
                this.alarms = alarms;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getDeploymentCircuitBreaker}
             * @param deploymentCircuitBreaker <blockquote><p>The deployment circuit breaker can only be used for services using the rolling update ( <code>ECS</code> ) deployment type.<p></blockquote>
             *                                 The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If you use the deployment circuit breaker, a service deployment will transition to a failed state and stop launching new tasks. If you use the rollback option, when a service deployment fails, the service is rolled back to the last deployment that completed successfully. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentCircuitBreaker(software.amazon.awscdk.IResolvable deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getDeploymentCircuitBreaker}
             * @param deploymentCircuitBreaker <blockquote><p>The deployment circuit breaker can only be used for services using the rolling update ( <code>ECS</code> ) deployment type.<p></blockquote>
             *                                 The <em>deployment circuit breaker</em> determines whether a service deployment will fail if the service can't reach a steady state. If you use the deployment circuit breaker, a service deployment will transition to a failed state and stop launching new tasks. If you use the rollback option, when a service deployment fails, the service is rolled back to the last deployment that completed successfully. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-ecs.html">Rolling update</a> in the <em>Amazon Elastic Container Service Developer Guide</em>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder deploymentCircuitBreaker(software.amazon.awscdk.services.ecs.CfnService.DeploymentCircuitBreakerProperty deploymentCircuitBreaker) {
                this.deploymentCircuitBreaker = deploymentCircuitBreaker;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getMaximumPercent}
             * @param maximumPercent If a service is using the rolling update ( <code>ECS</code> ) deployment type, the <code>maximumPercent</code> parameter represents an upper limit on the number of your service's tasks that are allowed in the <code>RUNNING</code> or <code>PENDING</code> state during a deployment, as a percentage of the <code>desiredCount</code> (rounded down to the nearest integer).
             *                       This parameter enables you to define the deployment batch size. For example, if your service is using the <code>REPLICA</code> service scheduler and has a <code>desiredCount</code> of four tasks and a <code>maximumPercent</code> value of 200%, the scheduler may start four new tasks before stopping the four older tasks (provided that the cluster resources required to do this are available). The default <code>maximumPercent</code> value for a service using the <code>REPLICA</code> service scheduler is 200%.
             *                       <p>
             *                       If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and tasks that use the EC2 launch type, the <em>maximum percent</em> value is set to the default value and is used to define the upper limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If the tasks in the service use the Fargate launch type, the maximum percent value is not used, although it is returned when describing your service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumPercent(java.lang.Number maximumPercent) {
                this.maximumPercent = maximumPercent;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentConfigurationProperty#getMinimumHealthyPercent}
             * @param minimumHealthyPercent If a service is using the rolling update ( <code>ECS</code> ) deployment type, the <code>minimumHealthyPercent</code> represents a lower limit on the number of your service's tasks that must remain in the <code>RUNNING</code> state during a deployment, as a percentage of the <code>desiredCount</code> (rounded up to the nearest integer).
             *                              This parameter enables you to deploy without using additional cluster capacity. For example, if your service has a <code>desiredCount</code> of four tasks and a <code>minimumHealthyPercent</code> of 50%, the service scheduler may stop two existing tasks to free up cluster capacity before starting two new tasks.
             *                              <p>
             *                              For services that <em>do not</em> use a load balancer, the following should be noted:
             *                              <p>
             *                              <ul>
             *                              <li>A service is considered healthy if all essential containers within the tasks in the service pass their health checks.</li>
             *                              <li>If a task has no essential containers with a health check defined, the service scheduler will wait for 40 seconds after a task reaches a <code>RUNNING</code> state before the task is counted towards the minimum healthy percent total.</li>
             *                              <li>If a task has one or more essential containers with a health check defined, the service scheduler will wait for the task to reach a healthy status before counting it towards the minimum healthy percent total. A task is considered healthy when all essential containers within the task have passed their health checks. The amount of time the service scheduler can wait for is determined by the container health check settings.</li>
             *                              </ul>
             *                              <p>
             *                              For services that <em>do</em> use a load balancer, the following should be noted:
             *                              <p>
             *                              <ul>
             *                              <li>If a task has no essential containers with a health check defined, the service scheduler will wait for the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
             *                              <li>If a task has an essential container with a health check defined, the service scheduler will wait for both the task to reach a healthy status and the load balancer target group health check to return a healthy status before counting the task towards the minimum healthy percent total.</li>
             *                              </ul>
             *                              <p>
             *                              If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the EC2 launch type, the <em>minimum healthy percent</em> value is set to the default value and is used to define the lower limit on the number of the tasks in the service that remain in the <code>RUNNING</code> state while the container instances are in the <code>DRAINING</code> state. If a service is using either the blue/green ( <code>CODE_DEPLOY</code> ) or <code>EXTERNAL</code> deployment types and is running tasks that use the Fargate launch type, the minimum healthy percent value is not used, although it is returned when describing your service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumHealthyPercent(java.lang.Number minimumHealthyPercent) {
                this.minimumHealthyPercent = minimumHealthyPercent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigurationProperty {
            private final java.lang.Object alarms;
            private final java.lang.Object deploymentCircuitBreaker;
            private final java.lang.Number maximumPercent;
            private final java.lang.Number minimumHealthyPercent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.alarms = software.amazon.jsii.Kernel.get(this, "alarms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.deploymentCircuitBreaker = software.amazon.jsii.Kernel.get(this, "deploymentCircuitBreaker", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumPercent = software.amazon.jsii.Kernel.get(this, "maximumPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minimumHealthyPercent = software.amazon.jsii.Kernel.get(this, "minimumHealthyPercent", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.alarms = builder.alarms;
                this.deploymentCircuitBreaker = builder.deploymentCircuitBreaker;
                this.maximumPercent = builder.maximumPercent;
                this.minimumHealthyPercent = builder.minimumHealthyPercent;
            }

            @Override
            public final java.lang.Object getAlarms() {
                return this.alarms;
            }

            @Override
            public final java.lang.Object getDeploymentCircuitBreaker() {
                return this.deploymentCircuitBreaker;
            }

            @Override
            public final java.lang.Number getMaximumPercent() {
                return this.maximumPercent;
            }

            @Override
            public final java.lang.Number getMinimumHealthyPercent() {
                return this.minimumHealthyPercent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAlarms() != null) {
                    data.set("alarms", om.valueToTree(this.getAlarms()));
                }
                if (this.getDeploymentCircuitBreaker() != null) {
                    data.set("deploymentCircuitBreaker", om.valueToTree(this.getDeploymentCircuitBreaker()));
                }
                if (this.getMaximumPercent() != null) {
                    data.set("maximumPercent", om.valueToTree(this.getMaximumPercent()));
                }
                if (this.getMinimumHealthyPercent() != null) {
                    data.set("minimumHealthyPercent", om.valueToTree(this.getMinimumHealthyPercent()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigurationProperty.Jsii$Proxy that = (DeploymentConfigurationProperty.Jsii$Proxy) o;

                if (this.alarms != null ? !this.alarms.equals(that.alarms) : that.alarms != null) return false;
                if (this.deploymentCircuitBreaker != null ? !this.deploymentCircuitBreaker.equals(that.deploymentCircuitBreaker) : that.deploymentCircuitBreaker != null) return false;
                if (this.maximumPercent != null ? !this.maximumPercent.equals(that.maximumPercent) : that.maximumPercent != null) return false;
                return this.minimumHealthyPercent != null ? this.minimumHealthyPercent.equals(that.minimumHealthyPercent) : that.minimumHealthyPercent == null;
            }

            @Override
            public final int hashCode() {
                int result = this.alarms != null ? this.alarms.hashCode() : 0;
                result = 31 * result + (this.deploymentCircuitBreaker != null ? this.deploymentCircuitBreaker.hashCode() : 0);
                result = 31 * result + (this.maximumPercent != null ? this.maximumPercent.hashCode() : 0);
                result = 31 * result + (this.minimumHealthyPercent != null ? this.minimumHealthyPercent.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The deployment controller to use for the service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * DeploymentControllerProperty deploymentControllerProperty = DeploymentControllerProperty.builder()
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.DeploymentControllerProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentControllerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentControllerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The deployment controller type to use. There are three deployment controller types available:.
         * <p>
         * <ul>
         * <li><strong>ECS</strong> - The rolling update ( <code>ECS</code> ) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeploymentConfiguration.html">DeploymentConfiguration</a> .</li>
         * <li><strong>CODE_DEPLOY</strong> - The blue/green ( <code>CODE_DEPLOY</code> ) deployment type uses the blue/green deployment model powered by AWS CodeDeploy , which allows you to verify a new deployment of a service before sending production traffic to it.</li>
         * <li><strong>EXTERNAL</strong> - The external ( <code>EXTERNAL</code> ) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html#cfn-ecs-service-deploymentcontroller-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-deploymentcontroller.html#cfn-ecs-service-deploymentcontroller-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentControllerProperty> {
            java.lang.String type;

            /**
             * Sets the value of {@link DeploymentControllerProperty#getType}
             * @param type The deployment controller type to use. There are three deployment controller types available:.
             *             <ul>
             *             <li><strong>ECS</strong> - The rolling update ( <code>ECS</code> ) deployment type involves replacing the current running version of the container with the latest version. The number of containers Amazon ECS adds or removes from the service during a rolling update is controlled by adjusting the minimum and maximum number of healthy tasks allowed during a service deployment, as specified in the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_DeploymentConfiguration.html">DeploymentConfiguration</a> .</li>
             *             <li><strong>CODE_DEPLOY</strong> - The blue/green ( <code>CODE_DEPLOY</code> ) deployment type uses the blue/green deployment model powered by AWS CodeDeploy , which allows you to verify a new deployment of a service before sending production traffic to it.</li>
             *             <li><strong>EXTERNAL</strong> - The external ( <code>EXTERNAL</code> ) deployment type enables you to use any third-party deployment controller for full control over the deployment process for an Amazon ECS service.</li>
             *             </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentControllerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentControllerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentControllerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentControllerProperty {
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = builder.type;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.DeploymentControllerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentControllerProperty.Jsii$Proxy that = (DeploymentControllerProperty.Jsii$Proxy) o;

                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type != null ? this.type.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The tag specifications of an Amazon EBS volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * EBSTagSpecificationProperty eBSTagSpecificationProperty = EBSTagSpecificationProperty.builder()
     *         .resourceType("resourceType")
     *         // the properties below are optional
     *         .propagateTags("propagateTags")
     *         .tags(List.of(CfnTag.builder()
     *                 .key("key")
     *                 .value("value")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.EBSTagSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(EBSTagSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EBSTagSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of volume resource.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-resourcetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-resourcetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getResourceType();

        /**
         * Determines whether to propagate the tags from the task definition to the Amazon EBS volume.
         * <p>
         * Tags can only propagate to a <code>SERVICE</code> specified in <code>ServiceVolumeConfiguration</code> . If no value is specified, the tags aren't propagated.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-propagatetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPropagateTags() {
            return null;
        }

        /**
         * The tags applied to this Amazon EBS volume.
         * <p>
         * <code>AmazonECSCreated</code> and <code>AmazonECSManaged</code> are reserved tags that can't be used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-ebstagspecification.html#cfn-ecs-service-ebstagspecification-tags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EBSTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EBSTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EBSTagSpecificationProperty> {
            java.lang.String resourceType;
            java.lang.String propagateTags;
            java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Sets the value of {@link EBSTagSpecificationProperty#getResourceType}
             * @param resourceType The type of volume resource. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resourceType(java.lang.String resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            /**
             * Sets the value of {@link EBSTagSpecificationProperty#getPropagateTags}
             * @param propagateTags Determines whether to propagate the tags from the task definition to the Amazon EBS volume.
             *                      Tags can only propagate to a <code>SERVICE</code> specified in <code>ServiceVolumeConfiguration</code> . If no value is specified, the tags aren't propagated.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propagateTags(java.lang.String propagateTags) {
                this.propagateTags = propagateTags;
                return this;
            }

            /**
             * Sets the value of {@link EBSTagSpecificationProperty#getTags}
             * @param tags The tags applied to this Amazon EBS volume.
             *             <code>AmazonECSCreated</code> and <code>AmazonECSManaged</code> are reserved tags that can't be used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @SuppressWarnings("unchecked")
            public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EBSTagSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EBSTagSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EBSTagSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EBSTagSpecificationProperty {
            private final java.lang.String resourceType;
            private final java.lang.String propagateTags;
            private final java.util.List<software.amazon.awscdk.CfnTag> tags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propagateTags = software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            @SuppressWarnings("unchecked")
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.resourceType = java.util.Objects.requireNonNull(builder.resourceType, "resourceType is required");
                this.propagateTags = builder.propagateTags;
                this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            }

            @Override
            public final java.lang.String getResourceType() {
                return this.resourceType;
            }

            @Override
            public final java.lang.String getPropagateTags() {
                return this.propagateTags;
            }

            @Override
            public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
                return this.tags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("resourceType", om.valueToTree(this.getResourceType()));
                if (this.getPropagateTags() != null) {
                    data.set("propagateTags", om.valueToTree(this.getPropagateTags()));
                }
                if (this.getTags() != null) {
                    data.set("tags", om.valueToTree(this.getTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.EBSTagSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EBSTagSpecificationProperty.Jsii$Proxy that = (EBSTagSpecificationProperty.Jsii$Proxy) o;

                if (!resourceType.equals(that.resourceType)) return false;
                if (this.propagateTags != null ? !this.propagateTags.equals(that.propagateTags) : that.propagateTags != null) return false;
                return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.resourceType.hashCode();
                result = 31 * result + (this.propagateTags != null ? this.propagateTags.hashCode() : 0);
                result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The <code>LoadBalancer</code> property specifies details on a load balancer that is used with a service.
     * <p>
     * If the service is using the <code>CODE_DEPLOY</code> deployment controller, the service is required to use either an Application Load Balancer or Network Load Balancer. When you are creating an AWS CodeDeploy deployment group, you specify two target groups (referred to as a <code>targetGroupPair</code> ). Each target group binds to a separate task set in the deployment. The load balancer can also have up to two listeners, a required listener for production traffic and an optional listener that allows you to test new revisions of the service before routing production traffic to it.
     * <p>
     * Services with tasks that use the <code>awsvpc</code> network mode (for example, those with the Fargate launch type) only support Application Load Balancers and Network Load Balancers. Classic Load Balancers are not supported. Also, when you create any target groups for these services, you must choose <code>ip</code> as the target type, not <code>instance</code> . Tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * LoadBalancerProperty loadBalancerProperty = LoadBalancerProperty.builder()
     *         .containerName("containerName")
     *         .containerPort(123)
     *         .loadBalancerName("loadBalancerName")
     *         .targetGroupArn("targetGroupArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.LoadBalancerProperty")
    @software.amazon.jsii.Jsii.Proxy(LoadBalancerProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoadBalancerProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the container (as it appears in a container definition) to associate with the load balancer.
         * <p>
         * You need to specify the container name when configuring the target group for an Amazon ECS load balancer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The port on the container to associate with the load balancer.
         * <p>
         * This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-containerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * The name of the load balancer to associate with the Amazon ECS service or task set.
         * <p>
         * If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-loadbalancername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-loadbalancername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLoadBalancerName() {
            return null;
        }

        /**
         * The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
         * <p>
         * A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer.
         * <p>
         * For services using the <code>ECS</code> deployment controller, you can specify one or multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering multiple target groups with a service</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * For services using the <code>CODE_DEPLOY</code> deployment controller, you're required to define two target groups for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/green deployment with CodeDeploy</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If your service's task definition uses the <code>awsvpc</code> network mode, you must choose <code>ip</code> as the target type, not <code>instance</code> . Do this when creating your target groups because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-targetgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-loadbalancer.html#cfn-ecs-service-loadbalancer-targetgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoadBalancerProperty> {
            java.lang.String containerName;
            java.lang.Number containerPort;
            java.lang.String loadBalancerName;
            java.lang.String targetGroupArn;

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerName}
             * @param containerName The name of the container (as it appears in a container definition) to associate with the load balancer.
             *                      You need to specify the container name when configuring the target group for an Amazon ECS load balancer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getContainerPort}
             * @param containerPort The port on the container to associate with the load balancer.
             *                      This port must correspond to a <code>containerPort</code> in the task definition the tasks in the service are using. For tasks that use the EC2 launch type, the container instance they're launched on must allow ingress traffic on the <code>hostPort</code> of the port mapping.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getLoadBalancerName}
             * @param loadBalancerName The name of the load balancer to associate with the Amazon ECS service or task set.
             *                         If you are using an Application Load Balancer or a Network Load Balancer the load balancer name parameter should be omitted.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loadBalancerName(java.lang.String loadBalancerName) {
                this.loadBalancerName = loadBalancerName;
                return this;
            }

            /**
             * Sets the value of {@link LoadBalancerProperty#getTargetGroupArn}
             * @param targetGroupArn The full Amazon Resource Name (ARN) of the Elastic Load Balancing target group or groups associated with a service or task set.
             *                       A target group ARN is only specified when using an Application Load Balancer or Network Load Balancer.
             *                       <p>
             *                       For services using the <code>ECS</code> deployment controller, you can specify one or multiple target groups. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/register-multiple-targetgroups.html">Registering multiple target groups with a service</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                       <p>
             *                       For services using the <code>CODE_DEPLOY</code> deployment controller, you're required to define two target groups for the load balancer. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-type-bluegreen.html">Blue/green deployment with CodeDeploy</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                       <p>
             *                       <blockquote>
             *                       <p>
             *                       If your service's task definition uses the <code>awsvpc</code> network mode, you must choose <code>ip</code> as the target type, not <code>instance</code> . Do this when creating your target groups because tasks that use the <code>awsvpc</code> network mode are associated with an elastic network interface, not an Amazon EC2 instance. This network mode is required for the Fargate launch type.
             *                       <p>
             *                       </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetGroupArn(java.lang.String targetGroupArn) {
                this.targetGroupArn = targetGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoadBalancerProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoadBalancerProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoadBalancerProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoadBalancerProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.String loadBalancerName;
            private final java.lang.String targetGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.loadBalancerName = software.amazon.jsii.Kernel.get(this, "loadBalancerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetGroupArn = software.amazon.jsii.Kernel.get(this, "targetGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = builder.containerName;
                this.containerPort = builder.containerPort;
                this.loadBalancerName = builder.loadBalancerName;
                this.targetGroupArn = builder.targetGroupArn;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.String getLoadBalancerName() {
                return this.loadBalancerName;
            }

            @Override
            public final java.lang.String getTargetGroupArn() {
                return this.targetGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getLoadBalancerName() != null) {
                    data.set("loadBalancerName", om.valueToTree(this.getLoadBalancerName()));
                }
                if (this.getTargetGroupArn() != null) {
                    data.set("targetGroupArn", om.valueToTree(this.getTargetGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.LoadBalancerProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoadBalancerProperty.Jsii$Proxy that = (LoadBalancerProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.loadBalancerName != null ? !this.loadBalancerName.equals(that.loadBalancerName) : that.loadBalancerName != null) return false;
                return this.targetGroupArn != null ? this.targetGroupArn.equals(that.targetGroupArn) : that.targetGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.loadBalancerName != null ? this.loadBalancerName.hashCode() : 0);
                result = 31 * result + (this.targetGroupArn != null ? this.targetGroupArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The log configuration for the container.
     * <p>
     * This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/commandline/run/"><code>docker run</code></a> .
     * <p>
     * By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition. For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
     * <p>
     * Understand the following when specifying a log configuration for your containers.
     * <p>
     * <ul>
     * <li>Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.</li>
     * </ul>
     * <p>
     * For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
     * <p>
     * For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
     * <p>
     * <ul>
     * <li>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.</li>
     * <li>For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .</li>
     * <li>For tasks that are on AWS Fargate , because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * LogConfigurationProperty logConfigurationProperty = LogConfigurationProperty.builder()
     *         .logDriver("logDriver")
     *         .options(Map.of(
     *                 "optionsKey", "options"))
     *         .secretOptions(List.of(SecretProperty.builder()
     *                 .name("name")
     *                 .valueFrom("valueFrom")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.LogConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The log driver to use for the container.
         * <p>
         * For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-logdriver">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-logdriver</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogDriver() {
            return null;
        }

        /**
         * The configuration options to send to the log driver.
         * <p>
         * This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-options">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-options</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptions() {
            return null;
        }

        /**
         * The secrets to pass to the log configuration.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-secretoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-logconfiguration.html#cfn-ecs-service-logconfiguration-secretoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSecretOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogConfigurationProperty> {
            java.lang.String logDriver;
            java.lang.Object options;
            java.lang.Object secretOptions;

            /**
             * Sets the value of {@link LogConfigurationProperty#getLogDriver}
             * @param logDriver The log driver to use for the container.
             *                  For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                  <p>
             *                  For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                  <p>
             *                  For more information about using the <code>awslogs</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs log driver</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  For more information about using the <code>awsfirelens</code> log driver, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_firelens.html">Custom log routing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If you have a custom driver that isn't listed, you can fork the Amazon ECS container agent project that's <a href="https://docs.aws.amazon.com/https://github.com/aws/amazon-ecs-agent">available on GitHub</a> and customize it to work with that driver. We encourage you to submit pull requests for changes that you would like to have included. However, we don't currently provide support for running modified copies of this software.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logDriver(java.lang.String logDriver) {
                this.logDriver = logDriver;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(software.amazon.awscdk.IResolvable options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getOptions}
             * @param options The configuration options to send to the log driver.
             *                This parameter requires version 1.19 of the Docker Remote API or greater on your container instance. To check the Docker Remote API version on your container instance, log in to your container instance and run the following command: <code>sudo docker version --format '{{.Server.APIVersion}}'</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder options(java.util.Map<java.lang.String, java.lang.String> options) {
                this.options = options;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(software.amazon.awscdk.IResolvable secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Sets the value of {@link LogConfigurationProperty#getSecretOptions}
             * @param secretOptions The secrets to pass to the log configuration.
             *                      For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretOptions(java.util.List<? extends java.lang.Object> secretOptions) {
                this.secretOptions = secretOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogConfigurationProperty {
            private final java.lang.String logDriver;
            private final java.lang.Object options;
            private final java.lang.Object secretOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logDriver = software.amazon.jsii.Kernel.get(this, "logDriver", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.options = software.amazon.jsii.Kernel.get(this, "options", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.secretOptions = software.amazon.jsii.Kernel.get(this, "secretOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logDriver = builder.logDriver;
                this.options = builder.options;
                this.secretOptions = builder.secretOptions;
            }

            @Override
            public final java.lang.String getLogDriver() {
                return this.logDriver;
            }

            @Override
            public final java.lang.Object getOptions() {
                return this.options;
            }

            @Override
            public final java.lang.Object getSecretOptions() {
                return this.secretOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogDriver() != null) {
                    data.set("logDriver", om.valueToTree(this.getLogDriver()));
                }
                if (this.getOptions() != null) {
                    data.set("options", om.valueToTree(this.getOptions()));
                }
                if (this.getSecretOptions() != null) {
                    data.set("secretOptions", om.valueToTree(this.getSecretOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.LogConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogConfigurationProperty.Jsii$Proxy that = (LogConfigurationProperty.Jsii$Proxy) o;

                if (this.logDriver != null ? !this.logDriver.equals(that.logDriver) : that.logDriver != null) return false;
                if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
                return this.secretOptions != null ? this.secretOptions.equals(that.secretOptions) : that.secretOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logDriver != null ? this.logDriver.hashCode() : 0;
                result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
                result = 31 * result + (this.secretOptions != null ? this.secretOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The network configuration for a task or service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .awsvpcConfiguration(AwsVpcConfigurationProperty.builder()
     *                 .assignPublicIp("assignPublicIp")
     *                 .securityGroups(List.of("securityGroups"))
     *                 .subnets(List.of("subnets"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The VPC subnets and security groups that are associated with a task.
         * <p>
         * <blockquote>
         * <p>
         * All specified subnets and security groups must be from the same VPC.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html#cfn-ecs-service-networkconfiguration-awsvpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-networkconfiguration.html#cfn-ecs-service-networkconfiguration-awsvpcconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAwsvpcConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.lang.Object awsvpcConfiguration;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration The VPC subnets and security groups that are associated with a task.
             *                            <blockquote>
             *                            <p>
             *                            All specified subnets and security groups must be from the same VPC.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.IResolvable awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getAwsvpcConfiguration}
             * @param awsvpcConfiguration The VPC subnets and security groups that are associated with a task.
             *                            <blockquote>
             *                            <p>
             *                            All specified subnets and security groups must be from the same VPC.
             *                            <p>
             *                            </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsvpcConfiguration(software.amazon.awscdk.services.ecs.CfnService.AwsVpcConfigurationProperty awsvpcConfiguration) {
                this.awsvpcConfiguration = awsvpcConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.lang.Object awsvpcConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsvpcConfiguration = software.amazon.jsii.Kernel.get(this, "awsvpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsvpcConfiguration = builder.awsvpcConfiguration;
            }

            @Override
            public final java.lang.Object getAwsvpcConfiguration() {
                return this.awsvpcConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsvpcConfiguration() != null) {
                    data.set("awsvpcConfiguration", om.valueToTree(this.getAwsvpcConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                return this.awsvpcConfiguration != null ? this.awsvpcConfiguration.equals(that.awsvpcConfiguration) : that.awsvpcConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsvpcConfiguration != null ? this.awsvpcConfiguration.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object representing a constraint on task placement.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-constraints.html">Task placement constraints</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * If you're using the Fargate launch type, task placement constraints aren't supported.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * PlacementConstraintProperty placementConstraintProperty = PlacementConstraintProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.PlacementConstraintProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementConstraintProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementConstraintProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of constraint.
         * <p>
         * Use <code>distinctInstance</code> to ensure that each task in a particular group is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * A cluster query language expression to apply to the constraint.
         * <p>
         * The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is <code>distinctInstance</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementconstraint.html#cfn-ecs-service-placementconstraint-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementConstraintProperty> {
            java.lang.String type;
            java.lang.String expression;

            /**
             * Sets the value of {@link PlacementConstraintProperty#getType}
             * @param type The type of constraint. This parameter is required.
             *             Use <code>distinctInstance</code> to ensure that each task in a particular group is running on a different container instance. Use <code>memberOf</code> to restrict the selection to a group of valid candidates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PlacementConstraintProperty#getExpression}
             * @param expression A cluster query language expression to apply to the constraint.
             *                   The expression can have a maximum length of 2000 characters. You can't specify an expression if the constraint type is <code>distinctInstance</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cluster-query-language.html">Cluster query language</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementConstraintProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementConstraintProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementConstraintProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementConstraintProperty {
            private final java.lang.String type;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.PlacementConstraintProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementConstraintProperty.Jsii$Proxy that = (PlacementConstraintProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The task placement strategy for a task or service.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-placement-strategies.html">Task placement strategies</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * PlacementStrategyProperty placementStrategyProperty = PlacementStrategyProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .field("field")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.PlacementStrategyProperty")
    @software.amazon.jsii.Jsii.Proxy(PlacementStrategyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PlacementStrategyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of placement strategy.
         * <p>
         * The <code>random</code> placement strategy randomly places tasks on available candidates. The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the <code>field</code> parameter. The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that's specified with the <code>field</code> parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The field to apply the placement strategy against.
         * <p>
         * For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code> , which has the same effect), or any platform or custom attribute that's applied to a container instance, such as <code>attribute:ecs.availability-zone</code> . For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code> . For the <code>random</code> placement strategy, this field is not used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-placementstrategy.html#cfn-ecs-service-placementstrategy-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getField() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PlacementStrategyProperty> {
            java.lang.String type;
            java.lang.String field;

            /**
             * Sets the value of {@link PlacementStrategyProperty#getType}
             * @param type The type of placement strategy. This parameter is required.
             *             The <code>random</code> placement strategy randomly places tasks on available candidates. The <code>spread</code> placement strategy spreads placement across available candidates evenly based on the <code>field</code> parameter. The <code>binpack</code> strategy places tasks on available candidates that have the least available amount of the resource that's specified with the <code>field</code> parameter. For example, if you binpack on memory, a task is placed on the instance with the least amount of remaining memory but still enough to run the task.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link PlacementStrategyProperty#getField}
             * @param field The field to apply the placement strategy against.
             *              For the <code>spread</code> placement strategy, valid values are <code>instanceId</code> (or <code>host</code> , which has the same effect), or any platform or custom attribute that's applied to a container instance, such as <code>attribute:ecs.availability-zone</code> . For the <code>binpack</code> placement strategy, valid values are <code>cpu</code> and <code>memory</code> . For the <code>random</code> placement strategy, this field is not used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PlacementStrategyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PlacementStrategyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PlacementStrategyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PlacementStrategyProperty {
            private final java.lang.String type;
            private final java.lang.String field;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.field = builder.field;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getField() != null) {
                    data.set("field", om.valueToTree(this.getField()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.PlacementStrategyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PlacementStrategyProperty.Jsii$Proxy that = (PlacementStrategyProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.field != null ? this.field.equals(that.field) : that.field == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.field != null ? this.field.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the secret to expose to your container.
     * <p>
     * Secrets can be exposed to a container in the following ways:
     * <p>
     * <ul>
     * <li>To inject sensitive data into your containers as environment variables, use the <code>secrets</code> container definition parameter.</li>
     * <li>To reference sensitive information in the log configuration of a container, use the <code>secretOptions</code> container definition parameter.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data.html">Specifying sensitive data</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * SecretProperty secretProperty = SecretProperty.builder()
     *         .name("name")
     *         .valueFrom("valueFrom")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.SecretProperty")
    @software.amazon.jsii.Jsii.Proxy(SecretProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SecretProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html#cfn-ecs-service-secret-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html#cfn-ecs-service-secret-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The secret to expose to the container.
         * <p>
         * The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
         * <p>
         * For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html#cfn-ecs-service-secret-valuefrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-secret.html#cfn-ecs-service-secret-valuefrom</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValueFrom();

        /**
         * @return a {@link Builder} of {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SecretProperty> {
            java.lang.String name;
            java.lang.String valueFrom;

            /**
             * Sets the value of {@link SecretProperty#getName}
             * @param name The name of the secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link SecretProperty#getValueFrom}
             * @param valueFrom The secret to expose to the container. This parameter is required.
             *                  The supported values are either the full ARN of the AWS Secrets Manager secret or the full ARN of the parameter in the SSM Parameter Store.
             *                  <p>
             *                  For information about the require AWS Identity and Access Management permissions, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-secrets.html#secrets-iam">Required IAM permissions for Amazon ECS secrets</a> (for Secrets Manager) or <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/specifying-sensitive-data-parameters.html">Required IAM permissions for Amazon ECS secrets</a> (for Systems Manager Parameter store) in the <em>Amazon Elastic Container Service Developer Guide</em> .
             *                  <p>
             *                  <blockquote>
             *                  <p>
             *                  If the SSM Parameter Store parameter exists in the same Region as the task you're launching, then you can use either the full ARN or name of the parameter. If the parameter exists in a different Region, then the full ARN must be specified.
             *                  <p>
             *                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder valueFrom(java.lang.String valueFrom) {
                this.valueFrom = valueFrom;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SecretProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SecretProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SecretProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretProperty {
            private final java.lang.String name;
            private final java.lang.String valueFrom;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.valueFrom = software.amazon.jsii.Kernel.get(this, "valueFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.valueFrom = java.util.Objects.requireNonNull(builder.valueFrom, "valueFrom is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getValueFrom() {
                return this.valueFrom;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("valueFrom", om.valueToTree(this.getValueFrom()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.SecretProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SecretProperty.Jsii$Proxy that = (SecretProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.valueFrom.equals(that.valueFrom);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.valueFrom.hashCode());
                return result;
            }
        }
    }
    /**
     * Each alias ("endpoint") is a fully-qualified name and port number that other tasks ("clients") can use to connect to this service.
     * <p>
     * Each name and port mapping must be unique within the namespace.
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectClientAliasProperty serviceConnectClientAliasProperty = ServiceConnectClientAliasProperty.builder()
     *         .port(123)
     *         // the properties below are optional
     *         .dnsName("dnsName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceConnectClientAliasProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectClientAliasProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectClientAliasProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The listening port number for the Service Connect proxy.
         * <p>
         * This port is available inside of all of the tasks within the same namespace.
         * <p>
         * To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html#cfn-ecs-service-serviceconnectclientalias-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html#cfn-ecs-service-serviceconnectclientalias-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getPort();

        /**
         * The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to this service.
         * <p>
         * The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
         * <p>
         * If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used. If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in <code>portName.namespace</code> .
         * <p>
         * To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are <code>database</code> , <code>db</code> , or the lowercase name of a database, such as <code>mysql</code> or <code>redis</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html#cfn-ecs-service-serviceconnectclientalias-dnsname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectclientalias.html#cfn-ecs-service-serviceconnectclientalias-dnsname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDnsName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectClientAliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectClientAliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectClientAliasProperty> {
            java.lang.Number port;
            java.lang.String dnsName;

            /**
             * Sets the value of {@link ServiceConnectClientAliasProperty#getPort}
             * @param port The listening port number for the Service Connect proxy. This parameter is required.
             *             This port is available inside of all of the tasks within the same namespace.
             *             <p>
             *             To avoid changing your applications in client Amazon ECS services, set this to the same port that the client application uses by default. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectClientAliasProperty#getDnsName}
             * @param dnsName The <code>dnsName</code> is the name that you use in the applications of client tasks to connect to this service.
             *                The name must be a valid DNS name but doesn't need to be fully-qualified. The name can include up to 127 characters. The name can include lowercase letters, numbers, underscores (_), hyphens (-), and periods (.). The name can't start with a hyphen.
             *                <p>
             *                If this parameter isn't specified, the default value of <code>discoveryName.namespace</code> is used. If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in <code>portName.namespace</code> .
             *                <p>
             *                To avoid changing your applications in client Amazon ECS services, set this to the same name that the client application uses by default. For example, a few common names are <code>database</code> , <code>db</code> , or the lowercase name of a database, such as <code>mysql</code> or <code>redis</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dnsName(java.lang.String dnsName) {
                this.dnsName = dnsName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectClientAliasProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectClientAliasProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectClientAliasProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectClientAliasProperty {
            private final java.lang.Number port;
            private final java.lang.String dnsName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dnsName = software.amazon.jsii.Kernel.get(this, "dnsName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.port = java.util.Objects.requireNonNull(builder.port, "port is required");
                this.dnsName = builder.dnsName;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getDnsName() {
                return this.dnsName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("port", om.valueToTree(this.getPort()));
                if (this.getDnsName() != null) {
                    data.set("dnsName", om.valueToTree(this.getDnsName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceConnectClientAliasProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectClientAliasProperty.Jsii$Proxy that = (ServiceConnectClientAliasProperty.Jsii$Proxy) o;

                if (!port.equals(that.port)) return false;
                return this.dnsName != null ? this.dnsName.equals(that.dnsName) : that.dnsName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.port.hashCode();
                result = 31 * result + (this.dnsName != null ? this.dnsName.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Service Connect configuration of your Amazon ECS service.
     * <p>
     * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectConfigurationProperty serviceConnectConfigurationProperty = ServiceConnectConfigurationProperty.builder()
     *         .enabled(false)
     *         // the properties below are optional
     *         .logConfiguration(LogConfigurationProperty.builder()
     *                 .logDriver("logDriver")
     *                 .options(Map.of(
     *                         "optionsKey", "options"))
     *                 .secretOptions(List.of(SecretProperty.builder()
     *                         .name("name")
     *                         .valueFrom("valueFrom")
     *                         .build()))
     *                 .build())
     *         .namespace("namespace")
     *         .services(List.of(ServiceConnectServiceProperty.builder()
     *                 .portName("portName")
     *                 // the properties below are optional
     *                 .clientAliases(List.of(ServiceConnectClientAliasProperty.builder()
     *                         .port(123)
     *                         // the properties below are optional
     *                         .dnsName("dnsName")
     *                         .build()))
     *                 .discoveryName("discoveryName")
     *                 .ingressPortOverride(123)
     *                 .timeout(TimeoutConfigurationProperty.builder()
     *                         .idleTimeoutSeconds(123)
     *                         .perRequestTimeoutSeconds(123)
     *                         .build())
     *                 .tls(ServiceConnectTlsConfigurationProperty.builder()
     *                         .issuerCertificateAuthority(ServiceConnectTlsCertificateAuthorityProperty.builder()
     *                                 .awsPcaAuthorityArn("awsPcaAuthorityArn")
     *                                 .build())
     *                         // the properties below are optional
     *                         .kmsKey("kmsKey")
     *                         .roleArn("roleArn")
     *                         .build())
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceConnectConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether to use Service Connect with this service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * The log configuration for the container.
         * <p>
         * This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/commandline/run/"><code>docker run</code></a> .
         * <p>
         * By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition. For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
         * <p>
         * Understand the following when specifying a log configuration for your containers.
         * <p>
         * <ul>
         * <li>Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.</li>
         * </ul>
         * <p>
         * For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
         * <p>
         * <ul>
         * <li>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.</li>
         * <li>For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .</li>
         * <li>For tasks that are on AWS Fargate , because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-logconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-logconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogConfiguration() {
            return null;
        }

        /**
         * The namespace name or full Amazon Resource Name (ARN) of the AWS Cloud Map namespace for use with Service Connect.
         * <p>
         * The namespace must be in the same AWS Region as the Amazon ECS service and cluster. The type of namespace doesn't affect Service Connect. For more information about AWS Cloud Map , see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a> in the <em>AWS Cloud Map Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-namespace">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-namespace</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespace() {
            return null;
        }

        /**
         * The list of Service Connect service objects.
         * <p>
         * These are names and aliases (also known as endpoints) that are used by other Amazon ECS services to connect to this service.
         * <p>
         * This field is not required for a "client" Amazon ECS service that's a member of a namespace only to connect to other services within the namespace. An example of this would be a frontend application that accepts incoming requests from either a load balancer that's attached to the service or by other means.
         * <p>
         * An object selects a port from the task definition, assigns a name for the AWS Cloud Map service, and a list of aliases (endpoints) and ports for client applications to refer to this service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-services">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectconfiguration.html#cfn-ecs-service-serviceconnectconfiguration-services</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getServices() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectConfigurationProperty> {
            java.lang.Object enabled;
            java.lang.Object logConfiguration;
            java.lang.String namespace;
            java.lang.Object services;

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getEnabled}
             * @param enabled Specifies whether to use Service Connect with this service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getEnabled}
             * @param enabled Specifies whether to use Service Connect with this service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/commandline/run/"><code>docker run</code></a> .
             *                         <p>
             *                         By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition. For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         Understand the following when specifying a log configuration for your containers.
             *                         <p>
             *                         <ul>
             *                         <li>Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.</li>
             *                         </ul>
             *                         <p>
             *                         For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                         <p>
             *                         For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                         <p>
             *                         <ul>
             *                         <li>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.</li>
             *                         <li>For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .</li>
             *                         <li>For tasks that are on AWS Fargate , because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.IResolvable logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getLogConfiguration}
             * @param logConfiguration The log configuration for the container.
             *                         This parameter maps to <code>LogConfig</code> in the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/#operation/ContainerCreate">Create a container</a> section of the <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/api/v1.35/">Docker Remote API</a> and the <code>--log-driver</code> option to <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/reference/commandline/run/"><code>docker run</code></a> .
             *                         <p>
             *                         By default, containers use the same logging driver that the Docker daemon uses. However, the container might use a different logging driver than the Docker daemon by specifying a log driver configuration in the container definition. For more information about the options for different supported log drivers, see <a href="https://docs.aws.amazon.com/https://docs.docker.com/engine/admin/logging/overview/">Configure logging drivers</a> in the Docker documentation.
             *                         <p>
             *                         Understand the following when specifying a log configuration for your containers.
             *                         <p>
             *                         <ul>
             *                         <li>Amazon ECS currently supports a subset of the logging drivers available to the Docker daemon. Additional log drivers may be available in future releases of the Amazon ECS container agent.</li>
             *                         </ul>
             *                         <p>
             *                         For tasks on AWS Fargate , the supported log drivers are <code>awslogs</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                         <p>
             *                         For tasks hosted on Amazon EC2 instances, the supported log drivers are <code>awslogs</code> , <code>fluentd</code> , <code>gelf</code> , <code>json-file</code> , <code>journald</code> , <code>logentries</code> , <code>syslog</code> , <code>splunk</code> , and <code>awsfirelens</code> .
             *                         <p>
             *                         <ul>
             *                         <li>This parameter requires version 1.18 of the Docker Remote API or greater on your container instance.</li>
             *                         <li>For tasks that are hosted on Amazon EC2 instances, the Amazon ECS container agent must register the available logging drivers with the <code>ECS_AVAILABLE_LOGGING_DRIVERS</code> environment variable before containers placed on that instance can use these log configuration options. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-agent-config.html">Amazon ECS container agent configuration</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .</li>
             *                         <li>For tasks that are on AWS Fargate , because you don't have access to the underlying infrastructure your tasks are hosted on, any additional software needed must be installed outside of the task. For example, the Fluentd output aggregators or a remote host running Logstash to send Gelf logs to.</li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logConfiguration(software.amazon.awscdk.services.ecs.CfnService.LogConfigurationProperty logConfiguration) {
                this.logConfiguration = logConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getNamespace}
             * @param namespace The namespace name or full Amazon Resource Name (ARN) of the AWS Cloud Map namespace for use with Service Connect.
             *                  The namespace must be in the same AWS Region as the Amazon ECS service and cluster. The type of namespace doesn't affect Service Connect. For more information about AWS Cloud Map , see <a href="https://docs.aws.amazon.com/cloud-map/latest/dg/working-with-services.html">Working with Services</a> in the <em>AWS Cloud Map Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespace(java.lang.String namespace) {
                this.namespace = namespace;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getServices}
             * @param services The list of Service Connect service objects.
             *                 These are names and aliases (also known as endpoints) that are used by other Amazon ECS services to connect to this service.
             *                 <p>
             *                 This field is not required for a "client" Amazon ECS service that's a member of a namespace only to connect to other services within the namespace. An example of this would be a frontend application that accepts incoming requests from either a load balancer that's attached to the service or by other means.
             *                 <p>
             *                 An object selects a port from the task definition, assigns a name for the AWS Cloud Map service, and a list of aliases (endpoints) and ports for client applications to refer to this service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder services(software.amazon.awscdk.IResolvable services) {
                this.services = services;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectConfigurationProperty#getServices}
             * @param services The list of Service Connect service objects.
             *                 These are names and aliases (also known as endpoints) that are used by other Amazon ECS services to connect to this service.
             *                 <p>
             *                 This field is not required for a "client" Amazon ECS service that's a member of a namespace only to connect to other services within the namespace. An example of this would be a frontend application that accepts incoming requests from either a load balancer that's attached to the service or by other means.
             *                 <p>
             *                 An object selects a port from the task definition, assigns a name for the AWS Cloud Map service, and a list of aliases (endpoints) and ports for client applications to refer to this service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder services(java.util.List<? extends java.lang.Object> services) {
                this.services = services;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectConfigurationProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object logConfiguration;
            private final java.lang.String namespace;
            private final java.lang.Object services;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logConfiguration = software.amazon.jsii.Kernel.get(this, "logConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.services = software.amazon.jsii.Kernel.get(this, "services", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(builder.enabled, "enabled is required");
                this.logConfiguration = builder.logConfiguration;
                this.namespace = builder.namespace;
                this.services = builder.services;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getLogConfiguration() {
                return this.logConfiguration;
            }

            @Override
            public final java.lang.String getNamespace() {
                return this.namespace;
            }

            @Override
            public final java.lang.Object getServices() {
                return this.services;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getLogConfiguration() != null) {
                    data.set("logConfiguration", om.valueToTree(this.getLogConfiguration()));
                }
                if (this.getNamespace() != null) {
                    data.set("namespace", om.valueToTree(this.getNamespace()));
                }
                if (this.getServices() != null) {
                    data.set("services", om.valueToTree(this.getServices()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceConnectConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectConfigurationProperty.Jsii$Proxy that = (ServiceConnectConfigurationProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.logConfiguration != null ? !this.logConfiguration.equals(that.logConfiguration) : that.logConfiguration != null) return false;
                if (this.namespace != null ? !this.namespace.equals(that.namespace) : that.namespace != null) return false;
                return this.services != null ? this.services.equals(that.services) : that.services == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.logConfiguration != null ? this.logConfiguration.hashCode() : 0);
                result = 31 * result + (this.namespace != null ? this.namespace.hashCode() : 0);
                result = 31 * result + (this.services != null ? this.services.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Service Connect service object configuration.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectServiceProperty serviceConnectServiceProperty = ServiceConnectServiceProperty.builder()
     *         .portName("portName")
     *         // the properties below are optional
     *         .clientAliases(List.of(ServiceConnectClientAliasProperty.builder()
     *                 .port(123)
     *                 // the properties below are optional
     *                 .dnsName("dnsName")
     *                 .build()))
     *         .discoveryName("discoveryName")
     *         .ingressPortOverride(123)
     *         .timeout(TimeoutConfigurationProperty.builder()
     *                 .idleTimeoutSeconds(123)
     *                 .perRequestTimeoutSeconds(123)
     *                 .build())
     *         .tls(ServiceConnectTlsConfigurationProperty.builder()
     *                 .issuerCertificateAuthority(ServiceConnectTlsCertificateAuthorityProperty.builder()
     *                         .awsPcaAuthorityArn("awsPcaAuthorityArn")
     *                         .build())
     *                 // the properties below are optional
     *                 .kmsKey("kmsKey")
     *                 .roleArn("roleArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceConnectServiceProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectServiceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectServiceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the containers in the task definition of this Amazon ECS service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-portname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-portname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPortName();

        /**
         * The list of client aliases for this Service Connect service.
         * <p>
         * You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
         * <p>
         * Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
         * <p>
         * Each name and port mapping must be unique within the namespace.
         * <p>
         * For each <code>ServiceConnectService</code> , you must provide at least one <code>clientAlias</code> with one <code>port</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-clientaliases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-clientaliases</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getClientAliases() {
            return null;
        }

        /**
         * The <code>discoveryName</code> is the name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
         * <p>
         * This must be unique within the AWS Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
         * <p>
         * If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in <code>portName.namespace</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-discoveryname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-discoveryname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDiscoveryName() {
            return null;
        }

        /**
         * The port number for the Service Connect proxy to listen on.
         * <p>
         * Use the value of this field to bypass the proxy for traffic on the port number specified in the named <code>portMapping</code> in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
         * <p>
         * In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container port number is in the <code>portMapping</code> in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-ingressportoverride">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-ingressportoverride</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIngressPortOverride() {
            return null;
        }

        /**
         * A reference to an object that represents the configured timeouts for Service Connect.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-timeout">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-timeout</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeout() {
            return null;
        }

        /**
         * A reference to an object that represents a Transport Layer Security (TLS) configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-tls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnectservice.html#cfn-ecs-service-serviceconnectservice-tls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTls() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectServiceProperty> {
            java.lang.String portName;
            java.lang.Object clientAliases;
            java.lang.String discoveryName;
            java.lang.Number ingressPortOverride;
            java.lang.Object timeout;
            java.lang.Object tls;

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getPortName}
             * @param portName The <code>portName</code> must match the name of one of the <code>portMappings</code> from all the containers in the task definition of this Amazon ECS service. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder portName(java.lang.String portName) {
                this.portName = portName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getClientAliases}
             * @param clientAliases The list of client aliases for this Service Connect service.
             *                      You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
             *                      <p>
             *                      Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
             *                      <p>
             *                      Each name and port mapping must be unique within the namespace.
             *                      <p>
             *                      For each <code>ServiceConnectService</code> , you must provide at least one <code>clientAlias</code> with one <code>port</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientAliases(software.amazon.awscdk.IResolvable clientAliases) {
                this.clientAliases = clientAliases;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getClientAliases}
             * @param clientAliases The list of client aliases for this Service Connect service.
             *                      You use these to assign names that can be used by client applications. The maximum number of client aliases that you can have in this list is 1.
             *                      <p>
             *                      Each alias ("endpoint") is a fully-qualified name and port number that other Amazon ECS tasks ("clients") can use to connect to this service.
             *                      <p>
             *                      Each name and port mapping must be unique within the namespace.
             *                      <p>
             *                      For each <code>ServiceConnectService</code> , you must provide at least one <code>clientAlias</code> with one <code>port</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder clientAliases(java.util.List<? extends java.lang.Object> clientAliases) {
                this.clientAliases = clientAliases;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getDiscoveryName}
             * @param discoveryName The <code>discoveryName</code> is the name of the new AWS Cloud Map service that Amazon ECS creates for this Amazon ECS service.
             *                      This must be unique within the AWS Cloud Map namespace. The name can contain up to 64 characters. The name can include lowercase letters, numbers, underscores (_), and hyphens (-). The name can't start with a hyphen.
             *                      <p>
             *                      If the <code>discoveryName</code> isn't specified, the port mapping name from the task definition is used in <code>portName.namespace</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder discoveryName(java.lang.String discoveryName) {
                this.discoveryName = discoveryName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getIngressPortOverride}
             * @param ingressPortOverride The port number for the Service Connect proxy to listen on.
             *                            Use the value of this field to bypass the proxy for traffic on the port number specified in the named <code>portMapping</code> in the task definition of this application, and then use it in your VPC security groups to allow traffic into the proxy for this Amazon ECS service.
             *                            <p>
             *                            In <code>awsvpc</code> mode and Fargate, the default value is the container port number. The container port number is in the <code>portMapping</code> in the task definition. In bridge mode, the default value is the ephemeral port of the Service Connect proxy.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ingressPortOverride(java.lang.Number ingressPortOverride) {
                this.ingressPortOverride = ingressPortOverride;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getTimeout}
             * @param timeout A reference to an object that represents the configured timeouts for Service Connect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.IResolvable timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getTimeout}
             * @param timeout A reference to an object that represents the configured timeouts for Service Connect.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeout(software.amazon.awscdk.services.ecs.CfnService.TimeoutConfigurationProperty timeout) {
                this.timeout = timeout;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.IResolvable tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectServiceProperty#getTls}
             * @param tls A reference to an object that represents a Transport Layer Security (TLS) configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tls(software.amazon.awscdk.services.ecs.CfnService.ServiceConnectTlsConfigurationProperty tls) {
                this.tls = tls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectServiceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectServiceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectServiceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectServiceProperty {
            private final java.lang.String portName;
            private final java.lang.Object clientAliases;
            private final java.lang.String discoveryName;
            private final java.lang.Number ingressPortOverride;
            private final java.lang.Object timeout;
            private final java.lang.Object tls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.portName = software.amazon.jsii.Kernel.get(this, "portName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.clientAliases = software.amazon.jsii.Kernel.get(this, "clientAliases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.discoveryName = software.amazon.jsii.Kernel.get(this, "discoveryName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.ingressPortOverride = software.amazon.jsii.Kernel.get(this, "ingressPortOverride", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tls = software.amazon.jsii.Kernel.get(this, "tls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.portName = java.util.Objects.requireNonNull(builder.portName, "portName is required");
                this.clientAliases = builder.clientAliases;
                this.discoveryName = builder.discoveryName;
                this.ingressPortOverride = builder.ingressPortOverride;
                this.timeout = builder.timeout;
                this.tls = builder.tls;
            }

            @Override
            public final java.lang.String getPortName() {
                return this.portName;
            }

            @Override
            public final java.lang.Object getClientAliases() {
                return this.clientAliases;
            }

            @Override
            public final java.lang.String getDiscoveryName() {
                return this.discoveryName;
            }

            @Override
            public final java.lang.Number getIngressPortOverride() {
                return this.ingressPortOverride;
            }

            @Override
            public final java.lang.Object getTimeout() {
                return this.timeout;
            }

            @Override
            public final java.lang.Object getTls() {
                return this.tls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("portName", om.valueToTree(this.getPortName()));
                if (this.getClientAliases() != null) {
                    data.set("clientAliases", om.valueToTree(this.getClientAliases()));
                }
                if (this.getDiscoveryName() != null) {
                    data.set("discoveryName", om.valueToTree(this.getDiscoveryName()));
                }
                if (this.getIngressPortOverride() != null) {
                    data.set("ingressPortOverride", om.valueToTree(this.getIngressPortOverride()));
                }
                if (this.getTimeout() != null) {
                    data.set("timeout", om.valueToTree(this.getTimeout()));
                }
                if (this.getTls() != null) {
                    data.set("tls", om.valueToTree(this.getTls()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceConnectServiceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectServiceProperty.Jsii$Proxy that = (ServiceConnectServiceProperty.Jsii$Proxy) o;

                if (!portName.equals(that.portName)) return false;
                if (this.clientAliases != null ? !this.clientAliases.equals(that.clientAliases) : that.clientAliases != null) return false;
                if (this.discoveryName != null ? !this.discoveryName.equals(that.discoveryName) : that.discoveryName != null) return false;
                if (this.ingressPortOverride != null ? !this.ingressPortOverride.equals(that.ingressPortOverride) : that.ingressPortOverride != null) return false;
                if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
                return this.tls != null ? this.tls.equals(that.tls) : that.tls == null;
            }

            @Override
            public final int hashCode() {
                int result = this.portName.hashCode();
                result = 31 * result + (this.clientAliases != null ? this.clientAliases.hashCode() : 0);
                result = 31 * result + (this.discoveryName != null ? this.discoveryName.hashCode() : 0);
                result = 31 * result + (this.ingressPortOverride != null ? this.ingressPortOverride.hashCode() : 0);
                result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
                result = 31 * result + (this.tls != null ? this.tls.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the AWS Private Certificate Authority certificate.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectTlsCertificateAuthorityProperty serviceConnectTlsCertificateAuthorityProperty = ServiceConnectTlsCertificateAuthorityProperty.builder()
     *         .awsPcaAuthorityArn("awsPcaAuthorityArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlscertificateauthority.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlscertificateauthority.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsCertificateAuthorityProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectTlsCertificateAuthorityProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectTlsCertificateAuthorityProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the AWS Private Certificate Authority certificate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlscertificateauthority.html#cfn-ecs-service-serviceconnecttlscertificateauthority-awspcaauthorityarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlscertificateauthority.html#cfn-ecs-service-serviceconnecttlscertificateauthority-awspcaauthorityarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAwsPcaAuthorityArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectTlsCertificateAuthorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectTlsCertificateAuthorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectTlsCertificateAuthorityProperty> {
            java.lang.String awsPcaAuthorityArn;

            /**
             * Sets the value of {@link ServiceConnectTlsCertificateAuthorityProperty#getAwsPcaAuthorityArn}
             * @param awsPcaAuthorityArn The ARN of the AWS Private Certificate Authority certificate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder awsPcaAuthorityArn(java.lang.String awsPcaAuthorityArn) {
                this.awsPcaAuthorityArn = awsPcaAuthorityArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectTlsCertificateAuthorityProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectTlsCertificateAuthorityProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectTlsCertificateAuthorityProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectTlsCertificateAuthorityProperty {
            private final java.lang.String awsPcaAuthorityArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.awsPcaAuthorityArn = software.amazon.jsii.Kernel.get(this, "awsPcaAuthorityArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.awsPcaAuthorityArn = builder.awsPcaAuthorityArn;
            }

            @Override
            public final java.lang.String getAwsPcaAuthorityArn() {
                return this.awsPcaAuthorityArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAwsPcaAuthorityArn() != null) {
                    data.set("awsPcaAuthorityArn", om.valueToTree(this.getAwsPcaAuthorityArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsCertificateAuthorityProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectTlsCertificateAuthorityProperty.Jsii$Proxy that = (ServiceConnectTlsCertificateAuthorityProperty.Jsii$Proxy) o;

                return this.awsPcaAuthorityArn != null ? this.awsPcaAuthorityArn.equals(that.awsPcaAuthorityArn) : that.awsPcaAuthorityArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.awsPcaAuthorityArn != null ? this.awsPcaAuthorityArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * An object that represents the configuration for Service Connect TLS.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceConnectTlsConfigurationProperty serviceConnectTlsConfigurationProperty = ServiceConnectTlsConfigurationProperty.builder()
     *         .issuerCertificateAuthority(ServiceConnectTlsCertificateAuthorityProperty.builder()
     *                 .awsPcaAuthorityArn("awsPcaAuthorityArn")
     *                 .build())
     *         // the properties below are optional
     *         .kmsKey("kmsKey")
     *         .roleArn("roleArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceConnectTlsConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceConnectTlsConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The signer certificate authority.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-issuercertificateauthority">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-issuercertificateauthority</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIssuerCertificateAuthority();

        /**
         * The AWS Key Management Service key.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-kmskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceconnecttlsconfiguration.html#cfn-ecs-service-serviceconnecttlsconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceConnectTlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceConnectTlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceConnectTlsConfigurationProperty> {
            java.lang.Object issuerCertificateAuthority;
            java.lang.String kmsKey;
            java.lang.String roleArn;

            /**
             * Sets the value of {@link ServiceConnectTlsConfigurationProperty#getIssuerCertificateAuthority}
             * @param issuerCertificateAuthority The signer certificate authority. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuerCertificateAuthority(software.amazon.awscdk.IResolvable issuerCertificateAuthority) {
                this.issuerCertificateAuthority = issuerCertificateAuthority;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectTlsConfigurationProperty#getIssuerCertificateAuthority}
             * @param issuerCertificateAuthority The signer certificate authority. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder issuerCertificateAuthority(software.amazon.awscdk.services.ecs.CfnService.ServiceConnectTlsCertificateAuthorityProperty issuerCertificateAuthority) {
                this.issuerCertificateAuthority = issuerCertificateAuthority;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectTlsConfigurationProperty#getKmsKey}
             * @param kmsKey The AWS Key Management Service key.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKey(java.lang.String kmsKey) {
                this.kmsKey = kmsKey;
                return this;
            }

            /**
             * Sets the value of {@link ServiceConnectTlsConfigurationProperty#getRoleArn}
             * @param roleArn The Amazon Resource Name (ARN) of the IAM role that's associated with the Service Connect TLS.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceConnectTlsConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceConnectTlsConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceConnectTlsConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceConnectTlsConfigurationProperty {
            private final java.lang.Object issuerCertificateAuthority;
            private final java.lang.String kmsKey;
            private final java.lang.String roleArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.issuerCertificateAuthority = software.amazon.jsii.Kernel.get(this, "issuerCertificateAuthority", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKey = software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.issuerCertificateAuthority = java.util.Objects.requireNonNull(builder.issuerCertificateAuthority, "issuerCertificateAuthority is required");
                this.kmsKey = builder.kmsKey;
                this.roleArn = builder.roleArn;
            }

            @Override
            public final java.lang.Object getIssuerCertificateAuthority() {
                return this.issuerCertificateAuthority;
            }

            @Override
            public final java.lang.String getKmsKey() {
                return this.kmsKey;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("issuerCertificateAuthority", om.valueToTree(this.getIssuerCertificateAuthority()));
                if (this.getKmsKey() != null) {
                    data.set("kmsKey", om.valueToTree(this.getKmsKey()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceConnectTlsConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceConnectTlsConfigurationProperty.Jsii$Proxy that = (ServiceConnectTlsConfigurationProperty.Jsii$Proxy) o;

                if (!issuerCertificateAuthority.equals(that.issuerCertificateAuthority)) return false;
                if (this.kmsKey != null ? !this.kmsKey.equals(that.kmsKey) : that.kmsKey != null) return false;
                return this.roleArn != null ? this.roleArn.equals(that.roleArn) : that.roleArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.issuerCertificateAuthority.hashCode();
                result = 31 * result + (this.kmsKey != null ? this.kmsKey.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf.
     * <p>
     * These settings are used to create each Amazon EBS volume, with one volume created for each task in the service.
     * <p>
     * Many of these parameters map 1:1 with the Amazon EBS <code>CreateVolume</code> API request parameters.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceManagedEBSVolumeConfigurationProperty serviceManagedEBSVolumeConfigurationProperty = ServiceManagedEBSVolumeConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         // the properties below are optional
     *         .encrypted(false)
     *         .filesystemType("filesystemType")
     *         .iops(123)
     *         .kmsKeyId("kmsKeyId")
     *         .sizeInGiB(123)
     *         .snapshotId("snapshotId")
     *         .tagSpecifications(List.of(EBSTagSpecificationProperty.builder()
     *                 .resourceType("resourceType")
     *                 // the properties below are optional
     *                 .propagateTags("propagateTags")
     *                 .tags(List.of(CfnTag.builder()
     *                         .key("key")
     *                         .value("value")
     *                         .build()))
     *                 .build()))
     *         .throughput(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceManagedEBSVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceManagedEBSVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceManagedEBSVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the IAM role to associate with this volume.
         * <p>
         * This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure. We recommend using the Amazon ECS-managed <code>AmazonECSInfrastructureRolePolicyForVolumes</code> IAM policy with this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS infrastructure IAM role</a> in the <em>Amazon ECS Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * Indicates whether the volume should be encrypted.
         * <p>
         * If no value is specified, encryption is turned on by default. This parameter maps 1:1 with the <code>Encrypted</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-encrypted">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-encrypted</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncrypted() {
            return null;
        }

        /**
         * The Linux filesystem type for the volume.
         * <p>
         * For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the task will fail to start.
         * <p>
         * The available filesystem types are <code>ext3</code> , <code>ext4</code> , and <code>xfs</code> . If no value is specified, the <code>xfs</code> filesystem type is used by default.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-filesystemtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-filesystemtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFilesystemType() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS).
         * <p>
         * For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
         * <p>
         * The following are the supported values for each volume type.
         * <p>
         * <ul>
         * <li><code>gp3</code> : 3,000 - 16,000 IOPS</li>
         * <li><code>io1</code> : 100 - 64,000 IOPS</li>
         * <li><code>io2</code> : 100 - 256,000 IOPS</li>
         * </ul>
         * <p>
         * This parameter is required for <code>io1</code> and <code>io2</code> volume types. The default for <code>gp3</code> volumes is <code>3,000 IOPS</code> . This parameter is not supported for <code>st1</code> , <code>sc1</code> , or <code>standard</code> volume types.
         * <p>
         * This parameter maps 1:1 with the <code>Iops</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) identifier of the AWS Key Management Service key to use for Amazon EBS encryption.
         * <p>
         * When encryption is turned on and no AWS Key Management Service key is specified, the default AWS managed key for Amazon EBS volumes is used. This parameter maps 1:1 with the <code>KmsKeyId</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * <blockquote>
         * <p>
         * AWS authenticates the AWS Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * The size of the volume in GiB.
         * <p>
         * You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the <code>Size</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * The following are the supported volume size values for each volume type.
         * <p>
         * <ul>
         * <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
         * <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
         * <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
         * <li><code>standard</code> : 1-1,024</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-sizeingib">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-sizeingib</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSizeInGiB() {
            return null;
        }

        /**
         * The snapshot that Amazon ECS uses to create the volume.
         * <p>
         * You must specify either a snapshot ID or a volume size. This parameter maps 1:1 with the <code>SnapshotId</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-snapshotid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-snapshotid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSnapshotId() {
            return null;
        }

        /**
         * The tags to apply to the volume.
         * <p>
         * Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the <code>TagSpecifications.N</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-tagspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-tagspecifications</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTagSpecifications() {
            return null;
        }

        /**
         * The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
         * <p>
         * This parameter maps 1:1 with the <code>Throughput</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
         * <p>
         * <blockquote>
         * <p>
         * This parameter is only supported for the <code>gp3</code> volume type.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-throughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * The volume type.
         * <p>
         * This parameter maps 1:1 with the <code>VolumeType</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> .
         * <p>
         * The following are the supported volume types.
         * <p>
         * <ul>
         * <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
         * <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
         * <li>Throughput Optimized HDD: <code>st1</code></li>
         * <li>Cold HDD: <code>sc1</code></li>
         * <li>Magnetic: <code>standard</code></li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * The magnetic volume type is not supported on Fargate.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicemanagedebsvolumeconfiguration.html#cfn-ecs-service-servicemanagedebsvolumeconfiguration-volumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceManagedEBSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceManagedEBSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceManagedEBSVolumeConfigurationProperty> {
            java.lang.String roleArn;
            java.lang.Object encrypted;
            java.lang.String filesystemType;
            java.lang.Number iops;
            java.lang.String kmsKeyId;
            java.lang.Number sizeInGiB;
            java.lang.String snapshotId;
            java.lang.Object tagSpecifications;
            java.lang.Number throughput;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of the IAM role to associate with this volume. This parameter is required.
             *                This is the Amazon ECS infrastructure IAM role that is used to manage your AWS infrastructure. We recommend using the Amazon ECS-managed <code>AmazonECSInfrastructureRolePolicyForVolumes</code> IAM policy with this role. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/infrastructure_IAM_role.html">Amazon ECS infrastructure IAM role</a> in the <em>Amazon ECS Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getEncrypted}
             * @param encrypted Indicates whether the volume should be encrypted.
             *                  If no value is specified, encryption is turned on by default. This parameter maps 1:1 with the <code>Encrypted</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(java.lang.Boolean encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getEncrypted}
             * @param encrypted Indicates whether the volume should be encrypted.
             *                  If no value is specified, encryption is turned on by default. This parameter maps 1:1 with the <code>Encrypted</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encrypted(software.amazon.awscdk.IResolvable encrypted) {
                this.encrypted = encrypted;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getFilesystemType}
             * @param filesystemType The Linux filesystem type for the volume.
             *                       For volumes created from a snapshot, you must specify the same filesystem type that the volume was using when the snapshot was created. If there is a filesystem type mismatch, the task will fail to start.
             *                       <p>
             *                       The available filesystem types are <code>ext3</code> , <code>ext4</code> , and <code>xfs</code> . If no value is specified, the <code>xfs</code> filesystem type is used by default.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder filesystemType(java.lang.String filesystemType) {
                this.filesystemType = filesystemType;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS).
             *             For <code>gp3</code> , <code>io1</code> , and <code>io2</code> volumes, this represents the number of IOPS that are provisioned for the volume. For <code>gp2</code> volumes, this represents the baseline performance of the volume and the rate at which the volume accumulates I/O credits for bursting.
             *             <p>
             *             The following are the supported values for each volume type.
             *             <p>
             *             <ul>
             *             <li><code>gp3</code> : 3,000 - 16,000 IOPS</li>
             *             <li><code>io1</code> : 100 - 64,000 IOPS</li>
             *             <li><code>io2</code> : 100 - 256,000 IOPS</li>
             *             </ul>
             *             <p>
             *             This parameter is required for <code>io1</code> and <code>io2</code> volume types. The default for <code>gp3</code> volumes is <code>3,000 IOPS</code> . This parameter is not supported for <code>st1</code> , <code>sc1</code> , or <code>standard</code> volume types.
             *             <p>
             *             This parameter maps 1:1 with the <code>Iops</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getKmsKeyId}
             * @param kmsKeyId The Amazon Resource Name (ARN) identifier of the AWS Key Management Service key to use for Amazon EBS encryption.
             *                 When encryption is turned on and no AWS Key Management Service key is specified, the default AWS managed key for Amazon EBS volumes is used. This parameter maps 1:1 with the <code>KmsKeyId</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             *                 <p>
             *                 <blockquote>
             *                 <p>
             *                 AWS authenticates the AWS Key Management Service key asynchronously. Therefore, if you specify an ID, alias, or ARN that is invalid, the action can appear to complete, but eventually fails.
             *                 <p>
             *                 </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getSizeInGiB}
             * @param sizeInGiB The size of the volume in GiB.
             *                  You must specify either a volume size or a snapshot ID. If you specify a snapshot ID, the snapshot size is used for the volume size by default. You can optionally specify a volume size greater than or equal to the snapshot size. This parameter maps 1:1 with the <code>Size</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             *                  <p>
             *                  The following are the supported volume size values for each volume type.
             *                  <p>
             *                  <ul>
             *                  <li><code>gp2</code> and <code>gp3</code> : 1-16,384</li>
             *                  <li><code>io1</code> and <code>io2</code> : 4-16,384</li>
             *                  <li><code>st1</code> and <code>sc1</code> : 125-16,384</li>
             *                  <li><code>standard</code> : 1-1,024</li>
             *                  </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sizeInGiB(java.lang.Number sizeInGiB) {
                this.sizeInGiB = sizeInGiB;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getSnapshotId}
             * @param snapshotId The snapshot that Amazon ECS uses to create the volume.
             *                   You must specify either a snapshot ID or a volume size. This parameter maps 1:1 with the <code>SnapshotId</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snapshotId(java.lang.String snapshotId) {
                this.snapshotId = snapshotId;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply to the volume.
             *                          Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the <code>TagSpecifications.N</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(software.amazon.awscdk.IResolvable tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getTagSpecifications}
             * @param tagSpecifications The tags to apply to the volume.
             *                          Amazon ECS applies service-managed tags by default. This parameter maps 1:1 with the <code>TagSpecifications.N</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tagSpecifications(java.util.List<? extends java.lang.Object> tagSpecifications) {
                this.tagSpecifications = tagSpecifications;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getThroughput}
             * @param throughput The throughput to provision for a volume, in MiB/s, with a maximum of 1,000 MiB/s.
             *                   This parameter maps 1:1 with the <code>Throughput</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> .
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   This parameter is only supported for the <code>gp3</code> volume type.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Sets the value of {@link ServiceManagedEBSVolumeConfigurationProperty#getVolumeType}
             * @param volumeType The volume type.
             *                   This parameter maps 1:1 with the <code>VolumeType</code> parameter of the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateVolume.html">CreateVolume API</a> in the <em>Amazon EC2 API Reference</em> . For more information, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-volume-types.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide</em> .
             *                   <p>
             *                   The following are the supported volume types.
             *                   <p>
             *                   <ul>
             *                   <li>General Purpose SSD: <code>gp2</code> | <code>gp3</code></li>
             *                   <li>Provisioned IOPS SSD: <code>io1</code> | <code>io2</code></li>
             *                   <li>Throughput Optimized HDD: <code>st1</code></li>
             *                   <li>Cold HDD: <code>sc1</code></li>
             *                   <li>Magnetic: <code>standard</code></li>
             *                   </ul>
             *                   <p>
             *                   <blockquote>
             *                   <p>
             *                   The magnetic volume type is not supported on Fargate.
             *                   <p>
             *                   </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceManagedEBSVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceManagedEBSVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceManagedEBSVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceManagedEBSVolumeConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.lang.Object encrypted;
            private final java.lang.String filesystemType;
            private final java.lang.Number iops;
            private final java.lang.String kmsKeyId;
            private final java.lang.Number sizeInGiB;
            private final java.lang.String snapshotId;
            private final java.lang.Object tagSpecifications;
            private final java.lang.Number throughput;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.encrypted = software.amazon.jsii.Kernel.get(this, "encrypted", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.filesystemType = software.amazon.jsii.Kernel.get(this, "filesystemType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sizeInGiB = software.amazon.jsii.Kernel.get(this, "sizeInGiB", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.snapshotId = software.amazon.jsii.Kernel.get(this, "snapshotId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tagSpecifications = software.amazon.jsii.Kernel.get(this, "tagSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.encrypted = builder.encrypted;
                this.filesystemType = builder.filesystemType;
                this.iops = builder.iops;
                this.kmsKeyId = builder.kmsKeyId;
                this.sizeInGiB = builder.sizeInGiB;
                this.snapshotId = builder.snapshotId;
                this.tagSpecifications = builder.tagSpecifications;
                this.throughput = builder.throughput;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.Object getEncrypted() {
                return this.encrypted;
            }

            @Override
            public final java.lang.String getFilesystemType() {
                return this.filesystemType;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            public final java.lang.Number getSizeInGiB() {
                return this.sizeInGiB;
            }

            @Override
            public final java.lang.String getSnapshotId() {
                return this.snapshotId;
            }

            @Override
            public final java.lang.Object getTagSpecifications() {
                return this.tagSpecifications;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                if (this.getEncrypted() != null) {
                    data.set("encrypted", om.valueToTree(this.getEncrypted()));
                }
                if (this.getFilesystemType() != null) {
                    data.set("filesystemType", om.valueToTree(this.getFilesystemType()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }
                if (this.getSizeInGiB() != null) {
                    data.set("sizeInGiB", om.valueToTree(this.getSizeInGiB()));
                }
                if (this.getSnapshotId() != null) {
                    data.set("snapshotId", om.valueToTree(this.getSnapshotId()));
                }
                if (this.getTagSpecifications() != null) {
                    data.set("tagSpecifications", om.valueToTree(this.getTagSpecifications()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceManagedEBSVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceManagedEBSVolumeConfigurationProperty.Jsii$Proxy that = (ServiceManagedEBSVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (this.encrypted != null ? !this.encrypted.equals(that.encrypted) : that.encrypted != null) return false;
                if (this.filesystemType != null ? !this.filesystemType.equals(that.filesystemType) : that.filesystemType != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
                if (this.sizeInGiB != null ? !this.sizeInGiB.equals(that.sizeInGiB) : that.sizeInGiB != null) return false;
                if (this.snapshotId != null ? !this.snapshotId.equals(that.snapshotId) : that.snapshotId != null) return false;
                if (this.tagSpecifications != null ? !this.tagSpecifications.equals(that.tagSpecifications) : that.tagSpecifications != null) return false;
                if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.encrypted != null ? this.encrypted.hashCode() : 0);
                result = 31 * result + (this.filesystemType != null ? this.filesystemType.hashCode() : 0);
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                result = 31 * result + (this.sizeInGiB != null ? this.sizeInGiB.hashCode() : 0);
                result = 31 * result + (this.snapshotId != null ? this.snapshotId.hashCode() : 0);
                result = 31 * result + (this.tagSpecifications != null ? this.tagSpecifications.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The details for the service registry.
     * <p>
     * Each service may be associated with one service registry. Multiple service registries for each service are not supported.
     * <p>
     * When you add, update, or remove the service registries configuration, Amazon ECS starts a new deployment. New tasks are registered and deregistered to the updated service registry configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceRegistryProperty serviceRegistryProperty = ServiceRegistryProperty.builder()
     *         .containerName("containerName")
     *         .containerPort(123)
     *         .port(123)
     *         .registryArn("registryArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceRegistryProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceRegistryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceRegistryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The container name value to be used for your service discovery service.
         * <p>
         * It's already specified in the task definition. If the task definition that your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition that your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getContainerName() {
            return null;
        }

        /**
         * The port value to be used for your service discovery service.
         * <p>
         * It's already specified in the task definition. If the task definition your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containerport">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-containerport</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getContainerPort() {
            return null;
        }

        /**
         * The port value used if your service discovery service specified an SRV record.
         * <p>
         * This field might be used if both the <code>awsvpc</code> network mode and SRV records are used.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the service registry.
         * <p>
         * The currently supported service registry is AWS Cloud Map . For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-registryarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-serviceregistry.html#cfn-ecs-service-serviceregistry-registryarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRegistryArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceRegistryProperty> {
            java.lang.String containerName;
            java.lang.Number containerPort;
            java.lang.Number port;
            java.lang.String registryArn;

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerName}
             * @param containerName The container name value to be used for your service discovery service.
             *                      It's already specified in the task definition. If the task definition that your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition that your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerName(java.lang.String containerName) {
                this.containerName = containerName;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getContainerPort}
             * @param containerPort The port value to be used for your service discovery service.
             *                      It's already specified in the task definition. If the task definition your service task specifies uses the <code>bridge</code> or <code>host</code> network mode, you must specify a <code>containerName</code> and <code>containerPort</code> combination from the task definition. If the task definition your service task specifies uses the <code>awsvpc</code> network mode and a type SRV DNS record is used, you must specify either a <code>containerName</code> and <code>containerPort</code> combination or a <code>port</code> value. However, you can't specify both.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder containerPort(java.lang.Number containerPort) {
                this.containerPort = containerPort;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getPort}
             * @param port The port value used if your service discovery service specified an SRV record.
             *             This field might be used if both the <code>awsvpc</code> network mode and SRV records are used.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link ServiceRegistryProperty#getRegistryArn}
             * @param registryArn The Amazon Resource Name (ARN) of the service registry.
             *                    The currently supported service registry is AWS Cloud Map . For more information, see <a href="https://docs.aws.amazon.com/cloud-map/latest/api/API_CreateService.html">CreateService</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder registryArn(java.lang.String registryArn) {
                this.registryArn = registryArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceRegistryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceRegistryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceRegistryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceRegistryProperty {
            private final java.lang.String containerName;
            private final java.lang.Number containerPort;
            private final java.lang.Number port;
            private final java.lang.String registryArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.containerName = software.amazon.jsii.Kernel.get(this, "containerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.containerPort = software.amazon.jsii.Kernel.get(this, "containerPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.registryArn = software.amazon.jsii.Kernel.get(this, "registryArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.containerName = builder.containerName;
                this.containerPort = builder.containerPort;
                this.port = builder.port;
                this.registryArn = builder.registryArn;
            }

            @Override
            public final java.lang.String getContainerName() {
                return this.containerName;
            }

            @Override
            public final java.lang.Number getContainerPort() {
                return this.containerPort;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.String getRegistryArn() {
                return this.registryArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getContainerName() != null) {
                    data.set("containerName", om.valueToTree(this.getContainerName()));
                }
                if (this.getContainerPort() != null) {
                    data.set("containerPort", om.valueToTree(this.getContainerPort()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getRegistryArn() != null) {
                    data.set("registryArn", om.valueToTree(this.getRegistryArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceRegistryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceRegistryProperty.Jsii$Proxy that = (ServiceRegistryProperty.Jsii$Proxy) o;

                if (this.containerName != null ? !this.containerName.equals(that.containerName) : that.containerName != null) return false;
                if (this.containerPort != null ? !this.containerPort.equals(that.containerPort) : that.containerPort != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.registryArn != null ? this.registryArn.equals(that.registryArn) : that.registryArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.containerName != null ? this.containerName.hashCode() : 0;
                result = 31 * result + (this.containerPort != null ? this.containerPort.hashCode() : 0);
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.registryArn != null ? this.registryArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
     * <p>
     * Currently, the only supported volume type is an Amazon EBS volume.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * ServiceVolumeConfigurationProperty serviceVolumeConfigurationProperty = ServiceVolumeConfigurationProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .managedEbsVolume(ServiceManagedEBSVolumeConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 // the properties below are optional
     *                 .encrypted(false)
     *                 .filesystemType("filesystemType")
     *                 .iops(123)
     *                 .kmsKeyId("kmsKeyId")
     *                 .sizeInGiB(123)
     *                 .snapshotId("snapshotId")
     *                 .tagSpecifications(List.of(EBSTagSpecificationProperty.builder()
     *                         .resourceType("resourceType")
     *                         // the properties below are optional
     *                         .propagateTags("propagateTags")
     *                         .tags(List.of(CfnTag.builder()
     *                                 .key("key")
     *                                 .value("value")
     *                                 .build()))
     *                         .build()))
     *                 .throughput(123)
     *                 .volumeType("volumeType")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.ServiceVolumeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceVolumeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceVolumeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the volume.
         * <p>
         * This value must match the volume name from the <code>Volume</code> object in the task definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html#cfn-ecs-service-servicevolumeconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html#cfn-ecs-service-servicevolumeconfiguration-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf.
         * <p>
         * These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html#cfn-ecs-service-servicevolumeconfiguration-managedebsvolume">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-servicevolumeconfiguration.html#cfn-ecs-service-servicevolumeconfiguration-managedebsvolume</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getManagedEbsVolume() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceVolumeConfigurationProperty> {
            java.lang.String name;
            java.lang.Object managedEbsVolume;

            /**
             * Sets the value of {@link ServiceVolumeConfigurationProperty#getName}
             * @param name The name of the volume. This parameter is required.
             *             This value must match the volume name from the <code>Volume</code> object in the task definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link ServiceVolumeConfigurationProperty#getManagedEbsVolume}
             * @param managedEbsVolume The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf.
             *                         These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedEbsVolume(software.amazon.awscdk.IResolvable managedEbsVolume) {
                this.managedEbsVolume = managedEbsVolume;
                return this;
            }

            /**
             * Sets the value of {@link ServiceVolumeConfigurationProperty#getManagedEbsVolume}
             * @param managedEbsVolume The configuration for the Amazon EBS volume that Amazon ECS creates and manages on your behalf.
             *                         These settings are used to create each Amazon EBS volume, with one volume created for each task in the service. The Amazon EBS volumes are visible in your account in the Amazon EC2 console once they are created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder managedEbsVolume(software.amazon.awscdk.services.ecs.CfnService.ServiceManagedEBSVolumeConfigurationProperty managedEbsVolume) {
                this.managedEbsVolume = managedEbsVolume;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceVolumeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceVolumeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceVolumeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceVolumeConfigurationProperty {
            private final java.lang.String name;
            private final java.lang.Object managedEbsVolume;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.managedEbsVolume = software.amazon.jsii.Kernel.get(this, "managedEbsVolume", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.managedEbsVolume = builder.managedEbsVolume;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.Object getManagedEbsVolume() {
                return this.managedEbsVolume;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getManagedEbsVolume() != null) {
                    data.set("managedEbsVolume", om.valueToTree(this.getManagedEbsVolume()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.ServiceVolumeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceVolumeConfigurationProperty.Jsii$Proxy that = (ServiceVolumeConfigurationProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.managedEbsVolume != null ? this.managedEbsVolume.equals(that.managedEbsVolume) : that.managedEbsVolume == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.managedEbsVolume != null ? this.managedEbsVolume.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the timeout configurations for Service Connect.
     * <p>
     * <blockquote>
     * <p>
     * If <code>idleTimeout</code> is set to a time that is less than <code>perRequestTimeout</code> , the connection will close when the <code>idleTimeout</code> is reached and not the <code>perRequestTimeout</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ecs.*;
     * TimeoutConfigurationProperty timeoutConfigurationProperty = TimeoutConfigurationProperty.builder()
     *         .idleTimeoutSeconds(123)
     *         .perRequestTimeoutSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnService.TimeoutConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeoutConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeoutConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time in seconds a connection will stay active while idle.
         * <p>
         * A value of <code>0</code> can be set to disable <code>idleTimeout</code> .
         * <p>
         * The <code>idleTimeout</code> default for <code>HTTP</code> / <code>HTTP2</code> / <code>GRPC</code> is 5 minutes.
         * <p>
         * The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html#cfn-ecs-service-timeoutconfiguration-idletimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html#cfn-ecs-service-timeoutconfiguration-idletimeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIdleTimeoutSeconds() {
            return null;
        }

        /**
         * The amount of time waiting for the upstream to respond with a complete response per request.
         * <p>
         * A value of <code>0</code> can be set to disable <code>perRequestTimeout</code> . <code>perRequestTimeout</code> can only be set if Service Connect <code>appProtocol</code> isn't <code>TCP</code> . Only <code>idleTimeout</code> is allowed for <code>TCP</code> <code>appProtocol</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html#cfn-ecs-service-timeoutconfiguration-perrequesttimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ecs-service-timeoutconfiguration.html#cfn-ecs-service-timeoutconfiguration-perrequesttimeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPerRequestTimeoutSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TimeoutConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeoutConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeoutConfigurationProperty> {
            java.lang.Number idleTimeoutSeconds;
            java.lang.Number perRequestTimeoutSeconds;

            /**
             * Sets the value of {@link TimeoutConfigurationProperty#getIdleTimeoutSeconds}
             * @param idleTimeoutSeconds The amount of time in seconds a connection will stay active while idle.
             *                           A value of <code>0</code> can be set to disable <code>idleTimeout</code> .
             *                           <p>
             *                           The <code>idleTimeout</code> default for <code>HTTP</code> / <code>HTTP2</code> / <code>GRPC</code> is 5 minutes.
             *                           <p>
             *                           The <code>idleTimeout</code> default for <code>TCP</code> is 1 hour.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idleTimeoutSeconds(java.lang.Number idleTimeoutSeconds) {
                this.idleTimeoutSeconds = idleTimeoutSeconds;
                return this;
            }

            /**
             * Sets the value of {@link TimeoutConfigurationProperty#getPerRequestTimeoutSeconds}
             * @param perRequestTimeoutSeconds The amount of time waiting for the upstream to respond with a complete response per request.
             *                                 A value of <code>0</code> can be set to disable <code>perRequestTimeout</code> . <code>perRequestTimeout</code> can only be set if Service Connect <code>appProtocol</code> isn't <code>TCP</code> . Only <code>idleTimeout</code> is allowed for <code>TCP</code> <code>appProtocol</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder perRequestTimeoutSeconds(java.lang.Number perRequestTimeoutSeconds) {
                this.perRequestTimeoutSeconds = perRequestTimeoutSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeoutConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeoutConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeoutConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeoutConfigurationProperty {
            private final java.lang.Number idleTimeoutSeconds;
            private final java.lang.Number perRequestTimeoutSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idleTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "idleTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.perRequestTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "perRequestTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idleTimeoutSeconds = builder.idleTimeoutSeconds;
                this.perRequestTimeoutSeconds = builder.perRequestTimeoutSeconds;
            }

            @Override
            public final java.lang.Number getIdleTimeoutSeconds() {
                return this.idleTimeoutSeconds;
            }

            @Override
            public final java.lang.Number getPerRequestTimeoutSeconds() {
                return this.perRequestTimeoutSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIdleTimeoutSeconds() != null) {
                    data.set("idleTimeoutSeconds", om.valueToTree(this.getIdleTimeoutSeconds()));
                }
                if (this.getPerRequestTimeoutSeconds() != null) {
                    data.set("perRequestTimeoutSeconds", om.valueToTree(this.getPerRequestTimeoutSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnService.TimeoutConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeoutConfigurationProperty.Jsii$Proxy that = (TimeoutConfigurationProperty.Jsii$Proxy) o;

                if (this.idleTimeoutSeconds != null ? !this.idleTimeoutSeconds.equals(that.idleTimeoutSeconds) : that.idleTimeoutSeconds != null) return false;
                return this.perRequestTimeoutSeconds != null ? this.perRequestTimeoutSeconds.equals(that.perRequestTimeoutSeconds) : that.perRequestTimeoutSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idleTimeoutSeconds != null ? this.idleTimeoutSeconds.hashCode() : 0;
                result = 31 * result + (this.perRequestTimeoutSeconds != null ? this.perRequestTimeoutSeconds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.CfnService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.CfnService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.CfnServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The capacity provider strategy to use for the service.
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * <p>
         * A capacity provider strategy may contain a maximum of 6 capacity providers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy</a>
         * @param capacityProviderStrategy The capacity provider strategy to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategy(final software.amazon.awscdk.IResolvable capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }
        /**
         * The capacity provider strategy to use for the service.
         * <p>
         * If a <code>capacityProviderStrategy</code> is specified, the <code>launchType</code> parameter must be omitted. If no <code>capacityProviderStrategy</code> or <code>launchType</code> is specified, the <code>defaultCapacityProviderStrategy</code> for the cluster is used.
         * <p>
         * A capacity provider strategy may contain a maximum of 6 capacity providers.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-capacityproviderstrategy</a>
         * @param capacityProviderStrategy The capacity provider strategy to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategy(final java.util.List<? extends java.lang.Object> capacityProviderStrategy) {
            this.props().capacityProviderStrategy(capacityProviderStrategy);
            return this;
        }

        /**
         * The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on.
         * <p>
         * If you do not specify a cluster, the default cluster is assumed.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-cluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-cluster</a>
         * @param cluster The short name or full Amazon Resource Name (ARN) of the cluster that you run your service on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final java.lang.String cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration</a>
         * @param deploymentConfiguration Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.IResolvable deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }
        /**
         * Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentconfiguration</a>
         * @param deploymentConfiguration Optional deployment parameters that control how many tasks run during the deployment and the ordering of stopping and starting tasks. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfiguration(final software.amazon.awscdk.services.ecs.CfnService.DeploymentConfigurationProperty deploymentConfiguration) {
            this.props().deploymentConfiguration(deploymentConfiguration);
            return this;
        }

        /**
         * The deployment controller to use for the service.
         * <p>
         * If no deployment controller is specified, the default value of <code>ECS</code> is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller</a>
         * @param deploymentController The deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.IResolvable deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }
        /**
         * The deployment controller to use for the service.
         * <p>
         * If no deployment controller is specified, the default value of <code>ECS</code> is used.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-deploymentcontroller</a>
         * @param deploymentController The deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.CfnService.DeploymentControllerProperty deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        /**
         * The number of instantiations of the specified task definition to place and keep running in your service.
         * <p>
         * For new services, if a desired count is not specified, a default value of <code>1</code> is used. When using the <code>DAEMON</code> scheduling strategy, the desired count is not required.
         * <p>
         * For existing services, if a desired count is not specified, it is omitted from the operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-desiredcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-desiredcount</a>
         * @param desiredCount The number of instantiations of the specified task definition to place and keep running in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder desiredCount(final java.lang.Number desiredCount) {
            this.props().desiredCount(desiredCount);
            return this;
        }

        /**
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags</a>
         * @param enableEcsManagedTags Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }
        /**
         * Specifies whether to turn on Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging your Amazon ECS resources</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * When you use Amazon ECS managed tags, you need to set the <code>propagateTags</code> request parameter.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableecsmanagedtags</a>
         * @param enableEcsManagedTags Specifies whether to turn on Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final software.amazon.awscdk.IResolvable enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Determines whether the execute command functionality is turned on for the service.
         * <p>
         * If <code>true</code> , the execute command functionality is turned on for all containers in tasks as part of the service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableexecutecommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableexecutecommand</a>
         * @param enableExecuteCommand Determines whether the execute command functionality is turned on for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }
        /**
         * Determines whether the execute command functionality is turned on for the service.
         * <p>
         * If <code>true</code> , the execute command functionality is turned on for all containers in tasks as part of the service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableexecutecommand">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-enableexecutecommand</a>
         * @param enableExecuteCommand Determines whether the execute command functionality is turned on for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final software.amazon.awscdk.IResolvable enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started.
         * <p>
         * This is only used when your service is configured to use a load balancer. If your service has a load balancer defined and you don't specify a health check grace period value, the default value of <code>0</code> is used.
         * <p>
         * If you do not use an Elastic Load Balancing, we recommend that you use the <code>startPeriod</code> in the task definition health check parameters. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_HealthCheck.html">Health check</a> .
         * <p>
         * If your service's tasks take a while to start and respond to Elastic Load Balancing health checks, you can specify a health check grace period of up to 2,147,483,647 seconds (about 69 years). During that time, the Amazon ECS service scheduler ignores health check status. This grace period can prevent the service scheduler from marking tasks as unhealthy and stopping them before they have time to come up.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-healthcheckgraceperiodseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-healthcheckgraceperiodseconds</a>
         * @param healthCheckGracePeriodSeconds The period of time, in seconds, that the Amazon ECS service scheduler ignores unhealthy Elastic Load Balancing target health checks after a task has first started. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheckGracePeriodSeconds(final java.lang.Number healthCheckGracePeriodSeconds) {
            this.props().healthCheckGracePeriodSeconds(healthCheckGracePeriodSeconds);
            return this;
        }

        /**
         * The launch type on which to run your service.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS Launch Types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-launchtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-launchtype</a>
         * @param launchType The launch type on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder launchType(final java.lang.String launchType) {
            this.props().launchType(launchType);
            return this;
        }

        /**
         * A list of load balancer objects to associate with the service.
         * <p>
         * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers</a>
         * @param loadBalancers A list of load balancer objects to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final software.amazon.awscdk.IResolvable loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }
        /**
         * A list of load balancer objects to associate with the service.
         * <p>
         * If you specify the <code>Role</code> property, <code>LoadBalancers</code> must be specified as well. For information about the number of load balancers that you can specify per service, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-load-balancing.html">Service Load Balancing</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-loadbalancers</a>
         * @param loadBalancers A list of load balancer objects to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancers(final java.util.List<? extends java.lang.Object> loadBalancers) {
            this.props().loadBalancers(loadBalancers);
            return this;
        }

        /**
         * The network configuration for the service.
         * <p>
         * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration</a>
         * @param networkConfiguration The network configuration for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The network configuration for the service.
         * <p>
         * This parameter is required for task definitions that use the <code>awsvpc</code> network mode to receive their own elastic network interface, and it is not supported for other network modes. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-networkconfiguration</a>
         * @param networkConfiguration The network configuration for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.ecs.CfnService.NetworkConfigurationProperty networkConfiguration) {
            this.props().networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * An array of placement constraint objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints</a>
         * @param placementConstraints An array of placement constraint objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final software.amazon.awscdk.IResolvable placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }
        /**
         * An array of placement constraint objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 10 constraints for each task. This limit includes constraints in the task definition and those specified at runtime.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementconstraints</a>
         * @param placementConstraints An array of placement constraint objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(final java.util.List<? extends java.lang.Object> placementConstraints) {
            this.props().placementConstraints(placementConstraints);
            return this;
        }

        /**
         * The placement strategy objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 5 strategy rules for each service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies</a>
         * @param placementStrategies The placement strategy objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementStrategies(final software.amazon.awscdk.IResolvable placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }
        /**
         * The placement strategy objects to use for tasks in your service.
         * <p>
         * You can specify a maximum of 5 strategy rules for each service.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-placementstrategies</a>
         * @param placementStrategies The placement strategy objects to use for tasks in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementStrategies(final java.util.List<? extends java.lang.Object> placementStrategies) {
            this.props().placementStrategies(placementStrategies);
            return this;
        }

        /**
         * The platform version that your tasks in the service are running on.
         * <p>
         * A platform version is specified only for tasks using the Fargate launch type. If one isn't specified, the <code>LATEST</code> platform version is used. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate platform versions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * Default: - "LATEST"
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-platformversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-platformversion</a>
         * @param platformVersion The platform version that your tasks in the service are running on. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final java.lang.String platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition to the task.
         * <p>
         * If no value is specified, the tags aren't propagated. Tags can only be propagated to the task during task creation. To add tags to a task after task creation, use the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_TagResource.html">TagResource</a> API action.
         * <p>
         * You must set this to a value other than <code>NONE</code> when you use Cost Explorer. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/usage-reports.html">Amazon ECS usage reports</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * The default is <code>NONE</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-propagatetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-propagatetags</a>
         * @param propagateTags Specifies whether to propagate the tags from the task definition to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.String propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf.
         * <p>
         * This parameter is only permitted if you are using a load balancer with your service and your task definition doesn't use the <code>awsvpc</code> network mode. If you specify the <code>role</code> parameter, you must also specify a load balancer object with the <code>loadBalancers</code> parameter.
         * <p>
         * <blockquote>
         * <p>
         * If your account has already created the Amazon ECS service-linked role, that role is used for your service unless you specify a role here. The service-linked role is required if your task definition uses the <code>awsvpc</code> network mode or if the service is configured to use service discovery, an external deployment controller, multiple target groups, or Elastic Inference accelerators in which case you don't specify a role here. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html">Using service-linked roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * </blockquote>
         * <p>
         * If your specified role has a path other than <code>/</code> , then you must either specify the full role ARN (this is recommended) or prefix the role name with the path. For example, if a role with the name <code>bar</code> has a path of <code>/foo/</code> then you would specify <code>/foo/bar</code> as the role name. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html#identifiers-friendly-names">Friendly names and paths</a> in the <em>IAM User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-role</a>
         * @param role The name or full Amazon Resource Name (ARN) of the IAM role that allows Amazon ECS to make calls to your load balancer on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final java.lang.String role) {
            this.props().role(role);
            return this;
        }

        /**
         * The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a> .
         * <p>
         * There are two service scheduler strategies available:
         * <p>
         * <ul>
         * <li><code>REPLICA</code> -The replica scheduling strategy places and maintains the desired number of tasks across your cluster. By default, the service scheduler spreads tasks across Availability Zones. You can use task placement strategies and constraints to customize task placement decisions. This scheduler strategy is required if the service uses the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types.</li>
         * <li><code>DAEMON</code> -The daemon scheduling strategy deploys exactly one task on each active container instance that meets all of the task placement constraints that you specify in your cluster. The service scheduler also evaluates the task placement constraints for running tasks and will stop tasks that don't meet the placement constraints. When you're using this strategy, you don't need to specify a desired number of tasks, a task placement strategy, or use Service Auto Scaling policies.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Tasks using the Fargate launch type or the <code>CODE_DEPLOY</code> or <code>EXTERNAL</code> deployment controller types don't support the <code>DAEMON</code> scheduling strategy.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-schedulingstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-schedulingstrategy</a>
         * @param schedulingStrategy The scheduling strategy to use for the service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs_services.html">Services</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingStrategy(final java.lang.String schedulingStrategy) {
            this.props().schedulingStrategy(schedulingStrategy);
            return this;
        }

        /**
         * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceconnectconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceconnectconfiguration</a>
         * @param serviceConnectConfiguration The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectConfiguration(final software.amazon.awscdk.IResolvable serviceConnectConfiguration) {
            this.props().serviceConnectConfiguration(serviceConnectConfiguration);
            return this;
        }
        /**
         * The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace.
         * <p>
         * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceconnectconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceconnectconfiguration</a>
         * @param serviceConnectConfiguration The configuration for this service to discover and connect to services, and be discovered by, and connected from, other services within a namespace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectConfiguration(final software.amazon.awscdk.services.ecs.CfnService.ServiceConnectConfigurationProperty serviceConnectConfiguration) {
            this.props().serviceConnectConfiguration(serviceConnectConfiguration);
            return this;
        }

        /**
         * The name of your service.
         * <p>
         * Up to 255 letters (uppercase and lowercase), numbers, underscores, and hyphens are allowed. Service names must be unique within a cluster, but you can have similarly named services in multiple clusters within a Region or across multiple Regions.
         * <p>
         * <blockquote>
         * <p>
         * The stack update fails if you change any properties that require replacement and the <code>ServiceName</code> is configured. This is because AWS CloudFormation creates the replacement service first, but each <code>ServiceName</code> must be unique in the cluster.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-servicename</a>
         * @param serviceName The name of your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> .
         * <p>
         * <blockquote>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries</a>
         * @param serviceRegistries The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final software.amazon.awscdk.IResolvable serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }
        /**
         * The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> .
         * <p>
         * <blockquote>
         * <p>
         * Each service may be associated with one service registry. Multiple service registries for each service isn't supported.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-serviceregistries</a>
         * @param serviceRegistries The details of the service discovery registry to associate with this service. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html">Service discovery</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceRegistries(final java.util.List<? extends java.lang.Object> serviceRegistries) {
            this.props().serviceRegistries(serviceRegistries);
            return this;
        }

        /**
         * The metadata that you apply to the service to help you categorize and organize them.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When a service is deleted, the tags are deleted as well.
         * <p>
         * The following basic restrictions apply to tags:
         * <p>
         * <ul>
         * <li>Maximum number of tags per resource - 50</li>
         * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-tags</a>
         * @param tags The metadata that you apply to the service to help you categorize and organize them. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The <code>family</code> and <code>revision</code> ( <code>family:revision</code> ) or full ARN of the task definition to run in your service.
         * <p>
         * If a <code>revision</code> isn't specified, the latest <code>ACTIVE</code> revision is used.
         * <p>
         * A task definition must be specified if the service uses either the <code>ECS</code> or <code>CODE_DEPLOY</code> deployment controllers.
         * <p>
         * For more information about deployment types, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS deployment types</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-taskdefinition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-taskdefinition</a>
         * @param taskDefinition The <code>family</code> and <code>revision</code> ( <code>family:revision</code> ) or full ARN of the task definition to run in your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final java.lang.String taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
         * <p>
         * Currently, the only supported volume type is an Amazon EBS volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-volumeconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-volumeconfigurations</a>
         * @param volumeConfigurations The configuration for a volume specified in the task definition as a volume that is configured at launch time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(final software.amazon.awscdk.IResolvable volumeConfigurations) {
            this.props().volumeConfigurations(volumeConfigurations);
            return this;
        }
        /**
         * The configuration for a volume specified in the task definition as a volume that is configured at launch time.
         * <p>
         * Currently, the only supported volume type is an Amazon EBS volume.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-volumeconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-service.html#cfn-ecs-service-volumeconfigurations</a>
         * @param volumeConfigurations The configuration for a volume specified in the task definition as a volume that is configured at launch time. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeConfigurations(final java.util.List<? extends java.lang.Object> volumeConfigurations) {
            this.props().volumeConfigurations(volumeConfigurations);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.CfnService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.CfnService build() {
            return new software.amazon.awscdk.services.ecs.CfnService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.CfnServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.CfnServiceProps.Builder();
            }
            return this.props;
        }
    }
}
