package software.amazon.awscdk.services.ecs;

/**
 * FileSystemType for Service Managed EBS Volume Configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition = new FargateTaskDefinition(this, "TaskDef");
 * ContainerDefinition container = taskDefinition.addContainer("web", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("amazon/amazon-ecs-sample"))
 *         .portMappings(List.of(PortMapping.builder()
 *                 .containerPort(80)
 *                 .protocol(Protocol.TCP)
 *                 .build()))
 *         .build());
 * ServiceManagedVolume volume = ServiceManagedVolume.Builder.create(this, "EBSVolume")
 *         .name("ebs1")
 *         .managedEBSVolume(ServiceManagedEBSVolumeConfiguration.builder()
 *                 .size(Size.gibibytes(15))
 *                 .volumeType(EbsDeviceVolumeType.GP3)
 *                 .fileSystemType(FileSystemType.XFS)
 *                 .tagSpecifications(List.of(EBSTagSpecification.builder()
 *                         .tags(Map.of(
 *                                 "purpose", "production"))
 *                         .propagateTags(EbsPropagatedTagSource.SERVICE)
 *                         .build()))
 *                 .build())
 *         .build();
 * volume.mountIn(container, ContainerMountPoint.builder()
 *         .containerPath("/var/lib")
 *         .readOnly(false)
 *         .build());
 * taskDefinition.addVolume(volume);
 * FargateService service = FargateService.Builder.create(this, "FargateService")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .build();
 * service.addVolume(volume);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:23.185Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.FileSystemType")
public enum FileSystemType {
    /**
     * ext3 type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXT3,
    /**
     * ext4 type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXT4,
    /**
     * xfs type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    XFS,
}
