package software.amazon.awscdk.services.greengrassv2;

/**
 * Creates a continuous deployment for a target, which is a AWS IoT Greengrass core device or group of core devices.
 * <p>
 * When you add a new core device to a group of core devices that has a deployment, AWS IoT Greengrass deploys that group's deployment to the new device.
 * <p>
 * You can define one deployment for each target. When you create a new deployment for a target that has an existing deployment, you replace the previous deployment. AWS IoT Greengrass applies the new deployment to the target devices.
 * <p>
 * You can only add, update, or delete up to 10 deployments at a time to a single target.
 * <p>
 * Every deployment has a revision number that indicates how many deployment revisions you define for a target. Use this operation to create a new revision of an existing deployment. This operation returns the revision number of the new deployment when you create it.
 * <p>
 * For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
 * <p>
 * <blockquote>
 * <p>
 * Deployment resources are deleted when you delete stacks. To keep the deployments in a stack, you must specify <code>"DeletionPolicy": "Retain"</code> on each deployment resource in the stack template that you want to keep. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-deletionpolicy.html">DeletionPolicy</a> .
 * <p>
 * You can only delete up to 10 deployment resources at a time. If you delete more than 10 resources, you receive an error.
 * <p>
 * </blockquote>
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.greengrassv2.*;
 * Object rateIncreaseCriteria;
 * CfnDeployment cfnDeployment = CfnDeployment.Builder.create(this, "MyCfnDeployment")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .components(Map.of(
 *                 "componentsKey", ComponentDeploymentSpecificationProperty.builder()
 *                         .componentVersion("componentVersion")
 *                         .configurationUpdate(ComponentConfigurationUpdateProperty.builder()
 *                                 .merge("merge")
 *                                 .reset(List.of("reset"))
 *                                 .build())
 *                         .runWith(ComponentRunWithProperty.builder()
 *                                 .posixUser("posixUser")
 *                                 .systemResourceLimits(SystemResourceLimitsProperty.builder()
 *                                         .cpus(123)
 *                                         .memory(123)
 *                                         .build())
 *                                 .windowsUser("windowsUser")
 *                                 .build())
 *                         .build()))
 *         .deploymentName("deploymentName")
 *         .deploymentPolicies(DeploymentPoliciesProperty.builder()
 *                 .componentUpdatePolicy(DeploymentComponentUpdatePolicyProperty.builder()
 *                         .action("action")
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .configurationValidationPolicy(DeploymentConfigurationValidationPolicyProperty.builder()
 *                         .timeoutInSeconds(123)
 *                         .build())
 *                 .failureHandlingPolicy("failureHandlingPolicy")
 *                 .build())
 *         .iotJobConfiguration(DeploymentIoTJobConfigurationProperty.builder()
 *                 .abortConfig(IoTJobAbortConfigProperty.builder()
 *                         .criteriaList(List.of(IoTJobAbortCriteriaProperty.builder()
 *                                 .action("action")
 *                                 .failureType("failureType")
 *                                 .minNumberOfExecutedThings(123)
 *                                 .thresholdPercentage(123)
 *                                 .build()))
 *                         .build())
 *                 .jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfigProperty.builder()
 *                         .exponentialRate(IoTJobExponentialRolloutRateProperty.builder()
 *                                 .baseRatePerMinute(123)
 *                                 .incrementFactor(123)
 *                                 .rateIncreaseCriteria(rateIncreaseCriteria)
 *                                 .build())
 *                         .maximumPerMinute(123)
 *                         .build())
 *                 .timeoutConfig(IoTJobTimeoutConfigProperty.builder()
 *                         .inProgressTimeoutInMinutes(123)
 *                         .build())
 *                 .build())
 *         .parentTargetArn("parentTargetArn")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:24.557Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment")
public class CfnDeployment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDeployment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDeployment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.greengrassv2.CfnDeployment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDeployment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.greengrassv2.CfnDeploymentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDeploymentId() {
        return software.amazon.jsii.Kernel.get(this, "attrDeploymentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ARN of the target AWS IoT thing or thing group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetArn() {
        return software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the target AWS IoT thing or thing group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetArn", java.util.Objects.requireNonNull(value, "targetArn is required"));
    }

    /**
     * The components to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getComponents() {
        return software.amazon.jsii.Kernel.get(this, "components", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The components to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "components", value);
    }

    /**
     * The components to deploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponents(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.greengrassv2.CfnDeployment.ComponentDeploymentSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.greengrassv2.CfnDeployment.ComponentDeploymentSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "components", value);
    }

    /**
     * The name of the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDeploymentName() {
        return software.amazon.jsii.Kernel.get(this, "deploymentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "deploymentName", value);
    }

    /**
     * The deployment policies for the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentPolicies() {
        return software.amazon.jsii.Kernel.get(this, "deploymentPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The deployment policies for the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPolicies", value);
    }

    /**
     * The deployment policies for the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDeploymentPolicies(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentPoliciesProperty value) {
        software.amazon.jsii.Kernel.set(this, "deploymentPolicies", value);
    }

    /**
     * The job configuration for the deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIotJobConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "iotJobConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The job configuration for the deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIotJobConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "iotJobConfiguration", value);
    }

    /**
     * The job configuration for the deployment configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIotJobConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentIoTJobConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "iotJobConfiguration", value);
    }

    /**
     * The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getParentTargetArn() {
        return software.amazon.jsii.Kernel.get(this, "parentTargetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setParentTargetArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "parentTargetArn", value);
    }

    /**
     * Application-specific metadata to attach to the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Application-specific metadata to attach to the deployment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Contains information about a deployment's update to a component's configuration on AWS IoT Greengrass core devices.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configurations</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * ComponentConfigurationUpdateProperty componentConfigurationUpdateProperty = ComponentConfigurationUpdateProperty.builder()
     *         .merge("merge")
     *         .reset(List.of("reset"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentConfigurationUpdateProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentConfigurationUpdateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentConfigurationUpdateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A serialized JSON string that contains the configuration object to merge to target devices.
         * <p>
         * The core device merges this configuration with the component's existing configuration. If this is the first time a component deploys on a device, the core device merges this configuration with the component's default configuration. This means that the core device keeps it's existing configuration for keys and values that you don't specify in this object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html#cfn-greengrassv2-deployment-componentconfigurationupdate-merge">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html#cfn-greengrassv2-deployment-componentconfigurationupdate-merge</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMerge() {
            return null;
        }

        /**
         * The list of configuration nodes to reset to default values on target devices.
         * <p>
         * Use JSON pointers to specify each node to reset. JSON pointers start with a forward slash ( <code>/</code> ) and use forward slashes to separate the key for each level in the object. For more information, see the <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html#cfn-greengrassv2-deployment-componentconfigurationupdate-reset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentconfigurationupdate.html#cfn-greengrassv2-deployment-componentconfigurationupdate-reset</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReset() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentConfigurationUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentConfigurationUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentConfigurationUpdateProperty> {
            java.lang.String merge;
            java.util.List<java.lang.String> reset;

            /**
             * Sets the value of {@link ComponentConfigurationUpdateProperty#getMerge}
             * @param merge A serialized JSON string that contains the configuration object to merge to target devices.
             *              The core device merges this configuration with the component's existing configuration. If this is the first time a component deploys on a device, the core device merges this configuration with the component's default configuration. This means that the core device keeps it's existing configuration for keys and values that you don't specify in this object. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#merge-configuration-update">Merge configuration updates</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder merge(java.lang.String merge) {
                this.merge = merge;
                return this;
            }

            /**
             * Sets the value of {@link ComponentConfigurationUpdateProperty#getReset}
             * @param reset The list of configuration nodes to reset to default values on target devices.
             *              Use JSON pointers to specify each node to reset. JSON pointers start with a forward slash ( <code>/</code> ) and use forward slashes to separate the key for each level in the object. For more information, see the <a href="https://docs.aws.amazon.com/https://tools.ietf.org/html/rfc6901">JSON pointer specification</a> and <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html#reset-configuration-update">Reset configuration updates</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder reset(java.util.List<java.lang.String> reset) {
                this.reset = reset;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentConfigurationUpdateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentConfigurationUpdateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentConfigurationUpdateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentConfigurationUpdateProperty {
            private final java.lang.String merge;
            private final java.util.List<java.lang.String> reset;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.merge = software.amazon.jsii.Kernel.get(this, "merge", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.reset = software.amazon.jsii.Kernel.get(this, "reset", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.merge = builder.merge;
                this.reset = builder.reset;
            }

            @Override
            public final java.lang.String getMerge() {
                return this.merge;
            }

            @Override
            public final java.util.List<java.lang.String> getReset() {
                return this.reset;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMerge() != null) {
                    data.set("merge", om.valueToTree(this.getMerge()));
                }
                if (this.getReset() != null) {
                    data.set("reset", om.valueToTree(this.getReset()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentConfigurationUpdateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentConfigurationUpdateProperty.Jsii$Proxy that = (ComponentConfigurationUpdateProperty.Jsii$Proxy) o;

                if (this.merge != null ? !this.merge.equals(that.merge) : that.merge != null) return false;
                return this.reset != null ? this.reset.equals(that.reset) : that.reset == null;
            }

            @Override
            public final int hashCode() {
                int result = this.merge != null ? this.merge.hashCode() : 0;
                result = 31 * result + (this.reset != null ? this.reset.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a component to deploy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * ComponentDeploymentSpecificationProperty componentDeploymentSpecificationProperty = ComponentDeploymentSpecificationProperty.builder()
     *         .componentVersion("componentVersion")
     *         .configurationUpdate(ComponentConfigurationUpdateProperty.builder()
     *                 .merge("merge")
     *                 .reset(List.of("reset"))
     *                 .build())
     *         .runWith(ComponentRunWithProperty.builder()
     *                 .posixUser("posixUser")
     *                 .systemResourceLimits(SystemResourceLimitsProperty.builder()
     *                         .cpus(123)
     *                         .memory(123)
     *                         .build())
     *                 .windowsUser("windowsUser")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentDeploymentSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentDeploymentSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentDeploymentSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The version of the component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-componentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-componentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentVersion() {
            return null;
        }

        /**
         * The configuration updates to deploy for the component.
         * <p>
         * You can define reset updates and merge updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device's component configuration with the keys and values that you specify. The AWS IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configuration</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-configurationupdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-configurationupdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationUpdate() {
            return null;
        }

        /**
         * The system user and group that the  software uses to run component processes on the core device.
         * <p>
         * If you omit this parameter, the  software uses the system user and group that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-runwith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentdeploymentspecification.html#cfn-greengrassv2-deployment-componentdeploymentspecification-runwith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRunWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentDeploymentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentDeploymentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentDeploymentSpecificationProperty> {
            java.lang.String componentVersion;
            java.lang.Object configurationUpdate;
            java.lang.Object runWith;

            /**
             * Sets the value of {@link ComponentDeploymentSpecificationProperty#getComponentVersion}
             * @param componentVersion The version of the component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentVersion(java.lang.String componentVersion) {
                this.componentVersion = componentVersion;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDeploymentSpecificationProperty#getConfigurationUpdate}
             * @param configurationUpdate The configuration updates to deploy for the component.
             *                            You can define reset updates and merge updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device's component configuration with the keys and values that you specify. The AWS IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configuration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationUpdate(software.amazon.awscdk.IResolvable configurationUpdate) {
                this.configurationUpdate = configurationUpdate;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDeploymentSpecificationProperty#getConfigurationUpdate}
             * @param configurationUpdate The configuration updates to deploy for the component.
             *                            You can define reset updates and merge updates. A reset updates the keys that you specify to the default configuration for the component. A merge updates the core device's component configuration with the keys and values that you specify. The AWS IoT Greengrass Core software applies reset updates before it applies merge updates. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/update-component-configurations.html">Update component configuration</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationUpdate(software.amazon.awscdk.services.greengrassv2.CfnDeployment.ComponentConfigurationUpdateProperty configurationUpdate) {
                this.configurationUpdate = configurationUpdate;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDeploymentSpecificationProperty#getRunWith}
             * @param runWith The system user and group that the  software uses to run component processes on the core device.
             *                If you omit this parameter, the  software uses the system user and group that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runWith(software.amazon.awscdk.IResolvable runWith) {
                this.runWith = runWith;
                return this;
            }

            /**
             * Sets the value of {@link ComponentDeploymentSpecificationProperty#getRunWith}
             * @param runWith The system user and group that the  software uses to run component processes on the core device.
             *                If you omit this parameter, the  software uses the system user and group that you configure for the core device. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder runWith(software.amazon.awscdk.services.greengrassv2.CfnDeployment.ComponentRunWithProperty runWith) {
                this.runWith = runWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentDeploymentSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentDeploymentSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentDeploymentSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentDeploymentSpecificationProperty {
            private final java.lang.String componentVersion;
            private final java.lang.Object configurationUpdate;
            private final java.lang.Object runWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentVersion = software.amazon.jsii.Kernel.get(this, "componentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configurationUpdate = software.amazon.jsii.Kernel.get(this, "configurationUpdate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.runWith = software.amazon.jsii.Kernel.get(this, "runWith", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentVersion = builder.componentVersion;
                this.configurationUpdate = builder.configurationUpdate;
                this.runWith = builder.runWith;
            }

            @Override
            public final java.lang.String getComponentVersion() {
                return this.componentVersion;
            }

            @Override
            public final java.lang.Object getConfigurationUpdate() {
                return this.configurationUpdate;
            }

            @Override
            public final java.lang.Object getRunWith() {
                return this.runWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentVersion() != null) {
                    data.set("componentVersion", om.valueToTree(this.getComponentVersion()));
                }
                if (this.getConfigurationUpdate() != null) {
                    data.set("configurationUpdate", om.valueToTree(this.getConfigurationUpdate()));
                }
                if (this.getRunWith() != null) {
                    data.set("runWith", om.valueToTree(this.getRunWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentDeploymentSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentDeploymentSpecificationProperty.Jsii$Proxy that = (ComponentDeploymentSpecificationProperty.Jsii$Proxy) o;

                if (this.componentVersion != null ? !this.componentVersion.equals(that.componentVersion) : that.componentVersion != null) return false;
                if (this.configurationUpdate != null ? !this.configurationUpdate.equals(that.configurationUpdate) : that.configurationUpdate != null) return false;
                return this.runWith != null ? this.runWith.equals(that.runWith) : that.runWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentVersion != null ? this.componentVersion.hashCode() : 0;
                result = 31 * result + (this.configurationUpdate != null ? this.configurationUpdate.hashCode() : 0);
                result = 31 * result + (this.runWith != null ? this.runWith.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information system user and group that the AWS IoT Greengrass Core software uses to run component processes on the core device.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * ComponentRunWithProperty componentRunWithProperty = ComponentRunWithProperty.builder()
     *         .posixUser("posixUser")
     *         .systemResourceLimits(SystemResourceLimitsProperty.builder()
     *                 .cpus(123)
     *                 .memory(123)
     *                 .build())
     *         .windowsUser("windowsUser")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentRunWithProperty")
    @software.amazon.jsii.Jsii.Proxy(ComponentRunWithProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ComponentRunWithProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The POSIX system user and (optional) group to use to run this component.
         * <p>
         * Specify the user and group separated by a colon ( <code>:</code> ) in the following format: <code>user:group</code> . The group is optional. If you don't specify a group, the AWS IoT Greengrass Core software uses the primary user for the group.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-posixuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-posixuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPosixUser() {
            return null;
        }

        /**
         * The system resource limits to apply to this component's process on the core device.
         * <p>
         * AWS IoT Greengrass supports this feature only on Linux core devices.
         * <p>
         * If you omit this parameter, the AWS IoT Greengrass Core software uses the default system resource limits that you configure on the AWS IoT Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-systemresourcelimits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-systemresourcelimits</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSystemResourceLimits() {
            return null;
        }

        /**
         * The Windows user to use to run this component on Windows core devices.
         * <p>
         * The user must exist on each Windows core device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
         * <p>
         * If you omit this parameter, the AWS IoT Greengrass Core software uses the default Windows user that you configure on the AWS IoT Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-windowsuser">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-componentrunwith.html#cfn-greengrassv2-deployment-componentrunwith-windowsuser</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWindowsUser() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ComponentRunWithProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ComponentRunWithProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ComponentRunWithProperty> {
            java.lang.String posixUser;
            java.lang.Object systemResourceLimits;
            java.lang.String windowsUser;

            /**
             * Sets the value of {@link ComponentRunWithProperty#getPosixUser}
             * @param posixUser The POSIX system user and (optional) group to use to run this component.
             *                  Specify the user and group separated by a colon ( <code>:</code> ) in the following format: <code>user:group</code> . The group is optional. If you don't specify a group, the AWS IoT Greengrass Core software uses the primary user for the group.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder posixUser(java.lang.String posixUser) {
                this.posixUser = posixUser;
                return this;
            }

            /**
             * Sets the value of {@link ComponentRunWithProperty#getSystemResourceLimits}
             * @param systemResourceLimits The system resource limits to apply to this component's process on the core device.
             *                             AWS IoT Greengrass supports this feature only on Linux core devices.
             *                             <p>
             *                             If you omit this parameter, the AWS IoT Greengrass Core software uses the default system resource limits that you configure on the AWS IoT Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemResourceLimits(software.amazon.awscdk.IResolvable systemResourceLimits) {
                this.systemResourceLimits = systemResourceLimits;
                return this;
            }

            /**
             * Sets the value of {@link ComponentRunWithProperty#getSystemResourceLimits}
             * @param systemResourceLimits The system resource limits to apply to this component's process on the core device.
             *                             AWS IoT Greengrass supports this feature only on Linux core devices.
             *                             <p>
             *                             If you omit this parameter, the AWS IoT Greengrass Core software uses the default system resource limits that you configure on the AWS IoT Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder systemResourceLimits(software.amazon.awscdk.services.greengrassv2.CfnDeployment.SystemResourceLimitsProperty systemResourceLimits) {
                this.systemResourceLimits = systemResourceLimits;
                return this;
            }

            /**
             * Sets the value of {@link ComponentRunWithProperty#getWindowsUser}
             * @param windowsUser The Windows user to use to run this component on Windows core devices.
             *                    The user must exist on each Windows core device, and its name and password must be in the LocalSystem account's Credentials Manager instance.
             *                    <p>
             *                    If you omit this parameter, the AWS IoT Greengrass Core software uses the default Windows user that you configure on the AWS IoT Greengrass nucleus component. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-user">Configure the user and group that run components</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowsUser(java.lang.String windowsUser) {
                this.windowsUser = windowsUser;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ComponentRunWithProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ComponentRunWithProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ComponentRunWithProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ComponentRunWithProperty {
            private final java.lang.String posixUser;
            private final java.lang.Object systemResourceLimits;
            private final java.lang.String windowsUser;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.posixUser = software.amazon.jsii.Kernel.get(this, "posixUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.systemResourceLimits = software.amazon.jsii.Kernel.get(this, "systemResourceLimits", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.windowsUser = software.amazon.jsii.Kernel.get(this, "windowsUser", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.posixUser = builder.posixUser;
                this.systemResourceLimits = builder.systemResourceLimits;
                this.windowsUser = builder.windowsUser;
            }

            @Override
            public final java.lang.String getPosixUser() {
                return this.posixUser;
            }

            @Override
            public final java.lang.Object getSystemResourceLimits() {
                return this.systemResourceLimits;
            }

            @Override
            public final java.lang.String getWindowsUser() {
                return this.windowsUser;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPosixUser() != null) {
                    data.set("posixUser", om.valueToTree(this.getPosixUser()));
                }
                if (this.getSystemResourceLimits() != null) {
                    data.set("systemResourceLimits", om.valueToTree(this.getSystemResourceLimits()));
                }
                if (this.getWindowsUser() != null) {
                    data.set("windowsUser", om.valueToTree(this.getWindowsUser()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.ComponentRunWithProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ComponentRunWithProperty.Jsii$Proxy that = (ComponentRunWithProperty.Jsii$Proxy) o;

                if (this.posixUser != null ? !this.posixUser.equals(that.posixUser) : that.posixUser != null) return false;
                if (this.systemResourceLimits != null ? !this.systemResourceLimits.equals(that.systemResourceLimits) : that.systemResourceLimits != null) return false;
                return this.windowsUser != null ? this.windowsUser.equals(that.windowsUser) : that.windowsUser == null;
            }

            @Override
            public final int hashCode() {
                int result = this.posixUser != null ? this.posixUser.hashCode() : 0;
                result = 31 * result + (this.systemResourceLimits != null ? this.systemResourceLimits.hashCode() : 0);
                result = 31 * result + (this.windowsUser != null ? this.windowsUser.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a deployment's policy that defines when components are safe to update.
     * <p>
     * Each component on a device can report whether or not it's ready to update. After a component and its dependencies are ready, they can apply the update in the deployment. You can configure whether or not the deployment notifies components of an update and waits for a response. You specify the amount of time each component has to respond to the update notification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * DeploymentComponentUpdatePolicyProperty deploymentComponentUpdatePolicyProperty = DeploymentComponentUpdatePolicyProperty.builder()
     *         .action("action")
     *         .timeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentComponentUpdatePolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentComponentUpdatePolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentComponentUpdatePolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether or not to notify components and wait for components to become safe to update.
         * <p>
         * Choose from the following options:
         * <p>
         * <ul>
         * <li><code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .</li>
         * <li><code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn't notify components or wait for them to be safe to update.</li>
         * </ul>
         * <p>
         * Default: <code>NOTIFY_COMPONENTS</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html#cfn-greengrassv2-deployment-deploymentcomponentupdatepolicy-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html#cfn-greengrassv2-deployment-deploymentcomponentupdatepolicy-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAction() {
            return null;
        }

        /**
         * The amount of time in seconds that each component on a device has to report that it's safe to update.
         * <p>
         * If the component waits for longer than this timeout, then the deployment proceeds on the device.
         * <p>
         * Default: <code>60</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html#cfn-greengrassv2-deployment-deploymentcomponentupdatepolicy-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentcomponentupdatepolicy.html#cfn-greengrassv2-deployment-deploymentcomponentupdatepolicy-timeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentComponentUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentComponentUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentComponentUpdatePolicyProperty> {
            java.lang.String action;
            java.lang.Number timeoutInSeconds;

            /**
             * Sets the value of {@link DeploymentComponentUpdatePolicyProperty#getAction}
             * @param action Whether or not to notify components and wait for components to become safe to update.
             *               Choose from the following options:
             *               <p>
             *               <ul>
             *               <li><code>NOTIFY_COMPONENTS</code> – The deployment notifies each component before it stops and updates that component. Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetocomponentupdates">SubscribeToComponentUpdates</a> IPC operation to receive these notifications. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-defercomponentupdate">DeferComponentUpdate</a> IPC operation. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .</li>
             *               <li><code>SKIP_NOTIFY_COMPONENTS</code> – The deployment doesn't notify components or wait for them to be safe to update.</li>
             *               </ul>
             *               <p>
             *               Default: <code>NOTIFY_COMPONENTS</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentComponentUpdatePolicyProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds The amount of time in seconds that each component on a device has to report that it's safe to update.
             *                         If the component waits for longer than this timeout, then the deployment proceeds on the device.
             *                         <p>
             *                         Default: <code>60</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentComponentUpdatePolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentComponentUpdatePolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentComponentUpdatePolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentComponentUpdatePolicyProperty {
            private final java.lang.String action;
            private final java.lang.Number timeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = builder.action;
                this.timeoutInSeconds = builder.timeoutInSeconds;
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAction() != null) {
                    data.set("action", om.valueToTree(this.getAction()));
                }
                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentComponentUpdatePolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentComponentUpdatePolicyProperty.Jsii$Proxy that = (DeploymentComponentUpdatePolicyProperty.Jsii$Proxy) o;

                if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
                return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.action != null ? this.action.hashCode() : 0;
                result = 31 * result + (this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about how long a component on a core device can validate its configuration updates before it times out.
     * <p>
     * Components can use the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-subscribetovalidateconfigurationupdates">SubscribeToValidateConfigurationUpdates</a> IPC operation to receive notifications when a deployment specifies a configuration update. Then, components can respond with the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/interprocess-communication.html#ipc-operation-sendconfigurationvalidityreport">SendConfigurationValidityReport</a> IPC operation. For more information, see the <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/create-deployments.html">Create deployments</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * DeploymentConfigurationValidationPolicyProperty deploymentConfigurationValidationPolicyProperty = DeploymentConfigurationValidationPolicyProperty.builder()
     *         .timeoutInSeconds(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentconfigurationvalidationpolicy.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentconfigurationvalidationpolicy.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentConfigurationValidationPolicyProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentConfigurationValidationPolicyProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentConfigurationValidationPolicyProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time in seconds that a component can validate its configuration updates.
         * <p>
         * If the validation time exceeds this timeout, then the deployment proceeds for the device.
         * <p>
         * Default: <code>30</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentconfigurationvalidationpolicy.html#cfn-greengrassv2-deployment-deploymentconfigurationvalidationpolicy-timeoutinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentconfigurationvalidationpolicy.html#cfn-greengrassv2-deployment-deploymentconfigurationvalidationpolicy-timeoutinseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTimeoutInSeconds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentConfigurationValidationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentConfigurationValidationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentConfigurationValidationPolicyProperty> {
            java.lang.Number timeoutInSeconds;

            /**
             * Sets the value of {@link DeploymentConfigurationValidationPolicyProperty#getTimeoutInSeconds}
             * @param timeoutInSeconds The amount of time in seconds that a component can validate its configuration updates.
             *                         If the validation time exceeds this timeout, then the deployment proceeds for the device.
             *                         <p>
             *                         Default: <code>30</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutInSeconds(java.lang.Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentConfigurationValidationPolicyProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentConfigurationValidationPolicyProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentConfigurationValidationPolicyProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentConfigurationValidationPolicyProperty {
            private final java.lang.Number timeoutInSeconds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeoutInSeconds = software.amazon.jsii.Kernel.get(this, "timeoutInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeoutInSeconds = builder.timeoutInSeconds;
            }

            @Override
            public final java.lang.Number getTimeoutInSeconds() {
                return this.timeoutInSeconds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTimeoutInSeconds() != null) {
                    data.set("timeoutInSeconds", om.valueToTree(this.getTimeoutInSeconds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentConfigurationValidationPolicyProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentConfigurationValidationPolicyProperty.Jsii$Proxy that = (DeploymentConfigurationValidationPolicyProperty.Jsii$Proxy) o;

                return this.timeoutInSeconds != null ? this.timeoutInSeconds.equals(that.timeoutInSeconds) : that.timeoutInSeconds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.timeoutInSeconds != null ? this.timeoutInSeconds.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains information about an AWS IoT job configuration.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * Object rateIncreaseCriteria;
     * DeploymentIoTJobConfigurationProperty deploymentIoTJobConfigurationProperty = DeploymentIoTJobConfigurationProperty.builder()
     *         .abortConfig(IoTJobAbortConfigProperty.builder()
     *                 .criteriaList(List.of(IoTJobAbortCriteriaProperty.builder()
     *                         .action("action")
     *                         .failureType("failureType")
     *                         .minNumberOfExecutedThings(123)
     *                         .thresholdPercentage(123)
     *                         .build()))
     *                 .build())
     *         .jobExecutionsRolloutConfig(IoTJobExecutionsRolloutConfigProperty.builder()
     *                 .exponentialRate(IoTJobExponentialRolloutRateProperty.builder()
     *                         .baseRatePerMinute(123)
     *                         .incrementFactor(123)
     *                         .rateIncreaseCriteria(rateIncreaseCriteria)
     *                         .build())
     *                 .maximumPerMinute(123)
     *                 .build())
     *         .timeoutConfig(IoTJobTimeoutConfigProperty.builder()
     *                 .inProgressTimeoutInMinutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentIoTJobConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentIoTJobConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentIoTJobConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The stop configuration for the job.
         * <p>
         * This configuration defines when and how to stop a job rollout.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-abortconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-abortconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAbortConfig() {
            return null;
        }

        /**
         * The rollout configuration for the job.
         * <p>
         * This configuration defines the rate at which the job rolls out to the fleet of target devices.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-jobexecutionsrolloutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-jobexecutionsrolloutconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJobExecutionsRolloutConfig() {
            return null;
        }

        /**
         * The timeout configuration for the job.
         * <p>
         * This configuration defines the amount of time each device has to complete the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-timeoutconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentiotjobconfiguration.html#cfn-greengrassv2-deployment-deploymentiotjobconfiguration-timeoutconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTimeoutConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentIoTJobConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentIoTJobConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentIoTJobConfigurationProperty> {
            java.lang.Object abortConfig;
            java.lang.Object jobExecutionsRolloutConfig;
            java.lang.Object timeoutConfig;

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getAbortConfig}
             * @param abortConfig The stop configuration for the job.
             *                    This configuration defines when and how to stop a job rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortConfig(software.amazon.awscdk.IResolvable abortConfig) {
                this.abortConfig = abortConfig;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getAbortConfig}
             * @param abortConfig The stop configuration for the job.
             *                    This configuration defines when and how to stop a job rollout.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder abortConfig(software.amazon.awscdk.services.greengrassv2.CfnDeployment.IoTJobAbortConfigProperty abortConfig) {
                this.abortConfig = abortConfig;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getJobExecutionsRolloutConfig}
             * @param jobExecutionsRolloutConfig The rollout configuration for the job.
             *                                   This configuration defines the rate at which the job rolls out to the fleet of target devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobExecutionsRolloutConfig(software.amazon.awscdk.IResolvable jobExecutionsRolloutConfig) {
                this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getJobExecutionsRolloutConfig}
             * @param jobExecutionsRolloutConfig The rollout configuration for the job.
             *                                   This configuration defines the rate at which the job rolls out to the fleet of target devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jobExecutionsRolloutConfig(software.amazon.awscdk.services.greengrassv2.CfnDeployment.IoTJobExecutionsRolloutConfigProperty jobExecutionsRolloutConfig) {
                this.jobExecutionsRolloutConfig = jobExecutionsRolloutConfig;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getTimeoutConfig}
             * @param timeoutConfig The timeout configuration for the job.
             *                      This configuration defines the amount of time each device has to complete the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConfig(software.amazon.awscdk.IResolvable timeoutConfig) {
                this.timeoutConfig = timeoutConfig;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentIoTJobConfigurationProperty#getTimeoutConfig}
             * @param timeoutConfig The timeout configuration for the job.
             *                      This configuration defines the amount of time each device has to complete the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeoutConfig(software.amazon.awscdk.services.greengrassv2.CfnDeployment.IoTJobTimeoutConfigProperty timeoutConfig) {
                this.timeoutConfig = timeoutConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentIoTJobConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentIoTJobConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentIoTJobConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentIoTJobConfigurationProperty {
            private final java.lang.Object abortConfig;
            private final java.lang.Object jobExecutionsRolloutConfig;
            private final java.lang.Object timeoutConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.abortConfig = software.amazon.jsii.Kernel.get(this, "abortConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jobExecutionsRolloutConfig = software.amazon.jsii.Kernel.get(this, "jobExecutionsRolloutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.timeoutConfig = software.amazon.jsii.Kernel.get(this, "timeoutConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.abortConfig = builder.abortConfig;
                this.jobExecutionsRolloutConfig = builder.jobExecutionsRolloutConfig;
                this.timeoutConfig = builder.timeoutConfig;
            }

            @Override
            public final java.lang.Object getAbortConfig() {
                return this.abortConfig;
            }

            @Override
            public final java.lang.Object getJobExecutionsRolloutConfig() {
                return this.jobExecutionsRolloutConfig;
            }

            @Override
            public final java.lang.Object getTimeoutConfig() {
                return this.timeoutConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAbortConfig() != null) {
                    data.set("abortConfig", om.valueToTree(this.getAbortConfig()));
                }
                if (this.getJobExecutionsRolloutConfig() != null) {
                    data.set("jobExecutionsRolloutConfig", om.valueToTree(this.getJobExecutionsRolloutConfig()));
                }
                if (this.getTimeoutConfig() != null) {
                    data.set("timeoutConfig", om.valueToTree(this.getTimeoutConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentIoTJobConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentIoTJobConfigurationProperty.Jsii$Proxy that = (DeploymentIoTJobConfigurationProperty.Jsii$Proxy) o;

                if (this.abortConfig != null ? !this.abortConfig.equals(that.abortConfig) : that.abortConfig != null) return false;
                if (this.jobExecutionsRolloutConfig != null ? !this.jobExecutionsRolloutConfig.equals(that.jobExecutionsRolloutConfig) : that.jobExecutionsRolloutConfig != null) return false;
                return this.timeoutConfig != null ? this.timeoutConfig.equals(that.timeoutConfig) : that.timeoutConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.abortConfig != null ? this.abortConfig.hashCode() : 0;
                result = 31 * result + (this.jobExecutionsRolloutConfig != null ? this.jobExecutionsRolloutConfig.hashCode() : 0);
                result = 31 * result + (this.timeoutConfig != null ? this.timeoutConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about policies that define how a deployment updates components and handles failure.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * DeploymentPoliciesProperty deploymentPoliciesProperty = DeploymentPoliciesProperty.builder()
     *         .componentUpdatePolicy(DeploymentComponentUpdatePolicyProperty.builder()
     *                 .action("action")
     *                 .timeoutInSeconds(123)
     *                 .build())
     *         .configurationValidationPolicy(DeploymentConfigurationValidationPolicyProperty.builder()
     *                 .timeoutInSeconds(123)
     *                 .build())
     *         .failureHandlingPolicy("failureHandlingPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentPoliciesProperty")
    @software.amazon.jsii.Jsii.Proxy(DeploymentPoliciesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DeploymentPoliciesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component update policy for the configuration deployment.
         * <p>
         * This policy defines when it's safe to deploy the configuration to devices.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-componentupdatepolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-componentupdatepolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getComponentUpdatePolicy() {
            return null;
        }

        /**
         * The configuration validation policy for the configuration deployment.
         * <p>
         * This policy defines how long each component has to validate its configure updates.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-configurationvalidationpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-configurationvalidationpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurationValidationPolicy() {
            return null;
        }

        /**
         * The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.
         * <p>
         * Default: <code>ROLLBACK</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-failurehandlingpolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-deploymentpolicies.html#cfn-greengrassv2-deployment-deploymentpolicies-failurehandlingpolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFailureHandlingPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DeploymentPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DeploymentPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DeploymentPoliciesProperty> {
            java.lang.Object componentUpdatePolicy;
            java.lang.Object configurationValidationPolicy;
            java.lang.String failureHandlingPolicy;

            /**
             * Sets the value of {@link DeploymentPoliciesProperty#getComponentUpdatePolicy}
             * @param componentUpdatePolicy The component update policy for the configuration deployment.
             *                              This policy defines when it's safe to deploy the configuration to devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentUpdatePolicy(software.amazon.awscdk.IResolvable componentUpdatePolicy) {
                this.componentUpdatePolicy = componentUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPoliciesProperty#getComponentUpdatePolicy}
             * @param componentUpdatePolicy The component update policy for the configuration deployment.
             *                              This policy defines when it's safe to deploy the configuration to devices.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentUpdatePolicy(software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentComponentUpdatePolicyProperty componentUpdatePolicy) {
                this.componentUpdatePolicy = componentUpdatePolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPoliciesProperty#getConfigurationValidationPolicy}
             * @param configurationValidationPolicy The configuration validation policy for the configuration deployment.
             *                                      This policy defines how long each component has to validate its configure updates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationValidationPolicy(software.amazon.awscdk.IResolvable configurationValidationPolicy) {
                this.configurationValidationPolicy = configurationValidationPolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPoliciesProperty#getConfigurationValidationPolicy}
             * @param configurationValidationPolicy The configuration validation policy for the configuration deployment.
             *                                      This policy defines how long each component has to validate its configure updates.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurationValidationPolicy(software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentConfigurationValidationPolicyProperty configurationValidationPolicy) {
                this.configurationValidationPolicy = configurationValidationPolicy;
                return this;
            }

            /**
             * Sets the value of {@link DeploymentPoliciesProperty#getFailureHandlingPolicy}
             * @param failureHandlingPolicy The failure handling policy for the configuration deployment. This policy defines what to do if the deployment fails.
             *                              Default: <code>ROLLBACK</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureHandlingPolicy(java.lang.String failureHandlingPolicy) {
                this.failureHandlingPolicy = failureHandlingPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DeploymentPoliciesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DeploymentPoliciesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DeploymentPoliciesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeploymentPoliciesProperty {
            private final java.lang.Object componentUpdatePolicy;
            private final java.lang.Object configurationValidationPolicy;
            private final java.lang.String failureHandlingPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentUpdatePolicy = software.amazon.jsii.Kernel.get(this, "componentUpdatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.configurationValidationPolicy = software.amazon.jsii.Kernel.get(this, "configurationValidationPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.failureHandlingPolicy = software.amazon.jsii.Kernel.get(this, "failureHandlingPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentUpdatePolicy = builder.componentUpdatePolicy;
                this.configurationValidationPolicy = builder.configurationValidationPolicy;
                this.failureHandlingPolicy = builder.failureHandlingPolicy;
            }

            @Override
            public final java.lang.Object getComponentUpdatePolicy() {
                return this.componentUpdatePolicy;
            }

            @Override
            public final java.lang.Object getConfigurationValidationPolicy() {
                return this.configurationValidationPolicy;
            }

            @Override
            public final java.lang.String getFailureHandlingPolicy() {
                return this.failureHandlingPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentUpdatePolicy() != null) {
                    data.set("componentUpdatePolicy", om.valueToTree(this.getComponentUpdatePolicy()));
                }
                if (this.getConfigurationValidationPolicy() != null) {
                    data.set("configurationValidationPolicy", om.valueToTree(this.getConfigurationValidationPolicy()));
                }
                if (this.getFailureHandlingPolicy() != null) {
                    data.set("failureHandlingPolicy", om.valueToTree(this.getFailureHandlingPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.DeploymentPoliciesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DeploymentPoliciesProperty.Jsii$Proxy that = (DeploymentPoliciesProperty.Jsii$Proxy) o;

                if (this.componentUpdatePolicy != null ? !this.componentUpdatePolicy.equals(that.componentUpdatePolicy) : that.componentUpdatePolicy != null) return false;
                if (this.configurationValidationPolicy != null ? !this.configurationValidationPolicy.equals(that.configurationValidationPolicy) : that.configurationValidationPolicy != null) return false;
                return this.failureHandlingPolicy != null ? this.failureHandlingPolicy.equals(that.failureHandlingPolicy) : that.failureHandlingPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentUpdatePolicy != null ? this.componentUpdatePolicy.hashCode() : 0;
                result = 31 * result + (this.configurationValidationPolicy != null ? this.configurationValidationPolicy.hashCode() : 0);
                result = 31 * result + (this.failureHandlingPolicy != null ? this.failureHandlingPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains a list of criteria that define when and how to cancel a configuration deployment.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * IoTJobAbortConfigProperty ioTJobAbortConfigProperty = IoTJobAbortConfigProperty.builder()
     *         .criteriaList(List.of(IoTJobAbortCriteriaProperty.builder()
     *                 .action("action")
     *                 .failureType("failureType")
     *                 .minNumberOfExecutedThings(123)
     *                 .thresholdPercentage(123)
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobAbortConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTJobAbortConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTJobAbortConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of criteria that define when and how to cancel the configuration deployment.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortconfig.html#cfn-greengrassv2-deployment-iotjobabortconfig-criterialist">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortconfig.html#cfn-greengrassv2-deployment-iotjobabortconfig-criterialist</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getCriteriaList();

        /**
         * @return a {@link Builder} of {@link IoTJobAbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTJobAbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTJobAbortConfigProperty> {
            java.lang.Object criteriaList;

            /**
             * Sets the value of {@link IoTJobAbortConfigProperty#getCriteriaList}
             * @param criteriaList The list of criteria that define when and how to cancel the configuration deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteriaList(software.amazon.awscdk.IResolvable criteriaList) {
                this.criteriaList = criteriaList;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobAbortConfigProperty#getCriteriaList}
             * @param criteriaList The list of criteria that define when and how to cancel the configuration deployment. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder criteriaList(java.util.List<? extends java.lang.Object> criteriaList) {
                this.criteriaList = criteriaList;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTJobAbortConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTJobAbortConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTJobAbortConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTJobAbortConfigProperty {
            private final java.lang.Object criteriaList;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.criteriaList = software.amazon.jsii.Kernel.get(this, "criteriaList", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.criteriaList = java.util.Objects.requireNonNull(builder.criteriaList, "criteriaList is required");
            }

            @Override
            public final java.lang.Object getCriteriaList() {
                return this.criteriaList;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("criteriaList", om.valueToTree(this.getCriteriaList()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobAbortConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTJobAbortConfigProperty.Jsii$Proxy that = (IoTJobAbortConfigProperty.Jsii$Proxy) o;

                return this.criteriaList.equals(that.criteriaList);
            }

            @Override
            public final int hashCode() {
                int result = this.criteriaList.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains criteria that define when and how to cancel a job.
     * <p>
     * The deployment stops if the following conditions are true:
     * <p>
     * <ul>
     * <li>The number of things that receive the deployment exceeds the <code>minNumberOfExecutedThings</code> .</li>
     * <li>The percentage of failures with type <code>failureType</code> exceeds the <code>thresholdPercentage</code> .</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * IoTJobAbortCriteriaProperty ioTJobAbortCriteriaProperty = IoTJobAbortCriteriaProperty.builder()
     *         .action("action")
     *         .failureType("failureType")
     *         .minNumberOfExecutedThings(123)
     *         .thresholdPercentage(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobAbortCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTJobAbortCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTJobAbortCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to perform when the criteria are met.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-action">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-action</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAction();

        /**
         * The type of job deployment failure that can cancel a job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-failuretype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-failuretype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getFailureType();

        /**
         * The minimum number of things that receive the configuration before the job can cancel.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-minnumberofexecutedthings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-minnumberofexecutedthings</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinNumberOfExecutedThings();

        /**
         * The minimum percentage of <code>failureType</code> failures that occur before the job can cancel.
         * <p>
         * This parameter supports up to two digits after the decimal (for example, you can specify <code>10.9</code> or <code>10.99</code> , but not <code>10.999</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-thresholdpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobabortcriteria.html#cfn-greengrassv2-deployment-iotjobabortcriteria-thresholdpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getThresholdPercentage();

        /**
         * @return a {@link Builder} of {@link IoTJobAbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTJobAbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTJobAbortCriteriaProperty> {
            java.lang.String action;
            java.lang.String failureType;
            java.lang.Number minNumberOfExecutedThings;
            java.lang.Number thresholdPercentage;

            /**
             * Sets the value of {@link IoTJobAbortCriteriaProperty#getAction}
             * @param action The action to perform when the criteria are met. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder action(java.lang.String action) {
                this.action = action;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobAbortCriteriaProperty#getFailureType}
             * @param failureType The type of job deployment failure that can cancel a job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failureType(java.lang.String failureType) {
                this.failureType = failureType;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobAbortCriteriaProperty#getMinNumberOfExecutedThings}
             * @param minNumberOfExecutedThings The minimum number of things that receive the configuration before the job can cancel. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minNumberOfExecutedThings(java.lang.Number minNumberOfExecutedThings) {
                this.minNumberOfExecutedThings = minNumberOfExecutedThings;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobAbortCriteriaProperty#getThresholdPercentage}
             * @param thresholdPercentage The minimum percentage of <code>failureType</code> failures that occur before the job can cancel. This parameter is required.
             *                            This parameter supports up to two digits after the decimal (for example, you can specify <code>10.9</code> or <code>10.99</code> , but not <code>10.999</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder thresholdPercentage(java.lang.Number thresholdPercentage) {
                this.thresholdPercentage = thresholdPercentage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTJobAbortCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTJobAbortCriteriaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTJobAbortCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTJobAbortCriteriaProperty {
            private final java.lang.String action;
            private final java.lang.String failureType;
            private final java.lang.Number minNumberOfExecutedThings;
            private final java.lang.Number thresholdPercentage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.failureType = software.amazon.jsii.Kernel.get(this, "failureType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.minNumberOfExecutedThings = software.amazon.jsii.Kernel.get(this, "minNumberOfExecutedThings", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.thresholdPercentage = software.amazon.jsii.Kernel.get(this, "thresholdPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.action = java.util.Objects.requireNonNull(builder.action, "action is required");
                this.failureType = java.util.Objects.requireNonNull(builder.failureType, "failureType is required");
                this.minNumberOfExecutedThings = java.util.Objects.requireNonNull(builder.minNumberOfExecutedThings, "minNumberOfExecutedThings is required");
                this.thresholdPercentage = java.util.Objects.requireNonNull(builder.thresholdPercentage, "thresholdPercentage is required");
            }

            @Override
            public final java.lang.String getAction() {
                return this.action;
            }

            @Override
            public final java.lang.String getFailureType() {
                return this.failureType;
            }

            @Override
            public final java.lang.Number getMinNumberOfExecutedThings() {
                return this.minNumberOfExecutedThings;
            }

            @Override
            public final java.lang.Number getThresholdPercentage() {
                return this.thresholdPercentage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("action", om.valueToTree(this.getAction()));
                data.set("failureType", om.valueToTree(this.getFailureType()));
                data.set("minNumberOfExecutedThings", om.valueToTree(this.getMinNumberOfExecutedThings()));
                data.set("thresholdPercentage", om.valueToTree(this.getThresholdPercentage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobAbortCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTJobAbortCriteriaProperty.Jsii$Proxy that = (IoTJobAbortCriteriaProperty.Jsii$Proxy) o;

                if (!action.equals(that.action)) return false;
                if (!failureType.equals(that.failureType)) return false;
                if (!minNumberOfExecutedThings.equals(that.minNumberOfExecutedThings)) return false;
                return this.thresholdPercentage.equals(that.thresholdPercentage);
            }

            @Override
            public final int hashCode() {
                int result = this.action.hashCode();
                result = 31 * result + (this.failureType.hashCode());
                result = 31 * result + (this.minNumberOfExecutedThings.hashCode());
                result = 31 * result + (this.thresholdPercentage.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about the rollout configuration for a job.
     * <p>
     * This configuration defines the rate at which the job deploys a configuration to a fleet of target devices.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * Object rateIncreaseCriteria;
     * IoTJobExecutionsRolloutConfigProperty ioTJobExecutionsRolloutConfigProperty = IoTJobExecutionsRolloutConfigProperty.builder()
     *         .exponentialRate(IoTJobExponentialRolloutRateProperty.builder()
     *                 .baseRatePerMinute(123)
     *                 .incrementFactor(123)
     *                 .rateIncreaseCriteria(rateIncreaseCriteria)
     *                 .build())
     *         .maximumPerMinute(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobExecutionsRolloutConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTJobExecutionsRolloutConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTJobExecutionsRolloutConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The exponential rate to increase the job rollout rate.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html#cfn-greengrassv2-deployment-iotjobexecutionsrolloutconfig-exponentialrate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html#cfn-greengrassv2-deployment-iotjobexecutionsrolloutconfig-exponentialrate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getExponentialRate() {
            return null;
        }

        /**
         * The maximum number of devices that receive a pending job notification, per minute.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html#cfn-greengrassv2-deployment-iotjobexecutionsrolloutconfig-maximumperminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexecutionsrolloutconfig.html#cfn-greengrassv2-deployment-iotjobexecutionsrolloutconfig-maximumperminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumPerMinute() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IoTJobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTJobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTJobExecutionsRolloutConfigProperty> {
            java.lang.Object exponentialRate;
            java.lang.Number maximumPerMinute;

            /**
             * Sets the value of {@link IoTJobExecutionsRolloutConfigProperty#getExponentialRate}
             * @param exponentialRate The exponential rate to increase the job rollout rate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exponentialRate(software.amazon.awscdk.IResolvable exponentialRate) {
                this.exponentialRate = exponentialRate;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobExecutionsRolloutConfigProperty#getExponentialRate}
             * @param exponentialRate The exponential rate to increase the job rollout rate.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exponentialRate(software.amazon.awscdk.services.greengrassv2.CfnDeployment.IoTJobExponentialRolloutRateProperty exponentialRate) {
                this.exponentialRate = exponentialRate;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobExecutionsRolloutConfigProperty#getMaximumPerMinute}
             * @param maximumPerMinute The maximum number of devices that receive a pending job notification, per minute.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maximumPerMinute(java.lang.Number maximumPerMinute) {
                this.maximumPerMinute = maximumPerMinute;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTJobExecutionsRolloutConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTJobExecutionsRolloutConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTJobExecutionsRolloutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTJobExecutionsRolloutConfigProperty {
            private final java.lang.Object exponentialRate;
            private final java.lang.Number maximumPerMinute;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exponentialRate = software.amazon.jsii.Kernel.get(this, "exponentialRate", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maximumPerMinute = software.amazon.jsii.Kernel.get(this, "maximumPerMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exponentialRate = builder.exponentialRate;
                this.maximumPerMinute = builder.maximumPerMinute;
            }

            @Override
            public final java.lang.Object getExponentialRate() {
                return this.exponentialRate;
            }

            @Override
            public final java.lang.Number getMaximumPerMinute() {
                return this.maximumPerMinute;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getExponentialRate() != null) {
                    data.set("exponentialRate", om.valueToTree(this.getExponentialRate()));
                }
                if (this.getMaximumPerMinute() != null) {
                    data.set("maximumPerMinute", om.valueToTree(this.getMaximumPerMinute()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobExecutionsRolloutConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTJobExecutionsRolloutConfigProperty.Jsii$Proxy that = (IoTJobExecutionsRolloutConfigProperty.Jsii$Proxy) o;

                if (this.exponentialRate != null ? !this.exponentialRate.equals(that.exponentialRate) : that.exponentialRate != null) return false;
                return this.maximumPerMinute != null ? this.maximumPerMinute.equals(that.maximumPerMinute) : that.maximumPerMinute == null;
            }

            @Override
            public final int hashCode() {
                int result = this.exponentialRate != null ? this.exponentialRate.hashCode() : 0;
                result = 31 * result + (this.maximumPerMinute != null ? this.maximumPerMinute.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about an exponential rollout rate for a configuration deployment job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * Object rateIncreaseCriteria;
     * IoTJobExponentialRolloutRateProperty ioTJobExponentialRolloutRateProperty = IoTJobExponentialRolloutRateProperty.builder()
     *         .baseRatePerMinute(123)
     *         .incrementFactor(123)
     *         .rateIncreaseCriteria(rateIncreaseCriteria)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobExponentialRolloutRateProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTJobExponentialRolloutRateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTJobExponentialRolloutRateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The minimum number of devices that receive a pending job notification, per minute, when the job starts.
         * <p>
         * This parameter defines the initial rollout rate of the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-baserateperminute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-baserateperminute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getBaseRatePerMinute();

        /**
         * The exponential factor to increase the rollout rate for the job.
         * <p>
         * This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code> , but not <code>1.55</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-incrementfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-incrementfactor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getIncrementFactor();

        /**
         * The criteria to increase the rollout rate for the job.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-rateincreasecriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobexponentialrolloutrate.html#cfn-greengrassv2-deployment-iotjobexponentialrolloutrate-rateincreasecriteria</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getRateIncreaseCriteria();

        /**
         * @return a {@link Builder} of {@link IoTJobExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTJobExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTJobExponentialRolloutRateProperty> {
            java.lang.Number baseRatePerMinute;
            java.lang.Number incrementFactor;
            java.lang.Object rateIncreaseCriteria;

            /**
             * Sets the value of {@link IoTJobExponentialRolloutRateProperty#getBaseRatePerMinute}
             * @param baseRatePerMinute The minimum number of devices that receive a pending job notification, per minute, when the job starts. This parameter is required.
             *                          This parameter defines the initial rollout rate of the job.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseRatePerMinute(java.lang.Number baseRatePerMinute) {
                this.baseRatePerMinute = baseRatePerMinute;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobExponentialRolloutRateProperty#getIncrementFactor}
             * @param incrementFactor The exponential factor to increase the rollout rate for the job. This parameter is required.
             *                        This parameter supports up to one digit after the decimal (for example, you can specify <code>1.5</code> , but not <code>1.55</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder incrementFactor(java.lang.Number incrementFactor) {
                this.incrementFactor = incrementFactor;
                return this;
            }

            /**
             * Sets the value of {@link IoTJobExponentialRolloutRateProperty#getRateIncreaseCriteria}
             * @param rateIncreaseCriteria The criteria to increase the rollout rate for the job. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rateIncreaseCriteria(java.lang.Object rateIncreaseCriteria) {
                this.rateIncreaseCriteria = rateIncreaseCriteria;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTJobExponentialRolloutRateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTJobExponentialRolloutRateProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTJobExponentialRolloutRateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTJobExponentialRolloutRateProperty {
            private final java.lang.Number baseRatePerMinute;
            private final java.lang.Number incrementFactor;
            private final java.lang.Object rateIncreaseCriteria;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseRatePerMinute = software.amazon.jsii.Kernel.get(this, "baseRatePerMinute", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.incrementFactor = software.amazon.jsii.Kernel.get(this, "incrementFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rateIncreaseCriteria = software.amazon.jsii.Kernel.get(this, "rateIncreaseCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseRatePerMinute = java.util.Objects.requireNonNull(builder.baseRatePerMinute, "baseRatePerMinute is required");
                this.incrementFactor = java.util.Objects.requireNonNull(builder.incrementFactor, "incrementFactor is required");
                this.rateIncreaseCriteria = java.util.Objects.requireNonNull(builder.rateIncreaseCriteria, "rateIncreaseCriteria is required");
            }

            @Override
            public final java.lang.Number getBaseRatePerMinute() {
                return this.baseRatePerMinute;
            }

            @Override
            public final java.lang.Number getIncrementFactor() {
                return this.incrementFactor;
            }

            @Override
            public final java.lang.Object getRateIncreaseCriteria() {
                return this.rateIncreaseCriteria;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("baseRatePerMinute", om.valueToTree(this.getBaseRatePerMinute()));
                data.set("incrementFactor", om.valueToTree(this.getIncrementFactor()));
                data.set("rateIncreaseCriteria", om.valueToTree(this.getRateIncreaseCriteria()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobExponentialRolloutRateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTJobExponentialRolloutRateProperty.Jsii$Proxy that = (IoTJobExponentialRolloutRateProperty.Jsii$Proxy) o;

                if (!baseRatePerMinute.equals(that.baseRatePerMinute)) return false;
                if (!incrementFactor.equals(that.incrementFactor)) return false;
                return this.rateIncreaseCriteria.equals(that.rateIncreaseCriteria);
            }

            @Override
            public final int hashCode() {
                int result = this.baseRatePerMinute.hashCode();
                result = 31 * result + (this.incrementFactor.hashCode());
                result = 31 * result + (this.rateIncreaseCriteria.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains information about the timeout configuration for a job.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * IoTJobTimeoutConfigProperty ioTJobTimeoutConfigProperty = IoTJobTimeoutConfigProperty.builder()
     *         .inProgressTimeoutInMinutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobtimeoutconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobtimeoutconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobTimeoutConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(IoTJobTimeoutConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IoTJobTimeoutConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The amount of time, in minutes, that devices have to complete the job.
         * <p>
         * The timer starts when the job status is set to <code>IN_PROGRESS</code> . If the job status doesn't change to a terminal state before the time expires, then the job status is set to <code>TIMED_OUT</code> .
         * <p>
         * The timeout interval must be between 1 minute and 7 days (10080 minutes).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobtimeoutconfig.html#cfn-greengrassv2-deployment-iotjobtimeoutconfig-inprogresstimeoutinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-iotjobtimeoutconfig.html#cfn-greengrassv2-deployment-iotjobtimeoutconfig-inprogresstimeoutinminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInProgressTimeoutInMinutes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IoTJobTimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IoTJobTimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IoTJobTimeoutConfigProperty> {
            java.lang.Number inProgressTimeoutInMinutes;

            /**
             * Sets the value of {@link IoTJobTimeoutConfigProperty#getInProgressTimeoutInMinutes}
             * @param inProgressTimeoutInMinutes The amount of time, in minutes, that devices have to complete the job.
             *                                   The timer starts when the job status is set to <code>IN_PROGRESS</code> . If the job status doesn't change to a terminal state before the time expires, then the job status is set to <code>TIMED_OUT</code> .
             *                                   <p>
             *                                   The timeout interval must be between 1 minute and 7 days (10080 minutes).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inProgressTimeoutInMinutes(java.lang.Number inProgressTimeoutInMinutes) {
                this.inProgressTimeoutInMinutes = inProgressTimeoutInMinutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IoTJobTimeoutConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IoTJobTimeoutConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IoTJobTimeoutConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IoTJobTimeoutConfigProperty {
            private final java.lang.Number inProgressTimeoutInMinutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inProgressTimeoutInMinutes = software.amazon.jsii.Kernel.get(this, "inProgressTimeoutInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inProgressTimeoutInMinutes = builder.inProgressTimeoutInMinutes;
            }

            @Override
            public final java.lang.Number getInProgressTimeoutInMinutes() {
                return this.inProgressTimeoutInMinutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInProgressTimeoutInMinutes() != null) {
                    data.set("inProgressTimeoutInMinutes", om.valueToTree(this.getInProgressTimeoutInMinutes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.IoTJobTimeoutConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IoTJobTimeoutConfigProperty.Jsii$Proxy that = (IoTJobTimeoutConfigProperty.Jsii$Proxy) o;

                return this.inProgressTimeoutInMinutes != null ? this.inProgressTimeoutInMinutes.equals(that.inProgressTimeoutInMinutes) : that.inProgressTimeoutInMinutes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inProgressTimeoutInMinutes != null ? this.inProgressTimeoutInMinutes.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains information about system resource limits that the  software applies to a component's processes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.greengrassv2.*;
     * SystemResourceLimitsProperty systemResourceLimitsProperty = SystemResourceLimitsProperty.builder()
     *         .cpus(123)
     *         .memory(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_greengrassv2.CfnDeployment.SystemResourceLimitsProperty")
    @software.amazon.jsii.Jsii.Proxy(SystemResourceLimitsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SystemResourceLimitsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum amount of CPU time that a component's processes can use on the core device.
         * <p>
         * A core device's total CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores, you can set this value to 2 to limit the component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to 0.25 to limit the component's processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the AWS IoT Greengrass Core software doesn't limit the component's CPU usage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html#cfn-greengrassv2-deployment-systemresourcelimits-cpus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html#cfn-greengrassv2-deployment-systemresourcelimits-cpus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCpus() {
            return null;
        }

        /**
         * The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html#cfn-greengrassv2-deployment-systemresourcelimits-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-greengrassv2-deployment-systemresourcelimits.html#cfn-greengrassv2-deployment-systemresourcelimits-memory</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMemory() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SystemResourceLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SystemResourceLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SystemResourceLimitsProperty> {
            java.lang.Number cpus;
            java.lang.Number memory;

            /**
             * Sets the value of {@link SystemResourceLimitsProperty#getCpus}
             * @param cpus The maximum amount of CPU time that a component's processes can use on the core device.
             *             A core device's total CPU time is equivalent to the device's number of CPU cores. For example, on a core device with 4 CPU cores, you can set this value to 2 to limit the component's processes to 50 percent usage of each CPU core. On a device with 1 CPU core, you can set this value to 0.25 to limit the component's processes to 25 percent usage of the CPU. If you set this value to a number greater than the number of CPU cores, the AWS IoT Greengrass Core software doesn't limit the component's CPU usage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cpus(java.lang.Number cpus) {
                this.cpus = cpus;
                return this;
            }

            /**
             * Sets the value of {@link SystemResourceLimitsProperty#getMemory}
             * @param memory The maximum amount of RAM, expressed in kilobytes, that a component's processes can use on the core device.
             *               For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/configure-greengrass-core-v2.html#configure-component-system-resource-limits">Configure system resource limits for components</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memory(java.lang.Number memory) {
                this.memory = memory;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SystemResourceLimitsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SystemResourceLimitsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SystemResourceLimitsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SystemResourceLimitsProperty {
            private final java.lang.Number cpus;
            private final java.lang.Number memory;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cpus = software.amazon.jsii.Kernel.get(this, "cpus", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cpus = builder.cpus;
                this.memory = builder.memory;
            }

            @Override
            public final java.lang.Number getCpus() {
                return this.cpus;
            }

            @Override
            public final java.lang.Number getMemory() {
                return this.memory;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCpus() != null) {
                    data.set("cpus", om.valueToTree(this.getCpus()));
                }
                if (this.getMemory() != null) {
                    data.set("memory", om.valueToTree(this.getMemory()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_greengrassv2.CfnDeployment.SystemResourceLimitsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SystemResourceLimitsProperty.Jsii$Proxy that = (SystemResourceLimitsProperty.Jsii$Proxy) o;

                if (this.cpus != null ? !this.cpus.equals(that.cpus) : that.cpus != null) return false;
                return this.memory != null ? this.memory.equals(that.memory) : that.memory == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cpus != null ? this.cpus.hashCode() : 0;
                result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.greengrassv2.CfnDeployment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.greengrassv2.CfnDeployment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.greengrassv2.CfnDeploymentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.greengrassv2.CfnDeploymentProps.Builder();
        }

        /**
         * The ARN of the target AWS IoT thing or thing group.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-targetarn</a>
         * @param targetArn The ARN of the target AWS IoT thing or thing group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(final java.lang.String targetArn) {
            this.props.targetArn(targetArn);
            return this;
        }

        /**
         * The components to deploy.
         * <p>
         * This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components</a>
         * @param components The components to deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final software.amazon.awscdk.IResolvable components) {
            this.props.components(components);
            return this;
        }
        /**
         * The components to deploy.
         * <p>
         * This is a dictionary, where each key is the name of a component, and each key's value is the version and configuration to deploy for that component.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-components</a>
         * @param components The components to deploy. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder components(final java.util.Map<java.lang.String, ? extends java.lang.Object> components) {
            this.props.components(components);
            return this;
        }

        /**
         * The name of the deployment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentname</a>
         * @param deploymentName The name of the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentName(final java.lang.String deploymentName) {
            this.props.deploymentName(deploymentName);
            return this;
        }

        /**
         * The deployment policies for the deployment.
         * <p>
         * These policies define how the deployment updates components and handles failure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies</a>
         * @param deploymentPolicies The deployment policies for the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPolicies(final software.amazon.awscdk.IResolvable deploymentPolicies) {
            this.props.deploymentPolicies(deploymentPolicies);
            return this;
        }
        /**
         * The deployment policies for the deployment.
         * <p>
         * These policies define how the deployment updates components and handles failure.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-deploymentpolicies</a>
         * @param deploymentPolicies The deployment policies for the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentPolicies(final software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentPoliciesProperty deploymentPolicies) {
            this.props.deploymentPolicies(deploymentPolicies);
            return this;
        }

        /**
         * The job configuration for the deployment configuration.
         * <p>
         * The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration</a>
         * @param iotJobConfiguration The job configuration for the deployment configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iotJobConfiguration(final software.amazon.awscdk.IResolvable iotJobConfiguration) {
            this.props.iotJobConfiguration(iotJobConfiguration);
            return this;
        }
        /**
         * The job configuration for the deployment configuration.
         * <p>
         * The job configuration specifies the rollout, timeout, and stop configurations for the deployment configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-iotjobconfiguration</a>
         * @param iotJobConfiguration The job configuration for the deployment configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iotJobConfiguration(final software.amazon.awscdk.services.greengrassv2.CfnDeployment.DeploymentIoTJobConfigurationProperty iotJobConfiguration) {
            this.props.iotJobConfiguration(iotJobConfiguration);
            return this;
        }

        /**
         * The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-parenttargetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-parenttargetarn</a>
         * @param parentTargetArn The parent deployment's <a href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">ARN</a> for a subdeployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parentTargetArn(final java.lang.String parentTargetArn) {
            this.props.parentTargetArn(parentTargetArn);
            return this;
        }

        /**
         * Application-specific metadata to attach to the deployment.
         * <p>
         * You can use tags in IAM policies to control access to AWS IoT Greengrass resources. You can also use tags to categorize your resources. For more information, see <a href="https://docs.aws.amazon.com/greengrass/v2/developerguide/tag-resources.html">Tag your AWS IoT Greengrass Version 2 resources</a> in the <em>AWS IoT Greengrass V2 Developer Guide</em> .
         * <p>
         * This <code>Json</code> property type is processed as a map of key-value pairs. It uses the following format, which is different from most <code>Tags</code> implementations in AWS CloudFormation templates.
         * <p>
         * <blockquote><pre>
         * "Tags": { "KeyName0": "value", "KeyName1": "value", "KeyName2": "value"
         * }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-greengrassv2-deployment.html#cfn-greengrassv2-deployment-tags</a>
         * @param tags Application-specific metadata to attach to the deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.greengrassv2.CfnDeployment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.greengrassv2.CfnDeployment build() {
            return new software.amazon.awscdk.services.greengrassv2.CfnDeployment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
