package software.amazon.awscdk.services.inspectorv2;

/**
 * The CIS scan configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * Object oneTime;
 * CfnCisScanConfiguration cfnCisScanConfiguration = CfnCisScanConfiguration.Builder.create(this, "MyCfnCisScanConfiguration")
 *         .scanName("scanName")
 *         .schedule(ScheduleProperty.builder()
 *                 .daily(DailyScheduleProperty.builder()
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .monthly(MonthlyScheduleProperty.builder()
 *                         .day("day")
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .oneTime(oneTime)
 *                 .weekly(WeeklyScheduleProperty.builder()
 *                         .days(List.of("days"))
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .securityLevel("securityLevel")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .targets(CisTargetsProperty.builder()
 *                 .accountIds(List.of("accountIds"))
 *                 // the properties below are optional
 *                 .targetResourceTags(Map.of(
 *                         "targetResourceTagsKey", List.of("targetResourceTags")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:24.822Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration")
public class CfnCisScanConfiguration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCisScanConfiguration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCisScanConfiguration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCisScanConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCisScanConfigurationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCisScanConfiguration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The CIS scan configuration's scan configuration ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of the CIS scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getScanName() {
        return software.amazon.jsii.Kernel.get(this, "scanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the CIS scan configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setScanName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "scanName", value);
    }

    /**
     * The CIS scan configuration's schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSchedule() {
        return software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The CIS scan configuration's schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The CIS scan configuration's schedule.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedule(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.ScheduleProperty value) {
        software.amazon.jsii.Kernel.set(this, "schedule", value);
    }

    /**
     * The CIS scan configuration's CIS Benchmark level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecurityLevel() {
        return software.amazon.jsii.Kernel.get(this, "securityLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The CIS scan configuration's CIS Benchmark level.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityLevel(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "securityLevel", value);
    }

    /**
     * The CIS scan configuration's tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The CIS scan configuration's tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * The CIS scan configuration's targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTargets() {
        return software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The CIS scan configuration's targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }

    /**
     * The CIS scan configuration's targets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargets(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.CisTargetsProperty value) {
        software.amazon.jsii.Kernel.set(this, "targets", value);
    }
    /**
     * The CIS targets.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * CisTargetsProperty cisTargetsProperty = CisTargetsProperty.builder()
     *         .accountIds(List.of("accountIds"))
     *         // the properties below are optional
     *         .targetResourceTags(Map.of(
     *                 "targetResourceTagsKey", List.of("targetResourceTags")))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.CisTargetsProperty")
    @software.amazon.jsii.Jsii.Proxy(CisTargetsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CisTargetsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The CIS target account ids.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html#cfn-inspectorv2-cisscanconfiguration-cistargets-accountids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html#cfn-inspectorv2-cisscanconfiguration-cistargets-accountids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAccountIds();

        /**
         * The CIS target resource tags.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html#cfn-inspectorv2-cisscanconfiguration-cistargets-targetresourcetags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-cistargets.html#cfn-inspectorv2-cisscanconfiguration-cistargets-targetresourcetags</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTargetResourceTags() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CisTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CisTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CisTargetsProperty> {
            java.util.List<java.lang.String> accountIds;
            java.lang.Object targetResourceTags;

            /**
             * Sets the value of {@link CisTargetsProperty#getAccountIds}
             * @param accountIds The CIS target account ids. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountIds(java.util.List<java.lang.String> accountIds) {
                this.accountIds = accountIds;
                return this;
            }

            /**
             * Sets the value of {@link CisTargetsProperty#getTargetResourceTags}
             * @param targetResourceTags The CIS target resource tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetResourceTags(software.amazon.awscdk.IResolvable targetResourceTags) {
                this.targetResourceTags = targetResourceTags;
                return this;
            }

            /**
             * Sets the value of {@link CisTargetsProperty#getTargetResourceTags}
             * @param targetResourceTags The CIS target resource tags.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetResourceTags(java.util.Map<java.lang.String, ? extends java.util.List<java.lang.String>> targetResourceTags) {
                this.targetResourceTags = targetResourceTags;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CisTargetsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CisTargetsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CisTargetsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CisTargetsProperty {
            private final java.util.List<java.lang.String> accountIds;
            private final java.lang.Object targetResourceTags;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountIds = software.amazon.jsii.Kernel.get(this, "accountIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.targetResourceTags = software.amazon.jsii.Kernel.get(this, "targetResourceTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountIds = java.util.Objects.requireNonNull(builder.accountIds, "accountIds is required");
                this.targetResourceTags = builder.targetResourceTags;
            }

            @Override
            public final java.util.List<java.lang.String> getAccountIds() {
                return this.accountIds;
            }

            @Override
            public final java.lang.Object getTargetResourceTags() {
                return this.targetResourceTags;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountIds", om.valueToTree(this.getAccountIds()));
                if (this.getTargetResourceTags() != null) {
                    data.set("targetResourceTags", om.valueToTree(this.getTargetResourceTags()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.CisTargetsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CisTargetsProperty.Jsii$Proxy that = (CisTargetsProperty.Jsii$Proxy) o;

                if (!accountIds.equals(that.accountIds)) return false;
                return this.targetResourceTags != null ? this.targetResourceTags.equals(that.targetResourceTags) : that.targetResourceTags == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountIds.hashCode();
                result = 31 * result + (this.targetResourceTags != null ? this.targetResourceTags.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A daily schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * DailyScheduleProperty dailyScheduleProperty = DailyScheduleProperty.builder()
     *         .startTime(TimeProperty.builder()
     *                 .timeOfDay("timeOfDay")
     *                 .timeZone("timeZone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-dailyschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-dailyschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.DailyScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(DailyScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DailyScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The schedule start time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-dailyschedule.html#cfn-inspectorv2-cisscanconfiguration-dailyschedule-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-dailyschedule.html#cfn-inspectorv2-cisscanconfiguration-dailyschedule-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStartTime();

        /**
         * @return a {@link Builder} of {@link DailyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DailyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DailyScheduleProperty> {
            java.lang.Object startTime;

            /**
             * Sets the value of {@link DailyScheduleProperty#getStartTime}
             * @param startTime The schedule start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.IResolvable startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link DailyScheduleProperty#getStartTime}
             * @param startTime The schedule start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.TimeProperty startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DailyScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DailyScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DailyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DailyScheduleProperty {
            private final java.lang.Object startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.Object getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.DailyScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DailyScheduleProperty.Jsii$Proxy that = (DailyScheduleProperty.Jsii$Proxy) o;

                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.startTime.hashCode();
                return result;
            }
        }
    }
    /**
     * A monthly schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * MonthlyScheduleProperty monthlyScheduleProperty = MonthlyScheduleProperty.builder()
     *         .day("day")
     *         .startTime(TimeProperty.builder()
     *                 .timeOfDay("timeOfDay")
     *                 .timeZone("timeZone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.MonthlyScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(MonthlyScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MonthlyScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The monthly schedule's day.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html#cfn-inspectorv2-cisscanconfiguration-monthlyschedule-day">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html#cfn-inspectorv2-cisscanconfiguration-monthlyschedule-day</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDay();

        /**
         * The monthly schedule's start time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html#cfn-inspectorv2-cisscanconfiguration-monthlyschedule-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-monthlyschedule.html#cfn-inspectorv2-cisscanconfiguration-monthlyschedule-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStartTime();

        /**
         * @return a {@link Builder} of {@link MonthlyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MonthlyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MonthlyScheduleProperty> {
            java.lang.String day;
            java.lang.Object startTime;

            /**
             * Sets the value of {@link MonthlyScheduleProperty#getDay}
             * @param day The monthly schedule's day. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder day(java.lang.String day) {
                this.day = day;
                return this;
            }

            /**
             * Sets the value of {@link MonthlyScheduleProperty#getStartTime}
             * @param startTime The monthly schedule's start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.IResolvable startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link MonthlyScheduleProperty#getStartTime}
             * @param startTime The monthly schedule's start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.TimeProperty startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MonthlyScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MonthlyScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MonthlyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MonthlyScheduleProperty {
            private final java.lang.String day;
            private final java.lang.Object startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.day = software.amazon.jsii.Kernel.get(this, "day", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.day = java.util.Objects.requireNonNull(builder.day, "day is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.lang.String getDay() {
                return this.day;
            }

            @Override
            public final java.lang.Object getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("day", om.valueToTree(this.getDay()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.MonthlyScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MonthlyScheduleProperty.Jsii$Proxy that = (MonthlyScheduleProperty.Jsii$Proxy) o;

                if (!day.equals(that.day)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.day.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }
    /**
     * The schedule the CIS scan configuration runs on.
     * <p>
     * Each CIS scan configuration has exactly one type of schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * Object oneTime;
     * ScheduleProperty scheduleProperty = ScheduleProperty.builder()
     *         .daily(DailyScheduleProperty.builder()
     *                 .startTime(TimeProperty.builder()
     *                         .timeOfDay("timeOfDay")
     *                         .timeZone("timeZone")
     *                         .build())
     *                 .build())
     *         .monthly(MonthlyScheduleProperty.builder()
     *                 .day("day")
     *                 .startTime(TimeProperty.builder()
     *                         .timeOfDay("timeOfDay")
     *                         .timeZone("timeZone")
     *                         .build())
     *                 .build())
     *         .oneTime(oneTime)
     *         .weekly(WeeklyScheduleProperty.builder()
     *                 .days(List.of("days"))
     *                 .startTime(TimeProperty.builder()
     *                         .timeOfDay("timeOfDay")
     *                         .timeZone("timeZone")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.ScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(ScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A daily schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-daily">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-daily</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDaily() {
            return null;
        }

        /**
         * A monthly schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-monthly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-monthly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMonthly() {
            return null;
        }

        /**
         * A one time schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-onetime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-onetime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOneTime() {
            return null;
        }

        /**
         * A weekly schedule.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-weekly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-schedule.html#cfn-inspectorv2-cisscanconfiguration-schedule-weekly</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWeekly() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ScheduleProperty> {
            java.lang.Object daily;
            java.lang.Object monthly;
            java.lang.Object oneTime;
            java.lang.Object weekly;

            /**
             * Sets the value of {@link ScheduleProperty#getDaily}
             * @param daily A daily schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daily(software.amazon.awscdk.IResolvable daily) {
                this.daily = daily;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getDaily}
             * @param daily A daily schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder daily(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.DailyScheduleProperty daily) {
                this.daily = daily;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getMonthly}
             * @param monthly A monthly schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monthly(software.amazon.awscdk.IResolvable monthly) {
                this.monthly = monthly;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getMonthly}
             * @param monthly A monthly schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder monthly(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.MonthlyScheduleProperty monthly) {
                this.monthly = monthly;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getOneTime}
             * @param oneTime A one time schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oneTime(java.lang.Object oneTime) {
                this.oneTime = oneTime;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getWeekly}
             * @param weekly A weekly schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weekly(software.amazon.awscdk.IResolvable weekly) {
                this.weekly = weekly;
                return this;
            }

            /**
             * Sets the value of {@link ScheduleProperty#getWeekly}
             * @param weekly A weekly schedule.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder weekly(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.WeeklyScheduleProperty weekly) {
                this.weekly = weekly;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ScheduleProperty {
            private final java.lang.Object daily;
            private final java.lang.Object monthly;
            private final java.lang.Object oneTime;
            private final java.lang.Object weekly;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.daily = software.amazon.jsii.Kernel.get(this, "daily", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.monthly = software.amazon.jsii.Kernel.get(this, "monthly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oneTime = software.amazon.jsii.Kernel.get(this, "oneTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.weekly = software.amazon.jsii.Kernel.get(this, "weekly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.daily = builder.daily;
                this.monthly = builder.monthly;
                this.oneTime = builder.oneTime;
                this.weekly = builder.weekly;
            }

            @Override
            public final java.lang.Object getDaily() {
                return this.daily;
            }

            @Override
            public final java.lang.Object getMonthly() {
                return this.monthly;
            }

            @Override
            public final java.lang.Object getOneTime() {
                return this.oneTime;
            }

            @Override
            public final java.lang.Object getWeekly() {
                return this.weekly;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDaily() != null) {
                    data.set("daily", om.valueToTree(this.getDaily()));
                }
                if (this.getMonthly() != null) {
                    data.set("monthly", om.valueToTree(this.getMonthly()));
                }
                if (this.getOneTime() != null) {
                    data.set("oneTime", om.valueToTree(this.getOneTime()));
                }
                if (this.getWeekly() != null) {
                    data.set("weekly", om.valueToTree(this.getWeekly()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.ScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ScheduleProperty.Jsii$Proxy that = (ScheduleProperty.Jsii$Proxy) o;

                if (this.daily != null ? !this.daily.equals(that.daily) : that.daily != null) return false;
                if (this.monthly != null ? !this.monthly.equals(that.monthly) : that.monthly != null) return false;
                if (this.oneTime != null ? !this.oneTime.equals(that.oneTime) : that.oneTime != null) return false;
                return this.weekly != null ? this.weekly.equals(that.weekly) : that.weekly == null;
            }

            @Override
            public final int hashCode() {
                int result = this.daily != null ? this.daily.hashCode() : 0;
                result = 31 * result + (this.monthly != null ? this.monthly.hashCode() : 0);
                result = 31 * result + (this.oneTime != null ? this.oneTime.hashCode() : 0);
                result = 31 * result + (this.weekly != null ? this.weekly.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * TimeProperty timeProperty = TimeProperty.builder()
     *         .timeOfDay("timeOfDay")
     *         .timeZone("timeZone")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.TimeProperty")
    @software.amazon.jsii.Jsii.Proxy(TimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The time of day in 24-hour format (00:00).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html#cfn-inspectorv2-cisscanconfiguration-time-timeofday">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html#cfn-inspectorv2-cisscanconfiguration-time-timeofday</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeOfDay();

        /**
         * The timezone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html#cfn-inspectorv2-cisscanconfiguration-time-timezone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-time.html#cfn-inspectorv2-cisscanconfiguration-time-timezone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTimeZone();

        /**
         * @return a {@link Builder} of {@link TimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TimeProperty> {
            java.lang.String timeOfDay;
            java.lang.String timeZone;

            /**
             * Sets the value of {@link TimeProperty#getTimeOfDay}
             * @param timeOfDay The time of day in 24-hour format (00:00). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeOfDay(java.lang.String timeOfDay) {
                this.timeOfDay = timeOfDay;
                return this;
            }

            /**
             * Sets the value of {@link TimeProperty#getTimeZone}
             * @param timeZone The timezone. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder timeZone(java.lang.String timeZone) {
                this.timeZone = timeZone;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TimeProperty {
            private final java.lang.String timeOfDay;
            private final java.lang.String timeZone;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.timeOfDay = software.amazon.jsii.Kernel.get(this, "timeOfDay", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.timeZone = software.amazon.jsii.Kernel.get(this, "timeZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.timeOfDay = java.util.Objects.requireNonNull(builder.timeOfDay, "timeOfDay is required");
                this.timeZone = java.util.Objects.requireNonNull(builder.timeZone, "timeZone is required");
            }

            @Override
            public final java.lang.String getTimeOfDay() {
                return this.timeOfDay;
            }

            @Override
            public final java.lang.String getTimeZone() {
                return this.timeZone;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("timeOfDay", om.valueToTree(this.getTimeOfDay()));
                data.set("timeZone", om.valueToTree(this.getTimeZone()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.TimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TimeProperty.Jsii$Proxy that = (TimeProperty.Jsii$Proxy) o;

                if (!timeOfDay.equals(that.timeOfDay)) return false;
                return this.timeZone.equals(that.timeZone);
            }

            @Override
            public final int hashCode() {
                int result = this.timeOfDay.hashCode();
                result = 31 * result + (this.timeZone.hashCode());
                return result;
            }
        }
    }
    /**
     * A weekly schedule.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.inspectorv2.*;
     * WeeklyScheduleProperty weeklyScheduleProperty = WeeklyScheduleProperty.builder()
     *         .days(List.of("days"))
     *         .startTime(TimeProperty.builder()
     *                 .timeOfDay("timeOfDay")
     *                 .timeZone("timeZone")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.WeeklyScheduleProperty")
    @software.amazon.jsii.Jsii.Proxy(WeeklyScheduleProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WeeklyScheduleProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The weekly schedule's days.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html#cfn-inspectorv2-cisscanconfiguration-weeklyschedule-days">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html#cfn-inspectorv2-cisscanconfiguration-weeklyschedule-days</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDays();

        /**
         * The weekly schedule's start time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html#cfn-inspectorv2-cisscanconfiguration-weeklyschedule-starttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-inspectorv2-cisscanconfiguration-weeklyschedule.html#cfn-inspectorv2-cisscanconfiguration-weeklyschedule-starttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStartTime();

        /**
         * @return a {@link Builder} of {@link WeeklyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WeeklyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WeeklyScheduleProperty> {
            java.util.List<java.lang.String> days;
            java.lang.Object startTime;

            /**
             * Sets the value of {@link WeeklyScheduleProperty#getDays}
             * @param days The weekly schedule's days. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder days(java.util.List<java.lang.String> days) {
                this.days = days;
                return this;
            }

            /**
             * Sets the value of {@link WeeklyScheduleProperty#getStartTime}
             * @param startTime The weekly schedule's start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.IResolvable startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Sets the value of {@link WeeklyScheduleProperty#getStartTime}
             * @param startTime The weekly schedule's start time. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startTime(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.TimeProperty startTime) {
                this.startTime = startTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WeeklyScheduleProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WeeklyScheduleProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WeeklyScheduleProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WeeklyScheduleProperty {
            private final java.util.List<java.lang.String> days;
            private final java.lang.Object startTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.days = software.amazon.jsii.Kernel.get(this, "days", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.startTime = software.amazon.jsii.Kernel.get(this, "startTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.days = java.util.Objects.requireNonNull(builder.days, "days is required");
                this.startTime = java.util.Objects.requireNonNull(builder.startTime, "startTime is required");
            }

            @Override
            public final java.util.List<java.lang.String> getDays() {
                return this.days;
            }

            @Override
            public final java.lang.Object getStartTime() {
                return this.startTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("days", om.valueToTree(this.getDays()));
                data.set("startTime", om.valueToTree(this.getStartTime()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfiguration.WeeklyScheduleProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WeeklyScheduleProperty.Jsii$Proxy that = (WeeklyScheduleProperty.Jsii$Proxy) o;

                if (!days.equals(that.days)) return false;
                return this.startTime.equals(that.startTime);
            }

            @Override
            public final int hashCode() {
                int result = this.days.hashCode();
                result = 31 * result + (this.startTime.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.inspectorv2.CfnCisScanConfigurationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The name of the CIS scan configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-scanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-scanname</a>
         * @param scanName The name of the CIS scan configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanName(final java.lang.String scanName) {
            this.props().scanName(scanName);
            return this;
        }

        /**
         * The CIS scan configuration's schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule</a>
         * @param schedule The CIS scan configuration's schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.IResolvable schedule) {
            this.props().schedule(schedule);
            return this;
        }
        /**
         * The CIS scan configuration's schedule.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule</a>
         * @param schedule The CIS scan configuration's schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.ScheduleProperty schedule) {
            this.props().schedule(schedule);
            return this;
        }

        /**
         * The CIS scan configuration's CIS Benchmark level.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-securitylevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-securitylevel</a>
         * @param securityLevel The CIS scan configuration's CIS Benchmark level. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityLevel(final java.lang.String securityLevel) {
            this.props().securityLevel(securityLevel);
            return this;
        }

        /**
         * The CIS scan configuration's tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-tags</a>
         * @param tags The CIS scan configuration's tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The CIS scan configuration's targets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets</a>
         * @param targets The CIS scan configuration's targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.IResolvable targets) {
            this.props().targets(targets);
            return this;
        }
        /**
         * The CIS scan configuration's targets.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets</a>
         * @param targets The CIS scan configuration's targets. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(final software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.CisTargetsProperty targets) {
            this.props().targets(targets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration build() {
            return new software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.inspectorv2.CfnCisScanConfigurationProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.inspectorv2.CfnCisScanConfigurationProps.Builder();
            }
            return this.props;
        }
    }
}
