package software.amazon.awscdk.services.iottwinmaker;

/**
 * Use the <code>AWS::IoTTwinMaker::ComponentType</code> resource to declare a component type.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iottwinmaker.*;
 * DataTypeProperty dataTypeProperty_;
 * DataValueProperty dataValueProperty_;
 * Object relationshipValue;
 * CfnComponentType cfnComponentType = CfnComponentType.Builder.create(this, "MyCfnComponentType")
 *         .componentTypeId("componentTypeId")
 *         .workspaceId("workspaceId")
 *         // the properties below are optional
 *         .compositeComponentTypes(Map.of(
 *                 "compositeComponentTypesKey", CompositeComponentTypeProperty.builder()
 *                         .componentTypeId("componentTypeId")
 *                         .build()))
 *         .description("description")
 *         .extendsFrom(List.of("extendsFrom"))
 *         .functions(Map.of(
 *                 "functionsKey", FunctionProperty.builder()
 *                         .implementedBy(DataConnectorProperty.builder()
 *                                 .isNative(false)
 *                                 .lambda(LambdaFunctionProperty.builder()
 *                                         .arn("arn")
 *                                         .build())
 *                                 .build())
 *                         .requiredProperties(List.of("requiredProperties"))
 *                         .scope("scope")
 *                         .build()))
 *         .isSingleton(false)
 *         .propertyDefinitions(Map.of(
 *                 "propertyDefinitionsKey", PropertyDefinitionProperty.builder()
 *                         .configurations(Map.of(
 *                                 "configurationsKey", "configurations"))
 *                         .dataType(DataTypeProperty.builder()
 *                                 .type("type")
 *                                 // the properties below are optional
 *                                 .allowedValues(List.of(DataValueProperty.builder()
 *                                         .booleanValue(false)
 *                                         .doubleValue(123)
 *                                         .expression("expression")
 *                                         .integerValue(123)
 *                                         .listValue(List.of(dataValueProperty_))
 *                                         .longValue(123)
 *                                         .mapValue(Map.of(
 *                                                 "mapValueKey", dataValueProperty_))
 *                                         .relationshipValue(relationshipValue)
 *                                         .stringValue("stringValue")
 *                                         .build()))
 *                                 .nestedType(dataTypeProperty_)
 *                                 .relationship(RelationshipProperty.builder()
 *                                         .relationshipType("relationshipType")
 *                                         .targetComponentTypeId("targetComponentTypeId")
 *                                         .build())
 *                                 .unitOfMeasure("unitOfMeasure")
 *                                 .build())
 *                         .defaultValue(DataValueProperty.builder()
 *                                 .booleanValue(false)
 *                                 .doubleValue(123)
 *                                 .expression("expression")
 *                                 .integerValue(123)
 *                                 .listValue(List.of(dataValueProperty_))
 *                                 .longValue(123)
 *                                 .mapValue(Map.of(
 *                                         "mapValueKey", dataValueProperty_))
 *                                 .relationshipValue(relationshipValue)
 *                                 .stringValue("stringValue")
 *                                 .build())
 *                         .isExternalId(false)
 *                         .isRequiredInEntity(false)
 *                         .isStoredExternally(false)
 *                         .isTimeSeries(false)
 *                         .build()))
 *         .propertyGroups(Map.of(
 *                 "propertyGroupsKey", PropertyGroupProperty.builder()
 *                         .groupType("groupType")
 *                         .propertyNames(List.of("propertyNames"))
 *                         .build()))
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.179Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType")
public class CfnComponentType extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnComponentType(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnComponentType(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnComponentType(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The date and time when the component type was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationDateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationDateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A boolean value that specifies whether the component type is abstract.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrIsAbstract() {
        return software.amazon.jsii.Kernel.get(this, "attrIsAbstract", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * A boolean value that specifies whether the component type has a schema initializer and that the schema initializer has run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrIsSchemaInitialized() {
        return software.amazon.jsii.Kernel.get(this, "attrIsSchemaInitialized", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrStatusError() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusError", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusErrorCode() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusErrorCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusErrorMessage() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusErrorMessage", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatusState() {
        return software.amazon.jsii.Kernel.get(this, "attrStatusState", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The component type the update time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdateDateTime() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdateDateTime", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getComponentTypeId() {
        return software.amazon.jsii.Kernel.get(this, "componentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setComponentTypeId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "componentTypeId", java.util.Objects.requireNonNull(value, "componentTypeId is required"));
    }

    /**
     * The ID of the workspace that contains the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkspaceId() {
        return software.amazon.jsii.Kernel.get(this, "workspaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the workspace that contains the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkspaceId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workspaceId", java.util.Objects.requireNonNull(value, "workspaceId is required"));
    }

    /**
     * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCompositeComponentTypes() {
        return software.amazon.jsii.Kernel.get(this, "compositeComponentTypes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompositeComponentTypes(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "compositeComponentTypes", value);
    }

    /**
     * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCompositeComponentTypes(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnComponentType.CompositeComponentTypeProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnComponentType.CompositeComponentTypeProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "compositeComponentTypes", value);
    }

    /**
     * The description of the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description of the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * The name of the parent component type that this component type extends.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExtendsFrom() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "extendsFrom", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The name of the parent component type that this component type extends.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExtendsFrom(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "extendsFrom", value);
    }

    /**
     * An object that maps strings to the functions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getFunctions() {
        return software.amazon.jsii.Kernel.get(this, "functions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that maps strings to the functions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "functions", value);
    }

    /**
     * An object that maps strings to the functions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setFunctions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnComponentType.FunctionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnComponentType.FunctionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "functions", value);
    }

    /**
     * A boolean value that specifies whether an entity can have more than one component of this type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsSingleton() {
        return software.amazon.jsii.Kernel.get(this, "isSingleton", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A boolean value that specifies whether an entity can have more than one component of this type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsSingleton(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isSingleton", value);
    }

    /**
     * A boolean value that specifies whether an entity can have more than one component of this type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsSingleton(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isSingleton", value);
    }

    /**
     * An object that maps strings to the property definitions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPropertyDefinitions() {
        return software.amazon.jsii.Kernel.get(this, "propertyDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that maps strings to the property definitions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropertyDefinitions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "propertyDefinitions", value);
    }

    /**
     * An object that maps strings to the property definitions in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropertyDefinitions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyDefinitionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyDefinitionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "propertyDefinitions", value);
    }

    /**
     * An object that maps strings to the property groups in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPropertyGroups() {
        return software.amazon.jsii.Kernel.get(this, "propertyGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that maps strings to the property groups in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropertyGroups(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "propertyGroups", value);
    }

    /**
     * An object that maps strings to the property groups in the component type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPropertyGroups(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyGroupProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.iottwinmaker.CfnComponentType.PropertyGroupProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "propertyGroups", value);
    }

    /**
     * The ComponentType tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The ComponentType tags.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * Specifies the ID of the composite component type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * CompositeComponentTypeProperty compositeComponentTypeProperty = CompositeComponentTypeProperty.builder()
     *         .componentTypeId("componentTypeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-compositecomponenttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-compositecomponenttype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.CompositeComponentTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(CompositeComponentTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CompositeComponentTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ID of the component type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-compositecomponenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttype-componenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-compositecomponenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttype-componenttypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComponentTypeId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CompositeComponentTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CompositeComponentTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CompositeComponentTypeProperty> {
            java.lang.String componentTypeId;

            /**
             * Sets the value of {@link CompositeComponentTypeProperty#getComponentTypeId}
             * @param componentTypeId The ID of the component type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder componentTypeId(java.lang.String componentTypeId) {
                this.componentTypeId = componentTypeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CompositeComponentTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CompositeComponentTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CompositeComponentTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CompositeComponentTypeProperty {
            private final java.lang.String componentTypeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.componentTypeId = software.amazon.jsii.Kernel.get(this, "componentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.componentTypeId = builder.componentTypeId;
            }

            @Override
            public final java.lang.String getComponentTypeId() {
                return this.componentTypeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getComponentTypeId() != null) {
                    data.set("componentTypeId", om.valueToTree(this.getComponentTypeId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.CompositeComponentTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CompositeComponentTypeProperty.Jsii$Proxy that = (CompositeComponentTypeProperty.Jsii$Proxy) o;

                return this.componentTypeId != null ? this.componentTypeId.equals(that.componentTypeId) : that.componentTypeId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.componentTypeId != null ? this.componentTypeId.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The data connector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataConnectorProperty dataConnectorProperty = DataConnectorProperty.builder()
     *         .isNative(false)
     *         .lambda(LambdaFunctionProperty.builder()
     *                 .arn("arn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataConnectorProperty")
    @software.amazon.jsii.Jsii.Proxy(DataConnectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataConnectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean value that specifies whether the data connector is native to IoT TwinMaker.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-isnative">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-isnative</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsNative() {
            return null;
        }

        /**
         * The Lambda function associated with the data connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-lambda">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-dataconnector.html#cfn-iottwinmaker-componenttype-dataconnector-lambda</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambda() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataConnectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataConnectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataConnectorProperty> {
            java.lang.Object isNative;
            java.lang.Object lambda;

            /**
             * Sets the value of {@link DataConnectorProperty#getIsNative}
             * @param isNative A boolean value that specifies whether the data connector is native to IoT TwinMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isNative(java.lang.Boolean isNative) {
                this.isNative = isNative;
                return this;
            }

            /**
             * Sets the value of {@link DataConnectorProperty#getIsNative}
             * @param isNative A boolean value that specifies whether the data connector is native to IoT TwinMaker.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isNative(software.amazon.awscdk.IResolvable isNative) {
                this.isNative = isNative;
                return this;
            }

            /**
             * Sets the value of {@link DataConnectorProperty#getLambda}
             * @param lambda The Lambda function associated with the data connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.IResolvable lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Sets the value of {@link DataConnectorProperty#getLambda}
             * @param lambda The Lambda function associated with the data connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambda(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.LambdaFunctionProperty lambda) {
                this.lambda = lambda;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataConnectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataConnectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataConnectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataConnectorProperty {
            private final java.lang.Object isNative;
            private final java.lang.Object lambda;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isNative = software.amazon.jsii.Kernel.get(this, "isNative", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambda = software.amazon.jsii.Kernel.get(this, "lambda", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isNative = builder.isNative;
                this.lambda = builder.lambda;
            }

            @Override
            public final java.lang.Object getIsNative() {
                return this.isNative;
            }

            @Override
            public final java.lang.Object getLambda() {
                return this.lambda;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getIsNative() != null) {
                    data.set("isNative", om.valueToTree(this.getIsNative()));
                }
                if (this.getLambda() != null) {
                    data.set("lambda", om.valueToTree(this.getLambda()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataConnectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataConnectorProperty.Jsii$Proxy that = (DataConnectorProperty.Jsii$Proxy) o;

                if (this.isNative != null ? !this.isNative.equals(that.isNative) : that.isNative != null) return false;
                return this.lambda != null ? this.lambda.equals(that.lambda) : that.lambda == null;
            }

            @Override
            public final int hashCode() {
                int result = this.isNative != null ? this.isNative.hashCode() : 0;
                result = 31 * result + (this.lambda != null ? this.lambda.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies the data type of a property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataTypeProperty dataTypeProperty_;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * DataTypeProperty dataTypeProperty = DataTypeProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .allowedValues(List.of(DataValueProperty.builder()
     *                 .booleanValue(false)
     *                 .doubleValue(123)
     *                 .expression("expression")
     *                 .integerValue(123)
     *                 .listValue(List.of(dataValueProperty_))
     *                 .longValue(123)
     *                 .mapValue(Map.of(
     *                         "mapValueKey", dataValueProperty_))
     *                 .relationshipValue(relationshipValue)
     *                 .stringValue("stringValue")
     *                 .build()))
     *         .nestedType(dataTypeProperty_)
     *         .relationship(RelationshipProperty.builder()
     *                 .relationshipType("relationshipType")
     *                 .targetComponentTypeId("targetComponentTypeId")
     *                 .build())
     *         .unitOfMeasure("unitOfMeasure")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(DataTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The underlying type of the data type.
         * <p>
         * Valid Values: <code>RELATIONSHIP | STRING | LONG | BOOLEAN | INTEGER | DOUBLE | LIST | MAP</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The allowed values for this data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-allowedvalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-allowedvalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowedValues() {
            return null;
        }

        /**
         * The nested type in the data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-nestedtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-nestedtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNestedType() {
            return null;
        }

        /**
         * A relationship that associates a component with another component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-relationship">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-relationship</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationship() {
            return null;
        }

        /**
         * The unit of measure used in this data type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-unitofmeasure">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datatype.html#cfn-iottwinmaker-componenttype-datatype-unitofmeasure</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUnitOfMeasure() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataTypeProperty> {
            java.lang.String type;
            java.lang.Object allowedValues;
            java.lang.Object nestedType;
            java.lang.Object relationship;
            java.lang.String unitOfMeasure;

            /**
             * Sets the value of {@link DataTypeProperty#getType}
             * @param type The underlying type of the data type. This parameter is required.
             *             Valid Values: <code>RELATIONSHIP | STRING | LONG | BOOLEAN | INTEGER | DOUBLE | LIST | MAP</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getAllowedValues}
             * @param allowedValues The allowed values for this data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(software.amazon.awscdk.IResolvable allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getAllowedValues}
             * @param allowedValues The allowed values for this data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedValues(java.util.List<? extends java.lang.Object> allowedValues) {
                this.allowedValues = allowedValues;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getNestedType}
             * @param nestedType The nested type in the data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestedType(software.amazon.awscdk.IResolvable nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getNestedType}
             * @param nestedType The nested type in the data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nestedType(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataTypeProperty nestedType) {
                this.nestedType = nestedType;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getRelationship}
             * @param relationship A relationship that associates a component with another component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationship(software.amazon.awscdk.IResolvable relationship) {
                this.relationship = relationship;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getRelationship}
             * @param relationship A relationship that associates a component with another component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationship(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.RelationshipProperty relationship) {
                this.relationship = relationship;
                return this;
            }

            /**
             * Sets the value of {@link DataTypeProperty#getUnitOfMeasure}
             * @param unitOfMeasure The unit of measure used in this data type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder unitOfMeasure(java.lang.String unitOfMeasure) {
                this.unitOfMeasure = unitOfMeasure;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataTypeProperty {
            private final java.lang.String type;
            private final java.lang.Object allowedValues;
            private final java.lang.Object nestedType;
            private final java.lang.Object relationship;
            private final java.lang.String unitOfMeasure;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.allowedValues = software.amazon.jsii.Kernel.get(this, "allowedValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nestedType = software.amazon.jsii.Kernel.get(this, "nestedType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationship = software.amazon.jsii.Kernel.get(this, "relationship", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.unitOfMeasure = software.amazon.jsii.Kernel.get(this, "unitOfMeasure", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.allowedValues = builder.allowedValues;
                this.nestedType = builder.nestedType;
                this.relationship = builder.relationship;
                this.unitOfMeasure = builder.unitOfMeasure;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getAllowedValues() {
                return this.allowedValues;
            }

            @Override
            public final java.lang.Object getNestedType() {
                return this.nestedType;
            }

            @Override
            public final java.lang.Object getRelationship() {
                return this.relationship;
            }

            @Override
            public final java.lang.String getUnitOfMeasure() {
                return this.unitOfMeasure;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getAllowedValues() != null) {
                    data.set("allowedValues", om.valueToTree(this.getAllowedValues()));
                }
                if (this.getNestedType() != null) {
                    data.set("nestedType", om.valueToTree(this.getNestedType()));
                }
                if (this.getRelationship() != null) {
                    data.set("relationship", om.valueToTree(this.getRelationship()));
                }
                if (this.getUnitOfMeasure() != null) {
                    data.set("unitOfMeasure", om.valueToTree(this.getUnitOfMeasure()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataTypeProperty.Jsii$Proxy that = (DataTypeProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                if (this.allowedValues != null ? !this.allowedValues.equals(that.allowedValues) : that.allowedValues != null) return false;
                if (this.nestedType != null ? !this.nestedType.equals(that.nestedType) : that.nestedType != null) return false;
                if (this.relationship != null ? !this.relationship.equals(that.relationship) : that.relationship != null) return false;
                return this.unitOfMeasure != null ? this.unitOfMeasure.equals(that.unitOfMeasure) : that.unitOfMeasure == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.allowedValues != null ? this.allowedValues.hashCode() : 0);
                result = 31 * result + (this.nestedType != null ? this.nestedType.hashCode() : 0);
                result = 31 * result + (this.relationship != null ? this.relationship.hashCode() : 0);
                result = 31 * result + (this.unitOfMeasure != null ? this.unitOfMeasure.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies a value for a property.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * DataValueProperty dataValueProperty = DataValueProperty.builder()
     *         .booleanValue(false)
     *         .doubleValue(123)
     *         .expression("expression")
     *         .integerValue(123)
     *         .listValue(List.of(dataValueProperty_))
     *         .longValue(123)
     *         .mapValue(Map.of(
     *                 "mapValueKey", dataValueProperty_))
     *         .relationshipValue(relationshipValue)
     *         .stringValue("stringValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataValueProperty")
    @software.amazon.jsii.Jsii.Proxy(DataValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A boolean value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-booleanvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-booleanvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBooleanValue() {
            return null;
        }

        /**
         * A double value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-doublevalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-doublevalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDoubleValue() {
            return null;
        }

        /**
         * An expression that produces the value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * An integer value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-integervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-integervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIntegerValue() {
            return null;
        }

        /**
         * A list of multiple values.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-listvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-listvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getListValue() {
            return null;
        }

        /**
         * A long value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-longvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-longvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLongValue() {
            return null;
        }

        /**
         * An object that maps strings to multiple <code>DataValue</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-mapvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-mapvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMapValue() {
            return null;
        }

        /**
         * A value that relates a component to another component.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-relationshipvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-relationshipvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRelationshipValue() {
            return null;
        }

        /**
         * A string value.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-stringvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-datavalue.html#cfn-iottwinmaker-componenttype-datavalue-stringvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStringValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataValueProperty> {
            java.lang.Object booleanValue;
            java.lang.Number doubleValue;
            java.lang.String expression;
            java.lang.Number integerValue;
            java.lang.Object listValue;
            java.lang.Number longValue;
            java.lang.Object mapValue;
            java.lang.Object relationshipValue;
            java.lang.String stringValue;

            /**
             * Sets the value of {@link DataValueProperty#getBooleanValue}
             * @param booleanValue A boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(java.lang.Boolean booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getBooleanValue}
             * @param booleanValue A boolean value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder booleanValue(software.amazon.awscdk.IResolvable booleanValue) {
                this.booleanValue = booleanValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getDoubleValue}
             * @param doubleValue A double value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder doubleValue(java.lang.Number doubleValue) {
                this.doubleValue = doubleValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getExpression}
             * @param expression An expression that produces the value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getIntegerValue}
             * @param integerValue An integer value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder integerValue(java.lang.Number integerValue) {
                this.integerValue = integerValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getListValue}
             * @param listValue A list of multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listValue(software.amazon.awscdk.IResolvable listValue) {
                this.listValue = listValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getListValue}
             * @param listValue A list of multiple values.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder listValue(java.util.List<? extends java.lang.Object> listValue) {
                this.listValue = listValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getLongValue}
             * @param longValue A long value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder longValue(java.lang.Number longValue) {
                this.longValue = longValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getMapValue}
             * @param mapValue An object that maps strings to multiple <code>DataValue</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapValue(software.amazon.awscdk.IResolvable mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getMapValue}
             * @param mapValue An object that maps strings to multiple <code>DataValue</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mapValue(java.util.Map<java.lang.String, ? extends java.lang.Object> mapValue) {
                this.mapValue = mapValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getRelationshipValue}
             * @param relationshipValue A value that relates a component to another component.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationshipValue(java.lang.Object relationshipValue) {
                this.relationshipValue = relationshipValue;
                return this;
            }

            /**
             * Sets the value of {@link DataValueProperty#getStringValue}
             * @param stringValue A string value.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stringValue(java.lang.String stringValue) {
                this.stringValue = stringValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataValueProperty {
            private final java.lang.Object booleanValue;
            private final java.lang.Number doubleValue;
            private final java.lang.String expression;
            private final java.lang.Number integerValue;
            private final java.lang.Object listValue;
            private final java.lang.Number longValue;
            private final java.lang.Object mapValue;
            private final java.lang.Object relationshipValue;
            private final java.lang.String stringValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.booleanValue = software.amazon.jsii.Kernel.get(this, "booleanValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.doubleValue = software.amazon.jsii.Kernel.get(this, "doubleValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.integerValue = software.amazon.jsii.Kernel.get(this, "integerValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.listValue = software.amazon.jsii.Kernel.get(this, "listValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.longValue = software.amazon.jsii.Kernel.get(this, "longValue", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.mapValue = software.amazon.jsii.Kernel.get(this, "mapValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.relationshipValue = software.amazon.jsii.Kernel.get(this, "relationshipValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.stringValue = software.amazon.jsii.Kernel.get(this, "stringValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.booleanValue = builder.booleanValue;
                this.doubleValue = builder.doubleValue;
                this.expression = builder.expression;
                this.integerValue = builder.integerValue;
                this.listValue = builder.listValue;
                this.longValue = builder.longValue;
                this.mapValue = builder.mapValue;
                this.relationshipValue = builder.relationshipValue;
                this.stringValue = builder.stringValue;
            }

            @Override
            public final java.lang.Object getBooleanValue() {
                return this.booleanValue;
            }

            @Override
            public final java.lang.Number getDoubleValue() {
                return this.doubleValue;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.Number getIntegerValue() {
                return this.integerValue;
            }

            @Override
            public final java.lang.Object getListValue() {
                return this.listValue;
            }

            @Override
            public final java.lang.Number getLongValue() {
                return this.longValue;
            }

            @Override
            public final java.lang.Object getMapValue() {
                return this.mapValue;
            }

            @Override
            public final java.lang.Object getRelationshipValue() {
                return this.relationshipValue;
            }

            @Override
            public final java.lang.String getStringValue() {
                return this.stringValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBooleanValue() != null) {
                    data.set("booleanValue", om.valueToTree(this.getBooleanValue()));
                }
                if (this.getDoubleValue() != null) {
                    data.set("doubleValue", om.valueToTree(this.getDoubleValue()));
                }
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }
                if (this.getIntegerValue() != null) {
                    data.set("integerValue", om.valueToTree(this.getIntegerValue()));
                }
                if (this.getListValue() != null) {
                    data.set("listValue", om.valueToTree(this.getListValue()));
                }
                if (this.getLongValue() != null) {
                    data.set("longValue", om.valueToTree(this.getLongValue()));
                }
                if (this.getMapValue() != null) {
                    data.set("mapValue", om.valueToTree(this.getMapValue()));
                }
                if (this.getRelationshipValue() != null) {
                    data.set("relationshipValue", om.valueToTree(this.getRelationshipValue()));
                }
                if (this.getStringValue() != null) {
                    data.set("stringValue", om.valueToTree(this.getStringValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.DataValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataValueProperty.Jsii$Proxy that = (DataValueProperty.Jsii$Proxy) o;

                if (this.booleanValue != null ? !this.booleanValue.equals(that.booleanValue) : that.booleanValue != null) return false;
                if (this.doubleValue != null ? !this.doubleValue.equals(that.doubleValue) : that.doubleValue != null) return false;
                if (this.expression != null ? !this.expression.equals(that.expression) : that.expression != null) return false;
                if (this.integerValue != null ? !this.integerValue.equals(that.integerValue) : that.integerValue != null) return false;
                if (this.listValue != null ? !this.listValue.equals(that.listValue) : that.listValue != null) return false;
                if (this.longValue != null ? !this.longValue.equals(that.longValue) : that.longValue != null) return false;
                if (this.mapValue != null ? !this.mapValue.equals(that.mapValue) : that.mapValue != null) return false;
                if (this.relationshipValue != null ? !this.relationshipValue.equals(that.relationshipValue) : that.relationshipValue != null) return false;
                return this.stringValue != null ? this.stringValue.equals(that.stringValue) : that.stringValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.booleanValue != null ? this.booleanValue.hashCode() : 0;
                result = 31 * result + (this.doubleValue != null ? this.doubleValue.hashCode() : 0);
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                result = 31 * result + (this.integerValue != null ? this.integerValue.hashCode() : 0);
                result = 31 * result + (this.listValue != null ? this.listValue.hashCode() : 0);
                result = 31 * result + (this.longValue != null ? this.longValue.hashCode() : 0);
                result = 31 * result + (this.mapValue != null ? this.mapValue.hashCode() : 0);
                result = 31 * result + (this.relationshipValue != null ? this.relationshipValue.hashCode() : 0);
                result = 31 * result + (this.stringValue != null ? this.stringValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The component type error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * ErrorProperty errorProperty = ErrorProperty.builder()
     *         .code("code")
     *         .message("message")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.ErrorProperty")
    @software.amazon.jsii.Jsii.Proxy(ErrorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ErrorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component type error code.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html#cfn-iottwinmaker-componenttype-error-code">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html#cfn-iottwinmaker-componenttype-error-code</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCode() {
            return null;
        }

        /**
         * The component type error message.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html#cfn-iottwinmaker-componenttype-error-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-error.html#cfn-iottwinmaker-componenttype-error-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMessage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ErrorProperty> {
            java.lang.String code;
            java.lang.String message;

            /**
             * Sets the value of {@link ErrorProperty#getCode}
             * @param code The component type error code.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder code(java.lang.String code) {
                this.code = code;
                return this;
            }

            /**
             * Sets the value of {@link ErrorProperty#getMessage}
             * @param message The component type error message.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ErrorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ErrorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ErrorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ErrorProperty {
            private final java.lang.String code;
            private final java.lang.String message;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.code = software.amazon.jsii.Kernel.get(this, "code", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.code = builder.code;
                this.message = builder.message;
            }

            @Override
            public final java.lang.String getCode() {
                return this.code;
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCode() != null) {
                    data.set("code", om.valueToTree(this.getCode()));
                }
                if (this.getMessage() != null) {
                    data.set("message", om.valueToTree(this.getMessage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.ErrorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ErrorProperty.Jsii$Proxy that = (ErrorProperty.Jsii$Proxy) o;

                if (this.code != null ? !this.code.equals(that.code) : that.code != null) return false;
                return this.message != null ? this.message.equals(that.message) : that.message == null;
            }

            @Override
            public final int hashCode() {
                int result = this.code != null ? this.code.hashCode() : 0;
                result = 31 * result + (this.message != null ? this.message.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The function body.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * FunctionProperty functionProperty = FunctionProperty.builder()
     *         .implementedBy(DataConnectorProperty.builder()
     *                 .isNative(false)
     *                 .lambda(LambdaFunctionProperty.builder()
     *                         .arn("arn")
     *                         .build())
     *                 .build())
     *         .requiredProperties(List.of("requiredProperties"))
     *         .scope("scope")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.FunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(FunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The data connector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-implementedby">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-implementedby</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getImplementedBy() {
            return null;
        }

        /**
         * The required properties of the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-requiredproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-requiredproperties</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiredProperties() {
            return null;
        }

        /**
         * The scope of the function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-scope">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-function.html#cfn-iottwinmaker-componenttype-function-scope</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getScope() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FunctionProperty> {
            java.lang.Object implementedBy;
            java.util.List<java.lang.String> requiredProperties;
            java.lang.String scope;

            /**
             * Sets the value of {@link FunctionProperty#getImplementedBy}
             * @param implementedBy The data connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder implementedBy(software.amazon.awscdk.IResolvable implementedBy) {
                this.implementedBy = implementedBy;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getImplementedBy}
             * @param implementedBy The data connector.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder implementedBy(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataConnectorProperty implementedBy) {
                this.implementedBy = implementedBy;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getRequiredProperties}
             * @param requiredProperties The required properties of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder requiredProperties(java.util.List<java.lang.String> requiredProperties) {
                this.requiredProperties = requiredProperties;
                return this;
            }

            /**
             * Sets the value of {@link FunctionProperty#getScope}
             * @param scope The scope of the function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder scope(java.lang.String scope) {
                this.scope = scope;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FunctionProperty {
            private final java.lang.Object implementedBy;
            private final java.util.List<java.lang.String> requiredProperties;
            private final java.lang.String scope;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.implementedBy = software.amazon.jsii.Kernel.get(this, "implementedBy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.requiredProperties = software.amazon.jsii.Kernel.get(this, "requiredProperties", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.implementedBy = builder.implementedBy;
                this.requiredProperties = builder.requiredProperties;
                this.scope = builder.scope;
            }

            @Override
            public final java.lang.Object getImplementedBy() {
                return this.implementedBy;
            }

            @Override
            public final java.util.List<java.lang.String> getRequiredProperties() {
                return this.requiredProperties;
            }

            @Override
            public final java.lang.String getScope() {
                return this.scope;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getImplementedBy() != null) {
                    data.set("implementedBy", om.valueToTree(this.getImplementedBy()));
                }
                if (this.getRequiredProperties() != null) {
                    data.set("requiredProperties", om.valueToTree(this.getRequiredProperties()));
                }
                if (this.getScope() != null) {
                    data.set("scope", om.valueToTree(this.getScope()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.FunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FunctionProperty.Jsii$Proxy that = (FunctionProperty.Jsii$Proxy) o;

                if (this.implementedBy != null ? !this.implementedBy.equals(that.implementedBy) : that.implementedBy != null) return false;
                if (this.requiredProperties != null ? !this.requiredProperties.equals(that.requiredProperties) : that.requiredProperties != null) return false;
                return this.scope != null ? this.scope.equals(that.scope) : that.scope == null;
            }

            @Override
            public final int hashCode() {
                int result = this.implementedBy != null ? this.implementedBy.hashCode() : 0;
                result = 31 * result + (this.requiredProperties != null ? this.requiredProperties.hashCode() : 0);
                result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The Lambda function.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * LambdaFunctionProperty lambdaFunctionProperty = LambdaFunctionProperty.builder()
     *         .arn("arn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.LambdaFunctionProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Lambda function ARN.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html#cfn-iottwinmaker-componenttype-lambdafunction-arn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-lambdafunction.html#cfn-iottwinmaker-componenttype-lambdafunction-arn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getArn();

        /**
         * @return a {@link Builder} of {@link LambdaFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionProperty> {
            java.lang.String arn;

            /**
             * Sets the value of {@link LambdaFunctionProperty#getArn}
             * @param arn The Lambda function ARN. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder arn(java.lang.String arn) {
                this.arn = arn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionProperty {
            private final java.lang.String arn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.arn = software.amazon.jsii.Kernel.get(this, "arn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.arn = java.util.Objects.requireNonNull(builder.arn, "arn is required");
            }

            @Override
            public final java.lang.String getArn() {
                return this.arn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("arn", om.valueToTree(this.getArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.LambdaFunctionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionProperty.Jsii$Proxy that = (LambdaFunctionProperty.Jsii$Proxy) o;

                return this.arn.equals(that.arn);
            }

            @Override
            public final int hashCode() {
                int result = this.arn.hashCode();
                return result;
            }
        }
    }
    /**
     * PropertyDefinition is an object that maps strings to the property definitions in the component type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * DataTypeProperty dataTypeProperty_;
     * DataValueProperty dataValueProperty_;
     * Object relationshipValue;
     * PropertyDefinitionProperty propertyDefinitionProperty = PropertyDefinitionProperty.builder()
     *         .configurations(Map.of(
     *                 "configurationsKey", "configurations"))
     *         .dataType(DataTypeProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .allowedValues(List.of(DataValueProperty.builder()
     *                         .booleanValue(false)
     *                         .doubleValue(123)
     *                         .expression("expression")
     *                         .integerValue(123)
     *                         .listValue(List.of(dataValueProperty_))
     *                         .longValue(123)
     *                         .mapValue(Map.of(
     *                                 "mapValueKey", dataValueProperty_))
     *                         .relationshipValue(relationshipValue)
     *                         .stringValue("stringValue")
     *                         .build()))
     *                 .nestedType(dataTypeProperty_)
     *                 .relationship(RelationshipProperty.builder()
     *                         .relationshipType("relationshipType")
     *                         .targetComponentTypeId("targetComponentTypeId")
     *                         .build())
     *                 .unitOfMeasure("unitOfMeasure")
     *                 .build())
     *         .defaultValue(DataValueProperty.builder()
     *                 .booleanValue(false)
     *                 .doubleValue(123)
     *                 .expression("expression")
     *                 .integerValue(123)
     *                 .listValue(List.of(dataValueProperty_))
     *                 .longValue(123)
     *                 .mapValue(Map.of(
     *                         "mapValueKey", dataValueProperty_))
     *                 .relationshipValue(relationshipValue)
     *                 .stringValue("stringValue")
     *                 .build())
     *         .isExternalId(false)
     *         .isRequiredInEntity(false)
     *         .isStoredExternally(false)
     *         .isTimeSeries(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.PropertyDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A mapping that specifies configuration information about the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-configurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-configurations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigurations() {
            return null;
        }

        /**
         * An object that specifies the data type of a property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-datatype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-datatype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataType() {
            return null;
        }

        /**
         * A boolean value that specifies whether the property ID comes from an external data store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-defaultvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-defaultvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultValue() {
            return null;
        }

        /**
         * A Boolean value that specifies whether the property ID comes from an external data source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isexternalid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isexternalid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsExternalId() {
            return null;
        }

        /**
         * A boolean value that specifies whether the property is required in an entity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isrequiredinentity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isrequiredinentity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsRequiredInEntity() {
            return null;
        }

        /**
         * A boolean value that specifies whether the property is stored externally.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isstoredexternally">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-isstoredexternally</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsStoredExternally() {
            return null;
        }

        /**
         * A boolean value that specifies whether the property consists of time series data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-istimeseries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertydefinition.html#cfn-iottwinmaker-componenttype-propertydefinition-istimeseries</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIsTimeSeries() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyDefinitionProperty> {
            java.lang.Object configurations;
            java.lang.Object dataType;
            java.lang.Object defaultValue;
            java.lang.Object isExternalId;
            java.lang.Object isRequiredInEntity;
            java.lang.Object isStoredExternally;
            java.lang.Object isTimeSeries;

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getConfigurations}
             * @param configurations A mapping that specifies configuration information about the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(software.amazon.awscdk.IResolvable configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getConfigurations}
             * @param configurations A mapping that specifies configuration information about the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configurations(java.util.Map<java.lang.String, java.lang.String> configurations) {
                this.configurations = configurations;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getDataType}
             * @param dataType An object that specifies the data type of a property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(software.amazon.awscdk.IResolvable dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getDataType}
             * @param dataType An object that specifies the data type of a property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataType(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataTypeProperty dataType) {
                this.dataType = dataType;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getDefaultValue}
             * @param defaultValue A boolean value that specifies whether the property ID comes from an external data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(software.amazon.awscdk.IResolvable defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getDefaultValue}
             * @param defaultValue A boolean value that specifies whether the property ID comes from an external data store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultValue(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.DataValueProperty defaultValue) {
                this.defaultValue = defaultValue;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsExternalId}
             * @param isExternalId A Boolean value that specifies whether the property ID comes from an external data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isExternalId(java.lang.Boolean isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsExternalId}
             * @param isExternalId A Boolean value that specifies whether the property ID comes from an external data source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isExternalId(software.amazon.awscdk.IResolvable isExternalId) {
                this.isExternalId = isExternalId;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsRequiredInEntity}
             * @param isRequiredInEntity A boolean value that specifies whether the property is required in an entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRequiredInEntity(java.lang.Boolean isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsRequiredInEntity}
             * @param isRequiredInEntity A boolean value that specifies whether the property is required in an entity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isRequiredInEntity(software.amazon.awscdk.IResolvable isRequiredInEntity) {
                this.isRequiredInEntity = isRequiredInEntity;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsStoredExternally}
             * @param isStoredExternally A boolean value that specifies whether the property is stored externally.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isStoredExternally(java.lang.Boolean isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsStoredExternally}
             * @param isStoredExternally A boolean value that specifies whether the property is stored externally.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isStoredExternally(software.amazon.awscdk.IResolvable isStoredExternally) {
                this.isStoredExternally = isStoredExternally;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsTimeSeries}
             * @param isTimeSeries A boolean value that specifies whether the property consists of time series data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isTimeSeries(java.lang.Boolean isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            /**
             * Sets the value of {@link PropertyDefinitionProperty#getIsTimeSeries}
             * @param isTimeSeries A boolean value that specifies whether the property consists of time series data.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isTimeSeries(software.amazon.awscdk.IResolvable isTimeSeries) {
                this.isTimeSeries = isTimeSeries;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyDefinitionProperty {
            private final java.lang.Object configurations;
            private final java.lang.Object dataType;
            private final java.lang.Object defaultValue;
            private final java.lang.Object isExternalId;
            private final java.lang.Object isRequiredInEntity;
            private final java.lang.Object isStoredExternally;
            private final java.lang.Object isTimeSeries;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.configurations = software.amazon.jsii.Kernel.get(this, "configurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dataType = software.amazon.jsii.Kernel.get(this, "dataType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.defaultValue = software.amazon.jsii.Kernel.get(this, "defaultValue", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isExternalId = software.amazon.jsii.Kernel.get(this, "isExternalId", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isRequiredInEntity = software.amazon.jsii.Kernel.get(this, "isRequiredInEntity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isStoredExternally = software.amazon.jsii.Kernel.get(this, "isStoredExternally", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.isTimeSeries = software.amazon.jsii.Kernel.get(this, "isTimeSeries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.configurations = builder.configurations;
                this.dataType = builder.dataType;
                this.defaultValue = builder.defaultValue;
                this.isExternalId = builder.isExternalId;
                this.isRequiredInEntity = builder.isRequiredInEntity;
                this.isStoredExternally = builder.isStoredExternally;
                this.isTimeSeries = builder.isTimeSeries;
            }

            @Override
            public final java.lang.Object getConfigurations() {
                return this.configurations;
            }

            @Override
            public final java.lang.Object getDataType() {
                return this.dataType;
            }

            @Override
            public final java.lang.Object getDefaultValue() {
                return this.defaultValue;
            }

            @Override
            public final java.lang.Object getIsExternalId() {
                return this.isExternalId;
            }

            @Override
            public final java.lang.Object getIsRequiredInEntity() {
                return this.isRequiredInEntity;
            }

            @Override
            public final java.lang.Object getIsStoredExternally() {
                return this.isStoredExternally;
            }

            @Override
            public final java.lang.Object getIsTimeSeries() {
                return this.isTimeSeries;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConfigurations() != null) {
                    data.set("configurations", om.valueToTree(this.getConfigurations()));
                }
                if (this.getDataType() != null) {
                    data.set("dataType", om.valueToTree(this.getDataType()));
                }
                if (this.getDefaultValue() != null) {
                    data.set("defaultValue", om.valueToTree(this.getDefaultValue()));
                }
                if (this.getIsExternalId() != null) {
                    data.set("isExternalId", om.valueToTree(this.getIsExternalId()));
                }
                if (this.getIsRequiredInEntity() != null) {
                    data.set("isRequiredInEntity", om.valueToTree(this.getIsRequiredInEntity()));
                }
                if (this.getIsStoredExternally() != null) {
                    data.set("isStoredExternally", om.valueToTree(this.getIsStoredExternally()));
                }
                if (this.getIsTimeSeries() != null) {
                    data.set("isTimeSeries", om.valueToTree(this.getIsTimeSeries()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.PropertyDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyDefinitionProperty.Jsii$Proxy that = (PropertyDefinitionProperty.Jsii$Proxy) o;

                if (this.configurations != null ? !this.configurations.equals(that.configurations) : that.configurations != null) return false;
                if (this.dataType != null ? !this.dataType.equals(that.dataType) : that.dataType != null) return false;
                if (this.defaultValue != null ? !this.defaultValue.equals(that.defaultValue) : that.defaultValue != null) return false;
                if (this.isExternalId != null ? !this.isExternalId.equals(that.isExternalId) : that.isExternalId != null) return false;
                if (this.isRequiredInEntity != null ? !this.isRequiredInEntity.equals(that.isRequiredInEntity) : that.isRequiredInEntity != null) return false;
                if (this.isStoredExternally != null ? !this.isStoredExternally.equals(that.isStoredExternally) : that.isStoredExternally != null) return false;
                return this.isTimeSeries != null ? this.isTimeSeries.equals(that.isTimeSeries) : that.isTimeSeries == null;
            }

            @Override
            public final int hashCode() {
                int result = this.configurations != null ? this.configurations.hashCode() : 0;
                result = 31 * result + (this.dataType != null ? this.dataType.hashCode() : 0);
                result = 31 * result + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
                result = 31 * result + (this.isExternalId != null ? this.isExternalId.hashCode() : 0);
                result = 31 * result + (this.isRequiredInEntity != null ? this.isRequiredInEntity.hashCode() : 0);
                result = 31 * result + (this.isStoredExternally != null ? this.isStoredExternally.hashCode() : 0);
                result = 31 * result + (this.isTimeSeries != null ? this.isTimeSeries.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The property group.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * PropertyGroupProperty propertyGroupProperty = PropertyGroupProperty.builder()
     *         .groupType("groupType")
     *         .propertyNames(List.of("propertyNames"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.PropertyGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(PropertyGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PropertyGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The group type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html#cfn-iottwinmaker-componenttype-propertygroup-grouptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html#cfn-iottwinmaker-componenttype-propertygroup-grouptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroupType() {
            return null;
        }

        /**
         * The property names.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html#cfn-iottwinmaker-componenttype-propertygroup-propertynames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-propertygroup.html#cfn-iottwinmaker-componenttype-propertygroup-propertynames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPropertyNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PropertyGroupProperty> {
            java.lang.String groupType;
            java.util.List<java.lang.String> propertyNames;

            /**
             * Sets the value of {@link PropertyGroupProperty#getGroupType}
             * @param groupType The group type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groupType(java.lang.String groupType) {
                this.groupType = groupType;
                return this;
            }

            /**
             * Sets the value of {@link PropertyGroupProperty#getPropertyNames}
             * @param propertyNames The property names.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder propertyNames(java.util.List<java.lang.String> propertyNames) {
                this.propertyNames = propertyNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PropertyGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PropertyGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PropertyGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PropertyGroupProperty {
            private final java.lang.String groupType;
            private final java.util.List<java.lang.String> propertyNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.groupType = software.amazon.jsii.Kernel.get(this, "groupType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.propertyNames = software.amazon.jsii.Kernel.get(this, "propertyNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.groupType = builder.groupType;
                this.propertyNames = builder.propertyNames;
            }

            @Override
            public final java.lang.String getGroupType() {
                return this.groupType;
            }

            @Override
            public final java.util.List<java.lang.String> getPropertyNames() {
                return this.propertyNames;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGroupType() != null) {
                    data.set("groupType", om.valueToTree(this.getGroupType()));
                }
                if (this.getPropertyNames() != null) {
                    data.set("propertyNames", om.valueToTree(this.getPropertyNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.PropertyGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PropertyGroupProperty.Jsii$Proxy that = (PropertyGroupProperty.Jsii$Proxy) o;

                if (this.groupType != null ? !this.groupType.equals(that.groupType) : that.groupType != null) return false;
                return this.propertyNames != null ? this.propertyNames.equals(that.propertyNames) : that.propertyNames == null;
            }

            @Override
            public final int hashCode() {
                int result = this.groupType != null ? this.groupType.hashCode() : 0;
                result = 31 * result + (this.propertyNames != null ? this.propertyNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that specifies a relationship with another component type.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * RelationshipProperty relationshipProperty = RelationshipProperty.builder()
     *         .relationshipType("relationshipType")
     *         .targetComponentTypeId("targetComponentTypeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.RelationshipProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationshipProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationshipProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of the relationship.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-relationshiptype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-relationshiptype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRelationshipType() {
            return null;
        }

        /**
         * The ID of the target component type associated with this relationship.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-targetcomponenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationship.html#cfn-iottwinmaker-componenttype-relationship-targetcomponenttypeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetComponentTypeId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationshipProperty> {
            java.lang.String relationshipType;
            java.lang.String targetComponentTypeId;

            /**
             * Sets the value of {@link RelationshipProperty#getRelationshipType}
             * @param relationshipType The type of the relationship.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder relationshipType(java.lang.String relationshipType) {
                this.relationshipType = relationshipType;
                return this;
            }

            /**
             * Sets the value of {@link RelationshipProperty#getTargetComponentTypeId}
             * @param targetComponentTypeId The ID of the target component type associated with this relationship.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetComponentTypeId(java.lang.String targetComponentTypeId) {
                this.targetComponentTypeId = targetComponentTypeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationshipProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationshipProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationshipProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationshipProperty {
            private final java.lang.String relationshipType;
            private final java.lang.String targetComponentTypeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.relationshipType = software.amazon.jsii.Kernel.get(this, "relationshipType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetComponentTypeId = software.amazon.jsii.Kernel.get(this, "targetComponentTypeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.relationshipType = builder.relationshipType;
                this.targetComponentTypeId = builder.targetComponentTypeId;
            }

            @Override
            public final java.lang.String getRelationshipType() {
                return this.relationshipType;
            }

            @Override
            public final java.lang.String getTargetComponentTypeId() {
                return this.targetComponentTypeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getRelationshipType() != null) {
                    data.set("relationshipType", om.valueToTree(this.getRelationshipType()));
                }
                if (this.getTargetComponentTypeId() != null) {
                    data.set("targetComponentTypeId", om.valueToTree(this.getTargetComponentTypeId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.RelationshipProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationshipProperty.Jsii$Proxy that = (RelationshipProperty.Jsii$Proxy) o;

                if (this.relationshipType != null ? !this.relationshipType.equals(that.relationshipType) : that.relationshipType != null) return false;
                return this.targetComponentTypeId != null ? this.targetComponentTypeId.equals(that.targetComponentTypeId) : that.targetComponentTypeId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.relationshipType != null ? this.relationshipType.hashCode() : 0;
                result = 31 * result + (this.targetComponentTypeId != null ? this.targetComponentTypeId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The component type relationship value.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * RelationshipValueProperty relationshipValueProperty = RelationshipValueProperty.builder()
     *         .targetComponentName("targetComponentName")
     *         .targetEntityId("targetEntityId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.RelationshipValueProperty")
    @software.amazon.jsii.Jsii.Proxy(RelationshipValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RelationshipValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target component name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html#cfn-iottwinmaker-componenttype-relationshipvalue-targetcomponentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html#cfn-iottwinmaker-componenttype-relationshipvalue-targetcomponentname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetComponentName() {
            return null;
        }

        /**
         * The target entity Id.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html#cfn-iottwinmaker-componenttype-relationshipvalue-targetentityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-relationshipvalue.html#cfn-iottwinmaker-componenttype-relationshipvalue-targetentityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTargetEntityId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RelationshipValueProperty> {
            java.lang.String targetComponentName;
            java.lang.String targetEntityId;

            /**
             * Sets the value of {@link RelationshipValueProperty#getTargetComponentName}
             * @param targetComponentName The target component name.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetComponentName(java.lang.String targetComponentName) {
                this.targetComponentName = targetComponentName;
                return this;
            }

            /**
             * Sets the value of {@link RelationshipValueProperty#getTargetEntityId}
             * @param targetEntityId The target entity Id.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetEntityId(java.lang.String targetEntityId) {
                this.targetEntityId = targetEntityId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RelationshipValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RelationshipValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RelationshipValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RelationshipValueProperty {
            private final java.lang.String targetComponentName;
            private final java.lang.String targetEntityId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetComponentName = software.amazon.jsii.Kernel.get(this, "targetComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetEntityId = software.amazon.jsii.Kernel.get(this, "targetEntityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetComponentName = builder.targetComponentName;
                this.targetEntityId = builder.targetEntityId;
            }

            @Override
            public final java.lang.String getTargetComponentName() {
                return this.targetComponentName;
            }

            @Override
            public final java.lang.String getTargetEntityId() {
                return this.targetEntityId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getTargetComponentName() != null) {
                    data.set("targetComponentName", om.valueToTree(this.getTargetComponentName()));
                }
                if (this.getTargetEntityId() != null) {
                    data.set("targetEntityId", om.valueToTree(this.getTargetEntityId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.RelationshipValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RelationshipValueProperty.Jsii$Proxy that = (RelationshipValueProperty.Jsii$Proxy) o;

                if (this.targetComponentName != null ? !this.targetComponentName.equals(that.targetComponentName) : that.targetComponentName != null) return false;
                return this.targetEntityId != null ? this.targetEntityId.equals(that.targetEntityId) : that.targetEntityId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.targetComponentName != null ? this.targetComponentName.hashCode() : 0;
                result = 31 * result + (this.targetEntityId != null ? this.targetEntityId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The component type status.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.iottwinmaker.*;
     * StatusProperty statusProperty = StatusProperty.builder()
     *         .error(ErrorProperty.builder()
     *                 .code("code")
     *                 .message("message")
     *                 .build())
     *         .state("state")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iottwinmaker.CfnComponentType.StatusProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The component type error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html#cfn-iottwinmaker-componenttype-status-error">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html#cfn-iottwinmaker-componenttype-status-error</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getError() {
            return null;
        }

        /**
         * The component type status state.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html#cfn-iottwinmaker-componenttype-status-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iottwinmaker-componenttype-status.html#cfn-iottwinmaker-componenttype-status-state</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getState() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusProperty> {
            java.lang.Object error;
            java.lang.String state;

            /**
             * Sets the value of {@link StatusProperty#getError}
             * @param error The component type error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder error(software.amazon.awscdk.IResolvable error) {
                this.error = error;
                return this;
            }

            /**
             * Sets the value of {@link StatusProperty#getError}
             * @param error The component type error.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder error(software.amazon.awscdk.services.iottwinmaker.CfnComponentType.ErrorProperty error) {
                this.error = error;
                return this;
            }

            /**
             * Sets the value of {@link StatusProperty#getState}
             * @param state The component type status state.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder state(java.lang.String state) {
                this.state = state;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StatusProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusProperty {
            private final java.lang.Object error;
            private final java.lang.String state;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.error = software.amazon.jsii.Kernel.get(this, "error", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.state = software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.error = builder.error;
                this.state = builder.state;
            }

            @Override
            public final java.lang.Object getError() {
                return this.error;
            }

            @Override
            public final java.lang.String getState() {
                return this.state;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getError() != null) {
                    data.set("error", om.valueToTree(this.getError()));
                }
                if (this.getState() != null) {
                    data.set("state", om.valueToTree(this.getState()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iottwinmaker.CfnComponentType.StatusProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusProperty.Jsii$Proxy that = (StatusProperty.Jsii$Proxy) o;

                if (this.error != null ? !this.error.equals(that.error) : that.error != null) return false;
                return this.state != null ? this.state.equals(that.state) : that.state == null;
            }

            @Override
            public final int hashCode() {
                int result = this.error != null ? this.error.hashCode() : 0;
                result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.iottwinmaker.CfnComponentType}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.iottwinmaker.CfnComponentType> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.iottwinmaker.CfnComponentTypeProps.Builder();
        }

        /**
         * The ID of the component type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-componenttypeid</a>
         * @param componentTypeId The ID of the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder componentTypeId(final java.lang.String componentTypeId) {
            this.props.componentTypeId(componentTypeId);
            return this;
        }

        /**
         * The ID of the workspace that contains the component type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-workspaceid</a>
         * @param workspaceId The ID of the workspace that contains the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workspaceId(final java.lang.String workspaceId) {
            this.props.workspaceId(workspaceId);
            return this;
        }

        /**
         * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
         * <p>
         * <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes</a>
         * @param compositeComponentTypes Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponentTypes(final software.amazon.awscdk.IResolvable compositeComponentTypes) {
            this.props.compositeComponentTypes(compositeComponentTypes);
            return this;
        }
        /**
         * Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> .
         * <p>
         * <code>CompositeComponentType</code> is referenced by <code>componentTypeId</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-compositecomponenttypes</a>
         * @param compositeComponentTypes Maps strings to <code>compositeComponentTypes</code> of the <code>componentType</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compositeComponentTypes(final java.util.Map<java.lang.String, ? extends java.lang.Object> compositeComponentTypes) {
            this.props.compositeComponentTypes(compositeComponentTypes);
            return this;
        }

        /**
         * The description of the component type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-description</a>
         * @param description The description of the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * The name of the parent component type that this component type extends.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-extendsfrom</a>
         * @param extendsFrom The name of the parent component type that this component type extends. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extendsFrom(final java.util.List<java.lang.String> extendsFrom) {
            this.props.extendsFrom(extendsFrom);
            return this;
        }

        /**
         * An object that maps strings to the functions in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information on the FunctionResponse object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_FunctionResponse.html">FunctionResponse</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions</a>
         * @param functions An object that maps strings to the functions in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(final software.amazon.awscdk.IResolvable functions) {
            this.props.functions(functions);
            return this;
        }
        /**
         * An object that maps strings to the functions in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information on the FunctionResponse object see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_FunctionResponse.html">FunctionResponse</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-functions</a>
         * @param functions An object that maps strings to the functions in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functions(final java.util.Map<java.lang.String, ? extends java.lang.Object> functions) {
            this.props.functions(functions);
            return this;
        }

        /**
         * A boolean value that specifies whether an entity can have more than one component of this type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton</a>
         * @param isSingleton A boolean value that specifies whether an entity can have more than one component of this type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSingleton(final java.lang.Boolean isSingleton) {
            this.props.isSingleton(isSingleton);
            return this;
        }
        /**
         * A boolean value that specifies whether an entity can have more than one component of this type.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-issingleton</a>
         * @param isSingleton A boolean value that specifies whether an entity can have more than one component of this type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isSingleton(final software.amazon.awscdk.IResolvable isSingleton) {
            this.props.isSingleton(isSingleton);
            return this;
        }

        /**
         * An object that maps strings to the property definitions in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information about the PropertyDefinitionResponse object, see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_PropertyDefinitionResponse.html">PropertyDefinitionResponse</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions</a>
         * @param propertyDefinitions An object that maps strings to the property definitions in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyDefinitions(final software.amazon.awscdk.IResolvable propertyDefinitions) {
            this.props.propertyDefinitions(propertyDefinitions);
            return this;
        }
        /**
         * An object that maps strings to the property definitions in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * For information about the PropertyDefinitionResponse object, see the <a href="https://docs.aws.amazon.com//iot-twinmaker/latest/apireference/API_PropertyDefinitionResponse.html">PropertyDefinitionResponse</a> API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertydefinitions</a>
         * @param propertyDefinitions An object that maps strings to the property definitions in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyDefinitions(final java.util.Map<java.lang.String, ? extends java.lang.Object> propertyDefinitions) {
            this.props.propertyDefinitions(propertyDefinitions);
            return this;
        }

        /**
         * An object that maps strings to the property groups in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups</a>
         * @param propertyGroups An object that maps strings to the property groups in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyGroups(final software.amazon.awscdk.IResolvable propertyGroups) {
            this.props.propertyGroups(propertyGroups);
            return this;
        }
        /**
         * An object that maps strings to the property groups in the component type.
         * <p>
         * Each string in the mapping must be unique to this object.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-propertygroups</a>
         * @param propertyGroups An object that maps strings to the property groups in the component type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propertyGroups(final java.util.Map<java.lang.String, ? extends java.lang.Object> propertyGroups) {
            this.props.propertyGroups(propertyGroups);
            return this;
        }

        /**
         * The ComponentType tags.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iottwinmaker-componenttype.html#cfn-iottwinmaker-componenttype-tags</a>
         * @param tags The ComponentType tags. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.iottwinmaker.CfnComponentType}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.iottwinmaker.CfnComponentType build() {
            return new software.amazon.awscdk.services.iottwinmaker.CfnComponentType(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
