package software.amazon.awscdk.services.iotwireless;

/**
 * Properties for defining a <code>CfnMulticastGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iotwireless.*;
 * CfnMulticastGroupProps cfnMulticastGroupProps = CfnMulticastGroupProps.builder()
 *         .loRaWan(LoRaWANProperty.builder()
 *                 .dlClass("dlClass")
 *                 .rfRegion("rfRegion")
 *                 // the properties below are optional
 *                 .numberOfDevicesInGroup(123)
 *                 .numberOfDevicesRequested(123)
 *                 .build())
 *         // the properties below are optional
 *         .associateWirelessDevice("associateWirelessDevice")
 *         .description("description")
 *         .disassociateWirelessDevice("disassociateWirelessDevice")
 *         .name("name")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.221Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iotwireless.CfnMulticastGroupProps")
@software.amazon.jsii.Jsii.Proxy(CfnMulticastGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnMulticastGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The LoRaWAN information that is to be used with the multicast group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-lorawan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-lorawan</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getLoRaWan();

    /**
     * The ID of the wireless device to associate with a multicast group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-associatewirelessdevice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-associatewirelessdevice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAssociateWirelessDevice() {
        return null;
    }

    /**
     * The description of the multicast group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The ID of the wireless device to disassociate from a multicast group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-disassociatewirelessdevice">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-disassociatewirelessdevice</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisassociateWirelessDevice() {
        return null;
    }

    /**
     * The name of the multicast group.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * The tags are an array of key-value pairs to attach to the specified resource.
     * <p>
     * Tags can have a minimum of 0 and a maximum of 50 items.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-multicastgroup.html#cfn-iotwireless-multicastgroup-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnMulticastGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnMulticastGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnMulticastGroupProps> {
        java.lang.Object loRaWan;
        java.lang.String associateWirelessDevice;
        java.lang.String description;
        java.lang.String disassociateWirelessDevice;
        java.lang.String name;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getLoRaWan}
         * @param loRaWan The LoRaWAN information that is to be used with the multicast group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.IResolvable loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getLoRaWan}
         * @param loRaWan The LoRaWAN information that is to be used with the multicast group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loRaWan(software.amazon.awscdk.services.iotwireless.CfnMulticastGroup.LoRaWANProperty loRaWan) {
            this.loRaWan = loRaWan;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getAssociateWirelessDevice}
         * @param associateWirelessDevice The ID of the wireless device to associate with a multicast group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associateWirelessDevice(java.lang.String associateWirelessDevice) {
            this.associateWirelessDevice = associateWirelessDevice;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getDescription}
         * @param description The description of the multicast group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getDisassociateWirelessDevice}
         * @param disassociateWirelessDevice The ID of the wireless device to disassociate from a multicast group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disassociateWirelessDevice(java.lang.String disassociateWirelessDevice) {
            this.disassociateWirelessDevice = disassociateWirelessDevice;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getName}
         * @param name The name of the multicast group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnMulticastGroupProps#getTags}
         * @param tags The tags are an array of key-value pairs to attach to the specified resource.
         *             Tags can have a minimum of 0 and a maximum of 50 items.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnMulticastGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnMulticastGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnMulticastGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnMulticastGroupProps {
        private final java.lang.Object loRaWan;
        private final java.lang.String associateWirelessDevice;
        private final java.lang.String description;
        private final java.lang.String disassociateWirelessDevice;
        private final java.lang.String name;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.loRaWan = software.amazon.jsii.Kernel.get(this, "loRaWan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.associateWirelessDevice = software.amazon.jsii.Kernel.get(this, "associateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.disassociateWirelessDevice = software.amazon.jsii.Kernel.get(this, "disassociateWirelessDevice", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.loRaWan = java.util.Objects.requireNonNull(builder.loRaWan, "loRaWan is required");
            this.associateWirelessDevice = builder.associateWirelessDevice;
            this.description = builder.description;
            this.disassociateWirelessDevice = builder.disassociateWirelessDevice;
            this.name = builder.name;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getLoRaWan() {
            return this.loRaWan;
        }

        @Override
        public final java.lang.String getAssociateWirelessDevice() {
            return this.associateWirelessDevice;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getDisassociateWirelessDevice() {
            return this.disassociateWirelessDevice;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("loRaWan", om.valueToTree(this.getLoRaWan()));
            if (this.getAssociateWirelessDevice() != null) {
                data.set("associateWirelessDevice", om.valueToTree(this.getAssociateWirelessDevice()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDisassociateWirelessDevice() != null) {
                data.set("disassociateWirelessDevice", om.valueToTree(this.getDisassociateWirelessDevice()));
            }
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iotwireless.CfnMulticastGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnMulticastGroupProps.Jsii$Proxy that = (CfnMulticastGroupProps.Jsii$Proxy) o;

            if (!loRaWan.equals(that.loRaWan)) return false;
            if (this.associateWirelessDevice != null ? !this.associateWirelessDevice.equals(that.associateWirelessDevice) : that.associateWirelessDevice != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.disassociateWirelessDevice != null ? !this.disassociateWirelessDevice.equals(that.disassociateWirelessDevice) : that.disassociateWirelessDevice != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.loRaWan.hashCode();
            result = 31 * result + (this.associateWirelessDevice != null ? this.associateWirelessDevice.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.disassociateWirelessDevice != null ? this.disassociateWirelessDevice.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
