package software.amazon.awscdk.services.kafkaconnect;

/**
 * Properties for defining a <code>CfnConnector</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.kafkaconnect.*;
 * CfnConnectorProps cfnConnectorProps = CfnConnectorProps.builder()
 *         .capacity(CapacityProperty.builder()
 *                 .autoScaling(AutoScalingProperty.builder()
 *                         .maxWorkerCount(123)
 *                         .mcuCount(123)
 *                         .minWorkerCount(123)
 *                         .scaleInPolicy(ScaleInPolicyProperty.builder()
 *                                 .cpuUtilizationPercentage(123)
 *                                 .build())
 *                         .scaleOutPolicy(ScaleOutPolicyProperty.builder()
 *                                 .cpuUtilizationPercentage(123)
 *                                 .build())
 *                         .build())
 *                 .provisionedCapacity(ProvisionedCapacityProperty.builder()
 *                         .workerCount(123)
 *                         // the properties below are optional
 *                         .mcuCount(123)
 *                         .build())
 *                 .build())
 *         .connectorConfiguration(Map.of(
 *                 "connectorConfigurationKey", "connectorConfiguration"))
 *         .connectorName("connectorName")
 *         .kafkaCluster(KafkaClusterProperty.builder()
 *                 .apacheKafkaCluster(ApacheKafkaClusterProperty.builder()
 *                         .bootstrapServers("bootstrapServers")
 *                         .vpc(VpcProperty.builder()
 *                                 .securityGroups(List.of("securityGroups"))
 *                                 .subnets(List.of("subnets"))
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .kafkaClusterClientAuthentication(KafkaClusterClientAuthenticationProperty.builder()
 *                 .authenticationType("authenticationType")
 *                 .build())
 *         .kafkaClusterEncryptionInTransit(KafkaClusterEncryptionInTransitProperty.builder()
 *                 .encryptionType("encryptionType")
 *                 .build())
 *         .kafkaConnectVersion("kafkaConnectVersion")
 *         .plugins(List.of(PluginProperty.builder()
 *                 .customPlugin(CustomPluginProperty.builder()
 *                         .customPluginArn("customPluginArn")
 *                         .revision(123)
 *                         .build())
 *                 .build()))
 *         .serviceExecutionRoleArn("serviceExecutionRoleArn")
 *         // the properties below are optional
 *         .connectorDescription("connectorDescription")
 *         .logDelivery(LogDeliveryProperty.builder()
 *                 .workerLogDelivery(WorkerLogDeliveryProperty.builder()
 *                         .cloudWatchLogs(CloudWatchLogsLogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .logGroup("logGroup")
 *                                 .build())
 *                         .firehose(FirehoseLogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .deliveryStream("deliveryStream")
 *                                 .build())
 *                         .s3(S3LogDeliveryProperty.builder()
 *                                 .enabled(false)
 *                                 // the properties below are optional
 *                                 .bucket("bucket")
 *                                 .prefix("prefix")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .workerConfiguration(WorkerConfigurationProperty.builder()
 *                 .revision(123)
 *                 .workerConfigurationArn("workerConfigurationArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.294Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kafkaconnect.CfnConnectorProps")
@software.amazon.jsii.Jsii.Proxy(CfnConnectorProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnConnectorProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The connector's compute capacity settings.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-capacity</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getCapacity();

    /**
     * The configuration of the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConnectorConfiguration();

    /**
     * The name of the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectorname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getConnectorName();

    /**
     * The details of the Apache Kafka cluster to which the connector is connected.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkacluster</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKafkaCluster();

    /**
     * The type of client authentication used to connect to the Apache Kafka cluster.
     * <p>
     * The value is NONE when no client authentication is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterclientauthentication</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusterClientAuthentication();

    /**
     * Details of encryption in transit to the Apache Kafka cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaclusterencryptionintransit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getKafkaClusterEncryptionInTransit();

    /**
     * The version of Kafka Connect.
     * <p>
     * It has to be compatible with both the Apache Kafka cluster's version and the plugins.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-kafkaconnectversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getKafkaConnectVersion();

    /**
     * Specifies which plugin to use for the connector.
     * <p>
     * You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-plugins</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getPlugins();

    /**
     * The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-serviceexecutionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getServiceExecutionRoleArn();

    /**
     * The description of the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-connectordescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getConnectorDescription() {
        return null;
    }

    /**
     * The settings for delivering connector logs to Amazon CloudWatch Logs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-logdelivery</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getLogDelivery() {
        return null;
    }

    /**
     * A collection of tags associated with a resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The worker configurations that are in use with the connector.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kafkaconnect-connector.html#cfn-kafkaconnect-connector-workerconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getWorkerConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnConnectorProps> {
        java.lang.Object capacity;
        java.lang.Object connectorConfiguration;
        java.lang.String connectorName;
        java.lang.Object kafkaCluster;
        java.lang.Object kafkaClusterClientAuthentication;
        java.lang.Object kafkaClusterEncryptionInTransit;
        java.lang.String kafkaConnectVersion;
        java.lang.Object plugins;
        java.lang.String serviceExecutionRoleArn;
        java.lang.String connectorDescription;
        java.lang.Object logDelivery;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object workerConfiguration;

        /**
         * Sets the value of {@link CfnConnectorProps#getCapacity}
         * @param capacity The connector's compute capacity settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.IResolvable capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getCapacity}
         * @param capacity The connector's compute capacity settings. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacity(software.amazon.awscdk.services.kafkaconnect.CfnConnector.CapacityProperty capacity) {
            this.capacity = capacity;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorConfiguration}
         * @param connectorConfiguration The configuration of the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorConfiguration(software.amazon.awscdk.IResolvable connectorConfiguration) {
            this.connectorConfiguration = connectorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorConfiguration}
         * @param connectorConfiguration The configuration of the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorConfiguration(java.util.Map<java.lang.String, java.lang.String> connectorConfiguration) {
            this.connectorConfiguration = connectorConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorName}
         * @param connectorName The name of the connector. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorName(java.lang.String connectorName) {
            this.connectorName = connectorName;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaCluster}
         * @param kafkaCluster The details of the Apache Kafka cluster to which the connector is connected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaCluster(software.amazon.awscdk.IResolvable kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaCluster}
         * @param kafkaCluster The details of the Apache Kafka cluster to which the connector is connected. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaCluster(software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterProperty kafkaCluster) {
            this.kafkaCluster = kafkaCluster;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaClusterClientAuthentication}
         * @param kafkaClusterClientAuthentication The type of client authentication used to connect to the Apache Kafka cluster. This parameter is required.
         *                                         The value is NONE when no client authentication is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterClientAuthentication(software.amazon.awscdk.IResolvable kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaClusterClientAuthentication}
         * @param kafkaClusterClientAuthentication The type of client authentication used to connect to the Apache Kafka cluster. This parameter is required.
         *                                         The value is NONE when no client authentication is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterClientAuthentication(software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterClientAuthenticationProperty kafkaClusterClientAuthentication) {
            this.kafkaClusterClientAuthentication = kafkaClusterClientAuthentication;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaClusterEncryptionInTransit}
         * @param kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterEncryptionInTransit(software.amazon.awscdk.IResolvable kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaClusterEncryptionInTransit}
         * @param kafkaClusterEncryptionInTransit Details of encryption in transit to the Apache Kafka cluster. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaClusterEncryptionInTransit(software.amazon.awscdk.services.kafkaconnect.CfnConnector.KafkaClusterEncryptionInTransitProperty kafkaClusterEncryptionInTransit) {
            this.kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getKafkaConnectVersion}
         * @param kafkaConnectVersion The version of Kafka Connect. This parameter is required.
         *                            It has to be compatible with both the Apache Kafka cluster's version and the plugins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kafkaConnectVersion(java.lang.String kafkaConnectVersion) {
            this.kafkaConnectVersion = kafkaConnectVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getPlugins}
         * @param plugins Specifies which plugin to use for the connector. This parameter is required.
         *                You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(software.amazon.awscdk.IResolvable plugins) {
            this.plugins = plugins;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getPlugins}
         * @param plugins Specifies which plugin to use for the connector. This parameter is required.
         *                You must specify a single-element list. Amazon MSK Connect does not currently support specifying multiple plugins.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder plugins(java.util.List<? extends java.lang.Object> plugins) {
            this.plugins = plugins;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getServiceExecutionRoleArn}
         * @param serviceExecutionRoleArn The Amazon Resource Name (ARN) of the IAM role used by the connector to access Amazon Web Services resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceExecutionRoleArn(java.lang.String serviceExecutionRoleArn) {
            this.serviceExecutionRoleArn = serviceExecutionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getConnectorDescription}
         * @param connectorDescription The description of the connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectorDescription(java.lang.String connectorDescription) {
            this.connectorDescription = connectorDescription;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getLogDelivery}
         * @param logDelivery The settings for delivering connector logs to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDelivery(software.amazon.awscdk.IResolvable logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getLogDelivery}
         * @param logDelivery The settings for delivering connector logs to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDelivery(software.amazon.awscdk.services.kafkaconnect.CfnConnector.LogDeliveryProperty logDelivery) {
            this.logDelivery = logDelivery;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getTags}
         * @param tags A collection of tags associated with a resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getWorkerConfiguration}
         * @param workerConfiguration The worker configurations that are in use with the connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfiguration(software.amazon.awscdk.IResolvable workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnConnectorProps#getWorkerConfiguration}
         * @param workerConfiguration The worker configurations that are in use with the connector.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerConfiguration(software.amazon.awscdk.services.kafkaconnect.CfnConnector.WorkerConfigurationProperty workerConfiguration) {
            this.workerConfiguration = workerConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnConnectorProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnConnectorProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnConnectorProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnConnectorProps {
        private final java.lang.Object capacity;
        private final java.lang.Object connectorConfiguration;
        private final java.lang.String connectorName;
        private final java.lang.Object kafkaCluster;
        private final java.lang.Object kafkaClusterClientAuthentication;
        private final java.lang.Object kafkaClusterEncryptionInTransit;
        private final java.lang.String kafkaConnectVersion;
        private final java.lang.Object plugins;
        private final java.lang.String serviceExecutionRoleArn;
        private final java.lang.String connectorDescription;
        private final java.lang.Object logDelivery;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object workerConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacity = software.amazon.jsii.Kernel.get(this, "capacity", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectorConfiguration = software.amazon.jsii.Kernel.get(this, "connectorConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.connectorName = software.amazon.jsii.Kernel.get(this, "connectorName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kafkaCluster = software.amazon.jsii.Kernel.get(this, "kafkaCluster", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kafkaClusterClientAuthentication = software.amazon.jsii.Kernel.get(this, "kafkaClusterClientAuthentication", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kafkaClusterEncryptionInTransit = software.amazon.jsii.Kernel.get(this, "kafkaClusterEncryptionInTransit", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kafkaConnectVersion = software.amazon.jsii.Kernel.get(this, "kafkaConnectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.plugins = software.amazon.jsii.Kernel.get(this, "plugins", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceExecutionRoleArn = software.amazon.jsii.Kernel.get(this, "serviceExecutionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connectorDescription = software.amazon.jsii.Kernel.get(this, "connectorDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.logDelivery = software.amazon.jsii.Kernel.get(this, "logDelivery", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.workerConfiguration = software.amazon.jsii.Kernel.get(this, "workerConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacity = java.util.Objects.requireNonNull(builder.capacity, "capacity is required");
            this.connectorConfiguration = java.util.Objects.requireNonNull(builder.connectorConfiguration, "connectorConfiguration is required");
            this.connectorName = java.util.Objects.requireNonNull(builder.connectorName, "connectorName is required");
            this.kafkaCluster = java.util.Objects.requireNonNull(builder.kafkaCluster, "kafkaCluster is required");
            this.kafkaClusterClientAuthentication = java.util.Objects.requireNonNull(builder.kafkaClusterClientAuthentication, "kafkaClusterClientAuthentication is required");
            this.kafkaClusterEncryptionInTransit = java.util.Objects.requireNonNull(builder.kafkaClusterEncryptionInTransit, "kafkaClusterEncryptionInTransit is required");
            this.kafkaConnectVersion = java.util.Objects.requireNonNull(builder.kafkaConnectVersion, "kafkaConnectVersion is required");
            this.plugins = java.util.Objects.requireNonNull(builder.plugins, "plugins is required");
            this.serviceExecutionRoleArn = java.util.Objects.requireNonNull(builder.serviceExecutionRoleArn, "serviceExecutionRoleArn is required");
            this.connectorDescription = builder.connectorDescription;
            this.logDelivery = builder.logDelivery;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.workerConfiguration = builder.workerConfiguration;
        }

        @Override
        public final java.lang.Object getCapacity() {
            return this.capacity;
        }

        @Override
        public final java.lang.Object getConnectorConfiguration() {
            return this.connectorConfiguration;
        }

        @Override
        public final java.lang.String getConnectorName() {
            return this.connectorName;
        }

        @Override
        public final java.lang.Object getKafkaCluster() {
            return this.kafkaCluster;
        }

        @Override
        public final java.lang.Object getKafkaClusterClientAuthentication() {
            return this.kafkaClusterClientAuthentication;
        }

        @Override
        public final java.lang.Object getKafkaClusterEncryptionInTransit() {
            return this.kafkaClusterEncryptionInTransit;
        }

        @Override
        public final java.lang.String getKafkaConnectVersion() {
            return this.kafkaConnectVersion;
        }

        @Override
        public final java.lang.Object getPlugins() {
            return this.plugins;
        }

        @Override
        public final java.lang.String getServiceExecutionRoleArn() {
            return this.serviceExecutionRoleArn;
        }

        @Override
        public final java.lang.String getConnectorDescription() {
            return this.connectorDescription;
        }

        @Override
        public final java.lang.Object getLogDelivery() {
            return this.logDelivery;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getWorkerConfiguration() {
            return this.workerConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("capacity", om.valueToTree(this.getCapacity()));
            data.set("connectorConfiguration", om.valueToTree(this.getConnectorConfiguration()));
            data.set("connectorName", om.valueToTree(this.getConnectorName()));
            data.set("kafkaCluster", om.valueToTree(this.getKafkaCluster()));
            data.set("kafkaClusterClientAuthentication", om.valueToTree(this.getKafkaClusterClientAuthentication()));
            data.set("kafkaClusterEncryptionInTransit", om.valueToTree(this.getKafkaClusterEncryptionInTransit()));
            data.set("kafkaConnectVersion", om.valueToTree(this.getKafkaConnectVersion()));
            data.set("plugins", om.valueToTree(this.getPlugins()));
            data.set("serviceExecutionRoleArn", om.valueToTree(this.getServiceExecutionRoleArn()));
            if (this.getConnectorDescription() != null) {
                data.set("connectorDescription", om.valueToTree(this.getConnectorDescription()));
            }
            if (this.getLogDelivery() != null) {
                data.set("logDelivery", om.valueToTree(this.getLogDelivery()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getWorkerConfiguration() != null) {
                data.set("workerConfiguration", om.valueToTree(this.getWorkerConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kafkaconnect.CfnConnectorProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnConnectorProps.Jsii$Proxy that = (CfnConnectorProps.Jsii$Proxy) o;

            if (!capacity.equals(that.capacity)) return false;
            if (!connectorConfiguration.equals(that.connectorConfiguration)) return false;
            if (!connectorName.equals(that.connectorName)) return false;
            if (!kafkaCluster.equals(that.kafkaCluster)) return false;
            if (!kafkaClusterClientAuthentication.equals(that.kafkaClusterClientAuthentication)) return false;
            if (!kafkaClusterEncryptionInTransit.equals(that.kafkaClusterEncryptionInTransit)) return false;
            if (!kafkaConnectVersion.equals(that.kafkaConnectVersion)) return false;
            if (!plugins.equals(that.plugins)) return false;
            if (!serviceExecutionRoleArn.equals(that.serviceExecutionRoleArn)) return false;
            if (this.connectorDescription != null ? !this.connectorDescription.equals(that.connectorDescription) : that.connectorDescription != null) return false;
            if (this.logDelivery != null ? !this.logDelivery.equals(that.logDelivery) : that.logDelivery != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.workerConfiguration != null ? this.workerConfiguration.equals(that.workerConfiguration) : that.workerConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacity.hashCode();
            result = 31 * result + (this.connectorConfiguration.hashCode());
            result = 31 * result + (this.connectorName.hashCode());
            result = 31 * result + (this.kafkaCluster.hashCode());
            result = 31 * result + (this.kafkaClusterClientAuthentication.hashCode());
            result = 31 * result + (this.kafkaClusterEncryptionInTransit.hashCode());
            result = 31 * result + (this.kafkaConnectVersion.hashCode());
            result = 31 * result + (this.plugins.hashCode());
            result = 31 * result + (this.serviceExecutionRoleArn.hashCode());
            result = 31 * result + (this.connectorDescription != null ? this.connectorDescription.hashCode() : 0);
            result = 31 * result + (this.logDelivery != null ? this.logDelivery.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.workerConfiguration != null ? this.workerConfiguration.hashCode() : 0);
            return result;
        }
    }
}
