package software.amazon.awscdk.services.lambda;

/**
 * Properties for defining a <code>CfnEventSourceMapping</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnEventSourceMappingProps cfnEventSourceMappingProps = CfnEventSourceMappingProps.builder()
 *         .functionName("functionName")
 *         // the properties below are optional
 *         .amazonManagedKafkaEventSourceConfig(AmazonManagedKafkaEventSourceConfigProperty.builder()
 *                 .consumerGroupId("consumerGroupId")
 *                 .build())
 *         .batchSize(123)
 *         .bisectBatchOnFunctionError(false)
 *         .destinationConfig(DestinationConfigProperty.builder()
 *                 .onFailure(OnFailureProperty.builder()
 *                         .destination("destination")
 *                         .build())
 *                 .build())
 *         .documentDbEventSourceConfig(DocumentDBEventSourceConfigProperty.builder()
 *                 .collectionName("collectionName")
 *                 .databaseName("databaseName")
 *                 .fullDocument("fullDocument")
 *                 .build())
 *         .enabled(false)
 *         .eventSourceArn("eventSourceArn")
 *         .filterCriteria(FilterCriteriaProperty.builder()
 *                 .filters(List.of(FilterProperty.builder()
 *                         .pattern("pattern")
 *                         .build()))
 *                 .build())
 *         .functionResponseTypes(List.of("functionResponseTypes"))
 *         .maximumBatchingWindowInSeconds(123)
 *         .maximumRecordAgeInSeconds(123)
 *         .maximumRetryAttempts(123)
 *         .parallelizationFactor(123)
 *         .queues(List.of("queues"))
 *         .scalingConfig(ScalingConfigProperty.builder()
 *                 .maximumConcurrency(123)
 *                 .build())
 *         .selfManagedEventSource(SelfManagedEventSourceProperty.builder()
 *                 .endpoints(EndpointsProperty.builder()
 *                         .kafkaBootstrapServers(List.of("kafkaBootstrapServers"))
 *                         .build())
 *                 .build())
 *         .selfManagedKafkaEventSourceConfig(SelfManagedKafkaEventSourceConfigProperty.builder()
 *                 .consumerGroupId("consumerGroupId")
 *                 .build())
 *         .sourceAccessConfigurations(List.of(SourceAccessConfigurationProperty.builder()
 *                 .type("type")
 *                 .uri("uri")
 *                 .build()))
 *         .startingPosition("startingPosition")
 *         .startingPositionTimestamp(123)
 *         .topics(List.of("topics"))
 *         .tumblingWindowInSeconds(123)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.698Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnEventSourceMappingProps")
@software.amazon.jsii.Jsii.Proxy(CfnEventSourceMappingProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnEventSourceMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name or ARN of the Lambda function.
     * <p>
     * <strong>Name formats</strong> - <em>Function name</em> – <code>MyFunction</code> .
     * <p>
     * <ul>
     * <li><em>Function ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
     * <li><em>Version or Alias ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code> .</li>
     * <li><em>Partial ARN</em> – <code>123456789012:function:MyFunction</code> .</li>
     * </ul>
     * <p>
     * The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFunctionName();

    /**
     * Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-amazonmanagedkafkaeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-amazonmanagedkafkaeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAmazonManagedKafkaEventSourceConfig() {
        return null;
    }

    /**
     * The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function.
     * <p>
     * Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
     * <p>
     * <ul>
     * <li><em>Amazon Kinesis</em> – Default 100. Max 10,000.</li>
     * <li><em>Amazon DynamoDB Streams</em> – Default 100. Max 10,000.</li>
     * <li><em>Amazon Simple Queue Service</em> – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</li>
     * <li><em>Amazon Managed Streaming for Apache Kafka</em> – Default 100. Max 10,000.</li>
     * <li><em>Self-managed Apache Kafka</em> – Default 100. Max 10,000.</li>
     * <li><em>Amazon MQ (ActiveMQ and RabbitMQ)</em> – Default 100. Max 10,000.</li>
     * <li><em>DocumentDB</em> – Default 100. Max 10,000.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getBatchSize() {
        return null;
    }

    /**
     * (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
     * <p>
     * The default value is false.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getBisectBatchOnFunctionError() {
        return null;
    }

    /**
     * (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDestinationConfig() {
        return null;
    }

    /**
     * Specific configuration settings for a DocumentDB event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-documentdbeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-documentdbeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDocumentDbEventSourceConfig() {
        return null;
    }

    /**
     * When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
     * <p>
     * Default: True
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the event source.
     * <p>
     * <ul>
     * <li><em>Amazon Kinesis</em> – The ARN of the data stream or a stream consumer.</li>
     * <li><em>Amazon DynamoDB Streams</em> – The ARN of the stream.</li>
     * <li><em>Amazon Simple Queue Service</em> – The ARN of the queue.</li>
     * <li><em>Amazon Managed Streaming for Apache Kafka</em> – The ARN of the cluster or the ARN of the VPC connection (for <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc">cross-account event source mappings</a> ).</li>
     * <li><em>Amazon MQ</em> – The ARN of the broker.</li>
     * <li><em>Amazon DocumentDB</em> – The ARN of the DocumentDB change stream.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEventSourceArn() {
        return null;
    }

    /**
     * An object that defines the filter criteria that determine whether Lambda should process an event.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-filtercriteria">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-filtercriteria</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getFilterCriteria() {
        return null;
    }

    /**
     * (Streams and SQS) A list of current response type enums applied to the event source mapping.
     * <p>
     * Valid Values: <code>ReportBatchItemFailures</code>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionresponsetypes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getFunctionResponseTypes() {
        return null;
    }

    /**
     * The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
     * <p>
     * <em>Default ( Kinesis , DynamoDB , Amazon SQS event sources)</em> : 0
     * <p>
     * <em>Default ( Amazon MSK , Kafka, Amazon MQ , Amazon DocumentDB event sources)</em> : 500 ms
     * <p>
     * <em>Related setting:</em> For Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumBatchingWindowInSeconds() {
        return null;
    }

    /**
     * (Kinesis and DynamoDB Streams only) Discard records older than the specified age.
     * <p>
     * The default value is -1,
     * which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
     * <p>
     * <blockquote>
     * <p>
     * The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRecordAgeInSeconds() {
        return null;
    }

    /**
     * (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries.
     * <p>
     * The default value is -1,
     * which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaximumRetryAttempts() {
        return null;
    }

    /**
     * (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard.
     * <p>
     * The default value is 1.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getParallelizationFactor() {
        return null;
    }

    /**
     * (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueues() {
        return null;
    }

    /**
     * (Amazon SQS only) The scaling configuration for the event source.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-scalingconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-scalingconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScalingConfig() {
        return null;
    }

    /**
     * The self-managed Apache Kafka cluster for your event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedeventsource</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedEventSource() {
        return null;
    }

    /**
     * Specific configuration settings for a self-managed Apache Kafka event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-selfmanagedkafkaeventsourceconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSelfManagedKafkaEventSourceConfig() {
        return null;
    }

    /**
     * An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSourceAccessConfigurations() {
        return null;
    }

    /**
     * The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
     * <p>
     * <ul>
     * <li><em>LATEST</em> - Read only new records.</li>
     * <li><em>TRIM_HORIZON</em> - Process all available records.</li>
     * <li><em>AT_TIMESTAMP</em> - Specify a time from which to start reading records.</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStartingPosition() {
        return null;
    }

    /**
     * With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code> , the time from which to start reading, in Unix time seconds.
     * <p>
     * <code>StartingPositionTimestamp</code> cannot be in the future.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingpositiontimestamp</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getStartingPositionTimestamp() {
        return null;
    }

    /**
     * The name of the Kafka topic.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTopics() {
        return null;
    }

    /**
     * (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources.
     * <p>
     * A value of 0 seconds indicates no tumbling window.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getTumblingWindowInSeconds() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnEventSourceMappingProps> {
        java.lang.String functionName;
        java.lang.Object amazonManagedKafkaEventSourceConfig;
        java.lang.Number batchSize;
        java.lang.Object bisectBatchOnFunctionError;
        java.lang.Object destinationConfig;
        java.lang.Object documentDbEventSourceConfig;
        java.lang.Object enabled;
        java.lang.String eventSourceArn;
        java.lang.Object filterCriteria;
        java.util.List<java.lang.String> functionResponseTypes;
        java.lang.Number maximumBatchingWindowInSeconds;
        java.lang.Number maximumRecordAgeInSeconds;
        java.lang.Number maximumRetryAttempts;
        java.lang.Number parallelizationFactor;
        java.util.List<java.lang.String> queues;
        java.lang.Object scalingConfig;
        java.lang.Object selfManagedEventSource;
        java.lang.Object selfManagedKafkaEventSourceConfig;
        java.lang.Object sourceAccessConfigurations;
        java.lang.String startingPosition;
        java.lang.Number startingPositionTimestamp;
        java.util.List<java.lang.String> topics;
        java.lang.Number tumblingWindowInSeconds;

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFunctionName}
         * @param functionName The name or ARN of the Lambda function. This parameter is required.
         *                     <strong>Name formats</strong> - <em>Function name</em> – <code>MyFunction</code> .
         *                     <p>
         *                     <ul>
         *                     <li><em>Function ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction</code> .</li>
         *                     <li><em>Version or Alias ARN</em> – <code>arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD</code> .</li>
         *                     <li><em>Partial ARN</em> – <code>123456789012:function:MyFunction</code> .</li>
         *                     </ul>
         *                     <p>
         *                     The length constraint applies only to the full ARN. If you specify only the function name, it's limited to 64 characters in length.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getAmazonManagedKafkaEventSourceConfig}
         * @param amazonManagedKafkaEventSourceConfig Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonManagedKafkaEventSourceConfig(software.amazon.awscdk.IResolvable amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getAmazonManagedKafkaEventSourceConfig}
         * @param amazonManagedKafkaEventSourceConfig Specific configuration settings for an Amazon Managed Streaming for Apache Kafka (Amazon MSK) event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder amazonManagedKafkaEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.AmazonManagedKafkaEventSourceConfigProperty amazonManagedKafkaEventSourceConfig) {
            this.amazonManagedKafkaEventSourceConfig = amazonManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBatchSize}
         * @param batchSize The maximum number of records in each batch that Lambda pulls from your stream or queue and sends to your function.
         *                  Lambda passes all of the records in the batch to the function in a single call, up to the payload limit for synchronous invocation (6 MB).
         *                  <p>
         *                  <ul>
         *                  <li><em>Amazon Kinesis</em> – Default 100. Max 10,000.</li>
         *                  <li><em>Amazon DynamoDB Streams</em> – Default 100. Max 10,000.</li>
         *                  <li><em>Amazon Simple Queue Service</em> – Default 10. For standard queues the max is 10,000. For FIFO queues the max is 10.</li>
         *                  <li><em>Amazon Managed Streaming for Apache Kafka</em> – Default 100. Max 10,000.</li>
         *                  <li><em>Self-managed Apache Kafka</em> – Default 100. Max 10,000.</li>
         *                  <li><em>Amazon MQ (ActiveMQ and RabbitMQ)</em> – Default 100. Max 10,000.</li>
         *                  <li><em>DocumentDB</em> – Default 100. Max 10,000.</li>
         *                  </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(java.lang.Number batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBisectBatchOnFunctionError}
         * @param bisectBatchOnFunctionError (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
         *                                   The default value is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnFunctionError(java.lang.Boolean bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getBisectBatchOnFunctionError}
         * @param bisectBatchOnFunctionError (Kinesis and DynamoDB Streams only) If the function returns an error, split the batch in two and retry.
         *                                   The default value is false.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bisectBatchOnFunctionError(software.amazon.awscdk.IResolvable bisectBatchOnFunctionError) {
            this.bisectBatchOnFunctionError = bisectBatchOnFunctionError;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDestinationConfig}
         * @param destinationConfig (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.IResolvable destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDestinationConfig}
         * @param destinationConfig (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Apache Kafka event sources only) A configuration object that specifies the destination of an event after Lambda processes it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.DestinationConfigProperty destinationConfig) {
            this.destinationConfig = destinationConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDocumentDbEventSourceConfig}
         * @param documentDbEventSourceConfig Specific configuration settings for a DocumentDB event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentDbEventSourceConfig(software.amazon.awscdk.IResolvable documentDbEventSourceConfig) {
            this.documentDbEventSourceConfig = documentDbEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getDocumentDbEventSourceConfig}
         * @param documentDbEventSourceConfig Specific configuration settings for a DocumentDB event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder documentDbEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.DocumentDBEventSourceConfigProperty documentDbEventSourceConfig) {
            this.documentDbEventSourceConfig = documentDbEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEnabled}
         * @param enabled When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         *                Default: True
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(java.lang.Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEnabled}
         * @param enabled When true, the event source mapping is active. When false, Lambda pauses polling and invocation.
         *                Default: True
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
            this.enabled = enabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getEventSourceArn}
         * @param eventSourceArn The Amazon Resource Name (ARN) of the event source.
         *                       <ul>
         *                       <li><em>Amazon Kinesis</em> – The ARN of the data stream or a stream consumer.</li>
         *                       <li><em>Amazon DynamoDB Streams</em> – The ARN of the stream.</li>
         *                       <li><em>Amazon Simple Queue Service</em> – The ARN of the queue.</li>
         *                       <li><em>Amazon Managed Streaming for Apache Kafka</em> – The ARN of the cluster or the ARN of the VPC connection (for <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-msk.html#msk-multi-vpc">cross-account event source mappings</a> ).</li>
         *                       <li><em>Amazon MQ</em> – The ARN of the broker.</li>
         *                       <li><em>Amazon DocumentDB</em> – The ARN of the DocumentDB change stream.</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSourceArn(java.lang.String eventSourceArn) {
            this.eventSourceArn = eventSourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFilterCriteria}
         * @param filterCriteria An object that defines the filter criteria that determine whether Lambda should process an event.
         *                       For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(software.amazon.awscdk.IResolvable filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFilterCriteria}
         * @param filterCriteria An object that defines the filter criteria that determine whether Lambda should process an event.
         *                       For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventfiltering.html">Lambda event filtering</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder filterCriteria(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.FilterCriteriaProperty filterCriteria) {
            this.filterCriteria = filterCriteria;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getFunctionResponseTypes}
         * @param functionResponseTypes (Streams and SQS) A list of current response type enums applied to the event source mapping.
         *                              Valid Values: <code>ReportBatchItemFailures</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionResponseTypes(java.util.List<java.lang.String> functionResponseTypes) {
            this.functionResponseTypes = functionResponseTypes;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumBatchingWindowInSeconds}
         * @param maximumBatchingWindowInSeconds The maximum amount of time, in seconds, that Lambda spends gathering records before invoking the function.
         *                                       <em>Default ( Kinesis , DynamoDB , Amazon SQS event sources)</em> : 0
         *                                       <p>
         *                                       <em>Default ( Amazon MSK , Kafka, Amazon MQ , Amazon DocumentDB event sources)</em> : 500 ms
         *                                       <p>
         *                                       <em>Related setting:</em> For Amazon SQS event sources, when you set <code>BatchSize</code> to a value greater than 10, you must set <code>MaximumBatchingWindowInSeconds</code> to at least 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumBatchingWindowInSeconds(java.lang.Number maximumBatchingWindowInSeconds) {
            this.maximumBatchingWindowInSeconds = maximumBatchingWindowInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumRecordAgeInSeconds}
         * @param maximumRecordAgeInSeconds (Kinesis and DynamoDB Streams only) Discard records older than the specified age.
         *                                  The default value is -1,
         *                                  which sets the maximum age to infinite. When the value is set to infinite, Lambda never discards old records.
         *                                  <p>
         *                                  <blockquote>
         *                                  <p>
         *                                  The minimum valid value for maximum record age is 60s. Although values less than 60 and greater than -1 fall within the parameter's absolute range, they are not allowed
         *                                  <p>
         *                                  </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRecordAgeInSeconds(java.lang.Number maximumRecordAgeInSeconds) {
            this.maximumRecordAgeInSeconds = maximumRecordAgeInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getMaximumRetryAttempts}
         * @param maximumRetryAttempts (Kinesis and DynamoDB Streams only) Discard records after the specified number of retries.
         *                             The default value is -1,
         *                             which sets the maximum number of retries to infinite. When MaximumRetryAttempts is infinite, Lambda retries failed records until the record expires in the event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maximumRetryAttempts(java.lang.Number maximumRetryAttempts) {
            this.maximumRetryAttempts = maximumRetryAttempts;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getParallelizationFactor}
         * @param parallelizationFactor (Kinesis and DynamoDB Streams only) The number of batches to process concurrently from each shard.
         *                              The default value is 1.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parallelizationFactor(java.lang.Number parallelizationFactor) {
            this.parallelizationFactor = parallelizationFactor;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getQueues}
         * @param queues (Amazon MQ) The name of the Amazon MQ broker destination queue to consume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queues(java.util.List<java.lang.String> queues) {
            this.queues = queues;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getScalingConfig}
         * @param scalingConfig (Amazon SQS only) The scaling configuration for the event source.
         *                      For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.IResolvable scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getScalingConfig}
         * @param scalingConfig (Amazon SQS only) The scaling configuration for the event source.
         *                      For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/with-sqs.html#events-sqs-max-concurrency">Configuring maximum concurrency for Amazon SQS event sources</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.ScalingConfigProperty scalingConfig) {
            this.scalingConfig = scalingConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedEventSource}
         * @param selfManagedEventSource The self-managed Apache Kafka cluster for your event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedEventSource(software.amazon.awscdk.IResolvable selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedEventSource}
         * @param selfManagedEventSource The self-managed Apache Kafka cluster for your event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedEventSource(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.SelfManagedEventSourceProperty selfManagedEventSource) {
            this.selfManagedEventSource = selfManagedEventSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedKafkaEventSourceConfig}
         * @param selfManagedKafkaEventSourceConfig Specific configuration settings for a self-managed Apache Kafka event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedKafkaEventSourceConfig(software.amazon.awscdk.IResolvable selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSelfManagedKafkaEventSourceConfig}
         * @param selfManagedKafkaEventSourceConfig Specific configuration settings for a self-managed Apache Kafka event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selfManagedKafkaEventSourceConfig(software.amazon.awscdk.services.lambda.CfnEventSourceMapping.SelfManagedKafkaEventSourceConfigProperty selfManagedKafkaEventSourceConfig) {
            this.selfManagedKafkaEventSourceConfig = selfManagedKafkaEventSourceConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSourceAccessConfigurations}
         * @param sourceAccessConfigurations An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccessConfigurations(software.amazon.awscdk.IResolvable sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getSourceAccessConfigurations}
         * @param sourceAccessConfigurations An array of the authentication protocol, VPC components, or virtual host to secure and define your event source.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceAccessConfigurations(java.util.List<? extends java.lang.Object> sourceAccessConfigurations) {
            this.sourceAccessConfigurations = sourceAccessConfigurations;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getStartingPosition}
         * @param startingPosition The position in a stream from which to start reading. Required for Amazon Kinesis and Amazon DynamoDB.
         *                         <ul>
         *                         <li><em>LATEST</em> - Read only new records.</li>
         *                         <li><em>TRIM_HORIZON</em> - Process all available records.</li>
         *                         <li><em>AT_TIMESTAMP</em> - Specify a time from which to start reading records.</li>
         *                         </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPosition(java.lang.String startingPosition) {
            this.startingPosition = startingPosition;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getStartingPositionTimestamp}
         * @param startingPositionTimestamp With <code>StartingPosition</code> set to <code>AT_TIMESTAMP</code> , the time from which to start reading, in Unix time seconds.
         *                                  <code>StartingPositionTimestamp</code> cannot be in the future.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startingPositionTimestamp(java.lang.Number startingPositionTimestamp) {
            this.startingPositionTimestamp = startingPositionTimestamp;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getTopics}
         * @param topics The name of the Kafka topic.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder topics(java.util.List<java.lang.String> topics) {
            this.topics = topics;
            return this;
        }

        /**
         * Sets the value of {@link CfnEventSourceMappingProps#getTumblingWindowInSeconds}
         * @param tumblingWindowInSeconds (Kinesis and DynamoDB Streams only) The duration in seconds of a processing window for DynamoDB and Kinesis Streams event sources.
         *                                A value of 0 seconds indicates no tumbling window.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tumblingWindowInSeconds(java.lang.Number tumblingWindowInSeconds) {
            this.tumblingWindowInSeconds = tumblingWindowInSeconds;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnEventSourceMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnEventSourceMappingProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnEventSourceMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnEventSourceMappingProps {
        private final java.lang.String functionName;
        private final java.lang.Object amazonManagedKafkaEventSourceConfig;
        private final java.lang.Number batchSize;
        private final java.lang.Object bisectBatchOnFunctionError;
        private final java.lang.Object destinationConfig;
        private final java.lang.Object documentDbEventSourceConfig;
        private final java.lang.Object enabled;
        private final java.lang.String eventSourceArn;
        private final java.lang.Object filterCriteria;
        private final java.util.List<java.lang.String> functionResponseTypes;
        private final java.lang.Number maximumBatchingWindowInSeconds;
        private final java.lang.Number maximumRecordAgeInSeconds;
        private final java.lang.Number maximumRetryAttempts;
        private final java.lang.Number parallelizationFactor;
        private final java.util.List<java.lang.String> queues;
        private final java.lang.Object scalingConfig;
        private final java.lang.Object selfManagedEventSource;
        private final java.lang.Object selfManagedKafkaEventSourceConfig;
        private final java.lang.Object sourceAccessConfigurations;
        private final java.lang.String startingPosition;
        private final java.lang.Number startingPositionTimestamp;
        private final java.util.List<java.lang.String> topics;
        private final java.lang.Number tumblingWindowInSeconds;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.amazonManagedKafkaEventSourceConfig = software.amazon.jsii.Kernel.get(this, "amazonManagedKafkaEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.batchSize = software.amazon.jsii.Kernel.get(this, "batchSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.bisectBatchOnFunctionError = software.amazon.jsii.Kernel.get(this, "bisectBatchOnFunctionError", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.destinationConfig = software.amazon.jsii.Kernel.get(this, "destinationConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.documentDbEventSourceConfig = software.amazon.jsii.Kernel.get(this, "documentDbEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.eventSourceArn = software.amazon.jsii.Kernel.get(this, "eventSourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.filterCriteria = software.amazon.jsii.Kernel.get(this, "filterCriteria", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.functionResponseTypes = software.amazon.jsii.Kernel.get(this, "functionResponseTypes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.maximumBatchingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "maximumBatchingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumRecordAgeInSeconds = software.amazon.jsii.Kernel.get(this, "maximumRecordAgeInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.maximumRetryAttempts = software.amazon.jsii.Kernel.get(this, "maximumRetryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.parallelizationFactor = software.amazon.jsii.Kernel.get(this, "parallelizationFactor", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.queues = software.amazon.jsii.Kernel.get(this, "queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.scalingConfig = software.amazon.jsii.Kernel.get(this, "scalingConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.selfManagedEventSource = software.amazon.jsii.Kernel.get(this, "selfManagedEventSource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.selfManagedKafkaEventSourceConfig = software.amazon.jsii.Kernel.get(this, "selfManagedKafkaEventSourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.sourceAccessConfigurations = software.amazon.jsii.Kernel.get(this, "sourceAccessConfigurations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.startingPosition = software.amazon.jsii.Kernel.get(this, "startingPosition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.startingPositionTimestamp = software.amazon.jsii.Kernel.get(this, "startingPositionTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.topics = software.amazon.jsii.Kernel.get(this, "topics", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.tumblingWindowInSeconds = software.amazon.jsii.Kernel.get(this, "tumblingWindowInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = java.util.Objects.requireNonNull(builder.functionName, "functionName is required");
            this.amazonManagedKafkaEventSourceConfig = builder.amazonManagedKafkaEventSourceConfig;
            this.batchSize = builder.batchSize;
            this.bisectBatchOnFunctionError = builder.bisectBatchOnFunctionError;
            this.destinationConfig = builder.destinationConfig;
            this.documentDbEventSourceConfig = builder.documentDbEventSourceConfig;
            this.enabled = builder.enabled;
            this.eventSourceArn = builder.eventSourceArn;
            this.filterCriteria = builder.filterCriteria;
            this.functionResponseTypes = builder.functionResponseTypes;
            this.maximumBatchingWindowInSeconds = builder.maximumBatchingWindowInSeconds;
            this.maximumRecordAgeInSeconds = builder.maximumRecordAgeInSeconds;
            this.maximumRetryAttempts = builder.maximumRetryAttempts;
            this.parallelizationFactor = builder.parallelizationFactor;
            this.queues = builder.queues;
            this.scalingConfig = builder.scalingConfig;
            this.selfManagedEventSource = builder.selfManagedEventSource;
            this.selfManagedKafkaEventSourceConfig = builder.selfManagedKafkaEventSourceConfig;
            this.sourceAccessConfigurations = builder.sourceAccessConfigurations;
            this.startingPosition = builder.startingPosition;
            this.startingPositionTimestamp = builder.startingPositionTimestamp;
            this.topics = builder.topics;
            this.tumblingWindowInSeconds = builder.tumblingWindowInSeconds;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.Object getAmazonManagedKafkaEventSourceConfig() {
            return this.amazonManagedKafkaEventSourceConfig;
        }

        @Override
        public final java.lang.Number getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final java.lang.Object getBisectBatchOnFunctionError() {
            return this.bisectBatchOnFunctionError;
        }

        @Override
        public final java.lang.Object getDestinationConfig() {
            return this.destinationConfig;
        }

        @Override
        public final java.lang.Object getDocumentDbEventSourceConfig() {
            return this.documentDbEventSourceConfig;
        }

        @Override
        public final java.lang.Object getEnabled() {
            return this.enabled;
        }

        @Override
        public final java.lang.String getEventSourceArn() {
            return this.eventSourceArn;
        }

        @Override
        public final java.lang.Object getFilterCriteria() {
            return this.filterCriteria;
        }

        @Override
        public final java.util.List<java.lang.String> getFunctionResponseTypes() {
            return this.functionResponseTypes;
        }

        @Override
        public final java.lang.Number getMaximumBatchingWindowInSeconds() {
            return this.maximumBatchingWindowInSeconds;
        }

        @Override
        public final java.lang.Number getMaximumRecordAgeInSeconds() {
            return this.maximumRecordAgeInSeconds;
        }

        @Override
        public final java.lang.Number getMaximumRetryAttempts() {
            return this.maximumRetryAttempts;
        }

        @Override
        public final java.lang.Number getParallelizationFactor() {
            return this.parallelizationFactor;
        }

        @Override
        public final java.util.List<java.lang.String> getQueues() {
            return this.queues;
        }

        @Override
        public final java.lang.Object getScalingConfig() {
            return this.scalingConfig;
        }

        @Override
        public final java.lang.Object getSelfManagedEventSource() {
            return this.selfManagedEventSource;
        }

        @Override
        public final java.lang.Object getSelfManagedKafkaEventSourceConfig() {
            return this.selfManagedKafkaEventSourceConfig;
        }

        @Override
        public final java.lang.Object getSourceAccessConfigurations() {
            return this.sourceAccessConfigurations;
        }

        @Override
        public final java.lang.String getStartingPosition() {
            return this.startingPosition;
        }

        @Override
        public final java.lang.Number getStartingPositionTimestamp() {
            return this.startingPositionTimestamp;
        }

        @Override
        public final java.util.List<java.lang.String> getTopics() {
            return this.topics;
        }

        @Override
        public final java.lang.Number getTumblingWindowInSeconds() {
            return this.tumblingWindowInSeconds;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("functionName", om.valueToTree(this.getFunctionName()));
            if (this.getAmazonManagedKafkaEventSourceConfig() != null) {
                data.set("amazonManagedKafkaEventSourceConfig", om.valueToTree(this.getAmazonManagedKafkaEventSourceConfig()));
            }
            if (this.getBatchSize() != null) {
                data.set("batchSize", om.valueToTree(this.getBatchSize()));
            }
            if (this.getBisectBatchOnFunctionError() != null) {
                data.set("bisectBatchOnFunctionError", om.valueToTree(this.getBisectBatchOnFunctionError()));
            }
            if (this.getDestinationConfig() != null) {
                data.set("destinationConfig", om.valueToTree(this.getDestinationConfig()));
            }
            if (this.getDocumentDbEventSourceConfig() != null) {
                data.set("documentDbEventSourceConfig", om.valueToTree(this.getDocumentDbEventSourceConfig()));
            }
            if (this.getEnabled() != null) {
                data.set("enabled", om.valueToTree(this.getEnabled()));
            }
            if (this.getEventSourceArn() != null) {
                data.set("eventSourceArn", om.valueToTree(this.getEventSourceArn()));
            }
            if (this.getFilterCriteria() != null) {
                data.set("filterCriteria", om.valueToTree(this.getFilterCriteria()));
            }
            if (this.getFunctionResponseTypes() != null) {
                data.set("functionResponseTypes", om.valueToTree(this.getFunctionResponseTypes()));
            }
            if (this.getMaximumBatchingWindowInSeconds() != null) {
                data.set("maximumBatchingWindowInSeconds", om.valueToTree(this.getMaximumBatchingWindowInSeconds()));
            }
            if (this.getMaximumRecordAgeInSeconds() != null) {
                data.set("maximumRecordAgeInSeconds", om.valueToTree(this.getMaximumRecordAgeInSeconds()));
            }
            if (this.getMaximumRetryAttempts() != null) {
                data.set("maximumRetryAttempts", om.valueToTree(this.getMaximumRetryAttempts()));
            }
            if (this.getParallelizationFactor() != null) {
                data.set("parallelizationFactor", om.valueToTree(this.getParallelizationFactor()));
            }
            if (this.getQueues() != null) {
                data.set("queues", om.valueToTree(this.getQueues()));
            }
            if (this.getScalingConfig() != null) {
                data.set("scalingConfig", om.valueToTree(this.getScalingConfig()));
            }
            if (this.getSelfManagedEventSource() != null) {
                data.set("selfManagedEventSource", om.valueToTree(this.getSelfManagedEventSource()));
            }
            if (this.getSelfManagedKafkaEventSourceConfig() != null) {
                data.set("selfManagedKafkaEventSourceConfig", om.valueToTree(this.getSelfManagedKafkaEventSourceConfig()));
            }
            if (this.getSourceAccessConfigurations() != null) {
                data.set("sourceAccessConfigurations", om.valueToTree(this.getSourceAccessConfigurations()));
            }
            if (this.getStartingPosition() != null) {
                data.set("startingPosition", om.valueToTree(this.getStartingPosition()));
            }
            if (this.getStartingPositionTimestamp() != null) {
                data.set("startingPositionTimestamp", om.valueToTree(this.getStartingPositionTimestamp()));
            }
            if (this.getTopics() != null) {
                data.set("topics", om.valueToTree(this.getTopics()));
            }
            if (this.getTumblingWindowInSeconds() != null) {
                data.set("tumblingWindowInSeconds", om.valueToTree(this.getTumblingWindowInSeconds()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnEventSourceMappingProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnEventSourceMappingProps.Jsii$Proxy that = (CfnEventSourceMappingProps.Jsii$Proxy) o;

            if (!functionName.equals(that.functionName)) return false;
            if (this.amazonManagedKafkaEventSourceConfig != null ? !this.amazonManagedKafkaEventSourceConfig.equals(that.amazonManagedKafkaEventSourceConfig) : that.amazonManagedKafkaEventSourceConfig != null) return false;
            if (this.batchSize != null ? !this.batchSize.equals(that.batchSize) : that.batchSize != null) return false;
            if (this.bisectBatchOnFunctionError != null ? !this.bisectBatchOnFunctionError.equals(that.bisectBatchOnFunctionError) : that.bisectBatchOnFunctionError != null) return false;
            if (this.destinationConfig != null ? !this.destinationConfig.equals(that.destinationConfig) : that.destinationConfig != null) return false;
            if (this.documentDbEventSourceConfig != null ? !this.documentDbEventSourceConfig.equals(that.documentDbEventSourceConfig) : that.documentDbEventSourceConfig != null) return false;
            if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
            if (this.eventSourceArn != null ? !this.eventSourceArn.equals(that.eventSourceArn) : that.eventSourceArn != null) return false;
            if (this.filterCriteria != null ? !this.filterCriteria.equals(that.filterCriteria) : that.filterCriteria != null) return false;
            if (this.functionResponseTypes != null ? !this.functionResponseTypes.equals(that.functionResponseTypes) : that.functionResponseTypes != null) return false;
            if (this.maximumBatchingWindowInSeconds != null ? !this.maximumBatchingWindowInSeconds.equals(that.maximumBatchingWindowInSeconds) : that.maximumBatchingWindowInSeconds != null) return false;
            if (this.maximumRecordAgeInSeconds != null ? !this.maximumRecordAgeInSeconds.equals(that.maximumRecordAgeInSeconds) : that.maximumRecordAgeInSeconds != null) return false;
            if (this.maximumRetryAttempts != null ? !this.maximumRetryAttempts.equals(that.maximumRetryAttempts) : that.maximumRetryAttempts != null) return false;
            if (this.parallelizationFactor != null ? !this.parallelizationFactor.equals(that.parallelizationFactor) : that.parallelizationFactor != null) return false;
            if (this.queues != null ? !this.queues.equals(that.queues) : that.queues != null) return false;
            if (this.scalingConfig != null ? !this.scalingConfig.equals(that.scalingConfig) : that.scalingConfig != null) return false;
            if (this.selfManagedEventSource != null ? !this.selfManagedEventSource.equals(that.selfManagedEventSource) : that.selfManagedEventSource != null) return false;
            if (this.selfManagedKafkaEventSourceConfig != null ? !this.selfManagedKafkaEventSourceConfig.equals(that.selfManagedKafkaEventSourceConfig) : that.selfManagedKafkaEventSourceConfig != null) return false;
            if (this.sourceAccessConfigurations != null ? !this.sourceAccessConfigurations.equals(that.sourceAccessConfigurations) : that.sourceAccessConfigurations != null) return false;
            if (this.startingPosition != null ? !this.startingPosition.equals(that.startingPosition) : that.startingPosition != null) return false;
            if (this.startingPositionTimestamp != null ? !this.startingPositionTimestamp.equals(that.startingPositionTimestamp) : that.startingPositionTimestamp != null) return false;
            if (this.topics != null ? !this.topics.equals(that.topics) : that.topics != null) return false;
            return this.tumblingWindowInSeconds != null ? this.tumblingWindowInSeconds.equals(that.tumblingWindowInSeconds) : that.tumblingWindowInSeconds == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName.hashCode();
            result = 31 * result + (this.amazonManagedKafkaEventSourceConfig != null ? this.amazonManagedKafkaEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.batchSize != null ? this.batchSize.hashCode() : 0);
            result = 31 * result + (this.bisectBatchOnFunctionError != null ? this.bisectBatchOnFunctionError.hashCode() : 0);
            result = 31 * result + (this.destinationConfig != null ? this.destinationConfig.hashCode() : 0);
            result = 31 * result + (this.documentDbEventSourceConfig != null ? this.documentDbEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
            result = 31 * result + (this.eventSourceArn != null ? this.eventSourceArn.hashCode() : 0);
            result = 31 * result + (this.filterCriteria != null ? this.filterCriteria.hashCode() : 0);
            result = 31 * result + (this.functionResponseTypes != null ? this.functionResponseTypes.hashCode() : 0);
            result = 31 * result + (this.maximumBatchingWindowInSeconds != null ? this.maximumBatchingWindowInSeconds.hashCode() : 0);
            result = 31 * result + (this.maximumRecordAgeInSeconds != null ? this.maximumRecordAgeInSeconds.hashCode() : 0);
            result = 31 * result + (this.maximumRetryAttempts != null ? this.maximumRetryAttempts.hashCode() : 0);
            result = 31 * result + (this.parallelizationFactor != null ? this.parallelizationFactor.hashCode() : 0);
            result = 31 * result + (this.queues != null ? this.queues.hashCode() : 0);
            result = 31 * result + (this.scalingConfig != null ? this.scalingConfig.hashCode() : 0);
            result = 31 * result + (this.selfManagedEventSource != null ? this.selfManagedEventSource.hashCode() : 0);
            result = 31 * result + (this.selfManagedKafkaEventSourceConfig != null ? this.selfManagedKafkaEventSourceConfig.hashCode() : 0);
            result = 31 * result + (this.sourceAccessConfigurations != null ? this.sourceAccessConfigurations.hashCode() : 0);
            result = 31 * result + (this.startingPosition != null ? this.startingPosition.hashCode() : 0);
            result = 31 * result + (this.startingPositionTimestamp != null ? this.startingPositionTimestamp.hashCode() : 0);
            result = 31 * result + (this.topics != null ? this.topics.hashCode() : 0);
            result = 31 * result + (this.tumblingWindowInSeconds != null ? this.tumblingWindowInSeconds.hashCode() : 0);
            return result;
        }
    }
}
