package software.amazon.awscdk.services.lambda;

/**
 * The <code>AWS::Lambda::Url</code> resource creates a function URL with the specified configuration parameters.
 * <p>
 * A <a href="https://docs.aws.amazon.com/lambda/latest/dg/lambda-urls.html">function URL</a> is a dedicated HTTP(S) endpoint that you can use to invoke your function.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * CfnUrl cfnUrl = CfnUrl.Builder.create(this, "MyCfnUrl")
 *         .authType("authType")
 *         .targetFunctionArn("targetFunctionArn")
 *         // the properties below are optional
 *         .cors(CorsProperty.builder()
 *                 .allowCredentials(false)
 *                 .allowHeaders(List.of("allowHeaders"))
 *                 .allowMethods(List.of("allowMethods"))
 *                 .allowOrigins(List.of("allowOrigins"))
 *                 .exposeHeaders(List.of("exposeHeaders"))
 *                 .maxAge(123)
 *                 .build())
 *         .invokeMode("invokeMode")
 *         .qualifier("qualifier")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.729Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnUrl")
public class CfnUrl extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnUrl(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnUrl(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.lambda.CfnUrl.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnUrl(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.CfnUrlProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "attrFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP URL endpoint for your function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrFunctionUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrFunctionUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The type of authentication that your function URL uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthType() {
        return software.amazon.jsii.Kernel.get(this, "authType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of authentication that your function URL uses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "authType", java.util.Objects.requireNonNull(value, "authType is required"));
    }

    /**
     * The name of the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getTargetFunctionArn() {
        return software.amazon.jsii.Kernel.get(this, "targetFunctionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the Lambda function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTargetFunctionArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "targetFunctionArn", java.util.Objects.requireNonNull(value, "targetFunctionArn is required"));
    }

    /**
     * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCors() {
        return software.amazon.jsii.Kernel.get(this, "cors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cors", value);
    }

    /**
     * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.CfnUrl.CorsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cors", value);
    }

    /**
     * Use one of the following options:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getInvokeMode() {
        return software.amazon.jsii.Kernel.get(this, "invokeMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Use one of the following options:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInvokeMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "invokeMode", value);
    }

    /**
     * The alias name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getQualifier() {
        return software.amazon.jsii.Kernel.get(this, "qualifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The alias name.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQualifier(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "qualifier", value);
    }
    /**
     * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL. Use CORS to grant access to your function URL from any origin. You can also use CORS to control access for specific HTTP headers and methods in requests to your function URL.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.lambda.*;
     * CorsProperty corsProperty = CorsProperty.builder()
     *         .allowCredentials(false)
     *         .allowHeaders(List.of("allowHeaders"))
     *         .allowMethods(List.of("allowMethods"))
     *         .allowOrigins(List.of("allowOrigins"))
     *         .exposeHeaders(List.of("exposeHeaders"))
     *         .maxAge(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.CfnUrl.CorsProperty")
    @software.amazon.jsii.Jsii.Proxy(CorsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CorsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether you want to allow cookies or other credentials in requests to your function URL.
         * <p>
         * The default is <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowcredentials">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowcredentials</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAllowCredentials() {
            return null;
        }

        /**
         * The HTTP headers that origins can include in requests to your function URL.
         * <p>
         * For example: <code>Date</code> , <code>Keep-Alive</code> , <code>X-Custom-Header</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowHeaders() {
            return null;
        }

        /**
         * The HTTP methods that are allowed when calling your function URL.
         * <p>
         * For example: <code>GET</code> , <code>POST</code> , <code>DELETE</code> , or the wildcard character ( <code>*</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowmethods">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-allowmethods</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowMethods() {
            return null;
        }

        /**
         * The origins that can access your function URL.
         * <p>
         * You can list any number of specific origins, separated by a comma. For example: <code>https://www.example.com</code> , <code>http://localhost:60905</code> .
         * <p>
         * Alternatively, you can grant access to all origins with the wildcard character ( <code>*</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-alloworigins">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-alloworigins</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowOrigins() {
            return null;
        }

        /**
         * The HTTP headers in your function response that you want to expose to origins that call your function URL.
         * <p>
         * For example: <code>Date</code> , <code>Keep-Alive</code> , <code>X-Custom-Header</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-exposeheaders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-exposeheaders</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExposeHeaders() {
            return null;
        }

        /**
         * The maximum amount of time, in seconds, that browsers can cache results of a preflight request.
         * <p>
         * By default, this is set to <code>0</code> , which means the browser will not cache results.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-maxage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-url-cors.html#cfn-lambda-url-cors-maxage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxAge() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CorsProperty> {
            java.lang.Object allowCredentials;
            java.util.List<java.lang.String> allowHeaders;
            java.util.List<java.lang.String> allowMethods;
            java.util.List<java.lang.String> allowOrigins;
            java.util.List<java.lang.String> exposeHeaders;
            java.lang.Number maxAge;

            /**
             * Sets the value of {@link CorsProperty#getAllowCredentials}
             * @param allowCredentials Whether you want to allow cookies or other credentials in requests to your function URL.
             *                         The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(java.lang.Boolean allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowCredentials}
             * @param allowCredentials Whether you want to allow cookies or other credentials in requests to your function URL.
             *                         The default is <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCredentials(software.amazon.awscdk.IResolvable allowCredentials) {
                this.allowCredentials = allowCredentials;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowHeaders}
             * @param allowHeaders The HTTP headers that origins can include in requests to your function URL.
             *                     For example: <code>Date</code> , <code>Keep-Alive</code> , <code>X-Custom-Header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowHeaders(java.util.List<java.lang.String> allowHeaders) {
                this.allowHeaders = allowHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowMethods}
             * @param allowMethods The HTTP methods that are allowed when calling your function URL.
             *                     For example: <code>GET</code> , <code>POST</code> , <code>DELETE</code> , or the wildcard character ( <code>*</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowMethods(java.util.List<java.lang.String> allowMethods) {
                this.allowMethods = allowMethods;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getAllowOrigins}
             * @param allowOrigins The origins that can access your function URL.
             *                     You can list any number of specific origins, separated by a comma. For example: <code>https://www.example.com</code> , <code>http://localhost:60905</code> .
             *                     <p>
             *                     Alternatively, you can grant access to all origins with the wildcard character ( <code>*</code> ).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowOrigins(java.util.List<java.lang.String> allowOrigins) {
                this.allowOrigins = allowOrigins;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getExposeHeaders}
             * @param exposeHeaders The HTTP headers in your function response that you want to expose to origins that call your function URL.
             *                      For example: <code>Date</code> , <code>Keep-Alive</code> , <code>X-Custom-Header</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exposeHeaders(java.util.List<java.lang.String> exposeHeaders) {
                this.exposeHeaders = exposeHeaders;
                return this;
            }

            /**
             * Sets the value of {@link CorsProperty#getMaxAge}
             * @param maxAge The maximum amount of time, in seconds, that browsers can cache results of a preflight request.
             *               By default, this is set to <code>0</code> , which means the browser will not cache results.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxAge(java.lang.Number maxAge) {
                this.maxAge = maxAge;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CorsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CorsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CorsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CorsProperty {
            private final java.lang.Object allowCredentials;
            private final java.util.List<java.lang.String> allowHeaders;
            private final java.util.List<java.lang.String> allowMethods;
            private final java.util.List<java.lang.String> allowOrigins;
            private final java.util.List<java.lang.String> exposeHeaders;
            private final java.lang.Number maxAge;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCredentials = software.amazon.jsii.Kernel.get(this, "allowCredentials", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowHeaders = software.amazon.jsii.Kernel.get(this, "allowHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowMethods = software.amazon.jsii.Kernel.get(this, "allowMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.allowOrigins = software.amazon.jsii.Kernel.get(this, "allowOrigins", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.exposeHeaders = software.amazon.jsii.Kernel.get(this, "exposeHeaders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.maxAge = software.amazon.jsii.Kernel.get(this, "maxAge", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCredentials = builder.allowCredentials;
                this.allowHeaders = builder.allowHeaders;
                this.allowMethods = builder.allowMethods;
                this.allowOrigins = builder.allowOrigins;
                this.exposeHeaders = builder.exposeHeaders;
                this.maxAge = builder.maxAge;
            }

            @Override
            public final java.lang.Object getAllowCredentials() {
                return this.allowCredentials;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowHeaders() {
                return this.allowHeaders;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowMethods() {
                return this.allowMethods;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowOrigins() {
                return this.allowOrigins;
            }

            @Override
            public final java.util.List<java.lang.String> getExposeHeaders() {
                return this.exposeHeaders;
            }

            @Override
            public final java.lang.Number getMaxAge() {
                return this.maxAge;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAllowCredentials() != null) {
                    data.set("allowCredentials", om.valueToTree(this.getAllowCredentials()));
                }
                if (this.getAllowHeaders() != null) {
                    data.set("allowHeaders", om.valueToTree(this.getAllowHeaders()));
                }
                if (this.getAllowMethods() != null) {
                    data.set("allowMethods", om.valueToTree(this.getAllowMethods()));
                }
                if (this.getAllowOrigins() != null) {
                    data.set("allowOrigins", om.valueToTree(this.getAllowOrigins()));
                }
                if (this.getExposeHeaders() != null) {
                    data.set("exposeHeaders", om.valueToTree(this.getExposeHeaders()));
                }
                if (this.getMaxAge() != null) {
                    data.set("maxAge", om.valueToTree(this.getMaxAge()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.CfnUrl.CorsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CorsProperty.Jsii$Proxy that = (CorsProperty.Jsii$Proxy) o;

                if (this.allowCredentials != null ? !this.allowCredentials.equals(that.allowCredentials) : that.allowCredentials != null) return false;
                if (this.allowHeaders != null ? !this.allowHeaders.equals(that.allowHeaders) : that.allowHeaders != null) return false;
                if (this.allowMethods != null ? !this.allowMethods.equals(that.allowMethods) : that.allowMethods != null) return false;
                if (this.allowOrigins != null ? !this.allowOrigins.equals(that.allowOrigins) : that.allowOrigins != null) return false;
                if (this.exposeHeaders != null ? !this.exposeHeaders.equals(that.exposeHeaders) : that.exposeHeaders != null) return false;
                return this.maxAge != null ? this.maxAge.equals(that.maxAge) : that.maxAge == null;
            }

            @Override
            public final int hashCode() {
                int result = this.allowCredentials != null ? this.allowCredentials.hashCode() : 0;
                result = 31 * result + (this.allowHeaders != null ? this.allowHeaders.hashCode() : 0);
                result = 31 * result + (this.allowMethods != null ? this.allowMethods.hashCode() : 0);
                result = 31 * result + (this.allowOrigins != null ? this.allowOrigins.hashCode() : 0);
                result = 31 * result + (this.exposeHeaders != null ? this.exposeHeaders.hashCode() : 0);
                result = 31 * result + (this.maxAge != null ? this.maxAge.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.CfnUrl}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.CfnUrl> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.lambda.CfnUrlProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.lambda.CfnUrlProps.Builder();
        }

        /**
         * The type of authentication that your function URL uses.
         * <p>
         * Set to <code>AWS_IAM</code> if you want to restrict access to authenticated users only. Set to <code>NONE</code> if you want to bypass IAM authentication to create a public endpoint. For more information, see <a href="https://docs.aws.amazon.com/lambda/latest/dg/urls-auth.html">Security and auth model for Lambda function URLs</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-authtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-authtype</a>
         * @param authType The type of authentication that your function URL uses. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authType(final java.lang.String authType) {
            this.props.authType(authType);
            return this;
        }

        /**
         * The name of the Lambda function.
         * <p>
         * <strong>Name formats</strong> - <em>Function name</em> - <code>my-function</code> .
         * <p>
         * <ul>
         * <li><em>Function ARN</em> - <code>arn:aws:lambda:us-west-2:123456789012:function:my-function</code> .</li>
         * <li><em>Partial ARN</em> - <code>123456789012:function:my-function</code> .</li>
         * </ul>
         * <p>
         * The length constraint applies only to the full ARN. If you specify only the function name, it is limited to 64 characters in length.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-targetfunctionarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-targetfunctionarn</a>
         * @param targetFunctionArn The name of the Lambda function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetFunctionArn(final java.lang.String targetFunctionArn) {
            this.props.targetFunctionArn(targetFunctionArn);
            return this;
        }

        /**
         * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-cors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-cors</a>
         * @param cors The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(final software.amazon.awscdk.IResolvable cors) {
            this.props.cors(cors);
            return this;
        }
        /**
         * The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-cors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-cors</a>
         * @param cors The <a href="https://docs.aws.amazon.com/https://developer.mozilla.org/en-US/docs/Web/HTTP/CORS">Cross-Origin Resource Sharing (CORS)</a> settings for your function URL. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cors(final software.amazon.awscdk.services.lambda.CfnUrl.CorsProperty cors) {
            this.props.cors(cors);
            return this;
        }

        /**
         * Use one of the following options:.
         * <p>
         * <ul>
         * <li><code>BUFFERED</code> – This is the default option. Lambda invokes your function using the <code>Invoke</code> API operation. Invocation results are available when the payload is complete. The maximum payload size is 6 MB.</li>
         * <li><code>RESPONSE_STREAM</code> – Your function streams payload results as they become available. Lambda invokes your function using the <code>InvokeWithResponseStream</code> API operation. The maximum response payload size is 20 MB, however, you can <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/request-quota-increase.html">request a quota increase</a> .</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-invokemode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-invokemode</a>
         * @param invokeMode Use one of the following options:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder invokeMode(final java.lang.String invokeMode) {
            this.props.invokeMode(invokeMode);
            return this;
        }

        /**
         * The alias name.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-qualifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-url.html#cfn-lambda-url-qualifier</a>
         * @param qualifier The alias name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder qualifier(final java.lang.String qualifier) {
            this.props.qualifier(qualifier);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.CfnUrl}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.CfnUrl build() {
            return new software.amazon.awscdk.services.lambda.CfnUrl(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
