package software.amazon.awscdk.services.lambda;

/**
 * X-Ray Tracing Modes (https://docs.aws.amazon.com/lambda/latest/dg/API_TracingConfig.html).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Function fn = Function.Builder.create(this, "MyFunction")
 *         .runtime(Runtime.NODEJS_18_X)
 *         .handler("index.handler")
 *         .code(Code.fromInline("exports.handler = function(event, ctx, cb) { return cb(null, \"hi\"); }"))
 *         .tracing(Tracing.ACTIVE)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:25.829Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.Tracing")
public enum Tracing {
    /**
     * Lambda will respect any tracing header it receives from an upstream service.
     * <p>
     * If no tracing header is received, Lambda will sample the request based on a fixed rate. Please see the <a href="https://docs.aws.amazon.com/lambda/latest/dg/services-xray.html">Using AWS Lambda with AWS X-Ray</a> documentation for details on this sampling behavior.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ACTIVE,
    /**
     * Lambda will only trace the request from an upstream service if it contains a tracing header with "sampled=1".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PASS_THROUGH,
    /**
     * Lambda will not trace any request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISABLED,
}
