package software.amazon.awscdk.services.location;

/**
 * Properties for defining a <code>CfnGeofenceCollection</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnGeofenceCollectionProps cfnGeofenceCollectionProps = CfnGeofenceCollectionProps.builder()
 *         .collectionName("collectionName")
 *         // the properties below are optional
 *         .description("description")
 *         .kmsKeyId("kmsKeyId")
 *         .pricingPlan("pricingPlan")
 *         .pricingPlanDataSource("pricingPlanDataSource")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:26.051Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnGeofenceCollectionProps")
@software.amazon.jsii.Jsii.Proxy(CfnGeofenceCollectionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnGeofenceCollectionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A custom name for the geofence collection.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique geofence collection name.</li>
     * <li>No spaces allowed. For example, <code>ExampleGeofenceCollection</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-collectionname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-collectionname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCollectionName();

    /**
     * An optional description for the geofence collection.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> . Enter a key ID, key ARN, alias name, or alias ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplan</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplandatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-pricingplandatasource</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlanDataSource() {
        return null;
    }

    /**
     * Applies one or more tags to the geofence collection.
     * <p>
     * A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
     * <p>
     * Format: <code>"key" : "value"</code>
     * <p>
     * Restrictions:
     * <p>
     * <ul>
     * <li>Maximum 50 tags per resource</li>
     * <li>Each resource tag must be unique with a maximum of one value.</li>
     * <li>Maximum key length: 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length: 256 Unicode characters in UTF-8</li>
     * <li>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-geofencecollection.html#cfn-location-geofencecollection-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnGeofenceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGeofenceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnGeofenceCollectionProps> {
        java.lang.String collectionName;
        java.lang.String description;
        java.lang.String kmsKeyId;
        java.lang.String pricingPlan;
        java.lang.String pricingPlanDataSource;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getCollectionName}
         * @param collectionName A custom name for the geofence collection. This parameter is required.
         *                       Requirements:
         *                       <p>
         *                       <ul>
         *                       <li>Contain only alphanumeric characters (A–Z, a–z, 0–9), hyphens (-), periods (.), and underscores (_).</li>
         *                       <li>Must be a unique geofence collection name.</li>
         *                       <li>No spaces allowed. For example, <code>ExampleGeofenceCollection</code> .</li>
         *                       </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder collectionName(java.lang.String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getDescription}
         * @param description An optional description for the geofence collection.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getKmsKeyId}
         * @param kmsKeyId A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> . Enter a key ID, key ARN, alias name, or alias ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getPricingPlan}
         * @param pricingPlan the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pricingPlan(java.lang.String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getPricingPlanDataSource}
         * @param pricingPlanDataSource the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pricingPlanDataSource(java.lang.String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnGeofenceCollectionProps#getTags}
         * @param tags Applies one or more tags to the geofence collection.
         *             A tag is a key-value pair helps manage, identify, search, and filter your resources by labelling them.
         *             <p>
         *             Format: <code>"key" : "value"</code>
         *             <p>
         *             Restrictions:
         *             <p>
         *             <ul>
         *             <li>Maximum 50 tags per resource</li>
         *             <li>Each resource tag must be unique with a maximum of one value.</li>
         *             <li>Maximum key length: 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length: 256 Unicode characters in UTF-8</li>
         *             <li>Can use alphanumeric characters (A–Z, a–z, 0–9), and the following characters: + - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGeofenceCollectionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnGeofenceCollectionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnGeofenceCollectionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGeofenceCollectionProps {
        private final java.lang.String collectionName;
        private final java.lang.String description;
        private final java.lang.String kmsKeyId;
        private final java.lang.String pricingPlan;
        private final java.lang.String pricingPlanDataSource;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.collectionName = software.amazon.jsii.Kernel.get(this, "collectionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlan = software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlanDataSource = software.amazon.jsii.Kernel.get(this, "pricingPlanDataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.collectionName = java.util.Objects.requireNonNull(builder.collectionName, "collectionName is required");
            this.description = builder.description;
            this.kmsKeyId = builder.kmsKeyId;
            this.pricingPlan = builder.pricingPlan;
            this.pricingPlanDataSource = builder.pricingPlanDataSource;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getCollectionName() {
            return this.collectionName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final java.lang.String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("collectionName", om.valueToTree(this.getCollectionName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getPricingPlan() != null) {
                data.set("pricingPlan", om.valueToTree(this.getPricingPlan()));
            }
            if (this.getPricingPlanDataSource() != null) {
                data.set("pricingPlanDataSource", om.valueToTree(this.getPricingPlanDataSource()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnGeofenceCollectionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGeofenceCollectionProps.Jsii$Proxy that = (CfnGeofenceCollectionProps.Jsii$Proxy) o;

            if (!collectionName.equals(that.collectionName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.pricingPlan != null ? !this.pricingPlan.equals(that.pricingPlan) : that.pricingPlan != null) return false;
            if (this.pricingPlanDataSource != null ? !this.pricingPlanDataSource.equals(that.pricingPlanDataSource) : that.pricingPlanDataSource != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.collectionName.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.pricingPlan != null ? this.pricingPlan.hashCode() : 0);
            result = 31 * result + (this.pricingPlanDataSource != null ? this.pricingPlanDataSource.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
