package software.amazon.awscdk.services.logs;

/**
 * How long, in days, the log contents will be retained.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.iam.*;
 * import software.amazon.awscdk.services.logs.*;
 * Role myLogsPublishingRole;
 * Vpc vpc;
 * DatabaseCluster cluster = DatabaseCluster.Builder.create(this, "Database")
 *         .masterUser(Login.builder()
 *                 .username("myuser")
 *                 .build())
 *         .instanceType(InstanceType.of(InstanceClass.MEMORY5, InstanceSize.LARGE))
 *         .vpcSubnets(SubnetSelection.builder()
 *                 .subnetType(SubnetType.PUBLIC)
 *                 .build())
 *         .vpc(vpc)
 *         .exportProfilerLogsToCloudWatch(true) // Enable sending profiler logs
 *         .exportAuditLogsToCloudWatch(true) // Enable sending audit logs
 *         .cloudWatchLogsRetention(RetentionDays.THREE_MONTHS) // Optional - default is to never expire logs
 *         .cloudWatchLogsRetentionRole(myLogsPublishingRole)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:26.127Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.RetentionDays")
public enum RetentionDays {
    /**
     * 1 day.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_DAY,
    /**
     * 3 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_DAYS,
    /**
     * 5 days.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_DAYS,
    /**
     * 1 week.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_WEEK,
    /**
     * 2 weeks.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_WEEKS,
    /**
     * 1 month.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_MONTH,
    /**
     * 2 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_MONTHS,
    /**
     * 3 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_MONTHS,
    /**
     * 4 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FOUR_MONTHS,
    /**
     * 5 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_MONTHS,
    /**
     * 6 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIX_MONTHS,
    /**
     * 1 year.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ONE_YEAR,
    /**
     * 13 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THIRTEEN_MONTHS,
    /**
     * 18 months.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EIGHTEEN_MONTHS,
    /**
     * 2 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TWO_YEARS,
    /**
     * 3 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    THREE_YEARS,
    /**
     * 5 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FIVE_YEARS,
    /**
     * 6 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SIX_YEARS,
    /**
     * 7 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SEVEN_YEARS,
    /**
     * 8 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EIGHT_YEARS,
    /**
     * 9 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NINE_YEARS,
    /**
     * 10 years.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TEN_YEARS,
    /**
     * Retain logs forever.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFINITE,
}
