package software.amazon.awscdk.services.lookoutequipment;

/**
 * Properties for defining a <code>CfnInferenceScheduler</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lookoutequipment.*;
 * Object dataInputConfiguration;
 * Object dataOutputConfiguration;
 * CfnInferenceSchedulerProps cfnInferenceSchedulerProps = CfnInferenceSchedulerProps.builder()
 *         .dataInputConfiguration(dataInputConfiguration)
 *         .dataOutputConfiguration(dataOutputConfiguration)
 *         .dataUploadFrequency("dataUploadFrequency")
 *         .modelName("modelName")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .dataDelayOffsetInMinutes(123)
 *         .inferenceSchedulerName("inferenceSchedulerName")
 *         .serverSideKmsKeyId("serverSideKmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:26.134Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lookoutequipment.CfnInferenceSchedulerProps")
@software.amazon.jsii.Jsii.Proxy(CfnInferenceSchedulerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInferenceSchedulerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datainputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datainputconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataInputConfiguration();

    /**
     * Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-dataoutputconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-dataoutputconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDataOutputConfiguration();

    /**
     * How often data is uploaded to the source S3 bucket for the input data.
     * <p>
     * This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datauploadfrequency">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datauploadfrequency</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDataUploadFrequency();

    /**
     * The name of the machine learning model used for the inference scheduler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-modelname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-modelname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getModelName();

    /**
     * The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-rolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

    /**
     * A period of time (in minutes) by which inference on the data is delayed after the data starts.
     * <p>
     * For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when uploading new data.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datadelayoffsetinminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-datadelayoffsetinminutes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getDataDelayOffsetInMinutes() {
        return null;
    }

    /**
     * The name of the inference scheduler.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-inferenceschedulername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-inferenceschedulername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInferenceSchedulerName() {
        return null;
    }

    /**
     * Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-serversidekmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-serversidekmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getServerSideKmsKeyId() {
        return null;
    }

    /**
     * Any tags associated with the inference scheduler.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lookoutequipment-inferencescheduler.html#cfn-lookoutequipment-inferencescheduler-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInferenceSchedulerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInferenceSchedulerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInferenceSchedulerProps> {
        java.lang.Object dataInputConfiguration;
        java.lang.Object dataOutputConfiguration;
        java.lang.String dataUploadFrequency;
        java.lang.String modelName;
        java.lang.String roleArn;
        java.lang.Number dataDelayOffsetInMinutes;
        java.lang.String inferenceSchedulerName;
        java.lang.String serverSideKmsKeyId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getDataInputConfiguration}
         * @param dataInputConfiguration Specifies configuration information for the input data for the inference scheduler, including delimiter, format, and dataset location. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataInputConfiguration(java.lang.Object dataInputConfiguration) {
            this.dataInputConfiguration = dataInputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getDataOutputConfiguration}
         * @param dataOutputConfiguration Specifies configuration information for the output results for the inference scheduler, including the Amazon S3 location for the output. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataOutputConfiguration(java.lang.Object dataOutputConfiguration) {
            this.dataOutputConfiguration = dataOutputConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getDataUploadFrequency}
         * @param dataUploadFrequency How often data is uploaded to the source S3 bucket for the input data. This parameter is required.
         *                            This value is the length of time between data uploads. For instance, if you select 5 minutes, Amazon Lookout for Equipment will upload the real-time data to the source bucket once every 5 minutes. This frequency also determines how often Amazon Lookout for Equipment starts a scheduled inference on your data. In this example, it starts once every 5 minutes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataUploadFrequency(java.lang.String dataUploadFrequency) {
            this.dataUploadFrequency = dataUploadFrequency;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getModelName}
         * @param modelName The name of the machine learning model used for the inference scheduler. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder modelName(java.lang.String modelName) {
            this.modelName = modelName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getRoleArn}
         * @param roleArn The Amazon Resource Name (ARN) of a role with permission to access the data source being used for the inference. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getDataDelayOffsetInMinutes}
         * @param dataDelayOffsetInMinutes A period of time (in minutes) by which inference on the data is delayed after the data starts.
         *                                 For instance, if an offset delay time of five minutes was selected, inference will not begin on the data until the first data measurement after the five minute mark. For example, if five minutes is selected, the inference scheduler will wake up at the configured frequency with the additional five minute delay time to check the customer S3 bucket. The customer can upload data at the same frequency and they don't need to stop and restart the scheduler when uploading new data.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataDelayOffsetInMinutes(java.lang.Number dataDelayOffsetInMinutes) {
            this.dataDelayOffsetInMinutes = dataDelayOffsetInMinutes;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getInferenceSchedulerName}
         * @param inferenceSchedulerName The name of the inference scheduler.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceSchedulerName(java.lang.String inferenceSchedulerName) {
            this.inferenceSchedulerName = inferenceSchedulerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getServerSideKmsKeyId}
         * @param serverSideKmsKeyId Provides the identifier of the AWS KMS key used to encrypt inference scheduler data by Amazon Lookout for Equipment .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverSideKmsKeyId(java.lang.String serverSideKmsKeyId) {
            this.serverSideKmsKeyId = serverSideKmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceSchedulerProps#getTags}
         * @param tags Any tags associated with the inference scheduler.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-resource-tags.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInferenceSchedulerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInferenceSchedulerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInferenceSchedulerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInferenceSchedulerProps {
        private final java.lang.Object dataInputConfiguration;
        private final java.lang.Object dataOutputConfiguration;
        private final java.lang.String dataUploadFrequency;
        private final java.lang.String modelName;
        private final java.lang.String roleArn;
        private final java.lang.Number dataDelayOffsetInMinutes;
        private final java.lang.String inferenceSchedulerName;
        private final java.lang.String serverSideKmsKeyId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dataInputConfiguration = software.amazon.jsii.Kernel.get(this, "dataInputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataOutputConfiguration = software.amazon.jsii.Kernel.get(this, "dataOutputConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.dataUploadFrequency = software.amazon.jsii.Kernel.get(this, "dataUploadFrequency", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.modelName = software.amazon.jsii.Kernel.get(this, "modelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dataDelayOffsetInMinutes = software.amazon.jsii.Kernel.get(this, "dataDelayOffsetInMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.inferenceSchedulerName = software.amazon.jsii.Kernel.get(this, "inferenceSchedulerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.serverSideKmsKeyId = software.amazon.jsii.Kernel.get(this, "serverSideKmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dataInputConfiguration = java.util.Objects.requireNonNull(builder.dataInputConfiguration, "dataInputConfiguration is required");
            this.dataOutputConfiguration = java.util.Objects.requireNonNull(builder.dataOutputConfiguration, "dataOutputConfiguration is required");
            this.dataUploadFrequency = java.util.Objects.requireNonNull(builder.dataUploadFrequency, "dataUploadFrequency is required");
            this.modelName = java.util.Objects.requireNonNull(builder.modelName, "modelName is required");
            this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
            this.dataDelayOffsetInMinutes = builder.dataDelayOffsetInMinutes;
            this.inferenceSchedulerName = builder.inferenceSchedulerName;
            this.serverSideKmsKeyId = builder.serverSideKmsKeyId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.Object getDataInputConfiguration() {
            return this.dataInputConfiguration;
        }

        @Override
        public final java.lang.Object getDataOutputConfiguration() {
            return this.dataOutputConfiguration;
        }

        @Override
        public final java.lang.String getDataUploadFrequency() {
            return this.dataUploadFrequency;
        }

        @Override
        public final java.lang.String getModelName() {
            return this.modelName;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.lang.Number getDataDelayOffsetInMinutes() {
            return this.dataDelayOffsetInMinutes;
        }

        @Override
        public final java.lang.String getInferenceSchedulerName() {
            return this.inferenceSchedulerName;
        }

        @Override
        public final java.lang.String getServerSideKmsKeyId() {
            return this.serverSideKmsKeyId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dataInputConfiguration", om.valueToTree(this.getDataInputConfiguration()));
            data.set("dataOutputConfiguration", om.valueToTree(this.getDataOutputConfiguration()));
            data.set("dataUploadFrequency", om.valueToTree(this.getDataUploadFrequency()));
            data.set("modelName", om.valueToTree(this.getModelName()));
            data.set("roleArn", om.valueToTree(this.getRoleArn()));
            if (this.getDataDelayOffsetInMinutes() != null) {
                data.set("dataDelayOffsetInMinutes", om.valueToTree(this.getDataDelayOffsetInMinutes()));
            }
            if (this.getInferenceSchedulerName() != null) {
                data.set("inferenceSchedulerName", om.valueToTree(this.getInferenceSchedulerName()));
            }
            if (this.getServerSideKmsKeyId() != null) {
                data.set("serverSideKmsKeyId", om.valueToTree(this.getServerSideKmsKeyId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lookoutequipment.CfnInferenceSchedulerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInferenceSchedulerProps.Jsii$Proxy that = (CfnInferenceSchedulerProps.Jsii$Proxy) o;

            if (!dataInputConfiguration.equals(that.dataInputConfiguration)) return false;
            if (!dataOutputConfiguration.equals(that.dataOutputConfiguration)) return false;
            if (!dataUploadFrequency.equals(that.dataUploadFrequency)) return false;
            if (!modelName.equals(that.modelName)) return false;
            if (!roleArn.equals(that.roleArn)) return false;
            if (this.dataDelayOffsetInMinutes != null ? !this.dataDelayOffsetInMinutes.equals(that.dataDelayOffsetInMinutes) : that.dataDelayOffsetInMinutes != null) return false;
            if (this.inferenceSchedulerName != null ? !this.inferenceSchedulerName.equals(that.inferenceSchedulerName) : that.inferenceSchedulerName != null) return false;
            if (this.serverSideKmsKeyId != null ? !this.serverSideKmsKeyId.equals(that.serverSideKmsKeyId) : that.serverSideKmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dataInputConfiguration.hashCode();
            result = 31 * result + (this.dataOutputConfiguration.hashCode());
            result = 31 * result + (this.dataUploadFrequency.hashCode());
            result = 31 * result + (this.modelName.hashCode());
            result = 31 * result + (this.roleArn.hashCode());
            result = 31 * result + (this.dataDelayOffsetInMinutes != null ? this.dataDelayOffsetInMinutes.hashCode() : 0);
            result = 31 * result + (this.inferenceSchedulerName != null ? this.inferenceSchedulerName.hashCode() : 0);
            result = 31 * result + (this.serverSideKmsKeyId != null ? this.serverSideKmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
