package software.amazon.awscdk.services.organizations;

/**
 * Properties for defining a <code>CfnOrganization</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.organizations.*;
 * CfnOrganizationProps cfnOrganizationProps = CfnOrganizationProps.builder()
 *         .featureSet("featureSet")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-organization.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-organization.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:26.875Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_organizations.CfnOrganizationProps")
@software.amazon.jsii.Jsii.Proxy(CfnOrganizationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnOrganizationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.
     * <p>
     * <ul>
     * <li><code>ALL</code>  In addition to all the features supported by the consolidated billing feature set, the management account gains access to advanced features that give you more control over accounts in your organization. By default or if you set the <code>FeatureSet</code> property to <code>ALL</code> , the new organization is created with all features enabled and service control policies automatically enabled in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#root">root</a> . For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <em>AWS Organizations User Guide</em> .</li>
     * <li><code>CONSOLIDATED_BILLING</code>  All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <em>AWS Organizations User Guide</em> .</li>
     * </ul>
     * <p>
     * The consolidated billing feature subset isn't available for organizations in the AWS GovCloud (US) Region.
     * <p>
     * Feature set <code>ALL</code> provides the following advanced features:
     * <p>
     * <ul>
     * <li>Apply any <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#orgs-policy-types">policy type</a> to any member account in the organization.</li>
     * <li>Apply <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html">service control policies (SCPs)</a> to member accounts that restrict the services and actions that users (including the root user) and roles in an account can access. Using SCPs you can prevent member accounts from leaving the organization.</li>
     * <li>Enable <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">integration with supported AWS services</a> to let those services provide functionality across all of the accounts in your organization.</li>
     * </ul>
     * <p>
     * If you don't specify this property, the default value is <code>ALL</code> .
     * <p>
     * Default: - "ALL"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-organization.html#cfn-organizations-organization-featureset">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-organizations-organization.html#cfn-organizations-organization-featureset</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFeatureSet() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnOrganizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnOrganizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnOrganizationProps> {
        java.lang.String featureSet;

        /**
         * Sets the value of {@link CfnOrganizationProps#getFeatureSet}
         * @param featureSet Specifies the feature set supported by the new organization. Each feature set supports different levels of functionality.
         *                   <ul>
         *                   <li><code>ALL</code>  In addition to all the features supported by the consolidated billing feature set, the management account gains access to advanced features that give you more control over accounts in your organization. By default or if you set the <code>FeatureSet</code> property to <code>ALL</code> , the new organization is created with all features enabled and service control policies automatically enabled in the <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#root">root</a> . For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-all">All features</a> in the <em>AWS Organizations User Guide</em> .</li>
         *                   <li><code>CONSOLIDATED_BILLING</code>  All member accounts have their bills consolidated to and paid by the management account. For more information, see <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#feature-set-cb-only">Consolidated billing</a> in the <em>AWS Organizations User Guide</em> .</li>
         *                   </ul>
         *                   <p>
         *                   The consolidated billing feature subset isn't available for organizations in the AWS GovCloud (US) Region.
         *                   <p>
         *                   Feature set <code>ALL</code> provides the following advanced features:
         *                   <p>
         *                   <ul>
         *                   <li>Apply any <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies.html#orgs-policy-types">policy type</a> to any member account in the organization.</li>
         *                   <li>Apply <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_scps.html">service control policies (SCPs)</a> to member accounts that restrict the services and actions that users (including the root user) and roles in an account can access. Using SCPs you can prevent member accounts from leaving the organization.</li>
         *                   <li>Enable <a href="https://docs.aws.amazon.com/organizations/latest/userguide/orgs_integrate_services_list.html">integration with supported AWS services</a> to let those services provide functionality across all of the accounts in your organization.</li>
         *                   </ul>
         *                   <p>
         *                   If you don't specify this property, the default value is <code>ALL</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder featureSet(java.lang.String featureSet) {
            this.featureSet = featureSet;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnOrganizationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnOrganizationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnOrganizationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnOrganizationProps {
        private final java.lang.String featureSet;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.featureSet = software.amazon.jsii.Kernel.get(this, "featureSet", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.featureSet = builder.featureSet;
        }

        @Override
        public final java.lang.String getFeatureSet() {
            return this.featureSet;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFeatureSet() != null) {
                data.set("featureSet", om.valueToTree(this.getFeatureSet()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_organizations.CfnOrganizationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnOrganizationProps.Jsii$Proxy that = (CfnOrganizationProps.Jsii$Proxy) o;

            return this.featureSet != null ? this.featureSet.equals(that.featureSet) : that.featureSet == null;
        }

        @Override
        public final int hashCode() {
            int result = this.featureSet != null ? this.featureSet.hashCode() : 0;
            return result;
        }
    }
}
