package software.amazon.awscdk.services.quicksight;

/**
 * Properties for defining a <code>CfnTheme</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.quicksight.*;
 * CfnThemeProps cfnThemeProps = CfnThemeProps.builder()
 *         .awsAccountId("awsAccountId")
 *         .baseThemeId("baseThemeId")
 *         .configuration(ThemeConfigurationProperty.builder()
 *                 .dataColorPalette(DataColorPaletteProperty.builder()
 *                         .colors(List.of("colors"))
 *                         .emptyFillColor("emptyFillColor")
 *                         .minMaxGradient(List.of("minMaxGradient"))
 *                         .build())
 *                 .sheet(SheetStyleProperty.builder()
 *                         .tile(TileStyleProperty.builder()
 *                                 .border(BorderStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .build())
 *                         .tileLayout(TileLayoutStyleProperty.builder()
 *                                 .gutter(GutterStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .margin(MarginStyleProperty.builder()
 *                                         .show(false)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .typography(TypographyProperty.builder()
 *                         .fontFamilies(List.of(FontProperty.builder()
 *                                 .fontFamily("fontFamily")
 *                                 .build()))
 *                         .build())
 *                 .uiColorPalette(UIColorPaletteProperty.builder()
 *                         .accent("accent")
 *                         .accentForeground("accentForeground")
 *                         .danger("danger")
 *                         .dangerForeground("dangerForeground")
 *                         .dimension("dimension")
 *                         .dimensionForeground("dimensionForeground")
 *                         .measure("measure")
 *                         .measureForeground("measureForeground")
 *                         .primaryBackground("primaryBackground")
 *                         .primaryForeground("primaryForeground")
 *                         .secondaryBackground("secondaryBackground")
 *                         .secondaryForeground("secondaryForeground")
 *                         .success("success")
 *                         .successForeground("successForeground")
 *                         .warning("warning")
 *                         .warningForeground("warningForeground")
 *                         .build())
 *                 .build())
 *         .name("name")
 *         .themeId("themeId")
 *         // the properties below are optional
 *         .permissions(List.of(ResourcePermissionProperty.builder()
 *                 .actions(List.of("actions"))
 *                 .principal("principal")
 *                 // the properties below are optional
 *                 .resource("resource")
 *                 .build()))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .versionDescription("versionDescription")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:28.737Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_quicksight.CfnThemeProps")
@software.amazon.jsii.Jsii.Proxy(CfnThemeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnThemeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The ID of the AWS account where you want to store the new theme.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-awsaccountid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAwsAccountId();

    /**
     * The ID of the theme that a custom theme will inherit from.
     * <p>
     * All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <em>Themes</em> from within an analysis.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-basethemeid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getBaseThemeId();

    /**
     * The theme configuration, which contains the theme display properties.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getConfiguration();

    /**
     * A display name for the theme.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * An ID for the theme that you want to create.
     * <p>
     * The theme ID is unique per AWS Region in each AWS account.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-themeid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getThemeId();

    /**
     * A valid grouping of resource permissions to apply to the new theme.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-permissions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPermissions() {
        return null;
    }

    /**
     * A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A description of the first version of the theme that you're creating.
     * <p>
     * Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-quicksight-theme.html#cfn-quicksight-theme-versiondescription</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersionDescription() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnThemeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnThemeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnThemeProps> {
        java.lang.String awsAccountId;
        java.lang.String baseThemeId;
        java.lang.Object configuration;
        java.lang.String name;
        java.lang.String themeId;
        java.lang.Object permissions;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String versionDescription;

        /**
         * Sets the value of {@link CfnThemeProps#getAwsAccountId}
         * @param awsAccountId The ID of the AWS account where you want to store the new theme. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder awsAccountId(java.lang.String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getBaseThemeId}
         * @param baseThemeId The ID of the theme that a custom theme will inherit from. This parameter is required.
         *                    All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use <code>ListThemes</code> or choose <em>Themes</em> from within an analysis.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseThemeId(java.lang.String baseThemeId) {
            this.baseThemeId = baseThemeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getConfiguration}
         * @param configuration The theme configuration, which contains the theme display properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getConfiguration}
         * @param configuration The theme configuration, which contains the theme display properties. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.quicksight.CfnTheme.ThemeConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getName}
         * @param name A display name for the theme. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getThemeId}
         * @param themeId An ID for the theme that you want to create. This parameter is required.
         *                The theme ID is unique per AWS Region in each AWS account.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder themeId(java.lang.String themeId) {
            this.themeId = themeId;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getPermissions}
         * @param permissions A valid grouping of resource permissions to apply to the new theme.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(software.amazon.awscdk.IResolvable permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getPermissions}
         * @param permissions A valid grouping of resource permissions to apply to the new theme.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissions(java.util.List<? extends java.lang.Object> permissions) {
            this.permissions = permissions;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getTags}
         * @param tags A map of the key-value pairs for the resource tag or tags that you want to add to the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnThemeProps#getVersionDescription}
         * @param versionDescription A description of the first version of the theme that you're creating.
         *                           Every time <code>UpdateTheme</code> is called, a new version is created. Each version of the theme has a description of the version in the <code>VersionDescription</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionDescription(java.lang.String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnThemeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnThemeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnThemeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnThemeProps {
        private final java.lang.String awsAccountId;
        private final java.lang.String baseThemeId;
        private final java.lang.Object configuration;
        private final java.lang.String name;
        private final java.lang.String themeId;
        private final java.lang.Object permissions;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String versionDescription;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.awsAccountId = software.amazon.jsii.Kernel.get(this, "awsAccountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.baseThemeId = software.amazon.jsii.Kernel.get(this, "baseThemeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.themeId = software.amazon.jsii.Kernel.get(this, "themeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.permissions = software.amazon.jsii.Kernel.get(this, "permissions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.versionDescription = software.amazon.jsii.Kernel.get(this, "versionDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.awsAccountId = java.util.Objects.requireNonNull(builder.awsAccountId, "awsAccountId is required");
            this.baseThemeId = java.util.Objects.requireNonNull(builder.baseThemeId, "baseThemeId is required");
            this.configuration = java.util.Objects.requireNonNull(builder.configuration, "configuration is required");
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.themeId = java.util.Objects.requireNonNull(builder.themeId, "themeId is required");
            this.permissions = builder.permissions;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.versionDescription = builder.versionDescription;
        }

        @Override
        public final java.lang.String getAwsAccountId() {
            return this.awsAccountId;
        }

        @Override
        public final java.lang.String getBaseThemeId() {
            return this.baseThemeId;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getThemeId() {
            return this.themeId;
        }

        @Override
        public final java.lang.Object getPermissions() {
            return this.permissions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVersionDescription() {
            return this.versionDescription;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("awsAccountId", om.valueToTree(this.getAwsAccountId()));
            data.set("baseThemeId", om.valueToTree(this.getBaseThemeId()));
            data.set("configuration", om.valueToTree(this.getConfiguration()));
            data.set("name", om.valueToTree(this.getName()));
            data.set("themeId", om.valueToTree(this.getThemeId()));
            if (this.getPermissions() != null) {
                data.set("permissions", om.valueToTree(this.getPermissions()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVersionDescription() != null) {
                data.set("versionDescription", om.valueToTree(this.getVersionDescription()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_quicksight.CfnThemeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnThemeProps.Jsii$Proxy that = (CfnThemeProps.Jsii$Proxy) o;

            if (!awsAccountId.equals(that.awsAccountId)) return false;
            if (!baseThemeId.equals(that.baseThemeId)) return false;
            if (!configuration.equals(that.configuration)) return false;
            if (!name.equals(that.name)) return false;
            if (!themeId.equals(that.themeId)) return false;
            if (this.permissions != null ? !this.permissions.equals(that.permissions) : that.permissions != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.versionDescription != null ? this.versionDescription.equals(that.versionDescription) : that.versionDescription == null;
        }

        @Override
        public final int hashCode() {
            int result = this.awsAccountId.hashCode();
            result = 31 * result + (this.baseThemeId.hashCode());
            result = 31 * result + (this.configuration.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.themeId.hashCode());
            result = 31 * result + (this.permissions != null ? this.permissions.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.versionDescription != null ? this.versionDescription.hashCode() : 0);
            return result;
        }
    }
}
