package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnCustomDBEngineVersion</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnCustomDBEngineVersionProps cfnCustomDBEngineVersionProps = CfnCustomDBEngineVersionProps.builder()
 *         .databaseInstallationFilesS3BucketName("databaseInstallationFilesS3BucketName")
 *         .engine("engine")
 *         .engineVersion("engineVersion")
 *         // the properties below are optional
 *         .databaseInstallationFilesS3Prefix("databaseInstallationFilesS3Prefix")
 *         .description("description")
 *         .kmsKeyId("kmsKeyId")
 *         .manifest("manifest")
 *         .status("status")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:28.814Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnCustomDBEngineVersionProps")
@software.amazon.jsii.Jsii.Proxy(CfnCustomDBEngineVersionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCustomDBEngineVersionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of an Amazon S3 bucket that contains database installation files for your CEV.
     * <p>
     * For example, a valid bucket name is <code>my-custom-installation-files</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-databaseinstallationfiless3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-databaseinstallationfiless3bucketname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDatabaseInstallationFilesS3BucketName();

    /**
     * The database engine to use for your custom engine version (CEV).
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>custom-oracle-ee</code></li>
     * <li><code>custom-oracle-ee-cdb</code></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-engine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-engine</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngine();

    /**
     * The name of your CEV.
     * <p>
     * The name format is <code>major version.customized_string</code> . For example, a valid CEV name is <code>19.my_cev1</code> . This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.
     * <p>
     * <em>Constraints:</em> Minimum length is 1. Maximum length is 60.
     * <p>
     * <em>Pattern:</em> <code>^[a-z0-9_.-]{1,60$</code> }
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-engineversion</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEngineVersion();

    /**
     * The Amazon S3 directory that contains the database installation files for your CEV.
     * <p>
     * For example, a valid bucket name is <code>123456789012/cev1</code> . If this setting isn't specified, no prefix is assumed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-databaseinstallationfiless3prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-databaseinstallationfiless3prefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDatabaseInstallationFilesS3Prefix() {
        return null;
    }

    /**
     * An optional description of your CEV.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The AWS KMS key identifier for an encrypted CEV.
     * <p>
     * A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
     * <p>
     * If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">Creating a symmetric encryption KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
     * <p>
     * The following JSON fields are valid:
     * <p>
     * <ul>
     * <li><strong>MediaImportTemplateVersion</strong> - Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code> .</li>
     * <li><strong>databaseInstallationFileNames</strong> - Ordered list of installation files for the CEV.</li>
     * <li><strong>opatchFileNames</strong> - Ordered list of OPatch installers used for the Oracle DB engine.</li>
     * <li><strong>psuRuPatchFileNames</strong> - The PSU and RU patches for this CEV.</li>
     * <li><strong>OtherPatchFileNames</strong> - The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</li>
     * </ul>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">Creating the CEV manifest</a> in the <em>Amazon RDS User Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-manifest">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-manifest</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManifest() {
        return null;
    }

    /**
     * A value that indicates the status of a custom engine version (CEV).
     * <p>
     * Default: - "available"
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-status</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
        return null;
    }

    /**
     * A list of tags.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <em>Amazon RDS User Guide.</em>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-customdbengineversion.html#cfn-rds-customdbengineversion-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCustomDBEngineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCustomDBEngineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCustomDBEngineVersionProps> {
        java.lang.String databaseInstallationFilesS3BucketName;
        java.lang.String engine;
        java.lang.String engineVersion;
        java.lang.String databaseInstallationFilesS3Prefix;
        java.lang.String description;
        java.lang.String kmsKeyId;
        java.lang.String manifest;
        java.lang.String status;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getDatabaseInstallationFilesS3BucketName}
         * @param databaseInstallationFilesS3BucketName The name of an Amazon S3 bucket that contains database installation files for your CEV. This parameter is required.
         *                                              For example, a valid bucket name is <code>my-custom-installation-files</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInstallationFilesS3BucketName(java.lang.String databaseInstallationFilesS3BucketName) {
            this.databaseInstallationFilesS3BucketName = databaseInstallationFilesS3BucketName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getEngine}
         * @param engine The database engine to use for your custom engine version (CEV). This parameter is required.
         *               Valid values:
         *               <p>
         *               <ul>
         *               <li><code>custom-oracle-ee</code></li>
         *               <li><code>custom-oracle-ee-cdb</code></li>
         *               </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engine(java.lang.String engine) {
            this.engine = engine;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getEngineVersion}
         * @param engineVersion The name of your CEV. This parameter is required.
         *                      The name format is <code>major version.customized_string</code> . For example, a valid CEV name is <code>19.my_cev1</code> . This setting is required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of <code>Engine</code> and <code>EngineVersion</code> is unique per customer per Region.
         *                      <p>
         *                      <em>Constraints:</em> Minimum length is 1. Maximum length is 60.
         *                      <p>
         *                      <em>Pattern:</em> <code>^[a-z0-9_.-]{1,60$</code> }
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(java.lang.String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getDatabaseInstallationFilesS3Prefix}
         * @param databaseInstallationFilesS3Prefix The Amazon S3 directory that contains the database installation files for your CEV.
         *                                          For example, a valid bucket name is <code>123456789012/cev1</code> . If this setting isn't specified, no prefix is assumed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder databaseInstallationFilesS3Prefix(java.lang.String databaseInstallationFilesS3Prefix) {
            this.databaseInstallationFilesS3Prefix = databaseInstallationFilesS3Prefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getDescription}
         * @param description An optional description of your CEV.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getKmsKeyId}
         * @param kmsKeyId The AWS KMS key identifier for an encrypted CEV.
         *                 A symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS.
         *                 <p>
         *                 If you have an existing symmetric encryption KMS key in your account, you can use it with RDS Custom. No further action is necessary. If you don't already have a symmetric encryption KMS key in your account, follow the instructions in <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html#create-symmetric-cmk">Creating a symmetric encryption KMS key</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                 <p>
         *                 You can choose the same symmetric encryption key when you create a CEV and a DB instance, or choose different keys.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getManifest}
         * @param manifest The CEV manifest, which is a JSON document that describes the installation .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string. RDS Custom applies the patches in the order in which they are listed.
         *                 The following JSON fields are valid:
         *                 <p>
         *                 <ul>
         *                 <li><strong>MediaImportTemplateVersion</strong> - Version of the CEV manifest. The date is in the format <code>YYYY-MM-DD</code> .</li>
         *                 <li><strong>databaseInstallationFileNames</strong> - Ordered list of installation files for the CEV.</li>
         *                 <li><strong>opatchFileNames</strong> - Ordered list of OPatch installers used for the Oracle DB engine.</li>
         *                 <li><strong>psuRuPatchFileNames</strong> - The PSU and RU patches for this CEV.</li>
         *                 <li><strong>OtherPatchFileNames</strong> - The patches that are not in the list of PSU and RU patches. Amazon RDS applies these patches after applying the PSU and RU patches.</li>
         *                 </ul>
         *                 <p>
         *                 For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/custom-cev.html#custom-cev.preparing.manifest">Creating the CEV manifest</a> in the <em>Amazon RDS User Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder manifest(java.lang.String manifest) {
            this.manifest = manifest;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getStatus}
         * @param status A value that indicates the status of a custom engine version (CEV).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder status(java.lang.String status) {
            this.status = status;
            return this;
        }

        /**
         * Sets the value of {@link CfnCustomDBEngineVersionProps#getTags}
         * @param tags A list of tags.
         *             For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <em>Amazon RDS User Guide.</em>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCustomDBEngineVersionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCustomDBEngineVersionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCustomDBEngineVersionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCustomDBEngineVersionProps {
        private final java.lang.String databaseInstallationFilesS3BucketName;
        private final java.lang.String engine;
        private final java.lang.String engineVersion;
        private final java.lang.String databaseInstallationFilesS3Prefix;
        private final java.lang.String description;
        private final java.lang.String kmsKeyId;
        private final java.lang.String manifest;
        private final java.lang.String status;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.databaseInstallationFilesS3BucketName = software.amazon.jsii.Kernel.get(this, "databaseInstallationFilesS3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engine = software.amazon.jsii.Kernel.get(this, "engine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.engineVersion = software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.databaseInstallationFilesS3Prefix = software.amazon.jsii.Kernel.get(this, "databaseInstallationFilesS3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.manifest = software.amazon.jsii.Kernel.get(this, "manifest", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.databaseInstallationFilesS3BucketName = java.util.Objects.requireNonNull(builder.databaseInstallationFilesS3BucketName, "databaseInstallationFilesS3BucketName is required");
            this.engine = java.util.Objects.requireNonNull(builder.engine, "engine is required");
            this.engineVersion = java.util.Objects.requireNonNull(builder.engineVersion, "engineVersion is required");
            this.databaseInstallationFilesS3Prefix = builder.databaseInstallationFilesS3Prefix;
            this.description = builder.description;
            this.kmsKeyId = builder.kmsKeyId;
            this.manifest = builder.manifest;
            this.status = builder.status;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getDatabaseInstallationFilesS3BucketName() {
            return this.databaseInstallationFilesS3BucketName;
        }

        @Override
        public final java.lang.String getEngine() {
            return this.engine;
        }

        @Override
        public final java.lang.String getEngineVersion() {
            return this.engineVersion;
        }

        @Override
        public final java.lang.String getDatabaseInstallationFilesS3Prefix() {
            return this.databaseInstallationFilesS3Prefix;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getManifest() {
            return this.manifest;
        }

        @Override
        public final java.lang.String getStatus() {
            return this.status;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("databaseInstallationFilesS3BucketName", om.valueToTree(this.getDatabaseInstallationFilesS3BucketName()));
            data.set("engine", om.valueToTree(this.getEngine()));
            data.set("engineVersion", om.valueToTree(this.getEngineVersion()));
            if (this.getDatabaseInstallationFilesS3Prefix() != null) {
                data.set("databaseInstallationFilesS3Prefix", om.valueToTree(this.getDatabaseInstallationFilesS3Prefix()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getManifest() != null) {
                data.set("manifest", om.valueToTree(this.getManifest()));
            }
            if (this.getStatus() != null) {
                data.set("status", om.valueToTree(this.getStatus()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnCustomDBEngineVersionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCustomDBEngineVersionProps.Jsii$Proxy that = (CfnCustomDBEngineVersionProps.Jsii$Proxy) o;

            if (!databaseInstallationFilesS3BucketName.equals(that.databaseInstallationFilesS3BucketName)) return false;
            if (!engine.equals(that.engine)) return false;
            if (!engineVersion.equals(that.engineVersion)) return false;
            if (this.databaseInstallationFilesS3Prefix != null ? !this.databaseInstallationFilesS3Prefix.equals(that.databaseInstallationFilesS3Prefix) : that.databaseInstallationFilesS3Prefix != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.manifest != null ? !this.manifest.equals(that.manifest) : that.manifest != null) return false;
            if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.databaseInstallationFilesS3BucketName.hashCode();
            result = 31 * result + (this.engine.hashCode());
            result = 31 * result + (this.engineVersion.hashCode());
            result = 31 * result + (this.databaseInstallationFilesS3Prefix != null ? this.databaseInstallationFilesS3Prefix.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.manifest != null ? this.manifest.hashCode() : 0);
            result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
