package software.amazon.awscdk.services.rds;

/**
 * Properties for defining a <code>CfnIntegration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.rds.*;
 * CfnIntegrationProps cfnIntegrationProps = CfnIntegrationProps.builder()
 *         .sourceArn("sourceArn")
 *         .targetArn("targetArn")
 *         // the properties below are optional
 *         .additionalEncryptionContext(Map.of(
 *                 "additionalEncryptionContextKey", "additionalEncryptionContext"))
 *         .integrationName("integrationName")
 *         .kmsKeyId("kmsKeyId")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.95.0 (build f1ff514)", date = "2024-03-26T18:09:28.923Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.CfnIntegrationProps")
@software.amazon.jsii.Jsii.Proxy(CfnIntegrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Amazon Resource Name (ARN) of the database to use as the source for replication.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-sourcearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-sourcearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSourceArn();

    /**
     * The ARN of the Redshift data warehouse to use as the target for replication.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-targetarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-targetarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTargetArn();

    /**
     * An optional set of non-secret key–value pairs that contains additional contextual information about the data.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <em>AWS Key Management Service Developer Guide</em> .
     * <p>
     * You can only include this parameter if you specify the <code>KMSKeyId</code> parameter.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-additionalencryptioncontext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-additionalencryptioncontext</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAdditionalEncryptionContext() {
        return null;
    }

    /**
     * The name of the integration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-integrationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-integrationname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIntegrationName() {
        return null;
    }

    /**
     * The AWS Key Management System ( AWS KMS) key identifier for the key to use to encrypt the integration.
     * <p>
     * If you don't specify an encryption key, RDS uses a default AWS owned key.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * A list of tags.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <em>Amazon RDS User Guide.</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-rds-integration.html#cfn-rds-integration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIntegrationProps> {
        java.lang.String sourceArn;
        java.lang.String targetArn;
        java.lang.Object additionalEncryptionContext;
        java.lang.String integrationName;
        java.lang.String kmsKeyId;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnIntegrationProps#getSourceArn}
         * @param sourceArn The Amazon Resource Name (ARN) of the database to use as the source for replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceArn(java.lang.String sourceArn) {
            this.sourceArn = sourceArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTargetArn}
         * @param targetArn The ARN of the Redshift data warehouse to use as the target for replication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targetArn(java.lang.String targetArn) {
            this.targetArn = targetArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext An optional set of non-secret key–value pairs that contains additional contextual information about the data.
         *                                    For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                                    <p>
         *                                    You can only include this parameter if you specify the <code>KMSKeyId</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(software.amazon.awscdk.IResolvable additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getAdditionalEncryptionContext}
         * @param additionalEncryptionContext An optional set of non-secret key–value pairs that contains additional contextual information about the data.
         *                                    For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <em>AWS Key Management Service Developer Guide</em> .
         *                                    <p>
         *                                    You can only include this parameter if you specify the <code>KMSKeyId</code> parameter.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalEncryptionContext(java.util.Map<java.lang.String, java.lang.String> additionalEncryptionContext) {
            this.additionalEncryptionContext = additionalEncryptionContext;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getIntegrationName}
         * @param integrationName The name of the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationName(java.lang.String integrationName) {
            this.integrationName = integrationName;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getKmsKeyId}
         * @param kmsKeyId The AWS Key Management System ( AWS KMS) key identifier for the key to use to encrypt the integration.
         *                 If you don't specify an encryption key, RDS uses a default AWS owned key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnIntegrationProps#getTags}
         * @param tags A list of tags.
         *             For more information, see <a href="https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_Tagging.html">Tagging Amazon RDS Resources</a> in the <em>Amazon RDS User Guide.</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIntegrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIntegrationProps {
        private final java.lang.String sourceArn;
        private final java.lang.String targetArn;
        private final java.lang.Object additionalEncryptionContext;
        private final java.lang.String integrationName;
        private final java.lang.String kmsKeyId;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.sourceArn = software.amazon.jsii.Kernel.get(this, "sourceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targetArn = software.amazon.jsii.Kernel.get(this, "targetArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalEncryptionContext = software.amazon.jsii.Kernel.get(this, "additionalEncryptionContext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.integrationName = software.amazon.jsii.Kernel.get(this, "integrationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.sourceArn = java.util.Objects.requireNonNull(builder.sourceArn, "sourceArn is required");
            this.targetArn = java.util.Objects.requireNonNull(builder.targetArn, "targetArn is required");
            this.additionalEncryptionContext = builder.additionalEncryptionContext;
            this.integrationName = builder.integrationName;
            this.kmsKeyId = builder.kmsKeyId;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getSourceArn() {
            return this.sourceArn;
        }

        @Override
        public final java.lang.String getTargetArn() {
            return this.targetArn;
        }

        @Override
        public final java.lang.Object getAdditionalEncryptionContext() {
            return this.additionalEncryptionContext;
        }

        @Override
        public final java.lang.String getIntegrationName() {
            return this.integrationName;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("sourceArn", om.valueToTree(this.getSourceArn()));
            data.set("targetArn", om.valueToTree(this.getTargetArn()));
            if (this.getAdditionalEncryptionContext() != null) {
                data.set("additionalEncryptionContext", om.valueToTree(this.getAdditionalEncryptionContext()));
            }
            if (this.getIntegrationName() != null) {
                data.set("integrationName", om.valueToTree(this.getIntegrationName()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_rds.CfnIntegrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIntegrationProps.Jsii$Proxy that = (CfnIntegrationProps.Jsii$Proxy) o;

            if (!sourceArn.equals(that.sourceArn)) return false;
            if (!targetArn.equals(that.targetArn)) return false;
            if (this.additionalEncryptionContext != null ? !this.additionalEncryptionContext.equals(that.additionalEncryptionContext) : that.additionalEncryptionContext != null) return false;
            if (this.integrationName != null ? !this.integrationName.equals(that.integrationName) : that.integrationName != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.sourceArn.hashCode();
            result = 31 * result + (this.targetArn.hashCode());
            result = 31 * result + (this.additionalEncryptionContext != null ? this.additionalEncryptionContext.hashCode() : 0);
            result = 31 * result + (this.integrationName != null ? this.integrationName.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
